.nr H1 2
.H 1 "Getting the System Ready for Your Users"
.PH ''XENIX~Operations~Guide''
Now that you have some experience turning on your system, and using your
keyboard to enter commands, 
you should begin to feel comfortable in your role as system manager.
.P
One of \*(x1's special features is its capacity to support multiple users. 
Even if your system has only one terminal, several people may be using
the system at different times. 
With \*(x1, each user accesses, or \*`logs in\*', to the system under a
separate name and is assigned a workspace, or \*`user directory\*' of 
their own. 
Each user is assigned a password to prevent unauthorized users from accessing
information on the system.
Your job as system manager is to create and maintain user accounts.
.P
In this chapter you will be introduced to one special user on the
system: the \*`super-user\*', and learn the following simple procedures:
.BL
.LI
how to add users to the system with the 
.B mkuser
program
.LI
how to remove users from the system with the 
.B rmuser
program
.LI
how to change a user's password
.LE
.sp
You will also be introduced to two important \*(x1 files:
.I /etc/passwd
and
.I .profile .
.H 2 "The Super-User"
\*(x1 restricts access to many of its own system files, and provides
a protection mechanism to allow users to restrict use of
their own files.
There is one user, however, who has unlimited access to the system: the
aptly named \*`super-user\*', whose login name is \*`root\*'. 
Because the \*`super-user\*' has unrestricted access to every file on the system,
many regular system maintenance duties require you to log in as \*`root\*'. 
Only the \*`root\*' can add or remove user accounts, for example. 
However, because the super-user's access is unlimited, simple mistakes
can cause massive damage to system and user files, or even bring down the
system itself.
Therefore, the number of individuals who are given the super-user password
should be extremely limited, and those users who are authorized to act
as super-user, including the system manager, should log in as super-user
only when absolutely necessary to perform a system maintenance task.
.P
One continuing responsibility you will have as system manager is creating
and maintaining \*`accounts\*' for each of your users.
Please remember that even if you are the only user on your system, you should
create a working account for yourself and consistently log in as an ordinary 
user, unless you must be super-user in order to perform a maintenance task. 
Accidental misuse of your super-user powers can result in disaster.
.H 2 "Adding a User: The mkuser Program"
The
.B mkuser
program makes the process of adding a new user as easy as possible
for you.
To prevent unauthorized users from creating \*`logins\*' for themselves,
you must be logged in as \*`root\*' to use the 
.B mkuser
program.
When you are logged in as root, you will see a number sign (#) prompt 
on the screen rather than the dollar sign ($) which prompts ordinary user 
activities.
Simply type
.DS I
mkuser
.DE
and hit the <ENTER> or <RETURN> key.
The system will respond with the following lines:
.DS
.TS
box expand;
L.
.sp 2
           Mkuser
           ------
      Add a user to the system
.sp
Do you require detailed instructions? (y/n/q):_ 
.sp 2
.TE
.DE
You must respond with one of these three letters.
If you answer with the letter \*`q\*', which stands for \*`quit\*', the
.B mkuser
program will terminate, and return you to the system.
Note that typing the letter \*`q\*', the word \*`quit\*', or hitting the
<BREAK> key will terminate the    
.B mkuser 
program at any time, unless you are specifically instructed NOT
to use it.
When you are more familiar with
.B mkuser
you will probably answer \*`n\*' for no, if you do not need to read
the explanation again. 
If you answer \*`y\*' for yes, you will be provided with more information. 
.P
You will need to know the meaning of three terms in order to continue:
.VL 20
.LI "login name"
is the name by which the user will be known to the system. It is generally
convenient to shorten this for easy entry to, perhaps, a first name and
last initial (johnd), a first initial and last name (jdoe), or three
initials (jad).
.LI "comment"
gives you space to record any information about your new user, such as his
department and phone extension (Accounting #333). You are limited
to twenty characters, including spaces.
.LI "initial password"
is the password you, as system manager, assign to your new users. 
The user may change this password after he has logged in with the
initial password.
.LE
.sp
After you have read the instructions, you may continue to use 
.B mkuser
by hitting the <ENTER> key.
.P
The program will now ask you to enter the new user's login name.
Note the rules for a valid entry; you will not be allowed to create
an invalid entry. 
For example,
.DS I
login name: johnd
.DE
.P
After you hit <ENTER>, the program will ask you for a password entry.
You are encouraged to mix uppercase and lowercase letters, digits, and
special characters to make the password hard to guess. 
After the user logs in for the first time with the password you give him,
he can change it with the
.B passwd
command.
(See Chapter 2 for a description of the 
.B passwd
command.)
Please type carefully because the password will NOT appear on your screen as 
you type; you will not be able to see if you have made a mistake.
You will be asked twice for the password; if the two entries are not
identical, \*(x1 will not accept them.
.P
After you have entered the password, you will be asked for a comment entry. 
This entry is limited to a total of 20 characters, including spaces. 
.DS
.TS
box expand;
L.
.sp 2
Please enter Comment>--------------------
                    >Accounting #333
.sp 2
.TE 
.DE
.P
If you do not wish to enter a comment, just type <ENTER> instead.
Now
.B mkuser
will show you the entire entry it has created for the new user in
a special system file called 
.I /etc/passwd.
This entry includes the following:
.VL 15
.LI "user ID"
The
.B mkuser 
program will arbitrarily create user ID (you will often see this
abbreviated in \*(x1 documentation as \*`uid\*') numbers for each
new user account, starting at 200.
Numbers below 200 are reserved for system IDs like root and cron. 
.LI "group ID"
The group ID is an optional facility for allowing joint access to the
same files. 
.B mkuser
will initially set the group id of all new users to 50. 
In effect, all users belong to the same \*`group\*', and they share access
to all files. 
If greater privacy is desired, or if you wish to create true group IDs,
the 
.I /etc/passwd
file may be edited, using your text editor.
.LI "home directory"
The 
.B mkuser
automatically creates a work space for the new user, 
a \*`directory\*' of the same name as the login name, located in the
.I /usr
parent directory. 
In this example, the directory would be:
.DS I
/usr/johnd
.DE
.LI "comment field"
This will contain whatever information you have entered (in this case,
John Doe's department and phone extension)
.LI "shell"
The shell is a \*(x1 program which prompts for and interprets user
commands,
normally
.I /bin/sh
unless otherwise specified.
.LE
.P
The
.B mkuser program will now display the entire
.I /etc/passwd
entry for you:
.DS 
.TS
box expand;
L.
.sp 2
User name is johnd
Comment field is: Accounting #333
Password file entry is:
.sp
johnd:j9djf:204:204:Accounting #333:/usr/johnd:/bin/sh:
.sp 
Do you want to change anything? (y/n/q):
.sp 2
.TE
.DE
Every user of the system must have an entry in this file.
Note that every field is separated by a colon (:).
The strange sequence of characters after the login name is an \*`encrypted\*',
or coded, version of the password you created for John Doe.
.P
The
.B mkuser
program will give you an opportunity to change the user name, password, or 
comment at this point, if you answer \*`n\*' for no.
.DS
.TS
box expand;
L.
.sp 2
You can change any of the following items:
.sp
      username
      password
      comment
.sp 2
.TE
.DE
If you hit <BREAK>,
the
.B mkuser
program will terminate without adding the new user.
If you do not hit <BREAK>, 
it will report:
.DS
.TS
box expand;
L.
.sp 2
Password file updated
Home directory /usr/johnd created
/usr/johnd/.profile created
Test mail sent to user: johnd
User johnd added to this system.
.sp 2
.TE
.DE
.P
Now John Doe can use the system as soon as you tell him his initial
password. 
If the \*(x1
.B mail
program is available on your system, when he logs in for the first time
with his new login name and password, he will receive the message:
.DS 
.TS
box expand;
L.
.sp 2
You have mail
.sp 2
.TE
.DE
If John is at all curious, he will type the command
.DS I
mail
.DE
and the system will respond
.DS 
.TS
box expand;
L.
.sp 2
From root [date]
      Welcome to XENIX!
.sp 2
.TE
.DE
If he chooses, he may change his password at this point by entering
the command
.DS I
passwd
.DE
\*(x1 will respond:
.DS 
.TS
box expand;
L.
.sp 2
Changing password for johnd.
Old password:
New password:
.sp 2
.TE
.DE
John enters his old password, followed by his choice of a new password.
The
.B passwd
command automatically updates the entry in the 
.I /etc/passwd
file.
.P
After you have been acting in the role of system manager for a while,
you may have reason to change entries in the 
.I /etc/passwd 
file directly, such as creating new group IDS.
If you are logged in as super-user, you will be able to edit
.I /etc/passwd
like any other file, with the following precautions: 
.BL 
.LI
Always use the
.B passwd
command to change passwords.
.LI
Make changes to 
.I /etc/passwd
when the system is relatively idle.
.LI
Never touch system IDs, like \*`cron\*' or \*`root\*'.
.LI
Save a copy of the old
.B /etc/passwd
file under another name, for example: 
.DS I
# cp /etc/passwd /etc/passwd-
.DE
.LE
.H 2 "The .profile File"
When any user, including root, or the super-user, first logs in,
a file in that user's \*`home\*' directory called 
.I .profile 
is executed automatically.  
This file performs several functions:
.BL
.LI
It tells the system what kind of terminal the user is working on.
.LI
It establishes the name of the user's home directory.
.LI
It tells the system where to look for programs the user runs.
.LI
It tells the system where the user's electronic mail box is located. 
.LI
It determines the meaning of certain characters on the terminal, 
such as \*`kill\*' and \*`backspace\*'. 
.LE
.P
The
.B mkuser
program automatically creates the
.I .profile
file in each user's directory, with entries which should be suitable.
However, if changes are necessary, it can be edited like any \*(x1 file, using 
your text editor. 
Ordinary users may edit their own
.I .profile
file. 
.H 2 "Removing a User: The rmuser Program"
Of course, it is sometimes necessary to remove a user from the system. 
If John Doe gets a job with another company, naturally the system manager
will want to prevent him from continuing to access the payroll files.
In removing a user from the system, the 
.B rmuser 
program does the following:
.BL
.LI
deletes the user's entry in the 
.I /etc/passwd 
file 
.LI
removes the user's home directory
.LE
.P
However, 
.B rmuser
will do nothing unless all of John's files and directories are either 
removed from the system, or moved to the directories of other users. 
It is not a good idea to remove a user's files from the system until they have 
been \*`saved\*' or copied to floppy disks by one of the methods described
in Chapter 6, \*`Backups\*'. 
After you have made a backup copy of the files, simply type:
.DS I  
# cd /usr/johnd
rm -fr *
.DE
and all of John's files will be deleted.
.P
After this, you can use the 
.B rmuser
program to remove his login from the system.
Just type the command
.B rmuser ,
making sure that you are logged in as root.
You should see the message:
.DS
.TS
box expand;
L.
.sp 2
****rmuser-remove a user from the system****
.sp 2
.TE
.DE
followed by a description of what
.B rmuser
does.
At the end of the description you will see:
.DS
.TS
box expand;
L.
.sp 2
Press ENTER when you are ready.
.sp 2
.TE 
.DE
You will be prompted
for the name of the user you are going to remove from the system. 
.DS
.TS
box expand;
L.
.sp 2
Enter name of id to be removed.
.sp 2
.TE
.DE
.B rmuser
will then delete that user's entry in the 
password file, remove his mail box,
.I .profile
file, and home directory.
.P
Once again,
before you remove a user ID from the system you should make sure the user's 
mail box is empty, and that all files belonging to that user ID have
been saved or deleted as required.
The
.B rmuser 
program will refuse to remove a user ID or any of its files if one or
more of the following checks fails:
.BL
.LI
The user name given is one of the \*`system\*' user names, such
as root, sys, sysinfo, cron, or uucp.
.LI
The user ID is below 200. (Only system IDs have numbers below 200.)
.LI
The user's mail box exists and is not empty.
.LI
The user's home directory contains files other than
.I .profile .
.LE
.sp
.P
You should now see the message:
.DS
.TS
box expand;
L.
.sp 2
Removing user johnd from the system. CONFIRM? (y/n/q):
.sp 2
.TE
.DE
If you answer \*`y\*', johnd will be removed from the system.
.DS
.TS
box expand;
L.
.sp 2
User johnd removed from the system
.sp 2
.TE
.DE
If you answer \*`n\*' or \*`q\*' johnd's account will remain.
.B Rmuser
will now give you a chance to remove another user:
.DS
.TS
box expand;
L.
.sp 2
Do you want to remove another user? (y/n/q):
.sp 2
.TE
.DE
You may repeat the removal process.
Of course, if you have accidentally removed a user (remember, you can't
remove the user if he has any files on the system), no harm is done.
Just use
.B mkuser
to recreate his user account.
.TC
