.nr H1 6
.H 1 "Common System Problems"
.PH ''XENIX~Operations~Guide''
If you follow the instructions in this operations guide carefully,
you will have few problems with your \*(x1 system. 
However, some difficulties are inevitable with any computer system.
Included here is a discussion of how to deal with some common system problems.
.H 2  "Jammed Lineprinter"
You will need super-user powers to carry out these instructions,
so first be sure you are logged in as \*`root\*'.
Now, do the following in this order:
.AL 1
.LI
Check to see which process \*`owns\*' the line printer and determine its
process ID number, using the \fBps -a\fR command: 
.DS I
ps -a
.DE
.LI
Use the
.B kill 
command, with the
.B -9
switch to remove the process.
.DS I
kill -9 [process ID number]
.DE
.LI
Remove the file 
.I /usr/spool/lpd/lock
and queue another print job:
.DS I 
cd /usr/spool/lpd
rm -f lock
.DE
.LI
Resubmit the print job:
.DS I
pr file|lpr&
.DE
.LE
.H 2 "Forgotten Password"
For security reasons, there is no way to determine an existing password.
If a user forgets his password,
the system manager--or someone who has the authority to log in as super-user
--must create a new password, using the
.B passwd
command, followed by the name of the user account:
.DS I
passwd joeb
New Passwd:
Reenter passwd:
.DE
This will give a user called \*`joeb\*' a new password.
.H 2 "System is Out of Space"
This requires some work.
If, after using the 
.B df
command, you see that there is very little space on the file system, or
the system gives you an \*`out of space\*' message,
you will have to use the
.B find 
and
.B quote  
commands and some good judgement to find and delete little-used files.
(These procedures are described in detail in Chapter 5, \*`Keeping Your
System Healthy\*'.)
.P
If you are chronically short of space, remind users regularly to clean up
their files, using the message of the day file, 
.I /etc/motd.
.P
It is generally a good idea to maintain 15% free space on your file system,
if possible.
.H 2 "System Files Damaged"
It is possible to remove or damage important \*(x1 system files while
logged in as root.
To recover these files, you must be in \*`single-user\*' mode. 
To do this, bring the system down with the
.B shutdown 
command, then reboot the system.
Now, when you see the message:
.DS I
Type control-d to proceed with normal startup
(or give root password for system maintenance):
.DE
respond with the root password, followed by <ENTER>.
Follow the normal procedure for restoring files described in Chapter 6.
In this case, you will be restoring your files to the root directory, /. 
For example, if 
.I /etc/passwd 
is lost or damaged, it can be recovered by using the following:
.DS I
restor xf /dev/rfd0 /etc/passwd
.DE
In this example, the
.B /etc/passwd 
file is restored from the disk in floppy disk drive 0.
If damage to your system files is very extensive, it is a good idea
to reinstall your \*(x1 system again, using your \*(x1 distribution package
and your 
.I
\*(x1 Installation Guide.
.R
Then restore all your working files and programs from your most recent
backup floppy disks.
.H 2 "Terminal Difficulties"
Occasionally, you may experience difficulties with your terminal.
For example,
if you use the <BREAK> key to exit from a screen-oriented program, 
like the \*(x1 text editor
.B vi ,
there is a possibility that you may leave the terminal in a \*`no echo\*' 
or \*`raw\*' mode. 
This is very confusing because you will be unable to see any output at your 
terminal. 
Try the following to reset the terminal:
.DS I
<CONTROL-J>
stty echo -raw <CONTROL-J>
.DE
Note that the first time you type <CONTROL-J>, you will probably
get an error message. 
The system is responding first to the invisible message you
attempted to type on the screen.  
Just try it a second time.
The 
.B stty 
command is terminated with a <CONTROL-J>, not an <ENTER>. 
If you are in \*`no echo\*' mode, of course, you will not see the command
as you type it.
.H 2 "Forgetting the Root Password."
Don't.
There is no way to recover from the loss of the root password, except to
reinstall your \*(x1 system from the \*(x1 distribution flopppies,
using the procedures described in the
.I
\*(x1 Installation Guide,
.R
then using your backup floppy disks to restore your system.
.H 2 "Removing a Directory"
Sometimes when you try to use the 
.B rmdir 
command to remove a directory, you will get a message saying that the 
directory is not empty, even though the
.B lc 
command does not list any files.
Remember that there may be one or more files beginning with \*`.\*'
(\fI.profile\fR, for example) which do not show up in
.B lc
output.
There are also two files in every directory called \*`.\*' and \*`..\*'
(This naming convention is explained in Chapter 2.)
The command 
.B rm * 
will NOT delete these; the asterisk (*) will not pick up these files. 
Use 
.DS I
lc -a 
.DE
to see these files and then 
.DS I
rm .*
.DE
to remove them.
.H 2 "Special Characters in Filenames"
You should never use any of the following special characters in the name
of a file or directory, because they have special meanings to \*(x1
(See the discussion of naming conventions in Chapter 2):
.DS I
< > . / ? { } ' " ; \ | ~ ` ( ) * & ^ $
.DE
If you accidentally type any of the above special characters into a 
filename they can be very difficult to remove.
Files with special characters in their names can be extremely difficult to
remove.
The worst case is beginning a file name with a dash (-). 
The 
.B rm
command thinks the \*`-\*' is a flag and reports an error.
If 
.B rm 
won't work, try renaming the file with the
.B mv 
command, as in the following case where a file is named
.I -x:
.DS I
mv -x junk
.DE
Then remove it. 
As a last resort, move everything else to another directory, and do 
.DS I
rm -rf dir
.DE
on the old directory. 
Then use
.B mv 
to rename the temporary directory to the old name. 
Do not try to delete oddly named files with wild card characters like asterisk 
(*) and question mark (?) unless you have thought it out carefully.
You can easily end up deleting everything in your directory.
.H 2 "Runaway Processes"
You may occasionally find yourself cursed by \*`runaway processes\*'
-- processes that you cannot stop, or unwanted output coming to your terminal.
Try the following, in this order of preference:
.AL 1
.LI
Wait until the process finishes. This is by far the safest course of
action, unless the process is causing harm. 
.LI
Try pressing <BREAK>.
.LI
A process  may prevent you from accessing the terminal.
(e.g., it may either be running in the foreground and not accepting input, or
running in the background and producing lots of output to the screen.)
In this case, go to another terminal (if you have one) and run
.DS I
ps -a
.DE
This variant of the
.B ps
command tells you about the all the processes running on the system,
so that you can determine the process ID (PID column) of the unwanted process
on the first terminal.
Then, logged in as root, try the following: 
.DS I
kill -2 PID
kill -3 PID
.DE
If neither of these work, try
.DS
kill -9 PID
.DE
This last variant is sure to work, but may leave temporary files in the
system, or leave the terminal in an unknown state.
Between each kill command, wait a few seconds to see if the process
terminates, before trying the next one.
.LI
In the event that a program prevents you from using the system, and you
don't have another terminal from which to issue the kill command, you
may have to resort to using the <RESET> switch. 
This should only be done if ABSOLUTELY necessary.
Listen for the sound of activity on your hard disk.
If you must reset the system, wait a couple of minutes until the system is not
accessing the disk, so that the system will be as consistent as possible
when shut down in this abnormal state.
.LE
.TC
