.ce 1
.B
GLOSSARY
.R
.PH ''XENIX~Operations~Guide''
.PF "''\\\\nP''"
Here is a list of words you will see in this 
.I
Operations Guide
.R
and other \*(x1 documentation.
It includes the definition of some commonly used computer terms
and concepts, as well as some terms specific to the \*(x1 System,
with an emphasis on terms related to system operation and maintenance.
.HU "Access" 
.br
Your ability to look at, change, and use files and directories. 
To have access, you must first have a valid account on your \*(x1 system,
as well as individual and/or group permission for the files you wish to work 
with.
.HU "Account"
.br
An account is your authorization to use the system. \*(x1 maintains a list
of all valid user logins--that is, user names, passwords, and optional group
identification.
.HU "Accounting"
.br
A \*(x1 facility for tracking system usage.
\*(x1 keeps a record of processes run on the system and how much the system
is used by a given user. 
.HU "Application"
.br
Application programs perform
specific user tasks, such as word processing, accounting, inventory, or 
business forecasting. 
These programs may be purchased with your system or in
separate packages, or written by system users. 
.HU "Archive"
.br
Archiving is the process of copying files and directories to
to floppy disks, and removing the files from the system.
Archiving should be done for programs and files which are little used 
in order to save space on your hard disk.
.HU "Argument"
.br
\*(x1 commands are often followed by an argument, most commonly the name of a 
file to which the command will be applied.
.HU "Background"
.br
\*(x2 is a multitasking system, which can run more than one process, or
program, at once.
Commands may be run in the background by putting
the ampersand character (&) at the end of the command line. 
Background processes leave the terminal free,
and other processes may be started without waiting for a
background process to finish.
.HU "Backup"
.br
The process of making a copy of all the data on your system in case the
original is destroyed or damaged.
.HU "Basic System"
.br
Your \*(x1 basic system contains system programs, utilities,
and frequently used commands. It does not include specialized software
development or text processing packages, or any other application software.
.HU "Boot"
.br
This is a frequently used computer term to describe the sequence of programs 
which start up your system.
It is distinguished from physically turning on, or powering up, the
computer, or the installattion of \*(x1 software on your system for
the first time.
.HU "CPU"
.br
The central processing unit of your computer.
.HU "Child Process"
.br
Refers to a process which is created by another, or parent, process. 
.HU "Command"
.br
This is your request to the system to perform a given task. Commands may
be system programs or shell procedures.
.HU "Configuration"
.br
This term refers to the particular collection of devices you have on your
system, and the way these are connected, such as a \*`floppy-only\*' 
or \*`8-megabyte hard disk\*' configuration.
.HU "Console"
.br
This is the controlling terminal for the \*(x1 system, 
from which the system is first booted, and to which error messages 
about serious system conditions are sent.
.HU "Cursor"
.br
The cursor, represented by a lighted square on your terminal, indicates
where the next character you type will appear. 
.HU "Core File"
.br
A file which is sometimes produced when a program terminates
unexpectedly due to some fault, such as an illegal instruction or data access, 
or when a user accidentally types a quit at the keyboard. 
This file will automatically be stored in your current working directory, and
should be deleted to save disk space.
.HU "Device Driver"
.br
A set of routines which enable the \*(x1 system to control and pass
data to and from an input/output device, such as a lineprinter or disk drive. 
.HU "Device special file"
.br
This is a \*(x1 file which provides direct access to a physical device.
Writing to a device special file causes the data to be sent directly
to the device. 
These files are in the
.I /dev
directory.
.HU "Directory"
.br
A directory is a file containing the names of a collection of files.
The \*(x1 system offers the capacity to organize information hierarhically
by allowing you to group related files into directories.
.HU "Disk Drive"
.br
A device that stores information in magnetic form on the surface of a either
a hard or floppy disk, and which can access data from any point on the disk.
.HU "File System"
.br
A collection of files associated with a physical disk drive, which is attached
to, or mounted on, the root directory.
.HU "File Structure"
.br
A hierarchically organized collection of files and directories.
.HU "File"
.br
The basic unit of storage on your system.
All data, programs, and text are stored in files.
.HU "Format"
.br
Both hard and floppy disks must be prepared to accept \*(x1 data with the
formatting program called
.B diskutil .
.HU "Group"
.br
A number of users may be designated as having identical access rights to
certain files, and are listed in a file called
.I /etc/group . 
.HU "Group ID"
.br
Each user on the system is assigned to a group, identified by a 
number taken from the password file when the user logs in. 
Each process started by the user inherits that group ID. 
.HU "Home Directory"
.br
The directory where you are automatically positioned when you log in. 
The home directory is set up by the login process from the information
in the password file. 
The shell maintains a shell variable \*`$HOME\*' which is set to the home 
directory. 
.HU "Kernel"
.br
The term "\*(x1 kernel" is usually used to refer to the code in the file
.B /xenix .
This is the program loaded at boot time, and contains routines to implement
all the system calls, task scheduling, and interrupt handling. 
It also contains the programs which ccontrol communication to the 
input/output devices.
.HU "Login"
.br
This is the process of typing your name and password into the computer in
order to begin work.
.HU "Mount"
.br
The process of attaching a file structure to the file system. 
.HU "Multi-user"
.br
When most \*(x1 systems are booted they come up in \*`single-user\*' mode, 
with just the \*`super-user\*' logged in on the system console. 
When the \*`super-user\*' logs out, the system goes \*`multi-user\*', and
users can log in on other terminals. 
.HU "Multi-tasking"
.br
The capacity to run two or more tasks, or programs, simultaneously.
.HU "Permission"
.br
Access to files and directories on your \*(x1 system may be limited by 
assigning read, write, execute, and search permissions.
.HU "Parent"
.br
This term has two meanings in the \*(x1 system. A parent process is one which
sets another, child process going.
A parent directory is the directory immediately above the current one in
the directory tree.
.HU "Operating System"
.br
This is the collection of programs which control the user's interaction with
the system and determines how the total resources of the computer are allocated
to individual users and programs.
An operating system also controls communication with input/output devices such
as terminals and lineprinters. The \*(x1 system is an operating system.
.HU "Output"
.br
The result of processing by the computer, generally communicated to the
user via terminal or lineprinter. 
.HU "Password"
.br
A user's account is optionally protected by a password, which the user must
type when requested along with their account name, in order to gain access to 
the system.
.HU "Pathname"
.br
This is the name of a file or directory, espressed as the path down which
you must travel from the root directory in order to reach it.
.HU "Pipe"
.br
This is a mechanism symbolized by the pipe character (|), which allows
the user to connect two processes together.
.HU "Prompt"
.br
The prompt is the signal that the system is ready to accept the user's input.
The two \*(x1 prompts are the number sign (#), if you are logged in as 
super-user, or dollar sign ($), the ordinary system prompt. 
.HU "Root directory"
.br
The directory at the top of the \*(x1 file structure, called \*`/\*',
which contains \*(x1 system-level files and directories.
.HU "Root"
.br
A synonym for the \*`super-user\*'.
Also the name for the directory at the top of the directory tree, refered
to as slash (/).
.HU "Scroll"
.br
The way in which text moves up and down on your terminal screen.
.HU "Shell"
.br
The \*(x1 command line interpreter which accepts commands from the user
and passes them to the system for execution. 
.HU "Single User"
.br
A \*(x1 system configured for only one user.
You may also see this
term used to describe the mode in which the system
first comes up, when the user is logged in as \*`super-user\*' at the system
console.
In this mode the date can be set and file system cleaning performed.
.HU "Standalone"
.br
Refers to programs which run independently from \*(x1. 
Examples are: 
.B diskutil , 
.B hdinit , 
and 
.B firsttime.
.HU "Super-user"
.br
Also known as root. Because the super-user has unrestricted access to the 
file system, this user ID should be used very cautiously.
.HU "Swapping"
.br
If there are more active processes in the system than there is space for in
memory, the system moves them back and forth to the disk while they are not 
actually running. 
.HU "System Management"
.br
Those functions performed by a user appointed as system manager, or 
administrator, including the establishment of user accounts, disk maintenance,
and backups.
.HU "Tar File"
.br
A file produced by the so-called tape archive program,
.B tar . 
This is usually written directly to floppy disk or magnetic tape. 
.HU "User ID"
.br
Each user on the system is identified by a number which is recorded 
in the password file. 
All files and directories in the file system belong to a user ID, and that 
user may specify whether and how other users on the system may access each 
file and directory. 
.HU "Working Directory"
.br
Your current position in the file structure hierarchy.
