.aX
.nr H1 0
.H 1 "Appendix A: XENIX Files and Directories"
.PH ''XENIX~Operations~Guide''
As system manager, you will be encountering certain \*(x1 directories often. 
For now, it is sufficient to know their names and general contents.
However, as you gain more experience, you may become curious about 
\*(x1 or decide that you want to make some changes.
If you are considering changing, moving, or deleting any \*(x1 system
files or directories, it is absolutely essential that you read the
following information very carefully.
There are, of course, several cases in which you might decide to make
these modifications, but you must proceed very cautiously:
.BL
.LI
You may need to move commands between \*(x1 distribution disks 2 and 3, if
you are operating a floppy-only system.
.LI
You may wish to remove unused commands or other files from a crowded disk,
to make room for your own applications.
.LI
You may need to edit files to adapt the system to your own special software
or hardware requirements. 
An example of this might be adding an entry in the
.I /etc/termcap 
file, if you are using an unusual, previously unsupported terminal. 
See Appendix B, \*`The Multi-user System\*'.
.LE
.P
Naturally, you should not attempt any modifications unless you have done 
a full backup of your system. 
You will also quickly discover that many of these files and directories
are owned by root, and you will need to be logged in as super-user to
access them.
This protects the system from accidental damage.
Also, note the list of files in the first section below. 
You should not touch these under ANY circumstances. 
The loss of these files is irrecoverable; you may not even be able to boot 
your system again. 
If any essential files are lost, you will need
to recreate your \*(x1 system from the distribution disks, repeating the 
the installation procedure described in the
.I
\*(x1 Installation Guide.
.R 
Then you will have to boot the system again and restore all your files from 
the most recent backup.
.H 2 "Do Not Touch"
You may have some, or all, of the following files on your system. 
Do not remove them:
.VL 20
.LI "\fI/fdboot\fR"
.LI "\fI/xenix\fR"
.LI "\fI/hdboot\fR"
.LI "\fI/z80ctl\fR"
.LI "\fI/diskutil\fR"
.LE
.H 2 "\fI/bin\fR"
The
.I /bin
directory contains all executable \*(x1 commands. The following
should not be removed from the directory: 
.sp
.nf
basename          echo              passwd            su
cp                expr              rm                sync
date              fsck              sh                tar
dump              login             sleep             restor
dumpdir           mv                stty              
.fi
.sp
One final note: do not remove a file with the peculiar name \*`[\*'
from the 
.I /bin
directory; it is required for the operation of system shell scripts. 
.H 2 "\fI/dev\fR"
This directory contains special device files which control access to peripheral
devices.
You should not delete or change any of them, since they are used by essential
\*(x1 commands.
.VL 15
.LI "\fI/dev/console\fR"   	
system console
.LI "\fI/dev/fd0\fR"
floppy drive 0
.LI "\fI/dev/fd1\fR"
floppy drive 1 
.LI "\fI/dev/hd0\fR"          
hard disk 0
.LI "\fI/dev/lp\fR"           
lineprinter
.LI "\fI/dev/mem\fR"          
physical memory
.LI "\fI/dev/null\fR"         
null device (used to redirect unwanted output)
.LI "\fI/dev/rXX\fR"        
unbuffered interface to corresponding device name
.LI "\fI/dev/root\fR"        
root file structure
.LI "\fI/dev/swap\fR"        
swap area
.LI "\fI/dev/ttyXX\fR"      
terminals
.LI "\fI/dev/tty\fR"         
the terminal you are using (the system will supply the number)
.LE
.P
Please note that you should never rename any of these files. The system
relies on some of these names. 
However, you can use the
.B ln
command to link a name variant. 
For example, use the command:
.DS I
ln /dev/fd0 /dev/floppy0
.DE
If you do accidentally destroy a device special file, you will have to restore
it from a backup done with the
.B sysadmin 
program.
The
.B tar
command will not handle special device files.
.H 2 "\fI/etc\fR"
The 
.I /etc
directory contains miscellaneous system data files, as well as administrative 
and other system programs. 
Some of these are:
.VL 15
.LI "\fI/etc/mtab\fR"
mounted device table
.LI "\fI/etc/passwd\fR"
password file
.LI "\fI/etc/mount\fR"
for mounting a file structure
.LI "\fI/etc/mkfs\fR"
for creating a file structure
.LI "\fI/etc/init\fR"
first process after boot
.LI "\fI/etc/rc\fR"
bootup shell script
.LE
.P
You should not touch any files in the 
.I /etc
directory, except 
.I /etc/ttys
to add or subtract terminals from your system, and
.I /etc/termcap
to add terminal types.
You will also want to edit
.I /etc/motd,
the file containing the message of the day which is sent to all users when
they log in.
.H 2 "\fI/lib\fR"
It is not a good idea to delete anything from this directory, although
it contains mostly libraries for the C compiler. If you are not using
the C compiler you will not need them.
.H 2 "\fI/mnt\fR"
This is an empty directory for mounting other file systems.
.H 2 "\fI/tmp\fR"
This directory contains temporary files, many of which can be deleted if
you are short of disk space. Naturally, you should check these individually
before removing them while processes are still running. 
You can also put a command in
.I /etc/rc
to do this automatically at the time of each boot:
.DS I
rm -fr /tmp
mkdir /tmp
chmod 777 /tmp
.DE 
.H 2 "\fI/usr\fR"
In addition to all the users' home directories, the 
.I usr
directory contains the following:
.VL 20
.LI "\fI/usr/bin\fR"
Contains more commands, generally those less frequently used or non-essential
to \*(x1 system operation
.LI "\fI/usr/include\fR"
Contains header files for compiling C programs.
Can be deleted if you are not using the C compiler.
.LI "\fI/usr/lib\fR"
Contains more libraries and data files used by various commands; should not be
deleted.
.LI "\fI/usr/spool\fR"
Contains various spoolers which store files in directories (e.g.,
\fI/usr/spool/lpd\fR).
.LI "\fI/usr/tmp\fR"
Contains more temporary files which might be deleted.
.LI "\fI/usr/adm/messages\fR" 
Contains a record of all the console error messages. 
Typically, these are reports of disk errors, along with some record of user
errors, such as \*`out of disk space\*' messages.
The messages are useful for determining whether you have a hardware problem; 
you can scan a week's worth of messages and see, for example, if one particular
drive is generating an unusual number of errors. 
You will not see every disk error as it appears on the console screen. 
This file is likely to grow quickly, so periodically check it, print it out,
and delete the file.
Save the printout as a record of your problems.
.LE
.TC
