.ds :? DEMONSTRATION RUN
.nr H1 2
.PH "'Demonstration Run''Demonstration Run'"
.H 2 "Introduction"
.XX "demonstration run"
The purpose of this demonstration run
is to help you get used to the main ideas of the
\*(x1 system, so that you can
quickly start to make effective use of it.
It shows you how to log in, 
how to type at your keyboard,
what to do about mistakes in typing,
how to enter commands, and how to log out.
.H 2 "Before You Log In"
Before you can log into the system, your 
name must be added to the \*(x1 list of known users.
You may have to add your name yourself, or
someone else may be charged with this task;
it all depends on the environment in which your system is used. 
In any case, see the 
.I "\*(x2 Operations Guide" 
for more information on adding users.
.P
When you are given an account on the \*(x1 system
you will also receive a user name, a password, and a
login directory.
Once you have these, all you need is a terminal on which
you can log into the system.
\*(x2 supports most terminals and you
should have little problem getting your terminal
to work with \*(x1.
Once again, see the 
.I "\*(x2 Operations Guide" 
for more information on how to configure your terminal.
.H 2 "Logging In"
.XX "logging in"
To log in to \*(x1, 
you must first have an up-and-running \*(x1 system.  
Normally, the system is sitting idle, with a simple 
.Q "login:" 
prompt on the terminal screen.
If the system displays nonsense characters,
your terminal may be receiving information at the wrong speed
and you should check your terminal's switches.
If that fails, push the 
.SM <BREAK>
.XX "<BREAK>"
or 
.SM <INTERRUPT>
.XX "<INTERRUPT>"
key a few times, slowly.
.P
When you finally get a 
.Q "login:"
message, type your login name.
Follow it by typing 
.SM <RETURN> ;
.XX "<RETURN>"
the system will not do anything until you do.
If a password is required, you will be asked for it.
The password that you type does not appear on the screen.
This prevents others from viewing it.
Don't forget to type
.SM <RETURN> 
after you type your password.
.P
A successful login will produce a
.Q "prompt character" ,
a single character that indicates 
the system is ready to accept commands.
The prompt
.XX "prompt \- login"
.XX "login prompt"
is usually a dollar sign
($) or a percent sign (%).
You may also get a login message just before the prompt, 
or a notification that you have received mail
sent by other users of the system.
.H 2 "Typing Commands"
Once the prompt character appears,
the system is ready to respond to commands typed at the terminal.
Try typing
.DS I
date
.DE
followed by
.SM <RETURN> .
The system responds by displaying something like:
.DS I
Mon Jun 16 14:17:10 EST 1983
.DE
Don't forget the
.SM <RETURN>
after the command,
or nothing will happen.
.SM <RETURN>
won't be mentioned again,
but don't forget it\*(EMit has to be entered
at the end of each command line.
On some terminals 
.SM <RETURN>
may be labeled 
.Q "ENTER"
or 
.Q "CR" ,
but in all cases,
the key performs the same function.
.P
Another command you might try is
.B who ,
.XX "who"
which lists the names of everyone who is logged in
to \*(x1.
A typical display from the
.B who
command might look
something like this:
.DS I
you     tty00   Jan 16    14:00
joe	tty01	Jan 16    09:11
ann	tty05	Jan 16    09:33
bob	tty11	Jan 16    13:07
.DE
The time, given in the fourth column, indicates when the user logged in;
.RI tty nn 
is the system name for each user's terminal, 
where
.I nn
is a unique two digit number.
.P
If you make a mistake typing the command name,
you will be told.
For example, if you type
.DS I
whom
.DE
you are told:
.DS I
whom: not found
.DE
Note that case is significant in 
\*(x1\*(EMthe commands
.DS I
who
.DE
and 
.DS I
WHO
.DE
are not the same; this differs from some
operating systems, where case doesn't matter.
.P
Now let's 
try using the 
.B echo 
command. 
Type:
.DS I
echo hello world!
.DE
.B Echo 
.XX "echo"
simply does what its name implies and echoes the rest of
the command line on your terminal:
.DS I
hello world!
.DE
Now try this:
.DS I
echo hello world! >greeting.file
.DE
This time the 
.B echo
command sends its output to the file named 
.I greeting.file ,
instead of to your terminal.
Note the use of the greater than sign (>) to 
.Q "redirect"
the output of the command.
(See Section 3.5.1 for more information on redirection.)
Now type
.DS I
ls
.DE
to list the name of the file,
.FN greeting.file .
To look at the contents of
.FN greeting.file ,
display it by typing:
.DS I
cat greeting.file
.DE
(\*`Cat\*' stands for concatenate.)
.XX "cat"
The output to your terminal is the echoed message:
.DS I
hello world!
.DE
.H 2 "Strange Terminal Behavior"
Occasionally, your terminal may act strangely.
You can often fix this behavior 
by logging out and logging back in;
this will reset your terminal characteristics.
.XX "resetting your terminal"
If logging out and back in doesn't work, 
read the description of the command
.IR stty (1)
in the 
.I "\*(x2 Reference Manual"
for more information about setting terminal
characteristics.
.P
Some terminals automatically expand tabs 
into an appropriate number of spaces; others do not.
To get tabs expanded into spaces for
terminals without automatic tab expansion, type:
.DS I
stty -tabs
.DE
The system will then convert each tab into the correct number
of spaces for you.
If your terminal does have computer-settable tabs, 
the command
.B tabs
correctly sets the tab stops for you.
.H 2 "Mistakes in Typing"
.XX "typing mistakes"
If you make a mistake in typing while entering a
command line, there are two ways to edit the line, provided you
have not yet typed
.SM <RETURN> . 
Typing the 
.SM <BKSP>
key causes the last character typed to be erased.
In fact, backspacing with the
.SM <BKSP>
key can erase characters back to
the beginning of the line, but not beyond.
Thus, if you type badly, you can correct as you go.
For example, typing
.DS I
dd<BKSP>atte<BKSP><BKSP>e<RETURN>
.DE
is the same as typing just
.DS I
date<RETURN>
.DE
.P
The \*(x1 kill character, 
.SM <CONTROL-U> ,
.XX "<CONTROL-U>"
erases all of the characters typed so far
on the current input line.
So, if the line is irretrievably fouled up, type
.SM <CONTROL-U>
and start the line over.
.P
What if you must enter a 
.SM <BKSP>
.XX "<BKSP>"
or 
.SM <CONTROL-U>
as part of the text?
If you must, precede it
with a backslash (\^\e\^),
so that the character loses its special, erase meaning.
To enter a 
.SM <BKSP>
or 
.SM <CONTROL-U>
in text, type 
.Q "\e\s-2<BKSP>\s0"
or 
.Q "\e\s-2<CONTROL-U>\s0" .
The system always prints a new line on your terminal
after your 
.SM <CONTROL-U> ,
even if preceded by a backslash.
Don't worry\*(EMthe 
.SM <CONTROL-U> 
will have been recorded.
.P
To erase a backslash, backspace twice with the
.SM <BKSP>
key,
as in 
.Q "\e\s-2<BKSP><BKSP>\s0" .
The backslash is used extensively in
\*(x1 to indicate that 
the following character is in some way special.
Note that the functions performed by 
.SM <BKSP>
and 
.SM <CONTROL-U>
are available on all \*(x1 systems; 
however, the keys used to perform these
functions can be set by the user.
.H 2 "Read-Ahead"
.XX "read-ahead"
\*(x2 has full read-ahead, which means 
that you can type as fast as you want, whenever you want,
and \*(x1 will remember what you have typed.
If you enter any text while a command is displaying text
on the screen, your input characters
will appear intermixed with the output characters,
but they will be stored away
and interpreted in the correct order.
Therefore, you can type several commands
(i.e., 
.Q "type ahead" )
one after another without
.XX "type ahead"
waiting for the first to finish.
Note that the one place that this doesn't work
is when you login;
type ahead does not work until 
.I after 
you have entered your password and 
you see the dollar sign ($) prompt for command input.
.H 2 "Stopping a Program"
You can abort the execution of most programs and
commands by pressing the
.SM <INTERRUPT>
.XX "<INTERRUPT>"
key (perhaps called 
.SM <DEL> ,
.XX "<DEL>"
.SM <DELETE> ,
.SM <CONTROL-C> ,
.XX "<CONTROL-C>"
or 
.SM <RUBOUT> 
on your terminal).
The 
.SM <BREAK> 
key found on many terminals
can also be used.
Inside some programs, like most text editors,
typing
.SM <INTERRUPT>
stops whatever the program is doing 
without aborting the program itself.
Throughout this manual, when we say 
.Q "send an interrupt" 
we mean press the 
.SM <INTERRUPT> 
key.
.H 2 "Logging Out"
.XX "logging out"
To end a session with \*(x1, you must log out.
This is done by typing
.SM <CONTROL-D> .
.XX "<CONTROL-D>"
It is not sufficient just to turn off the terminal,
since this does not log you out.
.H 2 "Further Learning"
For further learning, you will want to use 
the on-line help facility:
.B learn .
.XX "learn"
Simply type 
.DS I
learn
.DE
and it will give you instructions.
.B Learn
is especially useful when first learning how to use
the system, so you may want to investigate it now.
.P
This ends the demonstration run.
What you have learned so far is enough to keep you out of harm's way.
You will want to learn how to use
the \*(x1 shell and a text editor.
The shell language is the language with which you
speak to the system and execute commands. 
Text editors are used to create and edit files,
documents, and programs.
The available editors and the shell are 
discussed thoroughly in Chapters 5, 6, and 7.
.P
The next two chapters introduce you to the concepts
and commands that you will need to know each time
you log in to \*(x1. 
Be sure to read them before you
try to do anything you think difficult or dangerous.
It is especially important to understand how the
directory system is organized and how files are named.
.bp
.xp
.TC 2 1 5 0
