'\" 	@(#)Document: V1-00-2
'\" 	@(#)Subject: V3.0 Prog Intro: Xenix Basics
'\" 	@(#)Writer: Stewart Konzen
'\" 	@(#)Work: 4 weeks
'\" 	@(#)Target: 1/1
'\" 	@(#)Notes: Contains Basic Concepts
'\" 	@(#)Mods: 
.ds :? BASIC CONCEPTS
.nr H1 3
.PH "'Basic Concepts''Basic Concepts'"
.H 2 "Introduction"
This chapter gives you an understanding of the
basic concepts that you need to function in the \*(x1 environment.
It discusses the \*(x1 file system, naming
conventions, commands, and input and output.
After reading this chapter you will have an
understanding of how the system's files, directories,
and devices are organized and named,
how commands are entered, and how
a command's input and output can be manipulated.
.H 2 "File System"
.XX "file system"
A file system is a set of files organized in a logical fashion.
In \*(x1, this set of files consists of
all available resources
including data files, programs, lineprinters, and disks.
Thus, the \*(x1 file system is more generally a
system for accessing all system resources.
.P
To logically structure the resources of
the system,
the \*(x1 file system is organized 
hierarchically into an inverted 
.Q "tree structure" .
.XX "tree structure"
See Figure 3-1 for an illustration of a typical
tree-structured file system.
In this typical tree of files,
.XX "root" 
the root of the tree is at the top and branches of
the tree grow downward.
Directories correspond to nodes in the tree;
ordinary files correspond to 
.Q "leaves" .
.XX "leaves"
If a directory contains a downward branch to other
files or directories, then those files and
directories are 
.Q "contained"
in the given directory.
It is possible to specify any file in the system
by starting at the root (where the root is at the top)
and traveling down any of the branches to the desired file.
Similarly, you can specify any file in the system,
relative to any directory.
Specification of these files depends on a knowledge
of \*(x1 naming conventions, discussed in Section 3.3.
.P
Privacy and security for files and directories can be arranged.
Each file and directory has read-write-execute permissions
.XX "permissions"
that can be set to control access by the owner,
by a group of users, and by everyone else.
.DS I
                     \e (root)
                   / | \e
                  /  |  \e
                 /   |   \e
              bin   usr   dev
              /    /   \e    \e
           cmd    /     \e    tty
                doug   neil
               /  |     |  \e
              /   |     |   \e
            mail news  text  data    
		

.FG "A Typical File System" 3-
.DE
.P
In the typical tree-structured file system of Figure 3-1, the 
.Q "tree"
grows downward. 
The names
.FN bin ,
.FN usr ,
.FN dev ,
.FN doug ,
and
.FN neil 
all represent directories, 
and are all nodes in the tree.
In \*(x1 the name of the root
directory is given the one character name, 
.Q "\|/\|" .
The names 
.FN mail ,
.FN news ,
.FN text ,
and 
.FN data 
all represent normal data files,
and are all
.Q "leaves"
of the tree.
Note that the file
.FN cmd ,
is the name of a command that can be executed.
The name
.FN tty
represents a terminal and is also represented in
the tree. 
.H 3 "Files"
.XX "files"
The file is the fundamental unit of the \(x1 file system.
Conceptually, everything is treated as a file.
However, there are really three different types of files:
ordinary files (what we usually mean when we say
.Q "file" ),
special files, and directories.
Each of these file types is discussed below:
.VL 10 2
.LI "Ordinary~Files"
.br
.XX "ordinary files"
.XX "files \- ordinary"
Ordinary files typically contain textual information such
as documents, data, or program sources.
Executable binary files are also of this type.
.LI "Special~Files"
.br
.XX "special files"
.XX "files \- special"
A special file is one that corresponds to a physical
device of some sort, such as a disk, a lineprinter, a
terminal, or system memory.
To the \*(x1 user,
special files can be treated like ordinary files.
However, the internal handling of a printer
or terminal is much different from that of an ordinary
disk file, and the operations that can be
performed on devices vary from those that
can be performed on ordinary files.
The files that correspond to physical devices in the
system, are located in the directory named
.FN /dev .
.LI "Directories"
.br
.XX "directories"
.XX "files \- directory"
Directories are read-only files containing information
about the files or directories that are conceptually
(but not physically) contained within them.
The nesting of directories in other 
directories is the way in which \*(x1 implements
its characteristic tree-structured directory system.
Directories are discussed further in the next section.
.LE 1
.H 3 "Directory Structure"
.XX "directory \- structure"
With multiple users and multiple projects,
the number of files in a file system can proliferate rapidly.
Fortunately, as explained earlier,
\*(x1 organizes all files
into a tree-structured directory hierarchy.
Each user of the system has his own personal directory.
Within that directory, the user may have directories
or other subdirectories owned and controlled only by the user.
.P
When you log in to \*(x1, you are 
.Q "in"
your directory.
Unless you take special action
when you create a file,
the new file is created in your working directory.
This file is unrelated to any other file of the same name
in someone else's directory.
.ne 2.5i
.P
A diagram of part of a typical user directory is shown
in Figure 3-2.
.DS I

                    usr    
                   / | \e
                  /  |  \e
                 /   |   \e
              adam  eve   mary
              /    /   \e    \e
           text   /     \e   text
                text   temp

.FG "A Typical User Directory" 3-
.DE
.P
In Figure 3-2,
the
.FN usr 
directory contains each user's own personal directory.
Notice that Mary's file named
.FN text
is unrelated to Eve's.
This is not important if all the files of interest
are in Eve's directory,
but if Eve and Mary work together,
or if they work on separate but related projects,
this division of files becomes handy indeed.
For example, Mary could print Eve's text by typing:
.DS I
pr /usr/eve/text
.DE
Similarly, Eve could find out what files Mary has by
typing:
.DS I
ls /usr/mary
.DE
.H 2 "Naming Conventions"
Now that we have discussed what the \*(x1 file system is, 
and what it consists of,
.XX "naming conventions"
we need to use filenames
.XX "filenames"
in a more precise way.
The first thing to remember is that every single file,
directory, and device in \*(x1 has both a filename
and an absolute pathname.
.XX "absolute pathnames"
The absolute pathname is unique to all names in the
system; filenames are unique only within directories
and need not be unique system-wide.
This is similar to someone whose 
.Q "real"
name is John Robert Smith, but who everyone calls John.
.H 3 "Filenames"
.XX "filenames"
A simple filename is a sequence of one-fourteen characters
other than a slash (/).
Every single file, directory, and device in the
system has a filename.
Filenames are used to uniquely identify directory contents.
Thus, no two filenames in a directory may be the same.
However, filenames in different directories may be identical.
.H 3 "Pathnames"
.XX "pathnames"
A pathname is a sequence of directory 
names followed by a simple filename,
each separated from the previous one by a slash.
.XX "slash \- (/)"
If a pathname begins with a slash,
the search for the file begins at the 
.I root 
.XX "root"
of the entire tree.
Otherwise, it begins at the user's
.I "current directory"
(also known as the
.I "working directory" ).
A pathname beginning with a slash is called a
.I full 
(or 
.IR absolute \|) 
.I "pathname"
because it does not vary with regard
to the user's current directory.
A pathname 
.I not 
beginning with a slash is often called a
.I "relative pathname" ,
.XX "relative pathname"
because it specifies a path relative to the current directory.
The user may change the current directory
at any time by using the
.B cd
command.
.P
In most cases,
a filename and its longer, corresponding pathname
can be used interchangeably.
.H 3 "Sample Names"
Some sample names follow:
.VL 18 3
.LI /
The absolute pathname of the root directory 
of the entire file system.
.LI /bin
.XX "/bin"
The directory containing most of the frequently used \*(x1 commands.
.LI /usr
.XX "/usr"
The directory containing each user's personal directory.
The subdirectory,
.FN /usr/bin
contains frequently used \*(x1 commands not in 
.FN /bin .
.LI /dev
.XX "/dev"
The directory containing files corresponding to each
available physical device (e.g., terminals,
lineprinters, and disks).
.LI /lib
.XX "/lib"
The directory containing special data files used by
some standard commands.
.LI /tmp
.XX "/tmp"
This directory contains
temporary scratch files.
.LI /usr/joe/project/A
.br
This is a typical full pathname.
This one happens to be a file named 
.FN A
in the directory named
.FN project
belonging to the user named
.FN joe .
.LI bin/x
A relative pathname;
it names the file
.FN x
in subdirectory
.FN bin
of the current working directory.
If the current directory is
.FN / ,
it names
.FN /bin/x .
If the current directory is
.FN /usr/joe ,
it names
.FN /usr/joe/bin/x .
.LI file1
Name of an ordinary file in the current directory.
.LE
.P
Each user resides 
.Q "in"
a directory called the
current directory.
All files and directories have a
.Q "parent"
directory. 
This directory is the one immediately above and 
.Q "containing" 
the given file or directory.
The \*(x1 file system provides special shorthand
notations for this directory and for the current directory:
.VL 10 5
.LI "."
.XX ". \- current directory shorthand"
The shorthand name of the current directory.
Thus
.FN ./filexxx
names the same file as
.FN filexxx ,
if such a file exists in the current directory.
.LI ..
.XX ".. \- parent directory shorthand"
The shorthand name of the current directory's parent directory.
If you type
.DS I
cd ..
.DE
then the parent directory of your current working directory becomes
your new current directory.
.LE 1
.P
Although you can use almost any character
in a filename,
common sense says you should stick to ones that are visible,
and that you should probably avoid characters
that might be used
with other meanings.
For instance,
.XX "dash \- (\-)"
the dash (\-) is used in specifying command options, and
should be avoided when naming files.
To avoid pitfalls, you should 
use only letters, numbers, and the period.
.H 3 "Special Characters"
\*(x2 provides a pattern-matching facility for specifying
sets of filenames that match particular patterns.
For example, examine the
problem that occurs when naming
the parts of a large document, such as a book.
Logically, it can be divided into many small pieces:
chapters or perhaps sections.
Physically, it must be divided too,
since the \*(x1 editor
.B ed 
.XX "ed \- text editor"
cannot handle really big files.
Thus, you should construct a document as a number of files.
For example, you might have a separate file for each chapter:
.DS I
chap1
chap2
\&...
.DE
Or, if each chapter were broken into several files, you might have:
.DS I
chap1.1
chap1.2
chap1.3
\&...
chap2.1
chap2.2
\&...
.DE
You could then tell at a glance where a particular file
fits into the whole.
.ne 2i
.P
There are other advantages to a systematic
naming convention that are not so obvious.
What if you want to print the whole book on the
lineprinter?
You could type
.DS I
lpr chap1.1 chap1.2 chap1.3 ...
.DE
but you would get tired pretty fast, and
would probably even make mistakes.
Fortunately, there is a shortcut:
a sequence of similar names can be specified with the
use of two special 
.Q "wild card" 
.XX "wild cards"
.XX "metacharacters"
characters.
.P
For example, you can type:
.DS I
lpr chap*
.DE
The asterisk (*), sometimes called 
.Q "star" 
.XX "star \- shell metacharacter"
in \*(x1,
means 
.Q "zero or more characters of any type" ,
so this translates into 
\*`print all files
whose names begin with the word 
.Q "chap",
listed in alphabetical order\*'"
.P
This shorthand notation
is not a unique property of the
.B lpr
command;
it is a system-wide service of the shell program
that interprets commands, 
.B sh .
Using this fact,
you can list the names
of the files in the book by typing:
.DS I
ls chap*
.DE
This produces
.DS I
chap1.1
chap1.2
chap1.3
\&...
.DE
The star is not limited to the last position in a filename;
it can be used anywhere and can occur several times.
As a special case,
a star by itself matches every filename, so
.DS I
rm *
.DE
removes all your files.
.P
The star is not the only pattern-matching feature available.
Suppose you want to print only chapters 1 through 4, and 9.
Then you can say
.DS I
lpr chap[12349]*
.DE
The brackets ([\0and\0])
mean 
.Q "match any of the characters inside the brackets."
A range of consecutive letters or digits can be abbreviated,
so you can also do this with
.DS I
lpr chap[1-49]*
.DE
(Note that this does 
.I not
match forty-nine filenames, but only five.)
Letters can also be used within brackets:
.Q "[a\-z]"
matches any character in the range 
.Q "a"
through 
.Q "z" .
.P
The question mark (?) matches any single character, so
.XX "question mark \- shell metacharacter"
.DS I
ls ?
.DE
lists all files that have single-character names, and
.DS I
ls -l chap?.1
.DE
lists information about the first file of each chapter
(i.e.,
.FN chap1.1 ,
.FN chap2.1 ,\ ...).
.P
Of these pattern matching conventions, the star (*)
is certainly the most useful,
and you should get used to it at once.
.P
If you should ever need to turn off the special meaning of
any of the special characters ( *, ?, and [ ... ])
enclose the entire argument in single quotation marks.
For example, the following command will print out
only files named 
.Q "?"
rather than all one
character filenames:
.DS I
ls \'?\'
.DE
All of these special pattern matching features are 
discussed further in Chapter 7,
.Q "The Shell."
.H 2 "Commands"
.XX "commands"
Commands are used to invoke executable programs.
When you type the name of a command, the \*(x1 shell
looks for a program with the given name to execute.
If the shell finds an executable program, it will execute it.
Commands may also contain switches
.XX "switches"
that specify
.XX "options"
options or other arguments as needed by the program.
Commands are entered on a command line that is read
by the shell.
Command lines are discussed in the following subsection.
.H 3 "Command Line"
.XX "command line"
Whether typing at the terminal, or executing
commands from a file, \*(x1 always reads commands
from command lines.
The command line is a line of characters that is 
scanned and read by the shell command interpreter to
determine what to do next.
This interpreter, or 
.Q shell 
as it is usually known,
reads the names of commands from the command line,
then finds the executable file corresponding to the
a name of the command, and then executes that file.
When the command finishes executing, the shell
resumes reading the command line.
Thus, when you are typing at a terminal, you are editing
a line of text called the 
.I "command-line buffer"
.XX "command-line buffer"
that becomes a command line only when you type 
.SM <RETURN> .
This command-line buffer can be edited with the 
.SM <BKSP> 
.XX "<BKSP>"
and
.SM <CONTROL-U>
.XX "<CONTROL-U>"
keys.
Typing 
.SM <RETURN>
.XX "<RETURN>"
causes the command-line buffer to be submitted to 
the shell as a command line. 
The shell reads the command line and executes
the appropriate command.
If you type 
.SM <INTERRUPT>
.XX "<INTERRUPT>"
before you type 
.SM <RETURN> ,
then the command-line buffer is aborted.
Multiple commands can be entered on a single command
line so long as they are separated by a semicolon (;).
For example, the following command line prints out the current
date and the name of the current working directory:
.DS I
date ; pwd
.DE
.P
Commands can be submitted for processing in 
.Q "the background"
by appending an ampersand (&) to the command.
Thus
.DS I
du /usr&
.DE
will determine disk usage in the directory 
.FN /usr ,
a fairly lengthy operation,
without tying up your terminal.
This mode of execution is similar to \*`batch\*'
processing on some systems.
The main advantage to placing commands in the
background is that you can execute 
other commands from your terminal
in the 
.Q foreground 
at the same time 
that background commands execute.
.H 3 "Syntax"
.XX "syntax"
.XX "commands \- syntax"
The general syntax for commands is as follows:
.DS I
.B
cmd  [ \fIswitches\fP ][ \fIarguments\fP ] [ \fIfilenames\fP ]
.R
.DE
.P
In practically all cases, command names are all lowercase.
Switches are flags that select various
options available when executing the command.
Switches are optional and always
.I precede
other arguments and filenames.
Switches consist of a dash prefix (\-)
and an identifying alphanumeric character.
Some switches are also prefixed by a plus sign (+).
Switches can often be grouped as a single switch
as in:
.DS I
ls \-arl
.DE
Here the 
.B \-a 
switch (pronounced 
.Q "minus a"
)
selects the option which lists all
files in the directory. 
The 
.B \-r 
switch selects the option which causes the
names in the directory to be sorted in reverse
alphabetical order.
And the 
.B \-l 
switch selects the option which causes
listing of a long format for each directory entry.
.ne 1i
.P
Sometimes switches must be given separately, 
as in:
.DS I
copy \-v \-a source dest
.DE
.P
Here the 
.B \-v 
switch specifies a verbose option.
The 
.B \-a 
switch tells the 
.B copy
command to ask the user before copying the two given
directories.
.P
Arguments of various types can also be given, such as search
strings, as in:
.DS I
grep \'string of text\' outfile
.DE
In the above example 
.DS I
\'string\ of\ text\'
.DE
is a single argument and 
is the search string that the 
.B grep
command searches for in the file
.FN outfile , 
which, is a
.I filename
argument that specifies the name of a file required
by the command.  
.P
In most cases, commands are executable object files compiled
from C programs.
In some cases, commands are executable command
files called 
.Q "shell procedures" .
Shell procedures are discussed in 
Chapter 7,
.Q "The Shell."
.H 2 "Input and Output"
.XX "input"
.XX "output"
\*(x2 handles input and output from commands in a unique
way: it assumes that input and output, by default, are
associated with the terminal from which the command originates.
That is, input comes from the keyboard and output goes
to the terminal screen.
To illustrate typical command input and output,
type:
.DS I
cat
.DE
This command now expects input from your keyboard.
It will accept as many lines of text as you can type
as input, until you type a 
.SM <CONTROL-D>
as an 
.XX "end-of-file"
end-of-file indicator.
.ne 1.5i
.P
For example, type:
.DS I
this is two lines
of input
.SM <CONTROL-D>
.DE
When you type the
.SM <CONTROL-D> ,
input ends and output begins.
The
.B cat 
command then immediately outputs the two lines 
that you typed\*(EMsince output is sent to the terminal screen by
default, that is where the two lines are sent.
Thus, the complete session will look like this on
your terminal screen:
.DS I
$ cat
this is two lines
of input
this is two lines
of input
$
.DE
.P
The flow of command input and output can be
.XX "redirection"
.Q "redirected"
so that input comes from a file instead
of from the terminal keyboard, and so that output goes
to a file or to a lineprinter, instead of to the terminal
screen.
In addition, 
.XX "pipes"
.Q "pipes"
can be created that allow
the output from one command to become the input to another.
Redirection and pipes are the subjects of the next two
subsections.
.H 3 "Redirection"
.XX "redirection"
It is universal in \*(x1 systems
that a file can replace the terminal
for either input or output.
For example
.DS I
ls
.DE
displays a list of files on your terminal screen.
But if you say
.DS I
ls >filelist
.DE
a list of your files is placed in the file
.FN filelist
(which
is created if it does not exist).
.XX "output redirection (>)"
The symbol for output redirection, 
the greater-than sign (>), means 
\*`put the output from the command into the following file,
rather than display it on the terminal screen.\*'
As another example, you can combine
several files into one by capturing the output of
.B cat
in a file:
.DS I
cat f1 f2 f3 >temp
.DE
.P
.XX "output redirection (>>)"
The output append symbol (>>)
operates very much like the output redirection symbol does,
except that it means
.Q "add to the end of" . 
That is
.DS I
cat file1 file2 file3 >>temp
.DE
means to concatenate
.FN file1 ,
.FN file2 ,
and
.FN file3
to the end of whatever is already in
.FN temp ,
instead of overwriting and destroying the existing contents.
As with normal output redirection, if
.FN temp
doesn't exist, it is created for you.
.P
.XX "input redirection (<)"
In a similar way, the input redirection symbol (<)
means to take the input
for a program from the following file,
instead of from the terminal.
Thus, you could make up a script of
editing commands and put them into a file called
.FN script .
.XX "scripts"
Then you could execute the commands in the script 
on a file using the
\*(x1 editor by typing:
.DS I
ed file <script
.DE
As another example, you could use
.B ed
to prepare a letter in file
.FN letter.txt ,
then send it to several people with
.DS I
mail adam eve mary joe <letter.txt
.DE
.H 3 "Pipes"
.XX "pipes"
One of the major innovations of
the \*(x1 system is the concept of a
.Q pipe.
A pipe is simply a way to connect the output of one command
to the input of another command,
so that the two run as a sequence of commands
called a pipeline.
.XX "pipelines"
.P
For example
.DS I
pr frank.id george.id hank.id
.DE
prints the files named
.FN frank.id ,
.FN george.id ,
and
.FN hank.id ,
beginning each on a new page.
Suppose you want
them run together instead.
You could type:
.DS I
cat frank.id george.id hank.id >temp
pr <temp
rm temp
.DE
But this is more work than is necessary.
What we want is to take the output of
.B cat
and connect it to the input of
.B pr .
So we use a pipe:
.DS I
cat frank.id george.id hank.id | pr
.DE
.XX "pipe symbol \- (\||\|)"
The vertical bar (\||\|)
means to take the output from
.B cat ,
which would normally have gone to the terminal,
and put it into
.B pr
.XX "pr"
to be neatly formatted.
.P
There are many other examples of pipes.
For example,
.DS I
ls | pr -3
.DE
prints a list of your files in three columns.
The program
.B wc
counts the number of lines, words, and characters in
its input, and 
.B who
prints a list of currently logged on people,
one per line.
Thus,
.DS I
who | wc
.DE
tells how many people are logged on.
And of course
.DS I
ls | wc
.DE
counts your files.
.P
Any program
that reads from the terminal keyboard
can read from a pipe instead.
Any program that displays output to the terminal screen
can send input to a pipe.
You can have as many elements in a pipeline as you wish.
.P
Many
\*(x1
programs are written so that they
take their input from one or more files,
if file arguments are given.
If no arguments are given, they read from the terminal
keyboard,
and thus can be used in pipelines.
For example
.DS I
pr -3 albert.txt bernard.txt carl.txt
.DE
prints, in order, the files
.FN albert.txt ,
.FN bernard.txt ,
and
.FN carl.txt .
But in
.DS I
cat albert.txt bernard.txt carl.txt | pr
.DE
.B pr
prints the concatenation of these files coming down the pipeline.
The difference is that here, 
.FN albert.txt ,
.FN bernard.txt ,
and
.FN carl.txt
are run together and then treated as one file
rather than three.
.bp
.xp
.TC 2 1 5 0
