'\" 	@(#)Document: V1-00-2
'\" 	@(#)Subject: V3.0 Prog Intro: Frequently Used Procedures
'\" 	@(#)Writer: Stewart Konzen
'\" 	@(#)Work: 4 weeks
'\" 	@(#)Target: 1/1
'\" 	@(#)Notes: Needs formatting fixed
'\" 	@(#)Mods: 
.ds :? FREQUENTLY USED PROCEDURES
.nr H1 4
.PH "'Procedures''Procedures'"
.H 2 "Introduction"
This chapter explains how to perform frequently used procedures,
where a procedure is some task that may require one or more steps
to complete.
The commands used to perform these procedures are
discussed more thoroughly in the 
.I "\*(x2 Reference Manual."
.H 2 "System Access"
.nr Hu 3
.HU "Logging In"
.in +5
The procedure for gaining access to the system
is to respond to the
.Q "login:"
prompt by typing your user name followed by a
.SM <RETURN> .
Then respond to the
.Q Password:
.XX "password"
prompt with your password.
For example, a login for the user
.I joe
might look like this:
.DS I
login:\fBjoe\fR
Password:\fBabracadabra\fR
.DE
Note that the password is not shown on the terminal screen.
.HU "Gaining Access to a Group"
.in +5
When a file or directory is created, it has 
group permission attributes associated with it that control
.XX "groups"
access to the file by other members of the same group.
This means that some files can only be accessed if
you are a member of the right group.
When you log in  to \*(x1, you are automatically
associated with a default group.
.P
To change groups, you must go through a procedure
similar to that for logging in.
As with the login procedure, a password may be required
to switch your association from one group to another.
(Note, however, that there is no \*(x1 command to
set or change group passwords.)
.P
Assume, for instance, that you are associated with
the group named
.Q "engineers" .
To change your group affiliation to a new group named
.Q "managers"
you would type:
.DS I
newgrp managers
.DE
If the new group requires a password, you are prompted for it.
For example, if the password is
.Q "AbleBaker"
then you would respond to the password prompt with:
.DS I
password:\fBAbleBaker\fR
.DE
Note that 
.Q "AbleBaker"
would 
.I not
be echoed on the terminal screen.
.HU "Logging Out"
.in +5
The logout procedure is simple\*(EMall you need to do is type:
.DS I
\s-2<CONTROL-D>\s+2
.DE
In general,
.SM <CONTROL-D>
signifies the end-of-file in \*(x1, 
and is often used within programs to signal the end of
input from the keyboard.
In such cases,
.SM <CONTROL-D> 
will 
.I not
log you out, but simply terminate input to a
particular program.
This means, that it may sometimes be necessary to type 
.SM <CONTROL-D> 
several times before you can log yourself out.
.HU "Changing Your Password"
.in +5
To change your password, use the
.B passwd
command.
For the user joe, a session might go like this:
.DS I
Changing password for joe
Old password: \fBpalooka\fR
New password: \fBBazookah\fR
Retype new password: \fBBazookah\fR
.DE
To maintain security,
none of your responses are shown on the screen.
It is best to mix uppercase and lowercase letters and to
pick a password greater than five characters in length.
These measures should be taken to foil automated attempts
at guessing your password.
Note that the system ignores characters in the
password beyond the eighth character.
.H 2 "Terminal Configuration"
.HU "Setting Terminal Options"
.in +5
There are a number of terminal options that can be set
with the command
.B stty .
When entered without parameters,
.B stty
displays the current terminal settings.
For example, typical output might look like this:
.DS I
speed 9600 baud
erase '^h' ; kill '^u'
even -nl
.DE
Each of the above characteristics can be set with
.B stty .
For more information,
see 
.IR stty (1)
in the 
.I "\*(x2\0Reference\0Manual."
.HU "Setting Tabs"
.in +5
The tab stops for a particular terminal can be specified with the
.B tabs
command.
.B Tabs 
takes the name of a terminal as its only parameter.
For example, to reset tab stops for your terminal, type:
.DS I
tabs
.DE
That is all you have to do.
.HU "Changing Terminals"
.in +5
If you ever need to log in to \*(x1 on a terminal
of a type different than the terminal you normally use,
you may need to change the shell TERM variable.
This is normally set to the proper default terminal
when you log in, but if you switch terminals, you'll
need to type something like:
.DS I
TERM=termname; export TERM
.DE
where 
.I termname
is the name of a known terminal.
A wide variety of terminals are supported; 
terminal names are listed in the system file named
.FN /etc/termcap.
.H 2 "Process Control and Command Line Editing"
.HU "Placing A Process in the Background"
.in +5
Normal commands executed at the keyboard are
executed in strict sequence; one must finish
executing before the next can begin.
Executing commands of this type are called foreground processes.
A background process, in contrast, need not finish
executing before you execute your next command.
Background commands are especially useful for commands that may
take several minutes or even hours to complete,
because they can be placed in the background while you
continue executing other commands at your terminal.
.P
To place a process in the background, type an ampersand (&)
at the end of the command.
For example, to print out several files,
while simultaneously
continuing with whatever else you have to do, type:
.DS I
lpr file1 file2 file3& 
.DE
Note that when processes are placed in the background,
you lose control of them as they execute.
For instance, typing 
.SM <INTERRUPT> 
does
.I not
abort a background process.
You must use the
.B kill
command instead, described below.
.ne 2.5i
.HU "Killing a Process"
.in +5
To abort execution of a foreground process press your terminal's
.SM <INTERRUPT>
key.
This kills whatever foreground command you have running.
To kill all of your processes 
that are executing in the background, type:
.DS I
kill 0
.DE
To kill only a specified process executing in the background,
first type:
.DS I
ps
.DE
.B Ps
displays the Process Identification Numbers (PIDs)
of your existing processes:
.DS I
   PID TTY TIME CMD
  3459 03  0:15 -sh 
  4831 03  1:52 cc program.s 
  5185 03  0:00 sh -c ps 
.DE
Next, you might type
.DS I
kill 4831
.DE
where 4831
is the PID of the process that you want killed.
.P
.B Warning:
Killing a process associated with the editor 
.B vi 
may leave the terminal in
a strange mode.
Also, temporary files that are normally created when
a command starts and deleted when the command
finishes, may be left behind after a 
.B kill 
command. 
Temporary files are normally kept in the directory
.FN /tmp .
.HU "Erasing a Command Line"
.in +5
When entering commands, typing errors will occur.
To erase the current command line so that you can start
retyping a new one, enter a 
.SM <CONTROL-U> , 
as shown below.
First type
.DS I
kat file2<CONTROL-U>
.DE
and then enter the correct command on the next
line:
.DS I
cat file1<RETURN>
.DE
.P
In the above example, the first line is aborted
and a newline is automatically generated so that
typing may resume.
You then enter the correct command line.
.HU "Halting Screen Output"
.in +5
In many cases, you will be examining the contents of
a file on the terminal screen. 
For longer files, the
contents will often scroll off the screen faster than you
can examine them.
To temporarily halt a program's output to the
terminal screen, type 
.SM <CONTROL-S> .
To resume output, type a
.SM <CONTROL-Q> .
.H 2 "Status Information"
.HU "Finding Out Who Is on the System"
.in +5
The
.B who
command lists the names, terminal line numbers, and login
times of all users currently logged in the system.
For example, type:
.DS I
who
.DE
This command should produce something like
the following output on your terminal screen:
.DS I
arnold   tty02   Apr  7 10:02
daphne   tty21   Apr  7 07:47
elliot   tty23   Apr  7 14:21
ellen    tty25   Apr  7 08:36
gus      tty26   Apr  7 09:55
adrian   tty28   Apr  7 14:21
.DE
The 
.B finger
command also provides information about 
the users of the system.
For more information, see
.IR finger (1)
in the
.I "\*(x2 Reference Manual."
.HU "Finding Out What Processes Are Running"
.in +5
Because processes can be placed in the background for
processing, it is not always obvious which processes
you are responsible for.
The
.B ps
command stands for 
.Q "process status"
and lists information about currently 
running processes associated with your terminal.
For instance, the output from a
.B ps
command might look like this:
.DS I
 PID TTY TIME CMD
10308 38  1:36 ed chap02.man
   49 38  0:29 -sh
11267 38  0:00 sh -c ps
.DE
The PID column gives a unique process identification
number that can be used to kill a particular process.
The TTY column gives the terminal that the process is
associated with.
The TIME column gives the cumulative execution time
for the process.
.HU "Getting Lineprinter Information"
.in +5
At times it may be necessary to know how many files
are queued up at the lineprinter.
This information can be found by listing the directory
in which queued files reside.
Typically, this is in 
.FN /usr/spool/lpd .
To examine the relevant files type:
.DS I
ls -l /usr/spool/lpd
.DE
.H 2 "File Manipulation"
.HU "Creating a File"
.in +5
To create an empty file, simply type:
.DS I
>filename
.DE
Here,
.FN filename
is the name of the newly created file.
The greater-than sign (>) is used to redirect output from the
terminal to a file.
In this special case no information is sent.
In general, new files are created by commands
.I "as needed" \|.
To edit the contents of a file, you should use
one of the editors ed or Vi.
Ed is discussed in Chapter\ 5,
.Q "Ed" ;
Vi is discussed in Chapter\ 6,
.Q "Vi" .
.HU "Displaying File Contents"
.in +5
There are two programs available to display the contents
of a file:
.B cat
and
.B more .
The
.B cat
command displays the contents
of a file on the default
standard output file which is the terminal screen.
For example, the following command displays the contents of
.FN file1
on the screen:
.DS I
cat file1
.DE
.B Cat
can also display the contents of more than one
file as in
.DS I
cat file1 file2
.DE
The
.B more
command performs a similar function, except
that it displays a file's
contents one line or screen at a time.
After invoking 
.B more ,
file contents can be examined one line at a time by typing
.SM <RETURN> .
.B More
tells you what percentage of the file has
been viewed on the bottom status line.
If you type the letter 
.Q "z"
or a space, 
then the next screenful is displayed.
A listing of other 
.B more 
commands is obtained by typing
.Q "h"
for help.
.HU "Combining Files"
.in +5
.B Cat ,
as mentioned above, is normally used to send
the contents of files to the terminal screen. 
However, the name
.B cat
comes from the word concatenate, and
.B cat
is also frequently used to combine files into some other
new file.
Thus, to combine the two files named
.FN file1
and
.FN file2 ,
and to create a new file named
.FN bigfile ,
type:
.DS I
cat file1 file2 >bigfile
.DE
Note here that we are putting the contents of
the two files into a new file with the name
.FN bigfile .
The greater than sign (\|>\|) is used to
.I redirect
output of the
.B cat
command to the new file.
.HU "Moving a File"
.in +5
The
.B mv
command supports two ways of moving files:
.AL 1
.LI
Moving a file so that it now has a new name.
For instance, to move a file named 
.FN text
to a new file named 
.FN book ,
type:
.DS I
mv text book
.DE
After this move completes, no file named
.FN text
will exist in the working directory.
.ne 2i
.LI
Moving a file into a specified directory.
In this case,
you give the name of the destination directory as the final
name in the 
.B mv
command. 
For instance, to move
.FN file1
and 
.FN file2
into
the directory named
.FN /tmp ,
type:
.DS I
mv file1 file2 /tmp
.DE
.ne 2i
The two files you have moved no longer exist
in your working directory, but files with the same
names now exist in the directory
.FN /tmp .
The above command has exactly the same 
effect as typing the following two commands:
.DS I
mv file1 /tmp/file1
mv file2 /tmp/file2
.DE
Remember that the
.B mv
command always checks to see if the last argument is
the name of a directory, and, if so, all files
designated by filename arguments are moved into that
directory.
.LE 
.HU "Renaming a File"
.in +5
To rename a file, you simply 
.Q "move"
the file to
a file with the new name: the old name of the file is
removed.
Thus, to rename the file
.FN anon
to
.FN johndoe ,
type:
.DS I
mv  anon johndoe
.DE
Note that moving and renaming a file are essentially
identical operations.
.HU "Copying a File"
.in +5
There are two forms of the
.B cp
command: one in which files are copied into a directory,
and another in which a file is copied to another file.
Thus, to copy three files into a directory named
.FN filedir ,
type:
.DS I
cp file1 file2 file3 filedir
.DE
In the above command, three files are copied into the
directory 
.FN filedir ; 
the original versions still reside
in the working directory. 
There is a one-to-one correspondence
between the names in the two directories.
.P
To create two copies of a file in your own working directory,
you must rename the new copy.
To do this, the copy command can be invoked as follows:
.DS I
cp file clone-of-file
.DE
After the above command has executed, two files with
identical contents reside in the working directory.
See also the
.B copy
command, for recursively copying directories.
.HU "Deleting A File"
.in +5
To delete or remove files, simply type:
.DS I
rm file1 file2	
.DE
In the above command, the files
.FN file1
and
.FN file2
are removed from your working directory.
The command
.DS I
rm *
.DE
removes all files from the working directory (subdirectories
are
.I not
removed).
.H 2 "Directory Manipulation and Travel"
.HU "Printing Your Working Directory"
.in +5
All commands are executed relative to a 
.Q "working"
directory.
The name of this directory is given by the
.B pwd
command, which stands for
\&
.Q "print working directory" .
For instance,
if your current working directory is
.FN /usr/joe ,
when you type
.DS I
pwd
.DE
you will get the output:
.DS I
/usr/joe
.DE
You should always think of yourself as residing
.Q "in"
your working directory.
.HU "Listing Directory Contents"
.in +5
The most basic directory command is
.B ls .
The
.B ls
command
sorts and lists the names of the files and directories
that reside in a given directory.
By default, the contents of your working directory are listed.
If arguments are given,
then for each directory argument
.B ls
lists the contents of the given directory;
for each file argument,
.B ls
repeats its name.
.ne 2i
.P
For example, if you type
.DS I
ls
.DE
the output from the command might typically look like this:
.DS I
dir1
dir2
dir3
file1
file2
file3
.DE
Within the above directory, the command
.DS I
ls d* 
.DE
lists the files within each of the directories
.FN dir1 ,
.FN dir2 ,
and
.FN dir3 .
.P
When working at a terminal, it is sometimes distracting
to see the list of names from the 
.B ls
command scroll off the screen.
This can be avoided by using the 
.B lc
command, 
which stands for 
.Q "list in columns" .
Because names are printed in columns, 
more information can fit on the screen
than with 
.B ls.
A sample listing follows:
.DS I
atfile      help        oem         size        v0
bin         lib         papers      src         v1
calendar    maketape    po          termcap     v2
cmds        memos       port        termnames   v5
convert     mgr         probs       test.s
doem        mkfs        rand        testdir
errs        msg         rand.c      ttc
errs.sh     nroff       sco         typeset
.DE
.P
Note that when 
.B lc 
sends output through a pipe,
no columns are sent.
If you 
.I really
want the output to a pipe to be columnar,
you can force it with the 
.B \-C
switch.
Thus, to send a columnar listing to the lineprinter,
you would type:
.DS I
lc -C | lpr
.DE
.ne 2i
Note that 
.B lc
also lets you recursively list a directory and all
of its subdirectories by typing
.DS I
lc -R 
.DE
where the 
.B \-R
stands for recursive.
.P
A command very similar to 
.B ls
and 
.B lc
is the 
.B l
command. 
.B L
gives an expanded 
.Q "long"
listing of a directory,
producing an output that might look something like this:
.DS I
total 501
drwxr-x--- 2 boris     272 Apr  5 14:33 dir1
drwxr-x--- 2 enid      272 Apr  5 14:33 dir2
drwxr-x--- 2 iris      592 Apr  6 11:12 dir3
-rw-r----- 1 olaf      282 Apr  7 15:11 file1
-rw-r----- 1 olaf       72 Apr  7 13:50 file2
-rw-r----- 1 olaf     1403 Apr  1 13:22 file3
.DE
Reading from left to right, 
the information given for each file or directory includes:
.AL 1
.LI
Permissions
.LI
Number of links
.LI
Owner
.LI
Size in bytes
.LI
Time of last modification
.LI
Filename
.LE 1
The information in this listing and 
how to change permissions are discussed below in Section 4.8,
.Q "File and Directory Permissions" .
.HU "Changing Your Working Directory"
.in +5
Your working directory represents your location in
the file system: it is 
.Q "where you are"
in \*(x1.
To alter your location in the \*(x1 file system,
you need only type:
.DS I
cd
.DE
This changes your working directory to that of
your home directory.
To move to any given directory, simply specify that
directory as an argument to
.B cd .
For instance
.DS I
cd /usr
.DE
moves you to the
.FN /usr
directory. 
Because you are always 
.Q "in"
your working directory, 
changing working directories is much like 
.Q "traveling"
from directory to directory.
.HU "Creating a Directory"
.in +5
To create a subdirectory in your working directory,
use the
.B mkdir
command.
For instance, to create a new directory named
.FN phonenumbers , 
simply type:
.DS I
mkdir phonenumbers
.DE
After this command has been executed, a new but empty
directory will exist in the your home directory.
.HU "Removing a Directory"
.in +5
To remove a directory 
located in your working directory, use the
.B rmdir
command.
For instance, to remove the directory named
.FN phonenumbers 
from the current directory,
simply type:
.DS I
rmdir phonenumbers
.DE
Note that the directory 
.FN phonenumbers 
must be
.I empty
before it can be removed; this prevents catastrophic
deletions of files and directories.
If you want to live dangerously, it is possible to
recursively remove the contents of a directory
using the
.B rm
command,
but that will not be explained here.
See 
.IR rm (1)
in the 
.I "\*(x2 Reference Manual"
for more information.
.HU "Renaming a Directory"
.in +5
To rename a directory, use the
.B mv
command.
Note that directories and their contents cannot be
moved with the
.B mv
command; they can only be renamed.
For instance, to rename the directory
.FN little.dir
to
.FN big.dir ,
type:
.DS I
mv little.dir big.dir
.DE
This is a simple renaming operation;
no files are moved.
.ne 2.5i
.H 2 "File and Directory Permissions"
To determine the permissions 
associated with a given
file or directory, use the
.B l
command.
Permissions are given 
by the first ten characters 
of the output from this command.
A sample output follows:
.DS I
total 501
drwxr-x--- 2 boris     272 Apr  5 14:33 dir1
drwxr-x--- 2 enid      272 Apr  5 14:33 dir2
drwxr-x--- 2 iris      592 Apr  6 11:12 dir3
-rw-r----- 1 olaf      282 Apr  7 15:11 file1
-rw-r----- 1 olaf       72 Apr  7 13:50 file2
-rw-r----- 1 olaf     1403 Apr  1 13:22 file3
.DE
The first character is:
.VL 8 2
.LI "d"
if the entry is a directory
.LI "\-"
if the entry is an ordinary file
.LE
.P
The next nine characters are interpreted 
as three sets of three permissions each. 
The first set refers to user (owner) permissions; 
the next to permissions for others in a group associated
with the file or directory;
and the last to permissions for all other users. 
Within each set, the three characters
indicate permission to read, to write, and
to execute the file as a command, respectively. 
For a directory, 
.Q "execute"
permission is interpreted to mean permission to search
the directory for any included files or directories.
In summary, these permissions are indicated as follows:
.VL 8 2
.LI "r"
if the file is readable
.LI "w"
if the file is writable
.LI "x"
if the file is executable
.LI "\-"
if the indicated permission is not granted
.LE
.HU "Changing Read, Write, and Execute Permissions"
.in +5
To change a file or directory's read, write, and execute
permissions, you need only use one command:
.B chmod .
Several examples are included here to illustrate
the syntax for this command. 
Remember that there
are three distinct classes of users: user, group, and
other, and that for each class all three permissions
are either set or not set.
.ne 1.5i
.P
For example, presume that a file named
.FN file1
exists with the following permissions:
.DS I
-rw-r----- 
.DE
To give
.FN file1
read permission for
.I all
classes of users,
type:
.DS I
chmod a+r file1
.DE
Here, 
.Q "a"
stands for 
.Q "all" ,
which is a synonym for
\&
.Q "ugo"
where 
.Q "u"
stands for user, 
.Q "g"
for group, and 
.Q "o"
for other users.
If no user class is specified, then 
.Q "a"
is 
.I normally 
the default, although this default may vary.
The resulting permissions are:
.DS I
-rw-r--r-- 
.DE
.P
To give write and execute permissions to members of a
group only, type:
.DS I
chmod g+wx file1
.DE
For a 
.FN file1 
with the attributes
.DS I
-rw-------
.DE
the above command would alter attributes
so that they looked like this:
.DS I
-rw--wx---
.DE
To remove write and execute permission 
by the user (owner) and group associated with
.FN file1 ,
type:
.DS I
chmod ug-wx file1
.DE
Note how letters are grouped to set specific user/permission
combinations.
.HU "Changing Directory Search Permissions"
.in +5
Obviously, directories cannot be executable files,
yet they also, have an execute attribute that can be set.
This attribute signifies search permission.
if this permission is denied to a particular user, then
that user cannot even list the names of the files in
the directory.
.ne 1i
.P
For example, assume that the directory 
.I dir1
has the following attributes:
.DS I
drwxr-xr-x
.DE
To remove search permission for other users to examine 
.FN dir1 ,
type:
.DS I
chmod o-xr dir1
.DE
The new attributes for
.FN dir1
are then:
.DS I
drwxr-x---
.DE
Note that the read permission for the directory was
also removed with the above 
.B chmod 
command.
In the great majority of cases you will want to
treat these two permissions as a pair when changing
directory permissions.
.ne 6i
.H 2 "Information Processing"
.HU "Calculating"
.in +5
The
.B bc
command
invokes an interactive desk calculator that
can be used as if it were a hand-held calculator.
A typical session with
.B bc
is shown below.
Comments explain what action is performed after
each input line:
.DS 
  /* This is a comment	 */
  123.456789 + 987.654321 /* Add and output	 */
  1111.111110
  9.0000000 - 9.0000001   /* Subtract and output */
  -.0000001
  64/8			  /* Divide and output	 */
  8
  1.12345678934 * 2.3     /* Note precision	 */
  2.58395061548
  19%4			  /* Find remainder	 */
  3
  3^4			  /* Exponentiation	 */
  81
  2/1*2			  /* Note precedence	 */
  4
  2/(1*2)	 	  /* Note precedence again */
  1
  x = 46.5		  /* Assign value to x	 */
  y = 52.5		  /* Assign value to y	 */ 
  x + y + 1.0000	  /* Add and output	 */
  100.0000
  obase=16		  /* Set hex output base */
  15			  /* Convert to hex      */
  F
  16			  /* Convert to hex      */
  10
  64			  /* Convert to hex      */
  40
  255			  /* Convert to hex      */
  FF
  256			  /* Convert to hex      */
  100
  512			  /* Convert to hex      */
  200
  quit			  /* Must type whole word */
.DE
.P
Also available are scaling,
function definition, and programming statements
much like those in the C programming language.
Other features include assignment
to named registers and subroutine calling.
For more information, see 
Chapter 9, 
.Q "BC: A Calculator" .
.HU "Echoing Arguments"
.in +5
The
.B echo
command is used to echo arguments to the standard
output. 
For example
.DS I
echo hello
.DE
outputs
.DS I
hello
.DE
To output several lines of text, surround the echoed
argument in double quotation marks.
For example, type:
.DS I
echo "Now is the time\e
For all good men\e
To come to their party."
.DE
This will output:
.DS I
Now is the time
For all good men
To come to their party.
.DE
One use for echo is to remind yourself
of important events.
For example, you might type
.DS I
echo "Meeting at 9:00am." | mail self
.DE
where 
.Q "self"
is your log in name.
The above example pipes your message into mail; 
mail then sends you the reminder.
.B Echo
is also particularly useful 
if you should ever program in the shell command language.
For more information about the shell, see 
Chapter 7, 
.Q "The Shell" .
.HU "Sorting a File"
.in +5
One of the most useful file processing commands is
.B sort .
By default,
.B sort
sorts the lines of a file according to the
.SM ASCII 
collating sequence.
For example, to sort a file named
.FN phonelist ,
type:
.DS I
sort phonelist
.DE
In the above case, the sorted contents of the
file are displayed on the screen.
To create a sorted version of
.FN phonelist
named
.FN phonesort ,
type:
.DS I
sort phonelist >phonesort
.DE
Note that
.B sort
is useful for sorting the output from other commands.
For example, to sort the output from execution
of a
.B who
command,
type:
.DS I
who | sort >whosort
.DE
A wide variety of options are available for
.B sort .
For more information, see
.IR sort (1)
in the
.I "\*(x2 Reference Manual." 
.HU "Searching for a Pattern in a File"
.in +5
The
.B grep
command selects and extracts lines from a file,
printing only those lines that match a given pattern.
.B Grep
is one of the most useful commands
in all of \*(x1, so learn it well.
.P
For example, to print out all lines in a file containing the
word 
.Q "tty38" ,
type:
.DS I
grep \'tty38\' file
.DE
In general, you should always enclose the pattern
you are searching for in single quotes (\'),
so that special metacharacters are not expanded
unexpectedly by the shell.
.P
.B Grep
is also useful in pipelines containing other \*(x1 commands to 
select
.Q "filter"
out unwanted lines.
.P
As another example, assume that you have a file named
.FN phonelist 
that contains on each line a name followed by a phone number.
Assume also that there are several thousand lines in this list.
What is the quickest way to find the phone number of
someone named joe, whose phone number prefix is 822?
The answer, of course, is to use
.B grep :
.DS I
grep \'joe\' phonelist | grep \'822\-\' >joes.number
.DE
What happens above is that
.B grep
finds all occurrences of lines containing the
word 
.Q "joe"
in the file
.FN phonelist .
The output from this command is then filtered through
another
.B grep
command, which searches for an 
.Q "822\-"
prefix, thus
removing any unwanted joes.
Finally, assuming that a unique phone number for joe
exists with the 
.Q "822\-"
prefix, 
that name and number are placed in the file
.FN joes.number .
.P
For more information about 
.B grep ,
and the types of patterns it can be used to search
for (called regular expressions) see
.IR grep (1)
and its relatives,
.IR fgrep (1),
and 
.IR egrep (1)
in the 
.I "\*(x1 Reference Manual."
.HU "Counting Words, Lines, and Characters"
.in +5
.B Wc
is a simple, useful, easy-to-use utility.
The letters 
.Q "wc"
stand for word count.
Thus,
.B wc
counts the number of words in a file.
Words are presumed to be separated by punctuation, spaces,
tabs, or newlines.
.B Wc
also counts characters and lines; all three counts
are reported by default.
For example, to
count the number of lines, words, and characters in the file
.FN textfile ,
type:
.DS I
wc textfile
.DE
Typical output might be:
.DS I
   4432  18188   97808 textfile
.DE
To specify a count of characters, words, or lines only,
you must use an appropriate mnemonic switch.
To illustrate, examine the following three commands and
the output produced by each:
.DS I
wc -c textfile
  97808 textfile

wc -w textfile
  18188 textfile

wc -l textfile
   4432 textfile
.DE
The first example prints out the number of
characters in 
.FN textfile \|,
the second prints out the number of words,
and the third prints out the number of lines.
.H 2 "Lineprinters"
.HU "Sending a File to the Lineprinter"
.in +5
One of the most common operations that you will want to perform
is printing files on the lineprinter.
The most straightforward method for doing this is to type
.DS I
lpr file1
.DE
for one file, or
.DS I
lpr file1 file2 file3
.DE
for multiple files.
Other common uses of
.B lpr
involve pipes.
For instance, to paginate and print a file of raw text,
type:
.DS I
pr textfile | lpr
.DE
The
.B pr
and
.B lpr
commands are very often used together.
As another example, to sort, paginate, and print a file, type:
.DS I
sort datafile | pr | lpr
.DE
.HU "Getting Lineprinter Queue Information"
.in +5
More than one file may be waiting to be printed at the
lineprinter: \*(x1 does not require that the
file be printed before the
.B lpr
command finishes.
Instead,
.B lpr
makes sure only that the file is placed in a special
directory where it will wait its turn to be printed.
.P
The files in this queue are contained in
the directory
.FN /usr/spool/lpd .
Thus, to examine the lineprinter queue, type:
.DS I
ls -l /usr/spool/lpd
.DE
.ne 2i
.H 2 "Communications"
.HU "Sending Mail"
.in +5
Mail is a system-wide facility that permits you and other
system users to send and receive mail.
To send mail to another user on the system, type
.DS I
mail joe
.DE
where joe is the name of any user of the system.
Following entry of the command,
you enter the actual text of the message you want to send.
Entry of text is terminated by typing a
.SM <CONTROL-D> .
.ne 2.4i
.P
A complete session at the terminal might look like this
on your screen:
.DS I
mail joe
Subject: Meeting
There will be a meeting at 2:00 today
to review recent problems with the
new system.
.SM <CONTROL-D>
.DE
.P
For practice, send mail to yourself.
(This isn't as strange as it might sound \*(EM
mail to oneself is a handy reminder mechanism.)
.P
You can also send a previously prepared letter,
and you can send mail to a number of people all at once.
For more details see
.IR mail (1)
in the 
.I "\*(x2 Reference Manual."
.HU "Receiving Mail"
.in +5
When you log in, you may sometimes get the message:
.DS I
you have mail
.DE
To read your mail, type:
.DS I
mail
.DE
A heading for each message is then displayed on
your terminal screen.
After typing
.SM <RETURN> ,
the contents of the first message are displayed.
Subsequent messages are displayed, one message at a time,
most recent message first, each time you type
.SM <RETURN> .
.P
After each message is displayed,
.B mail
waits for you to tell what to do with the message.
The two basic responses are
.B d ,
which deletes the message,
and
.SM <RETURN> ,
which does not delete the message
(so it will still be there the next time you read your mailbox).
To exit mail, type
.B q ,
for 
.Q "quit" .
Other responses are described in the
.I "\*(x2 Reference Manual"
under
.IR mail (1).
.HU "Using The Automatic Reminder Service"
.in +5
An automatic reminder service is normally available
for all \*(x1 users.
Once each day, \*(x1 uses the
.B calendar
command to examine each user's home directory
for a file named
.FN calendar ,
the contents of which might look something like this:
.DS I
1/23 David's wedding
2/9  Mira's birthday
4/27 Meeting at 2:00
9/1  Karen's birthday
10/3 License renewal
.DE
.B Calendar
examines each line of the calendar file,
culling from the file
those lines containing today's and tomorrow's dates.
These lines are then mailed to you to remind you
of the specified events.
.HU "Writing To a Terminal"
.in +5
To write directly to another user's terminal, use the
.B write
command.
For example, to write to joe's terminal, type:
.DS I
write joe
.DE
After you have executed the command,
each subsequent line that you type is displayed 
both on your own terminal screen and on joe's.
To terminate writing of text to joe, enter a
.SM <CONTROL-D> .
The procedure for a two-way write 
is for each party to end each message
with a distinctive signal, normally (o) for 
.Q "over" .
The signal (oo) for 
.Q "over and out"
is used
when a conversation is about to be terminated.
.TC 2 1 5 0
