'\" 	@(#) Document: V3-00-1
'\" 	@(#) Subject: V3.0 Prog Intro: Ed Part 1
'\" 	@(#) Writer: Stewart Konzen
'\" 	@(#) Work: 1 week
'\" 	@(#) Target: 1/1
'\" 	@(#) Notes: Convert to Ex
'\" 	@(#) Mods: 
.PH "'Ed''Ed'"
.H 2 "Introduction"
Ed is a text editor used to
create and modify text.
The text is normally a document,
a program, or data for a program.
The recommended way to learn ed
is to read this chapter,
simultaneously using ed to follow the examples.
No matter what, you should do the exercises;
they cover material not completely discussed
in the actual text.
.P
This chapter is organized so that the most basic
information is presented early on.  
More difficult and advanced topics are discussed in
later sections.
A complete summary of all ed commands appears as the
last section in the chapter.
.H 2 "Entering and Exiting The Editor"
The simplest way to invoke ed,
.XX "ed \- invocation"
is to type:
.DS I
ed   
.DE
The most common way, however, is to type:
.DS I
ed \fIfilename\fP
.DE
where 
.I filename
is the name of a new or existing file.
.P
To exit the editor,
.XX "ed \- exiting"
all you need to do is type:
.DS I
q
.DE
If you have not written out any changes you have
.XX "ed>commands>q"
made before you quit,
ed will warn you that you will lose these changes
by printing 
.XX "ed \- ?"
.XX "? \- ed warning message"
a question mark (?).
If you still want to quit, type another 
.B q .
.H 2 "Commands
The following subsections describe the individual
ed commands and how they can be used.
Note that most commands are mnemonically named
to describe their function.
.H 3 "Append \- a"
.XX "ed>commands>a"
.XX "a \- ed append command"
As your first problem, suppose you want to create some text
starting from scratch.
Perhaps you are typing the very first
draft of a paper. 
Clearly, it will have to start
somewhere and undergo modifications later.
This section shows you how to put text in a file, just to
get started.
Later we'll talk about how to change it.
.P
When ed is first started, it is like working
with a blank piece of paper\*(EMthere is no text
or information present.
This must be supplied by the person using ed,
usually 
by typing in the text, or by reading it into ed from a file.
We will start by typing in some text,
and discuss how to read files later.
.P
First a bit of terminology.
In ed jargon, the text being
worked on is said to be 
.Q "kept in a buffer" .
Think of the buffer as a work space if you like, 
or simply as the information
that you are going to be editing.
In effect, the buffer is the
piece of paper on which you will write things, make changes,
and finally file away for another day.
.P
You tell ed what to do to your text
by typing instructions called 
.Q "commands" .
Most commands consist of a single letter,
which must be lowercase.
Each command is typed
on a separate line.
Ed makes no response
to most commands;there is no prompting
or typing of messages.
.P
The first command is
.Q "append" ,
written as the letter 
.Q "a"
on a line by itself.
It means 
\*`append (or add) text lines to the buffer,
as they are typed in.\*'
Appending is like writing fresh material on a piece of paper.
.P
To enter lines of text into the buffer,
just type an 
.Q "a" ,
followed by a
.SM <RETURN> ,
followed by the lines of text you want, like this:
.DS I
a
Now is the time
for all good men
to come to the aid of their party.
\&.
.DE
.P
To stop appending, type a
line that contains only a period.
This period (\|.\|) tells ed
that you have finished appending.
(You can also use
.SM <CONTROL-D> ,
but we will use the period throughout this discussion.)
If ed seems to be ignoring you,
type an extra line with just a period (\|.\|) on it.
You may find you've added some garbage lines
to your text, which you will have to take out later.
.P
After appending is completed, the buffer 
contains the following three lines:
.DS I
Now is the time
for all good men
to come to the aid of their party.
.DE
The
.B a
and
.B .
aren't there, because they are not text.
.P
To add more text to what you already have,
just type another
.B a
command, and continue typing your text.
.P
If at any time you make an error in the commands you type to ed,
it will tell you by typing:
.DS I
?
.DE
With practice, you should usually
be able to figure out how your mistake.
.H 3 "Write \- w"
.XX "ed>commands>w"
.XX "w \- ed write command"
It's likely that you will want to save your text for later use.
To write out the contents of the buffer into a file,
use the 
.Q "write"
command,
.B w ,
followed by the name of the file that you want to write to.
This copies the buffer's contents
to the specified file,
destroying any previous information in the file.
For example,
to save the text in a file named
.FN text ,
type:
.DS I
w text
.DE
Leave a space between
.B w
and the filename.
Ed responds by printing the number of characters it has written out.
For instance, ed might respond with
.DS I
68
.DE
(Remember that blanks and the newline character at the end of each
line are included in the character count.)
Writing a file just makes a copy of the text\*(EMthe buffer's 
contents are not disturbed, 
so you can go on adding lines to it.
.P
This is an important point.
Ed at all times works on a copy
of a file, not the file itself.
No change in the contents
of a file takes place until you give a
.B w
command.
Writing out the text to a file from time to time as it is being
created is a good idea, since if the system crashes or
if you make some horrible mistake, you will lose
all the text in the buffer. 
However, any text that was written out to a file is relatively safe.
.H 3 "Quit \- q"
.XX "ed>commands>q"
.XX "q \- ed quit command"
To terminate a session with ed,
save the text you're working on
by writing it to a file using the
.B w
command,
and then type:
.DS I
q
.DE
.P
The system responds with
the \*(x1 prompt character.
At this point your buffer vanishes, with all its text,
which is why you want to write it out before quitting.
Actually, ed will print 
.Q "?" ,
if you try to quit without writing.
At that point, write out the text if you want to
save it;
if not, typing another
.B q
will get you out.
.HU "Exercise"
.SP 1
Enter ed and
create some text by typing:
.SP 1
.DS I
a
\&... text ...
\&.
.DE
Write it out by typing:
.DS I
w \fIfilename\fP
.DE
Then leave ed by typing:
.DS I
q
.DE
Next, use the 
.B cat
command to display the
file on your terminal screen to
see that everything has worked.
.H 3 "Edit \- e"
.XX "ed>commands>e"
.XX "e \- ed edit command"
A common way to get text into 
your editing buffer is to read it in from a file.
This is what you do to edit text
that you have saved with the
.B w
command in a previous session.
The edit command
.B e
fetches the entire contents of a file to the buffer.
So if you had saved the three lines
\&
.Q "Now is the time" ,
etc.,
with a
.B w
.ne 2i
command in an earlier session, the ed command
.DS I
e text
.DE
would fetch the entire contents of the file
.FN text
into the buffer and might respond with
.DS I
68
.DE
which is the number of characters in
.FN text .
.I
If anything was already in the buffer, it is deleted first.
.R
.P
If you use the
.B e
command to read a file into the buffer,
then you need not use a filename after a subsequent
.B w
command.
Ed remembers the last filename used in an
.B e
command,
and
.B w
will write to this file.
Thus, a good way to operate is this:
.DS I
ed
e file
[\fIediting session\fR\|]
w
q
.DE
This way, you can type
.B w
from time to time
and be secure in the knowledge that
if you got the filename right in the beginning,
you are writing out to the proper file each time.
.H 3 "File \- f"
.XX "ed>commands>f"
.XX "f \- ed file command"
You can find out the remembered filename at any time
with the 
.Q "file"
command,
.B f .
Just type
.B f
without a filename.
You can also change the name of the remembered filename with
.B f ;
a useful sequence is
.DS I
ed precious
f  junk
   [rest of editing session]
.DE
which gets a copy of a precious file,
then uses
.B f
to guarantee that a careless 
.B w
command won't overwrite the original.
.H 3 "Read \- r"
.XX "ed>commands>r"
.XX "r \- ed read command"
Sometimes you want to read a file into the buffer
without destroying anything that is already there.
This is done with the 
.Q "read"
command,
.B r .
For example, the command
.DS I
r text
.DE
reads the file
.FN text
into your editing buffer and
adds it to the end of whatever is already in the buffer.
As another example, pretend that you have performed a read after
.ne 1.5i
an edit:
.DS I
e text
r text
.DE
The buffer will then contain
.I two
copies of
.FN text
(six lines):
.DS I
Now is the time
for all good men
to come to the aid of their party.
Now is the time
for all good men
to come to the aid of their party.
.DE
Like the
.B w
and
.B e
commands,
after the reading operation is complete,
.B r
prints
the
number of characters read in.
Generally speaking,
.B r
is used much less than
.B e .
.HU "Exercise"
.SP 1
Experiment with the
.B e
command\*(EMtry reading and printing various files.
You may get the error message
.DS I
?\fIname\fP
.DE
where
.I name
is the name of a nonexistent file.
This means that the file doesn't exist,
typically because you spelled the filename wrong,
or perhaps because you are not allowed to read from
or write to the
file.
Try alternately reading and appending to see that they work
similarly.
Verify that
.DS I
ed file.text
.DE
is equivalent to
.DS I
ed
e file.text
.DE
.H 3 "Print \- p"
.XX "ed>commands>p"
.XX "p \- ed print command"
To
print
the contents of the buffer (or parts
of it) on the terminal screen, use the 
.Q "print"
command,
.B p .
To do this,
specify the lines where
you want printing to begin and where you want it to end,
separated by a comma, and
followed by the letter 
.Q "p" .
Thus, to print the first two lines of the buffer 
.ne 1.5i
(that is, lines 1 through 2) type:
.DS I
1,2p
.DE
Ed responds with:
.DS I
Now is the time
for all good men
.DE
.P
Suppose you want to print
.I all
the lines in the buffer.
You could use
.B 1,3p
as above if you knew there were exactly 3 lines in the buffer.
But you will rarely
know how many lines there are, so what do you use 
for the final line number?
The answer is that ed provides a shorthand symbol for 
\*`the line number of the last line in the buffer\*'\*(EMthe 
dollar sign ($).
Use it this way:
.DS I
1,$p
.DE
This will print
.I all
the lines in the buffer (from line 1 to the last line).
If you want to stop the printing before it is finished, 
press the
.SM <INTERRUPT>
key.
Ed then types
.DS I
?
.DE
and waits for entry of the next ed command.
.P
To print the
.I last
line of the buffer, use:
.DS I
$p
.DE
You can print any single line by typing the line
number, followed by a
.B p .
Thus
.DS I
1p
.DE
produces the response
.DS I
Now is the time
.DE
which is the first line of the buffer.
.P
In fact, ed lets you abbreviate even further:
you can print any single line by typing
.I just
the line number; there's no need to type the letter
.B p .
So if you type
.DS I
$
.DE
ed prints the last line of the buffer.
.P
You can also use
.B $
in combinations like
.DS I
$-1,$p
.DE
which prints the last two lines of the buffer.
This helps when you want to see how far you are in your typing.
.P
The next step is to use address arithmetic to combine the line numbers
like dot (\|.\|), and dollar ($),
with plus (+) and minus (\-).
Thus
.DS I
$-1
.DE
is a command to print the next to last line of
the current file (that is, one line before the line dollar($)).
For example, to recall how far you got in a previous editing session
.DS I
$-5,$p
.DE
prints the last six lines.
(Be sure you understand why it's six, not five.)
If there aren't six in the file, 
you'll get an error message.
.P
As another example
.DS I
\&.-3,.+3p
.DE
prints from three lines before where you are now
(at line dot)
to three lines after,
thus giving you a bit of context.
By the way, the plus (+) can be omitted:
For example
.DS I
\&.-3,.3p
.DE
is identical in meaning.
.P
Another area in which you can save typing effort
in specifying lines is to use plus and minus
as line numbers by themselves.
For example
.DS I
\-
.DE
by itself is a command to move back one line in the file.
In fact, you can string several minus signs together to move
back that many lines.
For example
.DS I
\-\-\-
.DE
moves back three lines, as does 
.DS I
\-3
.DE
Thus
.DS I
-3,+3p
.DE
is also identical to the examples above.
.HU "Exercise"
.SP 1
As before, create some text using the
.B a
command and
experiment with the
.B p
command.
You will find, for example,
that you can't print line 0 or a line beyond
the end of the buffer, and that attempts
to print lines in reverse order using
.B 3,1p 
do not work.
.H 3 "Current Line \- dot (\|.\|)"
.XX "ed>dot"
.XX ". \- dot"
Suppose your editing buffer still contains the following
six lines:
.DS I
Now is the time
for all good men
to come to the aid of their party.
Now is the time
for all good men
to come to the aid of their party.
.DE
If you type
.DS I
1,3p
.DE
ed will display
.DS I
Now is the time
for all good men
to come to the aid of their party.
.DE
Now try typing:
.DS I
p
.DE
This prints
.DS I
to come to the aid of their party.
.DE
which is the third line of the buffer.
In fact, it is the last
(most recent) line that you have done anything with.
You can repeat this
.B p
command without line numbers, and
ed will continue to print line 3.
.P
This happens because ed
maintains a record of the last line
that you did anything to (in this case, line 3, which you
just printed) so that it can be used instead of an explicit
line number.
The line most recently acted on is referred to 
with a period (\|.\|)
and is called
.Q "dot" .
Dot is a line number in the same way that
dollar ($) is; 
it means 
.Q "the current line" ,
or loosely,
.Q "the line you most recently did something to" .
You can use it in several ways.
One possibility is to type:
.DS I
\&.,$p
.DE
This will print all the lines from (and including) the current
line clear to the end of the buffer.
In our example these are lines 3 through 6.
.P
Some commands change the value of dot, while others do not.
The
.B p
command
sets dot to the number of the last line printed.
In the example above,
.B p  
sets both dot and
dollar
to 6.
.P
Dot is often used in combinations like this one:
.DS I
\&.+1	(or equivalently, .+1p)
.DE
This means 
.Q "print the next line"
and is one way
of stepping slowly through the editing buffer.
You can also type
.DS I
\&.-1	(or .-1p)
.DE
which means 
.Q "print the line \fIbefore\fP the current line" .
This enables you to go backwards through the file if you wish.
Another useful command is something like
.DS I
\&.-3,.-1p
.DE
which prints the previous three lines.
.P
.I
Don't forget that all of these change the value of dot.
.R
You can find out what dot is at any time by typing:
.DS I
\&.=
.DE
Ed responds by printing the value of dot.
.P
Let's summarize some things about the
.B p
command
and dot.
Essentially,
.B p
can be preceded by zero, one, or two line numbers.
If there is no line number given, 
ed prints the 
.Q "current line" ,
the line that dot refers to.
If there is one line number given
(with or without the letter
.B p ),
ed prints that line (and dot is set there); and if there
are two line numbers, ed prints all the lines in that range
(and sets dot to the last line printed).
If two line numbers are specified,
the first cannot be bigger than the second.
.ne 1.5i
.P
Typing a single
.SM <RETURN>
causes printing of the next line.
It is equivalent to:
.DS I
\&.+1p
.DE
Try it.
Next, try typing a minus sign (\|\-\|)
alone;
you will find that it is equivalent to typing:
.DS I
\&.-1p
.DE
.H 3 "Delete \- d"
.XX "ed>commands>d"
.XX "d \- ed delete command"
Suppose you want to get rid of the three extra lines in the buffer.
This is done with the 
.Q "delete"
command,
.B d .
Its action is similar to that of
.B p ,
except that
.B d
deletes lines instead of printing them.
The lines to be deleted are specified for
.B d
exactly as they are for
.B p :
.DS I
\fIstarting-line,ending-line\fBd\fR
.DE
Thus, the command
.DS I
4,$d
.DE
deletes lines 4 through the end.
There are now three lines left in our example,
as you can check by typing:
.DS I
1,$p
.DE
Notice that
.B $
now is line 3!
Dot
is set to the next line after the last line deleted,
unless the last line deleted is the last line in the buffer.
In that case, dot is set to
.B $ .
.HU "Exercise"
.SP 1
Experiment with
.B a ,
.B e ,
.B r ,
.B w ,
.B p ,
and
.B d
until you are sure that you
know what they do, and until you understand how dot  (\|.\|),
dollar ($),
and line numbers are used.
.P
If you are adventurous, try using line numbers with
.B a ,
.B r ,
and
.B w ,
as well.
You will find that
.B a
appends lines
.I after
the line number that you specify (rather than after dot);
that
.B r
reads in
a file
.I after
the line number you specify (not necessarily
at the end of the buffer); and that
.B w
writes out exactly the lines
you specify,
but not necessarily the whole buffer.
These variations are sometimes handy.
For instance, you can insert a file at the beginning of a buffer
by typing
.DS I
0r \fIfilename\fP
.DE
.ne 1i
and you can enter lines at the beginning of the buffer
by typing:
.DS I
0a
[\fIinput text here\fP]
\&.
.DE
Notice that typing
.DS I
\&.w
.DE
is very different from
.DS I
\&.
w
.DE
since the former writes out only a single line,
and the latter writes out the whole file.
.H 3 "Substitute \- s"
.XX "ed>commands>s"
.XX "s \- ed substitute command"
We are now ready to try one of the most important
of all commands\*(EMthe 
.Q "substitute"
command
.B s .
This is the command that is used to change individual
words or letters within a line or group of lines.
It is the command you use for correcting spelling
mistakes and typing errors.
.P
Suppose that, due to a typing error, line 1 says:
.DS I
Now is th time
.DE
The letter
\&
.Q "e"
has been left off of the word
\&
.Q "the" .
You can use
.B s
to fix this up as follows:
.DS I
1s/th/the/
.DE
This says to substitute for the characters 
.Q "th" ,
the characters 
.Q "the" ,
in line 1.
To verify that the substitution has worked, type
.DS I
p
.DE
to get
.DS I
Now is the time
.DE
which is what you wanted.
Notice that dot must have been set to the line
where the substitution took place, since the
.B p
command
printed that line.
Dot is always set this way with the
.B s
command.
.P
The syntax for the substitute command follows:
.DS I
\fIstarting-line,ending-line\fBs/\|\fIpattern\fB/\|\fIreplacement\fB/\fR
.DE
Whatever string of characters is between the first pair of
slashes is replaced by whatever is between the second pair,
in
.I all
the lines between
.I starting-line
and
.I ending-line.
Only the first occurrence on each line is changed, however.
How to change
.I every
occurrence is discussed later in the section.
The rules for line numbers are the same as those for
.B p ,
except that dot is set to the last line changed.
(But there is a trap for the unwary: if no substitution
takes place, dot is
.I not
changed.
This causes printing of a question mark (?)
as a warning.)
.P
Thus, you can type
.DS I
1,$s/speling/spelling/
.DE
and correct the first spelling mistake
on each line in the text.
.P
If no line numbers are given, the
.B s
command assumes we mean
\&
.Q "make the substitution on line dot" ,
so it changes things only
on the current line.
This leads to the very common sequence
.DS I
s/something/something else/p
.DE
which makes some correction on the
current line, and then prints it, to make sure it
worked out right.
If it didn't,
you can try again.
(Notice that there is
a
.B p
on the same line as the
.B s
command.
With few exceptions,
.B p
can follow any command;
no other multicommand lines are legal.)
.P
It's also legal to type
.DS I
s/string//
.DE
which means 
.Q "change the first string of characters to nothing" ,
or, in other words, remove them.
This is useful for deleting extra words in a line or removing extra
letters from words.
For instance, if you had
.DS I
Nowxx is the time
.DE
you could type
.DS I
s/xx//p
.DE
to get
.DS I
Now is the time
.DE
Notice that two adjacent slashes 
mean 
.Q "no characters" , 
not a space.
There
.I is
a difference!
.HU "Exercise"
.SP 1
Experiment with the substitute command.
See what happens if you
substitute some word on a line
with several occurrences of that word.
For example, type:
.DS I
a
the other side of the coin
\&.
s/the/on the/p
.DE
This results in:
.DS I
on the other side of the coin
.DE
A substitute command changes only the
.I first
occurrence of the first string.
You can change all occurrences by adding a
.B g
(for 
.Q "global" )
to the
.B s
command, like this:
.DS I
s/ ... / ... /gp
.DE
Try other characters instead of slashes to delimit the two sets
of characters in the
.B s
command\*(EManything should work except spaces or tabs.
.H 3 "Search \- /\|\fIstring\fP/ and ?\|\fIstring\fP\|?"
.XX "ed>commands>/.../"
.XX "/.../ \- ed search command"
.XX "ed>commands>?...?"
.XX "?...? \- ed backwards search command"
Now that you've mastered the substitute command, you
can move on to mastering another important concept:
context searching.
.P
Suppose you have the original three line text in the buffer:
.DS I
Now is the time
for all good men
to come to the aid of their party.
.DE
Suppose you want to find the line that contains
the word 
.Q "their" ,
so that you can change it to
the word 
.Q "the" .
With only three lines in the buffer, it's pretty easy
to keep track of which line the word
.Q "their"
is on.
But if the buffer contained several hundred lines,
and you'd been making changes, deleting and rearranging lines,
and so on, you would no longer really know what this line
number would be.
Context searching is simply a method of specifying the desired line,
regardless of what its number is,
by specifying some textual pattern contained on the line.
.P
The way to say \*`search for a line
that contains this particular string of characters\*'
is to type:
.DS I
/string of characters we want to find/
.DE
For example, the ed command
.DS I
/their/
.DE
is a context search which
is sufficient to find the desired line\*(EMit 
will locate the next occurrence of
the characters between slashes (i.e.,
.Q "their" ).
It also sets dot to that line
and prints the line for verification:
.DS I
to come to the aid of their party.
.DE
.Q "Next occurrence"
means that ed
starts looking for the string at line
.Q ".+1" ,
searches to the end of the buffer,
then continues at line 1 and searches to line dot.
(That is, the search 
.Q "wraps around"
from
.B $
to 1.)
It scans all the lines in the buffer 
until it either finds the desired line or gets back to dot again.
If the given string of characters can't be found in any line,
ed prints an error message:
.DS I
?
.DE
Otherwise, ed prints the line it found.
.P
You can also search
.I backwards
in a file for search strings
by using question marks instead of slashes.
For example
.DS I
?thing?
.DE
searches backwards in the file for the word 
.Q "thing".
This is especially handy when you realize that the thing
you want to operate on is backwards from
where you are currently editing.
.P
The slash and question mark are the only characters you can
use to delimit a context search, though you can use
any character in a substitute command.
(If you get unexpected results using any of the characters
.DS I
^    .    $    [    *    \e    &
.DE
read 
.Q "Section 5.4, Context and Regular Expressions." )
.P
You can do both the search for the desired line
.I and
a substitution all at once, like this:
.DS I
/their/s/their/the/p
.DE
This yields:
.DS I
to come to the aid of the party.
.DE
There are three separate actions in the last command.
The first is a context search for the desired line, 
the second is the substitution,
and the third is the printing of the line.
.P
The expression 
.Q "/their/"
is a context search expression.
In their simplest form, all context search expressions 
are like this\*(EMa string of characters surrounded by slashes.
Context searches are interchangeable with line numbers,
so they can be used by themselves to find and print a desired line,
or as line numbers for some other command, like
.B s .
They were used both ways in the examples above.
.P
Suppose the buffer contains the three familiar lines
.DS I
Now is the time
for all good men
to come to the aid of their party.
.DE
Then the ed line numbers
.DS I
/Now/+1
/good/
/party/-1
.DE
are all context search expressions, and they all refer
to the same line (line 2).
To make a change in line 2,
you could type
.DS I
/Now/+1s/good/bad/
.DE
or
.DS I
/good/s/good/bad/
.DE
or
.DS I
/party/-1s/good/bad/
.DE
.ne 1i
The choice is dictated only by convenience.
For instance, you could print 
all three lines by typing either
.DS I
/Now/,/party/p
.DE
or
.DS I
/Now/,/Now/+2p
.DE
or by any number of similar combinations.
The first combination is better if you don't
know how many lines are involved.
(Of course, if there were only three lines in the buffer,
you'd use
.DS I
1,$p
.DE
but not if there were several hundred.)
.P
The basic rule is that a context search expression is the same as
a line number, so it can be used wherever a line number is needed.
.P
Suppose you ask for the search
.DS I
/horrible thing/
.DE
and when the line is printed you discover that it
isn't the 
.Q "horrible thing"
that you wanted,
so it is necessary to repeat the search again.
You don't have to retype the search,
for the construction
.DS I
//
.DE
is a shorthand expression for 
.Q "the previous thing that was searched for" ,
whatever it was.
This can be repeated as many times as necessary.
You can also go backwards, since
.DS I
??
.DE
searches for the same thing,
but in the reverse direction.
.P
Not only can you repeat the search, but you can
use /\|/ as the left side of a substitute command,
to mean
.Q "the most recent pattern" .
For example, examine:
.DS I
/horrible thing/
[\fIed prints line with "horrible thing"\fR]
s//good/p
.DE
To go backwards and change 
.Q "horrible thing"
to 
.Q "good" ,
type:
.DS I
??s//good/
.DE
.HU "Exercise"
.SP 1
Experiment with context searching.
Try a body of text with
several occurrences
of the same string of characters, and scan through it using
the same context search.
.P
Try using context searches as line numbers for the
substitute, print, and delete commands.
(They can also be used
with
.B r ,
.B w ,
and
.B a .)
.P
Try context searching using
.BI ? text ?
instead of
.BI /\| text \|/.
This scans lines in the buffer in reverse order
rather than normal order.
This is sometimes useful if you go too far while looking for a
string of characters. 
It's an easy way to back up in the file you're editing.
.P
(If you get unexpected results with any of the characters
.DS I
^    .    $    [    *    \e    &
.DE
read
.Q "Section 5.4, Context and Regular Expressions." )
.H 3 "Change and Insert \- c and i"
.XX "ed>commands>c"
.XX "c \- ed change command"
.XX "ed>commands>i"
.XX "i \- ed insert command"
This section discusses the 
.Q "change"
command,
.B c ,
which is used to change or replace a group of one or more lines,
and the 
.Q "insert"
command,
.B i ,
which is used for inserting a group of one or more lines.
.P
The 
.B c
command is used
to replace a number of lines with different lines that
you type at the terminal.
For example,
to change lines
.Q ".+1"
through
.Q "$"
to something else, type:
.DS I
\&.+1,$c
[\fItype the lines of text you want here ...\fP]
\&.
.DE
The lines you type between the
.B c
command and the dot (\|.\|)
will take the place of the original lines between
start line and end line.
This is useful in replacing a line
or several lines that have errors in them.
.P
If only one line is specified in the
.B c
command, then only
that line is replaced.
(You can type in as many replacement lines as you like.)
Notice the use of a period to end the
input.
This works just like the period
in the append command and 
must appear by itself on a new line.
If no line number is given, the current line specified
by dot is replaced.
The value of dot is set to the last line you typed in.
Note that the terminating period and the line referenced
by dot are completely different: the first is
used simply to terminate a command, the second points
at a specific line of text.
.P
The 
.B i 
command is similar to the append command.
For example
.DS I
/string/i
[\fItype the lines to be inserted here\fP ...]
\&.
.DE
inserts the given text
.I before
the next line that contains 
.Q "string" .
The text between
.B i
and the terminating period is
.I "inserted before"
the specified line.
If no line number is specified, dot is used.
Dot is set to the last line inserted.
.HU "Exercise"
.SP 1
The 
.B c 
command is like a combination of delete followed by insert.
Experiment to verify that
.DS I
\fIstart,end\fPd
i
[\fItext\fP]
\&.
.DE
is almost the same as
.DS I
\fIstart,end\fPc
.I
[\fItext\fP]
\&.
.R
.DE
These are not
.I precisely
the same if line dollar ($)
gets deleted.
.P
Experiment with
.B a
and
.B i 
to see that they are
similar, but not the same.
Observe that
.DS I
\fIline-number\fPa 
[\fItext\fP]
\&.
.DE
appends
.I after
the given line, while
.DS I
\fIline-number\fPi
\&... \fItext\fP ...
\&.
.DE
inserts
.I before
it.
Observe that if no line number is given,
.B i
inserts before line dot, while
.B a
appends
after line dot.
.H 3 "Move \- m"
.XX "ed>commands>m"
.XX "m \- ed move command"
The 
.Q "move"
command,
.B m ,
is used for cutting and pasting.
It lets you move a group of lines
from one place to another in the buffer.
Suppose you want to put the first three lines
of the buffer at the end instead.
You
.I could
do it by typing
.DS I
1,3w temp
$r temp
1,3d
.DE
where 
.I temp
is the name of a temporary file.
However, you can do it more easily with the
.B m
command:
.DS I
1,3m$
.DE
The general case is
.DS I
\fIstart-line,end-line\fBm\fIafter-this-line\fR
.DE
Notice that there is a third line to be specified:
the place where the moved text gets put.
Of course, the lines to be moved can be specified
by context searches.
If you had
.DS I
First paragraph
\&...
end of first paragraph.
Second paragraph
\&...
end of second paragraph.
.DE
you could reverse the two paragraphs like this:
.DS I
/Second/,/end of second/m/First/-1
.DE
Notice the \-1.
The moved text goes
.I after
the line mentioned.
Dot gets set to the last line moved.
.P
As another example of a frequent operation,
you can reverse the order of two adjacent lines
by moving the first one after the second.
Suppose that you are positioned at the first.
Then
.DS I
m+
.DE
moves line dot to one line after line dot.
If you are positioned on the second line,
.DS I
m--
.DE
does the interchange.
.P
The
.B m
command is more succinct and direct than
writing, deleting and rereading.
This is a matter of personal taste;
do what you have most confidence in.
The main difficulty with the
.B m
command
is that if you use patterns to specify both the lines
you are moving and the target,
you have to take care that you specify them properly,
or you may not move the lines you wanted.
The result of a bad
.B m
command can be a ghastly mess.
Doing the job a step at a time
makes it easier for you to verify at each step
that you accomplished what you wanted.
It is also a good idea to issue a 
.B w
command
before doing anything complicated;
then if you make a mistake, it's easy to back up
to where you were.
.H 3 "Global \- g and v"
.XX "ed>commands>g"
.XX "g \- ed global command"
.XX "ed>commands>a"
.XX "v \- ed global command"
The 
.Q "global"
commands
.B g
and
.B v
are used to execute one or more editing commands 
on all lines that either contain
.RB ( g ) 
or don't contain
.RB ( v ) 
a specified pattern.
.P
As the simplest example, the command
.DS I
g/XENIX/p
.DE
prints all lines that contain the word 
.Q "XENIX" .
The pattern that goes between the slashes can be anything
that could be used in a line search or in a substitute command;
exactly the same rules and limitations apply.
.P
As another example, then,
.DS I
g/^\e./p
.DE
prints all the formatting commands 
in a file (lines that begin with 
.Q "." ).
.P
The
.B v
command is identical to
.B g ,
except that it operates on those line that do
.I not
contain an occurrence of the pattern.
Mnemonically, the 
.Q "v"
can be thought of as part of
the word 
.RB in v erse.
.P
For example
.DS I
v/^\e./p
.DE
prints all the lines that don't begin with a period
(i.e., the actual text lines).
.ne 1i
.P
Any command can follow
.B g
or
.B v .
For example, the following command
deletes all lines that begin with 
.Q "." :
.DS I
g/^\e./d
.DE
This command deletes all empty lines:
.DS I
g/^$/d
.DE
.P
Probably the most useful command 
that can follow a global command is the
substitute command, 
for this can be used to make a change
and print each affected line for verification.
For example, we could change 
the word 
.Q "Xenix"
to 
.Q "XENIX"
everywhere, and verify that 
it really worked, with
.DS I
g/Xenix/s//XENIX/gp
.DE
.P
Notice that we used /.../ in the substitute command to mean
.Q "the previous pattern" ,
in this case, 
.Q "Xenix" .
The 
.B p
command executes on each line
that matches the pattern,
not just on those in which a substitution took place.
.P
The global command operates by making two passes over the file.
On the first pass, all lines that match the pattern are marked.
On the second pass, each marked line is examined in turn,
dot is set to that line, and the command executed.
This means that it is possible for the command that follows a
.B g
or
.B v
command to use addresses, set dot, and so on, quite freely.
For example:
.DS I
g/^\e.P/+
.DE
prints the line that follows each 
.Q ".P"
command (the signal for
a new paragraph in some formatting packages).
Remember that plus (+) means 
.Q "one line past dot."
And
.DS I
g/topic/?^\e.H?1
.DE
searches for each line that contains 
.Q "topic" , 
scans backwards until it finds
a line that begins 
.Q ".H"
(a heading) and prints the line
that follows that,
thus showing the headings under which 
.Q "topic"
is mentioned.
Finally
.DS I
g/^\e.EQ/+,/^\e.EN/-p
.DE
prints all the lines that lie between
lines beginning with 
.Q ".EQ"
and 
.Q ".EN"
formatting commands.
.P
The
.B g
and
.B v
commands can also be
preceded by line numbers, in which case the lines searched
are only those in the range specified.
.P
It is possible to give more 
than one command under the control of a global command.
As an example,
suppose the task is to 
change 
.Q "x"
to 
.Q "y"
and 
.Q "a"
to 
.Q "b"
on all lines that contain 
.Q "thing" .
Then
.DS I
g/thing/s/x/y/\e
s/a/b/
.DE
is sufficient.
The backslash (\|\e\|) signals the
.B g
command that the set of commands continues on the next line;
it terminates on the first line that does not end with a backslash.
.P
Note that you cannot use a substitute command
to insert a new line within a 
.B g
command.
.P
You should watch out for this problem.
The command
.DS I
g/x/s//y/\e
s/a/b/
.DE
does
.I not
work as you expect.
The remembered pattern is 
the last pattern that was actually executed,
so sometimes it will be
.Q "x"
(as expected), and sometimes it will be 
.Q "a"
(not expected).
You must spell it out, like this:
.DS I
g/x/s/x/y/\e
s/a/b/
.DE
.P
It is also possible to execute 
.B a ,
.B c
and
.B i
commands as part of a global command. 
As with other multiline constructions,
all that is needed is to add a backslash
at the end of each line except the last.
Thus, to add an 
.Q ".nf"
and 
.Q ".sp"
command before each 
.Q ".EQ"
line, type:
.DS I
g/^\e.EQ/i\e
\&.nf\e
\&.sp
.DE
There is no need for a final line containing a 
period (\|.\|) to terminate the 
.B i
command,
unless there are further commands
to be executed under the global command.
On the other hand, it does no harm to put it in either.
.H 3 "List \- l"
.XX "ed>commands>l"
.XX "l \- ed list command"
Ed provides two commands for printing 
the contents of the lines you're editing.
You should be familiar with
.B p ,
in combinations like
.DS I
1,$p
.DE
to print all the lines you are editing,
or
.DS I
s/abc/def/p
.DE
to change 
.Q "abc"
to
.Q "def"
on the current line.
Less familiar is the list command
.B l ,
which gives slightly more information than
.B p .
In particular,
.B l
makes visible characters that are normally invisible,
such as tabs and backspaces.
If you list a line that contains some of these,
.B l
prints each tab as 
.Q ">"
and each backspace as 
.Q "<" .
This makes it much easier to correct the sort of typing mistake
that inserts extra spaces adjacent to tabs,
or inserts a backspace followed by a space.
.P
The
.B l
command
also 
.Q "folds"
long lines for printing.
Any line that exceeds 72 characters 
is printed on multiple lines;
each printed line 
except the last is terminated by a backslash (\|\e\|),
so you can tell it was folded.
This is useful for printing lines longer than the width
of your terminal screen.
.P
Occasionally, the
.B l
command will print in a line a string of numbers 
preceded by a backslash, such as \e07 or \e16.
These combinations are used 
to make visible characters that normally don't print,
like form feed or vertical tab or bell.
Each backslash-number combination is a single character.
When you see such characters, be wary:
they may have surprising meanings when printed on some terminals.
Often their presence means 
that your finger slipped while you were typing;
you almost never want them.
.H 3 "Undo \- u"
.XX "ed>commands>u"
.XX "u \- ed undo command"
Occasionally you will make a substitution in a line,
only to realize too late that it was a mistake.
The 
.Q "undo"
command,
.B u ,
lets you 
.Q "undo"
the last substitution:
the last line that was substituted can be restored to
its previous state by typing:
.DS I
u
.DE
This command does
.I not 
work with the 
.B g
and 
.B v
commands.
.H 3 "Mark \- k"
.XX "ed>commands>k"
.XX "k \- ed mark command"
The mark command,
.B k ,
provides a facility for marking a line
with a particular name, 
so that you can later reference it by name,
regardless of its actual line number.
This can be handy for moving lines
and keeping track of them as they move.
For example
.DS I
kx
.DE
marks the current line with the name 
.Q "x" .
If a line number precedes the
.B k ,
that line is marked.
(The mark name must be a single lowercase letter.)
Now you can refer to the marked line with the notation:
.DS I
\&\'x
.DE
.P
Note the use of the single quotation mark (\|\'\|) here.
Marks are most useful for moving things around.
Find the first line of the block 
to be moved and then mark it with:
.DS I
ka
.DE
Then find the last line and mark it with
.DS I
kb
.DE
Now position yourself at the place 
where the text is to go and type:
.DS I
\&\'a,\'bm.
.DE
.P
Bear in mind that a line can have only one 
mark name associated with it at any given time.
.H 3 "Transfer \- t"
.XX "ed>commands>t"
.XX "t \- ed transfer command"
We mentioned earlier the idea of saving a line
that is hard to type or used often,
to cut down on typing time.
Of course, this could be more than one line;
then the saving is presumably even greater.
.P
Ed provides another command, called
.B t
(for transfer)
for making a copy of a group of one or more lines
at any point.
This is often easier than writing and reading.
.P
The 
.B t
command is identical to the
.B m
command, except that instead of moving lines
it simply duplicates them at the place you named.
Thus
.DS I
1,$t$
.DE
duplicates the entire contents that you are editing.
.P
A more common use for
.B t
is to create a series of lines that differ only slightly.
For example, you can type
.DS I
a
\&abcdefghijkl  x  zzzzzzz [long line]
\&.
t.	[make a copy]
s/x/y/	[change it a bit]
t.	[make third copy]
s/y/z/	[change it a bit]
.DE
and so on.
.H 3 "Shell Escape \- !"
.XX "ed>commands>!"
.XX "! \- ed shell escape"
Sometimes it is convenient 
to temporarily escape from the editor to execute
a \*(x1 command without leaving the editor.
The shell 
.Q "escape"
command,
.B ! ,
provides a way to do this.
You can really execute
.I any
\*(x1 command, including another ed.
(This is quite common, in fact.)
.P
If you type
.DS I
!\fIcommand\fP
.DE
your current editing state is suspended,
and the \*(x1 command you asked for is executed.
When the command finishes, ed
will signal you by printing another exclamation (!);
at that point you can resume editing.
