.PH "'Vi''Vi'"
.H 2 "Introduction"
Vi is a screen-oriented text editor that can be
used for most any text editing need.  
It is well integrated into the \*(x1 environment
and should be thought of, along with the shell, as 
one of the central \*(x1 tools.
Vi
offers a powerful set of text editing
operations based on a mnemonic command set.
Most commands are single keystrokes that perform
simple editing functions.
Vi displays a full screen
.Q "window"
into the file
you are editing.
This window can be changed quickly and easily within Vi,
and provides visual feedback while editing
(the name Vi itself is short for 
.Q "visual" ).
.P
As you use Vi, it is important to realize 
that it and the line editor Ex are one and the same editor:
the names Vi and Ex identify a particular user interface
rather than any underlying functional difference.
The differences in user interface, however, are
quite striking.  
Ex is a powerful line-oriented editor.  
However, visual
updating of the terminal screen is limited,
and commands are entered on a command line.
Vi, on the other hand, is a screen-oriented editor
designed so that what you see on the screen corresponds
exactly and immediately to the contents of the file you are editing.
Most Vi commands 
are single keystroke mnemonics that do
not require a command line.
.P
For most editing purposes, you will want to use Vi
rather than either of the editors Ed or Ex
because of the superior way in which
Vi displays file contents on the screen.
It is important, however, to realize that many of
the commands available to you in Ex also work in Vi.
Those commands that work in an identical fashion are
those that you will type on the bottom status line in Vi.
.bp
.H 2 "Demonstration Run"
.tr ~~
The following demonstration run gives you 
hands-on experience using Vi. 
It should give you 
some initial satisfaction that Vi can be
used for most any editing purpose.
Remember that the best way to learn Vi is to actually use it,
so don't be afraid to experiment.
.P
\fINOTE:\fP Most of the Vi commands in this
demonstration run are single keystrokes that do 
.I not
require a terminating  
.SM <RETURN>. 
Therefore, do 
.I not
assume that a 
.SM <RETURN>
is needed after the entry of each command.
Commands that 
.I do
require a terminating 
.SM <RETURN>
are called Ex commands and are entered
as command lines on the Vi status line.
.P
To begin, you must first make
sure that your terminal has been properly set up.
Most terminals are supported, so there should be no problem.
However, this demonstration run presumes that Vi knows about
the terminal you are using.
See Section 6.8 
.Q "Start-Up Files and Options" ,
for more information about setting up your terminal for use with Vi.
.P 
To enter the editor type:
.DS I
vi temp
.DE
This invokes the editor
and places you
in Vi command mode, where the keys you press are
interpreted as editing commands.
The editor then clears your screen and prints out a
row of tildes (~). 
You are initially editing a temporary file called
the editing buffer.
The top line of your display is the only line in the
editing buffer and is marked by the cursor.
The line containing the cursor is called the 
.Q "current line" .
The lines containing tildes are not part of the
editing buffer: they indicate lines on the screen
only, not real lines in the editing buffer.
When you write out the editing buffer,
you will write to the file named
.FN temp ,
which is the same as the file you named when you
invoked the editor.
.ne 2.5i
.P
In our examples, the cursor will be indicated by an
underscore, as shown below:
.DS I
 --------------------------------------
|  _                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
.P
Note that we show a shrunken ten line screen to save space. 
In reality, however,
Vi takes advantage of whatever size screen you have.
.P
To begin, create some text by using the 
.B i
(insert) command.
To do this, type:
.DS I
i
.DE
.ne 2.5i
Next, type the following three lines of text to give yourself
something to play around with (note that 
.SM <RETURN>
and 
.SM <ESC>
are single keys):
.DS I
 --------------------------------------
|  Files contain text.<RETURN>         |
|  Text contains lines.<RETURN>        |
|  Lines contain characters.<RETURN>   |
|  <ESC>                               |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Like most commands, the 
.B i
command is mnemonic (for insert) and is not echoed on your screen.  
The command itself switches you from command mode to
insert mode.
Once in insert mode, the characters you type are
inserted into the editing buffer; they are 
.I not
interpreted as Vi commands.
To exit insert mode and reenter command mode 
you will always need to type
.SM <ESC> .
This switching between modes occurs often in
Vi, so get used to it now.
.P
Next comes a command that you'll use frequently in Vi: 
the repeat command. 
The repeat command repeats the most
recent insert or delete command.
Since we have just executed an insert command, the
repeat command repeat the insertion,
duplicating the inserted text.
The repeat command is executed by typing a period (.) or 
.Q "dot" .
So, just type
.DS I
\&\fB.\fR
.DE
to insert another three lines of text.
The command is repeated relative to the location of
the cursor and inserts text 
.I below 
the current line. 
(The current line is always the line 
containing the cursor.)
After you type dot, your screen will look like this:
.DS I
 --------------------------------------
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  _                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Another command which is very useful (and which
you'll need often in the beginning) is the undo command, 
.B u .
Type 
.DS I
u
.DE
and notice that the three lines you just finished inserting are
deleted or 
.Q "undone" :
.DS I
 --------------------------------------
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  _                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Now type 
.DS I
u
.DE
again, and the three lines are reinserted!
This undo feature can be remarkably useful in recovering
from inadvertent deletions or insertions.
Notice that in contrast to the repeat command (\^\fB.\fR\^),
the undo command 
.I inverts
the last insert or delete command.  
And because the undo command is an insert or delete
command itself, two consecutive undo commands cancel
each other out.
.P
Now let's learn how to move the cursor around in Vi.
Typing the keys 
.Q "h" , 
.Q "j" , 
.Q "k" ,
and 
.Q "l" 
will move the cursor left, down, up, and right, respectively.
Note that these keys are chosen
because of their relative positions on the keyboard,
not for any mnemonic reason.
On most terminals, you can also use the arrow keys to
move in the same way.
Remember that the 
.Q "h" , 
.Q "j" , 
.Q "k" , 
and 
.Q "l"
keys and the arrow keys
only work when in command mode.
.P
Try moving the cursor using these keys.
When you are done, type the 
.B H
command to home the cursor in the upper left 
corner of the screen.
Then type the 
.B L 
command to move to the lowest line on the screen.
(Note that case is significant in our example: 
.B L 
moves to the lowest line on the screen;
while 
.B l
will move the cursor forward one character.)
Next, try moving the cursor to the last line in the
file with the 
.Q "goto"
command, 
.B G .
If you type 
.Q "2G" ,
the cursor will move to 
the beginning of the second line in
the file; if you have a 10,000 line file, and type
.Q "8888G" ,
the cursor will go to the beginning of line 8888.
.P
The above cursor movement commands should allow you 
to move around well enough for this demonstration run.
Other cursor movement commands you might want to try out
are:
.B w ,
to move forward a word;
.B b ,
to back up a word;
.B 0
to move to the beginning of a line;
and 
.B $
to move to the end of a line.
.P
Several screen-oriented scrolling commands also exist.
These are all mnemonically named control characters: 
.VL 10 5
.LI "\s-2<CONTROL-U>\s0"
Scroll up
.LI "\s-2<CONTROL-D>\s0"
Scroll down
.LI "\s-2<CONTROL-F>\s0"
Page forward one screenful
.LI "\s-2<CONTROL-B>\s0"
Page backwards one screenful
.LE
.P
You can also search forward for a string of characters by
typing a slash (/) followed by the string of
characters you are searching for, terminated by a 
.SM <RETURN>.
For example, type 
.DS I
H
.DE
to move the cursor to the top of the screen, then type
.DS I
/char<RETURN>
.DE
as shown below:
.DS I
 --------------------------------------
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain \fIc\fPharacters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  /char<RETURN>                       |
 --------------------------------------
.DE
Your cursor moves to the beginning of the word 
.Q "characters"
on line three.
To search for the next occurrence of the string 
.Q "char" ,
simply type the character 
.Q "n" . 
This will take you to the beginning of the word 
.Q "characters" 
on line six.
If you type 
.Q "n" 
.I again,
Vi will search past the end of the file, wrap
around to the beginning, and again find the
occurrence of the string 
.Q "char"
on line three.
.P
Note that the slash character and the string that
you were searching for appear 
at the bottom of the screen before you type. 
This bottom line is the Vi status line. 
It is used to display several different kinds of information:
.AL 1
.LI 
Ex commands
.LI
Strings that you are searching for 
.LI
Buffer status information
.LI
Error messages 
.LI
Any other information that
needs to be distinguished from the text that is part of your file
.LE
.P
For example,
to get status information about the editing buffer, type 
.SM <CONTROL-G> .
This tells you the name of the file you are editing,
whether it has been modified,
the current line number, the number of lines in the file, 
and your location in the file as a percentage 
of the number of lines in the file.
All this information is given on the status line.
.P
Now that we know how to insert and create text, and
how to move around within the editing buffer, we're
ready to delete text.
The three most common delete commands are:
.VL 10 5
.LI "\fBdd\fR"
Delete the current line 
(i.e., the line in which the cursor resides).
.LI "\fBdw\fR"
Delete the word in which the cursor resides.
.LI "\fBx\fR"
Delete the character beneath the cursor.
.LI "\fBD\fR"
Delete from the cursor to the end of the line.
.LI "\fBd0\fR"
Delete from the cursor to the start of the line.
.LI "\fB.\fR"
Repeat the last change. 
(Use this only if your last command was a deletion
and not an insertion, otherwise you'll insert text
instead of delete it.)
.LE
.P
To learn how all these commands work, we'll step
you through the deletion of various parts of the editing buffer.  
To begin, move to the first line of your editing
buffer by typing:
.DS I
1G
.DE
.ne 2.5i
At first, your editing buffer should look like this:
.DS I
 --------------------------------------
|  \fIF\fPiles contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Now type
.DS I
dd
.DE
to delete the first line.
Your editing buffer now looks like this:
.DS I
 --------------------------------------
|  \fIT\fPext contains lines.                |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Next type
.DS I
dw
.DE
to delete the word in which the cursor resides.
Your file now looks like this:
.DS I
 --------------------------------------
|  \fIc\fPontains lines                      |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
.ne 2.5i
.P
You can quickly delete the character beneath the cursor by typing:
.DS I
x
.DE
This leaves:
.DS I
 --------------------------------------
|  \fIo\fPntains lines.                      |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Now type a 
.Q "w"
command to move your cursor to the
beginning of the word 
.Q "lines"
on line one.
Then type an uppercase 
.Q "D"
to delete to the end 
of the line:
.DS I
D
.DE
This leaves your editing buffer looking like this:
.DS I
 --------------------------------------
|  ontains_                            |
|  Text contains lines.                |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
Now type 
.DS I
d0
.DE
to delete all characters on the line 
.I before 
the cursor.
This leaves a single space on the line:
.DS I
 --------------------------------------
|  _                                   |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
 --------------------------------------
.DE
All of the editing you have been doing has affected
the editing buffer, and
.I not
the file named 
.I temp 
that you specified when you invoked Vi. 
To write the editing buffer out to 
.I temp ,
use the Ex 
.Q write 
command:
.DS I
 --------------------------------------
|  _                                   |
|  Lines contain characters.           |
|  Files contain text.                 |
|  Text contains lines.                |
|  Lines contain characters.           |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  ~                                   |
|  :w<RETURN>                          |
 --------------------------------------
.DE
All Ex commands are preceded by a colon which
acts as a prompt on the status line.
Ex commands themselves are entered on this line
and terminated with a 
.SM <RETURN> .
If you want to write the editing buffer out to a
file other than
.I temp,
you can give the 
.B w
command a filename argument that specifies the
name of the file you want to write to.
.P
In general, Ex commands allow you to interface
with the operating system.
For instance, you can read in the contents of a file
.I below
the current line by typing
.DS I
:r \fIfilename\s-2\fR<RETURN>\s0
.DE
where 
.I filename 
is the name of the file you want to read in.
You can also execute arbitrary \*(x1 commands such as 
.B date ,
by typing:
.DS I
:!date\s-2<RETURN>\s0 
.DE
This will output the date and then prompt 
you to press 
.SM <RETURN>
to reenter Vi command mode.
Go ahead and try it.
.P
Note that when you execute Ex commands, you are 
really executing commands available in the
line-oriented editor called Ex.  
Ex and Vi are really one and the same editor; the
only difference between the two is the user interface.
.P
Besides the set of editing commands
described above, 
there are a number of options that can be set either
when you invoke Vi, or later when editing.
These options allow you to control a large number of
editing parameters.
For example, you can specify automatic line numbering,
automatic word wrap, and whether or not case is
significant in string searches.
You can get a complete list of the available options
by typing:
.DS I
:set all\s-2<RETURN>\s0
.DE
How to set these options is described in Section 6.7,
.Q "Start-Up Files and Options" ,
but it is important now that you be aware of their existence.  
Depending on what you are doing, and your own
personal preferences, you will want to alter the
default settings for many of these options.
.P
Finally, to exit Vi and save the editing buffer to the file named
.FN temp ,
type:
.DS I
:x\s-2<RETURN>\s0 
.DE
If you have made any changes to the editing buffer,
this writes out the editing buffer 
to the last named file and then exits the editor. 
If you don't want to save the editing buffer, you
can abort the editing session by typing:
.DS I
:q!\s-2<RETURN>\s0
.DE
.P
This completes the demonstration run.
There are still many commands that have not been
shown you, but nevertheless, the
fundamentals of using Vi have been covered.
You should now know how to get into and out of Vi,
how to insert and delete text, how to move your
cursor around, how to execute Ex commands,
and how to write out the editing buffer to a file.
Following sections give you more detailed
information about the commands covered above
and about Vi's other commands and features.
.bp
.H 2 "Basic Concepts"
To use Vi effectively, you will need to understand
the basic concepts that are essential to
understanding how Vi works.
The topics discussed here include:
.DL
.LI
The Editing Buffer
.LI
Modes of Operation
.LI
Special Keys
.LI
Text Objects
.LE 1
.H 3 "The Editing Buffer"
Vi performs no editing operations on the file
that you name during invocation.
Instead, it works on a copy of the file in an
.I "editing buffer."
The editor remembers the name of the file
specified at invocation,
so that it can later copy the editing
buffer back to the named file.
This means that
you do not affect the contents of the named file unless
and until you explicitly copy the changes
you have made back to the original file.
This setup allows you to edit the buffer without
immediately destroying the contents of the original file.
See Figure 6-1 for an illustration of how this all works.
.DS CB

+----------+               +----------+
|          |               |          |
| Named    |               | Editing  |
|   File   |  vi file.txt  |   Buffer |
|          |  -----------> |          |
|          |               |          |
+----------+               +----------+
  file.txt                 /tmp/Ex?????

+----------+               +----------+
|          |               |          |
| Named    |               | Editing  |
|   File   |   :w<RETURN>  |   Buffer |
|          |  <----------  |          |
|          |               |          |
+----------+               +----------+
  file.txt                 /tmp/Ex?????

.FG "The Editing Buffer" 6-
.sp 1
.fi
When you invoke Vi with a single filename argument,
the named file is copied to a temporary editing buffer.
When the file is written out, the temporary file is
written back to the named file.
.nf
.DE
.H 3 "Modes of Operation"
Before using Vi extensively you need to clearly understand
the concept of mode.
Within Vi there are three distinct modes of
operation:
.VL 10 
.LI "Command Mode"
.br
After invoking Vi, you are automatically placed in
Vi command mode.
Within command mode, the keys that you press are
interpreted as editing commands.
In most cases, the keys that you press are
.I not
echoed on the screen.
Because they are not echoed, you get no visual
feedback on the command you are typing.
This isn't bad for single keystroke commands, but
it sometimes can be confusing for commands that
require several keystrokes.
However, if you ever get confused when typing a command,
you can abort command entry by pressing
.SM <INTERRUPT> .
.LI "Insert Mode"
.br
Insert mode can be entered by typing any of the Vi
insert, append, open, substitute, change, or replace commands.
A few other commands also put you into insert mode.
Once in insert mode, the keys you type are inserted
into your editing buffer as you type them.
Some characters are special in insert mode; these
are listed and described below:
.VL 5
.LI "\s-2<BKSP>\s0"
.br
This backs up the cursor one character on the current line.
The last character typed before the 
.SM <BKSP>
is removed from the input buffer, but remains
displayed on the screen.
.LI "\s-2<CONTROL-U>\s0"
.br
Moves the cursor back to the first character of the insertion,
and restarts insertion.
.LI "\s-2<CONTROL-V>\s0"
.br
Removes the special significance of the next typed
character.
Use
.SM <CONTROL-V>
to insert control characters.
Note that line feed
.SM <LF>
and
.SM <CONTROL-J>
cannot be inserted
in the text except as newline characters.
Also,
.SM <CONTROL-Q>
and
.SM <CONTROL-S>
are trapped by the operating system
before they are interpreted by Vi, so they too cannot
be inserted.
.LI "\s-2<CONTROL-W>\s0"
.br
Moves the cursor back to the first character of the
last inserted word.
.LI "\s-2<CONTROL-D>\s0"
.br
Backtabs over whitespace at the beginning of a line.
Otherwise, if the 
.I autoindent
option is set this whitespace cannot be backspaced over.
.LI "\s-2<CONTROL-T>\s0"
.br
During an insertion, with the 
.I autoindent
option
set and at the beginning of the current
line, typing this character will insert 
.I shiftwidth 
white space.
.LI "\s-2<CONTROL-@>\s0"
.br
If typed as the first character of an insertion 
it is replaced with the
last text inserted, and the insertion terminates.
Only 128 characters are
saved from the last insertion.
If more than 128 characters were inserted, then
this command inserts no characters.
A
.SM <CONTROL-@> 
cannot be part of a file, even if quoted.
.LE 1
.LI "Ex Escape Mode"
.br
The Vi and Ex editors are one and the same editor
differing mainly in their user interface.
In Vi, as we have seen, commands are usually single
keystrokes.
In Ex, commands are lines of text terminated by a 
.SM <RETURN> .
Vi has a special 
.Q "escape"
command that gives you access to many of these
line-oriented Ex commands.
To escape to Ex escape mode,
you need only type a colon (:).
The colon is echoed on the bottom status line as a
prompt for the Ex command that you want to execute.
You then may type in the command, followed by a
.SM <RETURN> 
or an
.SM <ESC> .
An executing command can also be
aborted by typing
.SM <INTERRUPT> .
Most file manipulation commands are executed in
Ex escape mode; for example, the commands to
read in a file, and to write out the editing buffer to a file.
Other Ex commands that you need to know
are the commands to perform global substitutions
and to quit the editor.
For more information, see Section 6.6 
.Q "Ex Commands" .
.LE 1
.H 3 "Special Keys"
There are several keys that you'll use over and over 
when editing in Vi.  
These keys are used to
edit, delimit, or abort commands and command lines.
The first key that we'll look at is the
.SM <ESC> 
key.
It should be near the upper left corner of your terminal.
Try pressing it a few times\*(EMit rings
the bell to indicate that Vi is in its normal command state.
On some terminals, the editor quietly
flashes the screen rather than ringing the bell.
In general, the 
.SM <ESC>
key always returns you to Vi command mode.
You'll use it most often in exiting from insert mode.
It can also be used to terminate Ex command lines.
In addition,
partially formed commands are cancelled by typing an
.SM <ESC>. 
This key is a fairly harmless one to press, 
so you should press it when you don't know
exactly what is going on.
.P
The 
.SM <RETURN> 
key is used to terminate Ex commands
when in Ex escape mode.
You also type 
.SM <RETURN> 
whenever you want to start a new
line when in insert mode.
.P
Another useful key is the 
.SM <INTERRUPT>
key,
which is often the same as the 
.SM <DEL> 
or 
.SM <RUBOUT>
key on many terminals. 
The 
.SM <INTERRUPT>
key,
as its name implies,
generates an interrupt, telling the editor to stop what it is doing.
You can use 
.SM <INTERRUPT>
to abort any command that is executing.
It is a forceful way of making the editor listen
to you, or to return to Vi command mode,
if you don't know or don't like what is going on.  
.P
The next key of interest is
the slash (\^/\^) key.
This key is used when you want to specify 
a string to be searched for.  
When you type it, the slash appears
on the bottom status line as a prompt for a search string.
You can then enter the search string,
followed by a 
.SM <RETURN>
or an
.SM <ESC> . 
You can get the cursor back to the current
position by pressing the 
.SM <INTERRUPT> 
key.
Note that the question mark (?) works exactly like
the slash key, except that it is used to search
backwards in a file instead of forwards.
.P
The last key that we'll discuss is the colon (:).
When you type a colon, it is echoed on the status
line as a prompt for an Ex command.
You can then type in any Ex command, followed by
an 
.SM <ESC>
or
.SM <RETURN>
and the given Ex command will be executed.
.H 3 "Text Objects"
The editing operations of the Vi editor
are in most cases based on the notion of a text object.
A text object is any sequence of consecutive characters in a
line or any sequence of consecutive lines in a file.
In general, text objects are delimited by the
cursor and a cursor movement command.
The character on which the cursor sits 
delimits one end of an intraline object such as a word;
the current line delimits one end of a
multiline object such as a line number range.
Because the location of the cursor is always known
by Vi, text objects are normally specified
by simply typing the appropriate cursor movement command.
Thus, naked cursor movement commands move the cursor
to the opposite end of a given text object.
Text objects can be moved, changed, or
deleted by combining the appropriate 
command operator with a cursor movement command.
.H 2 "Invoking and Exiting Vi"
The Vi invocation syntax is as follows:
.DS I
.B
vi [\-\fIoption\fP ...] [+\fIcommand\fP] [\fIfilename\fP ...]
.R
.DE
.P
The simplest form of this syntax, and the easiest 
way to enter Vi is to type:
.DS I
vi
.DE
This allows you to work on an empty editing buffer.
The most common way to enter Vi, however, is to specify
one or more filenames as shown below:
.DS I
vi \fIfilename ...\fP
.DE
.I Filename
arguments indicate files to be edited.
You can also enter the editor and then move to a
particular place in a file by giving Vi a single 
line number or search string argument, preceded by a plus (+).
.P
Examples:
.DS I
vi		\fIEdit empty editing buffer\fP
vi file		\fIEdit named file\fP
vi +123 file	\fIGoto line 123\fR
vi +45 file	\fIGoto line 45\fR
vi +/word file	\fIFind first occurrence of "word"\fR
vi +/tty file   \fIFind first occurrence of "tty"\fR
.DE
.P
Vi may be invoked with any of the following options:
.VL 10
.LI "\-t"
This option is equivalent to an initial tag
command, editing the file containing the tag
and positioning the editor at its definition.
.LI "\-r"
This option is used in recovering after an editor or system crash,
retrieving the last saved version of the named file or,
if no file is specified, printing a list of saved files.
'\"	.LI "\-l"
'\"	This option is specific to editing LISP, setting the showmatch
'\"	and lisp options.
'\"	.LI "\-w"
'\"	With this option the default window size may be set to
'\"	.I n,
'\"	and is useful on dialups to start in small windows.
.LI "\-x"
This option causes Vi to prompt for a key 
used to encrypt and decrypt the contents of the named files.
.LI "\-R"
This sets a readonly option so that files can be
viewed but not edited.
.LE
.P
There are several ways to exit the editor.
One way is to type:
.DS I
:wq\s-2<RETURN>\s0
.DE
This command writes the editing buffer to the file
you are editing,  quits the editor, and then returns
you to the \*(x1 shell.
Similarly, if you type
.DS I
ZZ
.DE
the same thing happens, except that the editing
buffer is written to the file you are editing 
.I only 
if you have made any changes.
The 
.Q "ZZ"
command is equivalent to the command:
.DS I
:x\s-2<RETURN>\s0
.DE
.P
To abort an editing session, type
.DS I
:q!\s-2<RETURN>\s0
.DE
The exclamation mark (!) tells Vi to quit unconditionally.
In this case, the editing buffer is not written out.
If you type just
.DS I
:q\s-2<RETURN>\s0
.DE
the editor will not let you quit unless you
have written out your file and will
print the message:
.DS I
No write since last change (:quit! overrides)
.DE
This tells you to use 
.Q ":q!"
if you really want
to quit without writing out your file.
.ne 4i
.H 2 "Vi Commands"
Vi is a visual editor with a window on the file.  
What you see on the screen is Vi's notion of
what the file contains.
Commands do not cause any change to the screen until the
complete command is typed.  
Most commands may take a preceding count that
specifies repetition of the command.
This count parameter is not given in
the following command descriptions, 
but is implied unless overriden by some
other prefix argument.
.P
Should you get confused while
typing a command, you can abort the command by typing an
.SM <INTERRUPT>
character.  
Usually typing an 
.SM <ESC> 
will produce the
same result.  
When Vi gets an improperly formatted command
it also rings a bell.
.P
The following subsections describe Vi commands.
These are not all of the commands available in Vi.
By typing a colon, you can enter Ex command mode
and enter Ex commands.
For more information,
see Section 6.6, 
.Q "Ex Commands" .
.H 3 "Cursor Movement"
The cursor movement keys allow you to move your
cursor around in a file.
Note in particular the arrow
keys (if available on your terminal), 
the 
.Q "h" ,
.Q "j" ,
.Q "k" ,
and
.Q "l"
cursor keys, and 
.SM <SPACE> ,
.SM <BKSP> ,
.SM <CONTROL-N> ,
and 
.SM <CONTROL-P> .
These three sets of keys perform identical
functions;
the choice of which to use is entirely up to you.
.ds cT \fB[\fIcnt\fB]\fR
.HU "Forward Space \- l, <SPACE>, or -->"
.VL 12 2
.LI "Syntax:"
.B l
.br
.SM \fB<SPACE>\fR
.br
.B -->
.LI "Function:"
Move cursor forward one character.  
If a count is given, move forward 
count characters.
You cannot move past the end of the line.
.LE 1
.HU "Backspace \- h, \s-2<BKSP>\s0, or <--"
.VL 12 2
.LI "Syntax:"
.B h
.br
.SM \fB<BKSP>\fR
.br
.B <--
.LI "Function:"
Move cursor backward one character.
If a count is given, move backwards
count characters.
Note that you cannot move past the beginning of
the current line.
.LE 1
.HU "Next Line \- +, \s-2<RETURN>\s0, j, \
\s-2<CONTROL-N>\s0, and \s-2<LF>\s0"
.VL 12 2
.LI "Syntax:"
.B +
.br
.SM \fB<RETURN>\fR
.LI "Function:"
Move cursor down to the beginning of the next line.
.LE 1
.VL 12 2
.LI "Syntax:"
.B j
.br
.SM \fB<CONTROL-N>\fR
.br
.SM \fB<LF>\fR
.br
.B "(down arrow)"
.LI "Function:"
Move cursor down one line, remaining in the same column.
Note the difference between these commands and the
preceding set of next line commands which move to
the 
.I beginning 
of the next line.
.LE 1
.HU "Previous Line \- k, \s-2<CONTROL-P>\s0, and \-"
.VL 12 2
.LI "Syntax:"
.B k
.br
.SM \fB<CONTROL-P>\fR
.br
.B "(up arrow)"
.br
.LI "Function:"
Move cursor up one line, remaining in the same column.
If a count is given then the cursor is moved up a
number of lines equal to the count.
.LE 1
.VL 12 2
.LI "Syntax:"
.B \- 
.LI "Function:"
Move cursor up to the beginning of the previous line.
If a count is given then the cursor is moved up a
number of lines equal to the count.
.LE 1
.HU "Beginning of Line \- 0 and ^"
.VL 12 2
.LI "Syntax:"
.B ^
.br
.B 0
.LI "Function:"
Move cursor to the beginning of the current line.
Note that 
.B 0 
always moves the cursor to the first
character of the current line. 
The caret 
.RB (\| ^ \|)
works somewhat differently: it
moves to the first character on a line that is not a tab or a space.
This is useful when editing files that have a great
deal of indentation, such as program texts.
.LE 1
.HU "End of Line \- $"
.VL 12 2
.LI "Syntax:"
.B $
.LI "Function:"
Move cursor to the end of the current line.
Note that the cursor resides on top of the last
character on the line.
If a count is given, 
then the cursor is moved forward count\-1 
lines to the end of the line.
.LE 1
.HU "Goto Line \- G"
.VL 12 2
.LI "Syntax:"
.B [\fIlinenumber\fP]G
.LI "Function:"
Go to the beginning of the line specified by
.I linenumber.
If no 
.I linenumber
is given, the cursor moves to the beginning of the
.I last 
line in the file.
To find the line number of the current line, use 
.SM <CONTROL-G> .
To turn on automatic line numbering on your screen,
type:
.DS I
:set linenumber\s-2<RETURN>\s0
.DE
.LE 1
.HU "Column \- |"
.VL 12 2
.LI "Syntax:"
.B [\fIcolumn\fP]|
.LI "Function:"
Move cursor to the 
column in the current line given by 
.I column .
If no 
.I column
is given then the cursor is moved to the
first column in the current line.
.LE 1
.HU "Word Forward \- w and W"
.VL 12 2
.LI "Syntax:"
.B w
.br
.B W
.LI "Function:"
Move cursor forward to the beginning of the next word.
The lowercase
.B w 
command
searches for a word defined as a 
string of alphanumeric characters separated by
punctuation or whitespace (i.e., tab, newline, or space characters).
The uppercase
.B W 
command searches for a word defined as a 
string of non-whitespace characters.
.LE 1
.HU "Back Word \- b and B"
.VL 12 2
.LI "Syntax:"
.B b
.br
.B B
.LI "Function:"
Move cursor backward to the beginning of a word.
The lowercase
.B b 
command searches backwards for a word defined as a 
string of alphanumeric characters separated by
punctuation or whitespace (i.e., tab, newline, or space characters).
The uppercase
.B B 
command searches for a word defined as a 
string of non-whitespace characters.
If the cursor is already within a word,
then it moves backwards to the beginning of that word.
.LE 1
.HU "End \- e and E"
.VL 12 2
.LI "Syntax:"
.B e
.br
.B E
.LI "Function:"
Move cursor to the end of a word.
The lowercase
.B e 
command moves the cursor to the last character of
a word, where a word is defined as a 
string of alphanumeric characters separated by
punctuation or whitespace (i.e., tab, newline, or space characters).
The uppercase
.B E 
moves the cursor to the last character of a word
where a word is defined as a 
string of non-whitespace characters.
If the cursor is already within a word,
then it moves to the end of that word.
.LE 1
.HU "Sentence \- ( and )"
.VL 12 2
.LI "Syntax:"
.B (
.br
.B )
.LI "Function:"
Move cursor to the beginning (left parenthesis)
or end 
of a sentence (right parenthesis).
A sentence is defined as a sequence of characters
ending with a period (\|.\|),
question mark (?), or exclamation mark (!), followed by
either two spaces or a newline.
A sentence begins on the
first non-whitespace character following a preceding sentence.
Sentences are also delimited by paragraph and
section delimiters. See below.
.LE 1
.HU "Paragraph \- { and }"
.VL 12 2
.LI "Syntax:"
.B }
.br
.B {
.LI "Function:"
Move cursor to the beginning 
.RB ( { ) 
or end 
.RB ( } )
of a paragraph.
A paragraph is  defined with the 
.I paragraphs 
option.
By default, paragraphs are delimited by the nroff macros 
.Q ".IP" , 
.Q ".LP" , 
.Q ".PP" , 
.Q ".QP" ,
and
.Q ".bp" .
Paragraphs also begin after empty lines.
.LE 1
.HU "Section \- [[ and ]]"
.VL 12 2
.LI "Syntax:"
.B ]]
.br
.B [[
.LI "Function:"
Move cursor to the beginning 
.RB ( [[ ) 
or end 
.RB ( ]] )
of a section.
A section is  defined with the 
.I sections 
option.
By default, sections are delimited by the nroff macros 
.Q ".NH"
and 
.Q ".SH" .
Sections also start at formfeeds (\s-2<CONTROL-L>\s0)
and at lines beginning with a brace ({).
.LE 1
.HU "Match Delimiter \- %"
.VL 12 2
.LI "Syntax:"
.B %
.LI "Function:"
Move cursor to a matching delimiter, where
a delimiter is a parenthesis, a bracket, or a brace.
This is useful when matching pairs 
of nested parentheses, brackets, and braces.
.LE 1
.HU "Home \- H"
.VL 12 2
.LI "Syntax:"
.B [\fIoffset\fB]H
.LI "Function:"
Home cursor to upper left corner of screen.
Use this command to quickly move to the top of the screen.
If an 
.I offset 
is given, then the cursor is homed 
.I offset -1 
number of lines from the top of the screen.
Note that the command 
.Q "dH"
deletes all lines from
the current line to the top line shown on the screen.
.LE 1
.HU "Middle Screen \- M"
.VL 12 2
.LI "Syntax:"
.B M
.LI "Function:"
Move cursor to the beginning of the screen's middle line. 
Use this command to quickly move to the middle of
the screen from either the top or the bottom.
Note that the command 
.Q "dM"
deletes from the
current line to the line specified by the 
.B M 
command.
.LE 1
.HU "Lower Screen \- L"
.VL 12 2
.LI "Syntax:"
.B [\fIoffset\fR]L
.LI "Function:"
Move cursor to the lowest line on the screen.
Use this command to quickly move to the bottom of the screen.
If an 
.I offset 
is given, then the cursor is homed 
.I offset -1
number of lines from the bottom of the screen.
Note that the command 
.Q "dL"
deletes all lines from
the current line to the bottom line shown on the screen.
.LE 1
.HU "Previous Context \- \`\` and \'\' "
.VL 12 2
.LI "Syntax:"
.B \'\'
.br
.B \'\fIcharacter\fR
.br
.B \`\`
.br
.B \`\fIcharacter\fR
.LI "Function:"
Move cursor to previous context or to context
marked with the 
.B m
command.
If the single quotation mark or back quotation mark is doubled, then
the cursor is moved to previous context.
If a single character is given after either quotation mark, 
then the cursor is moved to the location of the specified mark
as defined by the
.B m
command.
Previous context is the location in the file of the
last 
.Q "nonrelative"
cursor movement.
The single quotation mark (\|\'\|) syntax
is used to move to the beginning of the
line representing the previous context. 
The back quotation mark (\|\`\|) syntax
is used to move to the previous context
.I within 
a line.
.LE 1
.H 3 "The Screen Commands"
The screen commands are
.I not 
cursor movement commands and cannot be used in
delete commands as the delimiters of text objects.
However, the screen commands do move the cursor and
are useful in paging or scrolling through a file.
These commands are described below:
.HU "Page \- \s-2<CONTROL-U>\s0 and \s-2<CONTROL-D>\s0"
.VL 12 2
.LI "Syntax:"
.SM \fB[\fIsize\fB]<CONTROL-U>\fR
.br
.SM \fB[\fIsize\fB]<CONTROL-D>\fR
.LI "Function:"
Scroll screen up a half window
(\s-2<CONTROL-U>\s0) or down a half window (\s-2<CONTROL-D>\s0).
If 
.I size 
is given, then the scroll is 
.I size 
number of lines.
This value is remembered for all later scrolling
commands.
.LE 1
.HU "Scroll \- \s-2<CONTROL-F>\s0 and \s-2<CONTROL-B>\s0"
.VL 12 2
.LI "Syntax:"
.SM \fB<CONTROL-F>\fR
.br
.SM \fB<CONTROL-B>\fR
.LI "Function:"
Page screen forward and backwards.
Two lines of continuity are kept between pages if
possible.
A preceding count gives the number of pages to move
forward or backwards.
.LE 1
.HU "Status \- \s-2<CONTROL-G>\s0"
.VL 12 2
.LI "Syntax:"
.SM \fB<BELL>\fR
.br
.SM \fB<CONTROL-G>\fR
.LI "Function:"
Print Vi status on status line.
This gives you the name of the file you are editing,
whether it has been modified,
the current line number, the number of lines in the file, 
and the percentage of the file (in lines) that precedes the
cursor.
.LE 1
.HU "Zero Screen \- z"
.VL 12 2
.LI "Syntax:"
.B [\fIlinenumber\fP]z[\fIsize\fP\]\s-2<RETURN>\s0
.br
.B [\fIlinenumber\fP]z[\fIsize\fP\]\s+2.\s0
.br
.B [\fIlinenumber\fP]z[\fIsize\fP\]\-
.br
.LI "Function:"
Redraw the display with the current line placed at
or 
.Q zeroed 
at the top, bottom, or middle of the screen,
respectively.
If you give a
.I size ,
then the number of lines displayed is equal to
.I size .
If a preceding 
.I linenumber 
is given, then the given line is
placed at the top of the screen.
If the last argument is a 
.SM <RETURN> ,
then the current line is placed at the top of the screen.
If the last argument is a period (\|.\|),
then the current line is placed in the middle of the screen.
If the last argument is a minus sign (\-),
then the current line is placed at the bottom of the screen.
.LE 1
.HU "Redraw \- \s-2<CONTROL-R>\s0 or \s-2<CONTROL-L>\s0" 
.VL 12 2
.LI "Syntax:"
.SM \fB<CONTROL-R>\fR
.br
.SM \fB<CONTROL-L>\fR
.LI "Function:"
Redraw the screen.
Use this command to erase any system messages that
may scramble your screen. 
These messages do not affect the file you are
editing.
.LE 1
.H 3 "Text Insertion"
The text insertion commands always place you in
insert mode.
Exit from insert mode is always done by pressing
.SM <ESC> .
The following insertion commands are 
.Q "pure"
insertion commands; no text is deleted when you use them.
This differs from the text modification 
commands\*(EMchange, replace, and substitute\*(EMwhich 
delete and then insert text in one operation.
.HU "Insert \- i and I"
.VL 12 2
.LI "Syntax:"
.B i[\fItext\fP]\s-2<ESC>\s0
.br
.B I[\fItext\fP]\s-2<ESC>\s0
.LI "Function:"
Insert 
.I text
in editing buffer.
The lowercase
.B i
command places you in insert mode.
.I Text 
is inserted 
.I before
the character beneath the cursor.
To insert a newline, just press a
.SM <RETURN> .
Exit insert mode by typing the
.SM <ESC> 
key.
The uppercase 
.B I
command places you in insert mode, but begins text insertion
at the beginning of the current line,
rather than before the cursor.
.LE 1
.HU "Append \- a and A"
.VL 12 2
.LI "Syntax:"
.B a[\fItext\fP]\s-2<ESC>\s0
.br
.B A[\fItext\fP]\s-2<ESC>\s0
.LI "Function:"
Append 
.I text
to editing buffer.
The lowercase
.B a
command works 
.I exactly 
like the lowercase
.B i
command, except that
text insertion begins after the cursor and not before.
This is the one way to add text to the end of a line.
The uppercase
.B A
command begins appending text at the end of the
current line rather than after the cursor.
.LE 1
.HU "Open New Line \- o and O"
.VL 12 2
.LI "Syntax:"
.B o[\fItext\fP]\s-2<ESC>\s0
.br
.B O[\fItext\fP]\s-2<ESC>\s0
.LI "Function:"
Open a new line and insert text.
The lowercase
.B o
command opens a new line below the current line;
uppercase
.B O
opens a new line 
.I above
the current line.
After the new line has been opened,
both these commands work like the 
.B I
command.
.LE 1
.H 3 "Text Deletion"
Many of the text deletion commands use 
the letter 
.Q "d"
as an operator.
This operator deletes text objects delimited by
the cursor and a cursor movement command.
Deleted text is always saved away in a buffer.
The delete commands are described below:
.HU "Delete Character \- x and X"
.VL 12 2
.LI "Syntax:"
.B x
.br
.B X
.LI "Function:"
Delete a character.
The lowercase 
.B x
command deletes the character beneath the cursor.
With a preceding count,
.I cnt 
characters are deleted to the left beginning with
the character beneath the cursor.
This is the quick and easy way to delete a few characters.
The uppercase 
.B X
command deletes the character just before the cursor.
With a preceding count,
.I cnt 
characters are deleted backwards, beginning with
the character just before the cursor.
.LE 1
.HU "Delete \- d and D"
.VL 12 2
.LI "Syntax:"
.B d\fIcursor-movement\fR
.br
.B dd
.br
.B D
.LI "Function:"
Delete text object.
The lowercase
.B d
command takes a 
.I cursor-movement 
as an argument.
If the 
.I cursor-movement 
is an intra-line command, then
deletion takes place from the cursor to the end of
the text object delimited by the 
.I cursor-movement .
Deletion forward deletes the character beneath the 
cursor; deletion backwards does not.
If the 
.I cursor-movement 
is a multi-line command, then
deletion takes place from and including the current
line to the text object delimited by the 
.I cursor-movement .
.P 
The 
.B dd
command deletes whole lines.
The uppercase
.B D
command deletes from and including the cursor 
to the end of the current line.
.P
Deleted text is automatically pushed on a stack of
buffers numbered 1 through 9.
The most recently deleted text is also placed in a
special delete buffer that is logically buffer 0.
This special buffer is the default buffer for all
delete, put, and yank commands.
The buffers 1 through 9 can be accessed with the 
.B p
and
.B P
(put) commands using the double quotation mark
(") to specify the number of the buffer.
For example 
.DS I
"4p
.DE
puts the contents of delete buffer number 4 in your
editing buffer just below the current line.
Note that the last deleted text is 
.Q "put"
by default and does not need a preceding buffer number.
.LE 1
.H 3 "Text Modification"
The text modification commands all involve the
replacement of text with other text.
This means that some text will necessarily be
deleted.
All text modification commands can be 
.Q "undone"
with the 
.B u 
command, discussed below:
.HU "Undo \- u and U"
.VL 12 2
.LI "Syntax:"
.B u 
.br
.B U 
.LI "Function:"
Undo the last insert or delete command.
The lowercase
.B u
command undoes the last insert or delete command.
This means that after an insert,
.B u
deletes text; and after a delete,
.B u
inserts text.
For the purposes of undo, all text modification
commands are considered insertions.
.P
The uppercase
.B U
command restores the current line to its state
before it was edited, no matter how many times the
current line has been edited since you moved to it.
.LE 1
.HU "Repeat \- \fB.\fR"
.VL 12 2
.LI "Syntax:"
.B \s+4\&.\s0 
.LI "Function:"
Repeat the last insert or delete command.
A special case exists for repeating the 
.B p
and 
.B P
.Q "put"
commands.
When these commands are preceded by the name of a
delete buffer, then successive
.B u 
commands print out the contents of the delete buffers.
.LE 1
.HU "Change \- c and C"
.VL 12 2
.LI "Syntax:"
.B "c\fIcursor-movement\ text\fB\s-2<ESC>\s0"
.br
.B C\fItext\fB\s-2<ESC>\s0
.br
.B cc\fItext\fB\s-2<ESC>\s0
.LI "Function:"
Change a text object and replace it with
.I text .
Text is inserted as with the 
.B i
command.
A dollar sign ($) marks the extent of the change.
The 
.B c
command changes arbitrary text objects delimited by
the cursor and a 
.I cursor-movement .
The 
.B C
and 
.B cc 
commands affect whole lines and are identical in
function.
.LE 1
.HU "Replace \- r and R"
.VL 12 2
.LI "Syntax:"
.B r\fIchar\fP
.br
.B R\fItext\fP\s-2<ESC>\s0
.LI "Function:"
Overstrike character or line
with 
.I char
or
.I text ,
respectively.
Use
.B r
to overstrike a single character and
.B R
to overstrike a whole line.
A count multiplies the replacement text
count times.
.LE 1
.HU "Substitute \- s and S"
.VL 12 2
.LI "Syntax:"
.B s\fItext\fP\s-2<ESC>\s0
.br
.B S\fItext\fP\s-2<ESC>\s0
.LI "Function:"
Substitute current character
or current line with 
.I text.
Use 
.B s
to replace a single character with new text.
Use 
.B S
to replace the current line with new text.
If a preceding count is given, then 
.I text 
substitutes for count number of characters or lines
depending on whether the command is
.B s
or
.B S ,
respectively.
.LE 1
.HU "Filter \- !"
.VL 12 2
.LI "Syntax:"
.B "!\fIcursor-movement\ cmd\s-2<RETURN>\s0"
.LI "Function:"
Filter the text object delimited by the cursor and 
.I cursor-movement
through the \*(x1 command,
.I cmd .
For example, the following command sorts all
lines between the cursor and the bottom of the screen,
substituting the designated lines with the sorted lines:
.DS I
!Lsort
.DE
Arguments and shell metacharacters may be included
as part of 
.I cmd ;
however, standard input and output are always
associated with the text object being filtered.
.LE 1
.HU "Join Lines \- J"
.VL 12 2
.LI "Syntax:"
.B J 
.LI "Function:"
Join the current line with the following line.
If a count is given, then count lines are joined.
.LE 1
.HU "Shift \- < and >"
.VL 12 2
.LI "Syntax:"
.B >[\fIcursor-movement\fP]
.br
.B <[\fIcursor-movement\fP]
.br
.B >>
.br
.B <<
.LI "Function:"
Shift text left (>) or right (<).
Text is shifted by the value of the option
.I shiftwidth , 
which is normally set to eight spaces.
Both the
.B >
and 
.B <
commands shift all lines in the text object 
delimited by the current line and 
.I cursor-movement .
The
.B >>
and 
.B <<
commands affect whole lines.
All versions of the command can take a preceding
count that acts to multiply the number of objects affected.
.LE 1
.H 3 "Text Movement"
The text movement commands move text in and out of the
named buffers a-z and out of the delete buffers 1-9.
These commands either 
.Q "yank"
text out of the editing
buffer and into a named buffer or 
.Q "put"
text into the editing buffer from a named buffer or a
delete buffer.
By default, text is put and yanked from 
the 
.Q "unnamed buffer" ,
which is also where the most recently deleted text
is placed.
Thus it is quite reasonable to delete text, 
move your cursor to the location where you want the
deleted text placed, and then put the text back into
the editing buffer at this new location 
with the 
.B p
or
.B P
command.
.P
The named buffers are  most useful for keeping track
of several chunks of text that you want to keep on
hand for later access, movement, or rearrangement.
These buffers are named with the letters 
.Q "a"
through 
.Q "z" .
To refer to one of these buffers (or one of the
numbered delete buffers) in a command such
as a put, yank, or delete command, use a quotation mark.
For example, to yank a line into the buffer named 
.I a ,
type:
.DS I
"ayy
.DE
To put this text back into the file, type:
.DS I
"ap
.DE
If you delete text into the buffer named
.I A
rather than 
.I a ,
then text is appended to the buffer.
.P
Note that the contents of the
named buffers are not destroyed when you switch
files.
Therefore, you can delete or yank text into a
buffer, switch files, and then do a put. 
Beware, buffer contents are
.I destroyed
when you exit the editor,
so be careful.
.HU "Put \- p and P"
.VL 12 2
.LI "Syntax:"
.B ["\fIalphanumeric\fP]p 
.br
.B ["\fIalphanumeric\fP]P 
.LI "Function:"
Put text from a buffer into the editing buffer.
If no buffer name is specified, then text is put
from the unnamed buffer.
The lowercase 
.B p
command puts text either below the current line
or after the cursor, depending on whether the buffer
contains a partial line or not.
The uppercase 
.B P
command puts text either above the current line
or before the cursor, again depending on whether the buffer
contains a partial line or not.
.LE 1
.HU "Yank \- y and Y"
.VL 12 2
.LI "Syntax:"
.B ["\fIletter\fP]y\fIcursor-movement\fR
.br
.B ["\fIletter\fP]yy
.br
.B ["\fIletter\fP]Y
.LI "Function:"
Copy text in the editing buffer to a named buffer.
If no buffer name is specified, then text is yanked
into the unnamed buffer.
If an uppercase 
.I letter
is used,
then text is appended to the buffer and does not
overwrite and destroy the previous contents.
When a 
.I cursor-movement
is given as an argument, the
delimited text object is yanked.
The
.B Y
and 
.B yy
commands
yank a single line, or, if a preceding count is
given, multiple lines can be yanked.
.LE 1
.H 3 "Searching"
The search commands search either forward or
backwards in the editing buffer for 
text that matches a given regular expression.
For more information about regular expressions,
see Section 6.8 
.Q "Regular Expressions" .
.HU "Search \- / and ?"
.VL 12 2
.LI "Syntax:"
.B /[\fIpattern\fP]/[\fIoffset\fP]\s-2<RETURN>\s0
.br
.B /[\fIpattern\fP]\s-2<RETURN>\s0
.br
.B ?[\fIpattern\fP]?[\fIoffset\fP]\s-2<RETURN>\s0
.br
.B ?[\fIpattern\fP]\s-2<RETURN>\s0
.LI "Function:"
Search forward (/) or backward (?) for 
.I pattern .
A string is actually a regular expression as defined
in Section 6.8 
.Q "Regular Expressions" .
The trailing delimiter is not required.
If no 
.I pattern
is given, 
then last 
.I pattern 
searched for is used.
After the second delimiter, an 
.I offset
may be
given, specifying the beginning of a line relative to the line on
which 
.I pattern 
was found.
For example
.DS I
/word/-
.DE
finds the beginning of the line immediately preceding 
the line containing 
.Q word
and 
.DS I
/word/+2
.DE
finds the beginning of the line two lines after
the line containing 
.Q word .
See also the 
.I ignorecase
and
.I magic
options.
.LE 1
.HU "Next String \- n and N"
.VL 12 2
.LI "Syntax:"
.B n 
.br
.B N 
.LI "Function:"
Repeat the last search command.
The 
.B n
command repeats the search in the same direction
as the last search command.
The 
.B N
command repeats the search in the opposite
direction of the last search command.
.LE 1
.HU "Find Character \- f and F"
.VL 12 2
.LI "Syntax:"
.B f\fIchar\fR
.br
.B F\fIchar\fR 
.br
.B ;
.br
.B ,
.LI "Function:"
Find character on current line.
The lowercase 
.B f
searches forward on the line;
the uppercase
.B F
searches backwards.
The semicolon
.RB (\| ; \|) 
repeats the last character search.
The comma
.RB (\| , \|) 
reverses the direction of the search.
.LE 1
.HU "To Character \- t and T"
.VL 12 2
.LI "Syntax:"
.B t\fIchar\fR 
.br
.B T\fIchar\fR 
.br
.B ;
.br
.B ,
.LI "Function:"
Move cursor up to but not on 
.I char.
The semi-colon
.RB (\| ; \|) 
repeats the last character search.
The comma
.RB (\| , \|) 
reverses the direction of the search.
.LE 1
.HU "Mark \- m"
.VL 12 2
.LI "Syntax:"
.B m\fIletter\fR
.LI "Function:"
Mark place in file with a lowercase
.I letter.
You can move to a mark using the 
.Q "to mark"
commands described below.
It is often useful to create a mark, move the
cursor,
and then delete from the cursor to the mark 
.Q a
with the
following command: 
.DS I
d\'a
.DE
.LE 1
.HU "To Mark \- \' and \`"
.VL 12 2
.LI "Syntax:"
\'\fIletter\fP
.br
\`\fIletter\fP
.LI "Function:"
Move to 
.I letter .
These commands let you move to the location of a mark.
Marks are denoted by single lowercase alphabetic characters.
Before you can move to a mark, it must first have
been created with the 
.B m
command.
The back quotation mark (\|\'\|) moves you to the exact location of the
mark within a line;
the forward quotation mark (\|\'\|) moves you to the beginning of the
line containing the mark.
Note that these commands are also legal cursor movement commands.
.LE 1
.H 3 "Exit and Escape Commands"
There are several commands that are used to
escape from Vi command mode and to exit the editor.
These are described below:
.P
.HU "Ex Escape \- :"
.VL 12 2
.LI "Syntax:"
.B :
.LI "Function:"
Enter Ex escape mode to execute an Ex command.
The colon appears on the status line as a prompt for
an Ex command.
You then can enter an Ex command line terminated by
either a 
.SM <RETURN>
or an
.SM <ESC>
and the Ex command will execute.
You are then prompted to type 
.SM <RETURN>
to return to Vi command mode.
During the input of the Ex command line or during
execution of the Ex command you may press 
.SM <INTERRUPT>
to abort what you are doing and return to Vi command mode.
.LE 1
.HU "Exit Editor \- ZZ"
.VL 12 2
.LI "Syntax:"
.B ZZ
.LI "Function:"
Exit Vi and write out the file if any changes have been made.
This returns you to the shell from which you invoked Vi.
.LE 1
.HU "Quit to Ex \- Q"
.VL 12 2
.LI "Syntax:"
.B Q
.LI "Function:"
Enter the Ex editor.
When you do this, you will still be editing the same file.
You can return to Vi by typing the 
.B vi
command from Ex.
.LE 1
