.ds :? SED
.nr H1 8
.PH "'Sed''Sed'"
.H 2 "Introduction"
.I Sed 
is a context editor designed 
to be used in three cases:
.AL 1
.LI
To edit files too large for comfortable
interactive editing.
.LI
To edit files of any size when the sequence
of editing commands is too complicated to be comfortably
typed in interactive mode.
.LI
To perform multiple 
.Q "global"
editing functions
efficiently in one pass through the input.
.LE 1
.P
Since only a few lines of the input reside in memory
at one time in Sed, and no temporary files are used,
the effective size of a file that can be edited is 
virtually unlimited.
.I Sed ,
by its nature, is noninteractive, and cannot be
used at the terminal like the editors 
.B ed ,
and 
.B vi .
.P
Complicated editing scripts can be created separately and given to 
.I sed 
as a command file.
For complex edits, this saves considerable typing and its
attendant errors.
.I Sed, 
running from a command file, is much more efficient than any 
known interactive editor, even if that editor
can be driven by a prewritten script.
.P
The principal disadvantages of 
.I sed,
compared to an interactive editor,
are lack of relative addressing (because of the line-at-a-time
operation), and lack of immediate verification that a command has
done what was intended.
.P
.I Sed 
is a descendant of the \*(x1 line editor,
.IR ed (1).
Because of the differences between interactive and noninteractive
operation, considerable changes have been made between
the two;
even confirmed users of
.B ed
will frequently be surprised,
if they rashly use 
.I sed 
without reading this chapter.
The most striking family resemblance between the two
editors is in the class 
of patterns (regular expressions) they recognize;
the code for matching patterns is copied almost
verbatim from the code for
.B ed .
.H 2 "Overall Operation"
.I Sed 
copies the standard input to the standard output,
perhaps performing one or more editing commands on each
line before writing it to the output.
This behavior may be modified by flags on the command line.
.P
The general format of an editing command is:
.DS I
.I
\fB[\fPaddress1\fB,\fPaddress2\fB][\fPfunction\fB][\fParguments\fB]\fP
.R
.DE
.P
One or both addresses may be omitted. 
Any number of blanks or tabs may separate the addresses
from the function, but the function must be present. 
The arguments may be required or optional, 
according to the function given. 
Tab characters and spaces at the beginning of lines are ignored.
.H 2 "Command Line Flags"
Three flags are recognized on the command line:
.VL 10 5
.LI \fB\-n\fR
No copy of input to output. 
This option suppresses the automatic copying of
lines to the output.
The only lines copied are those specified by the print functions
.RB ( p
or
.BR P )
or by
.B p
flags.
.LI \fB\-e\fR
Tells 
.I sed 
to take the next argument as an editing command.
This next argument should be quoted with single
quotation marks (\|\'\|) to prevent expansion of metacharacters by
the shell. 
If only 
.I one
.B \-e
argument is given and if there are no
.B \-f 
flags, then the 
.B \-e
flag may be omitted and the argument given 
as the first one on the command line.
.LI \fB\-f\fR
Tells 
.I sed 
to take the next argument as a filename.
The file should contain editing commands, one to a line.
.LE 1
Some sample invocations are given below:
.DS I
sed \-f sed.script <input >output
sed \'s/one/two/g\' <input >output
sed \-e \'s/one/two/g\' <input >output
sed \-n \-e /s/one/two/p <input >output
.DE
The first of these examples reads commands from the file 
.FN sed.script .
The second and third examples perform an identical operation: 
both take the first argument as a 
.I sed 
substitute command. 
The fourth example has the same effect as examples two and three, 
except that input lines are not copied to 
.I output.
.H 2 "Order of Application of Editing Commands"
Commands are applied in the order that they are
given on the command line or in the file specified
by the 
.B \-f
flag.
Each line may undergo several transformations 
before being output, depending on the number of 
commands to be executed.
The output from each command is always a single line.
This output line is the input to the next command
to be executed.
Thus 
.I sed 
is said to be a 
.Q "line-at-a-time"
editor as illustrated in Figure 8-1.
.DS 
	  ---------- 
	 |          |
	 |  Input   |
	 |          |
 	  ---------- 
     	      |         Input comes a line at a time.
     	      |         Each line is read one time only.
     	      v
   	    -----
  	   |     |      Sed performs zero or more commands
  	   | Sed |        on the current line.
	   |     |        
 	    -----
     	      |         Input lines are echoed to the output 
              |           by default.  If the \-n switch is
	      v           used, then lines are not echoed.
 	  ---------- 
	 |          |
	 |  Output  |
	 |          |
 	  ---------- 

.FG "Line at a Time Processing" 8-
.DE
.P
Note that 
the default linear order of application of editing commands can
be changed by the flow-of-control commands,
.B t
and
.B b .
.H 2 "The Pattern Space"
The range of pattern matches is called the pattern space.
Ordinarily the pattern space is one line of the input text,
but more than one line can be read into the pattern space
by using the
.B N
command.
.P
Except where otherwise noted,
all examples in this chapter assume the following input text:
.DS I
In Xanadu did Kubla Khan
A stately pleasure dome decree:
Where Alph, the sacred river, ran
Through caverns measureless to man
Down to a sunless sea.
.DE
The following is an an example of a command:
.DS I
2q
.DE
.P
This quits after copying the first two lines of the input.
The output is:
.DS I
In Xanadu did Kubla Khan
A stately pleasure dome decree:
.DE
.H 2 "Addresses: Selecting lines for editing"
Lines in the input file(s) to which editing commands are
to be applied can be selected by addresses.
Addresses may be either line numbers or context addresses.
.P
The application of a group of commands can be controlled by
one address (or address-pair) by grouping
the commands with curly braces (\|{ and }\|).
.H 3 "Line-Number Addresses"
A 
.I line 
number 
is a decimal integer.
As each line is read from the input, a 
.I line number 
counter is incremented.
A 
.I line number 
address matches and selects the input
line equal to that line number in the input file.
The counter runs cumulatively through multiple input files.
It is not reset when a new input file is opened.
.P
As a special case, the dollar sign ($)
matches the last line of the last input file.
.H 3 "Context Addresses"
A context address is a pattern (regular expression) 
enclosed in slashes (/).
The regular expressions recognized by 
.I sed
are constructed as follows:
.AL 1
.LI
An ordinary character (not one of those discussed below)
is a regular expression, and matches that character.
.LI
A caret (\|^\|) at the beginning of a regular expression
matches the beginning of a line.
.LI
A dollar sign ($) at the end of a regular expression
matches the end of a line.
.LI
The characters (\en) match an embedded newline character,
but 
.I not 
the newline at the end of the pattern space.
.LI
A period (.) matches any character except the terminal newline
of the pattern space.
.LI
A regular expression followed by an asterisk (*) matches any
number (including 0) of adjacent occurrences of the regular
expression it follows.
.LI
A string of characters in square brackets ([) and (]) 
matches any character in the string, and no others.
If, however, the first character of the string 
is a caret (\|^\|),
the regular expression matches any character
.I except
the characters in the string and the terminal newline 
of the pattern space.
.LI
Concatenated regular expressions make up a regular expression
that matches a string consisting of the concatenated matched strings
of the component regular expressions.
.LI
A regular expression between 
the sequences 
.Q "\e("
and 
.Q "\e)"
is
identical to the unadorned regular expression, but has
side-effects which are described under the
.B s
command and 10, immediately below.
.LI
The expression
\e\fId\fP
means the same string of characters matched
by an expression enclosed in 
.Q "\e("
and 
.Q "\e)"
earlier in the same pattern.
Here
.I d
is a single digit.
The string specified is that beginning with the
\fId\|\fRth
occurrence of 
.Q "\e("
counting from the left.
For example, the expression
.Q "^\e(.*\e)\e1"
matches a line beginning with
two repeated occurrences of the same string.
.LI
The null regular expression standing alone 
(for example, 
.Q "//" )
is equivalent to the last regular expression searched for.
.LE 1
.P
To use one of the special 
characters (^ $ . * [ ] \e /) as a literal
(to match an occurrence of itself in the input), 
precede or 
.Q "escape"
the
special character with a backslash (\e),
as in 
.Q "\e$"
or 
.Q "\e*" .
.P
If a context address is to  
.Q "match"
the input, 
then the whole pattern within the address must match some
portion of the pattern space.
.H 3 "Command Address Arguments"
A command may have 0, 1, or 2 preceding address
arguments, as described
below:
.AL 1
.LI
If a command has no addresses, 
it is applied to every line in the input.
.LI
If a command has one address, it is applied to all
lines which match that address.
.LI
If a command has two addresses (separated by a comma), 
it is applied to the first
line that matches the first address, and to all subsequent lines
up to and and including the first line matching the second address.
This process is repeated, 
so that an attempt is made on 
subsequent lines to again match the first address.
.LI
An error occurs
if a command has more addresses than the maximum allowed.
.P
For example, examine the input text:
.DS I
In Xanadu did Kubla Khan
A stately pleasure dome decree:
Where Alph, the sacred river, ran
Through caverns measureless to man
Down to a sunless sea.
.DE
The following addresses match lines of this text
as noted:
.DS I
/an/		Matches lines 1, 3, 4 in our sample text
/an.*an/	Matches line 1
/^an/		Matches no lines
/./		Matches all lines
/\e./		Matches line 5
/r*an/		Matches lines 1, 3, and 4 
/\e(an\e).*\e1/	Matches line 1
.DE 1
.LE
.H 2 "Functions"
All functions are named by a single character.
In the following descriptions, 
the single character
function name is given followed by possible arguments.
Next, a description of what each function does
is followed by the maximum number of allowable addresses
that may precede the command given. 
This number is given in parentheses. 
.H 3 "Whole-Line Oriented Functions"
The following commands operate on whole lines;
they do not affect intraline contents:
.VL 10 5
.LI "\fBd\fR~\*(EM~Delete lines (2)"
.br
The
.B d
function deletes from the input (i.e., does not write to the output)
all those lines matched by its addresses.
A side effect is that no further commands are attempted
on the deleted line.
As soon as the
.B d
function is executed, a new line is read from the input, and
the list of editing commands is restarted from the beginning
on the new line.
.LI "\fBn\fR~\*(EM~Next~line (2)"
.br
The
.B n
function reads the next line from the input, replacing
the current line.
The current line is written to the output if it should be.
The list of editing commands is continued 
following the 
.B n
command.
.LI "\fBa\fR\e~\fItext\fR~\*(EM~Append~lines (1)"
.br
The
.B a
function causes the 
.I text 
argument to be written to the
output after the line matched by its address.
The
.B a
command is inherently multiline:
the
.B a
itself must appear at the end of a line and must be
followed by a backslash. 
The appended
.I text 
may contain
any number of lines.
However, to preserve the one-command-to-a-line fiction,
the interior newlines must be hidden by a
backslash character (\e) immediately preceding the
newline.
The 
.I text 
argument is terminated by the first unhidden
newline (the first one not immediately preceded
by backslash).
Remember that 
.I text
does not appear on the same line as the 
.B a 
command itself, and that the 
.B a 
command must always be followed by a backslash to
have any effect, as in
.DS I
a\e
one line of appended text\e
the second and last line with no backslash.
.DE
.P 
Once an
.B a
function is successfully executed, 
.I text 
is 
written to the output regardless of what later commands do to
the line that triggered it.
The triggering line may be 
deleted entirely, 
but
.I text 
is still written to the output.
.P
The 
.I text 
is not scanned for address matches, and no editing
commands are attempted on it.
It does not cause any change in the 
.I line number 
counter.
.LI "\fBi\fR\e~\fItext\fP~\*(EM~Insert~lines (1)"
.br
The
.B i
function  is similar to the
.B a
function, except that
.I text 
is written to the output
.I before
the matched line.
All other comments about the
.B a
function apply to the
.B i
function as well.
.LI "\fBc\fR\e~\fItext\fP~\*(EM~Change~lines (2)"
.br
The
.B c
function deletes the lines selected by its address(es),
and replaces them with the lines in 
.I text .
Like
.B a
and
.B i,
.B c
must be followed by a newline hidden by a backslash;
interior newlines in 
.I text 
must be hidden by backslashes.
.P
The
.B c
command may have two addresses, and therefore select a range
of lines.
If it does, all the lines in the range are deleted, but only
one copy of 
.I text 
is written to the output,
.I not
one copy per line deleted.
As with
.B a
and
.B i ,
.I text 
is not scanned for address matches, and no
editing commands are attempted on it.
It does not change the line-number counter.
.P
After a line has been deleted by a
.B c
function, no further commands are attempted on it.
.P
If text is appended after a line by
either the 
.B a
or
.B r
function, and the line is subsequently changed, the text
inserted by the
.B c
function is placed
.I before
the text of the
.B a
or
.B r
function.
.LE 
.P
.B Note:
Within the text put in the output by these functions,
leading blanks and tabs will disappear, as always in 
.I sed 
commands.
To get leading blanks and tabs into the output, precede the first
desired blank or tab by a backslash; the backslash will not
appear in the output.
.P
As an example, examine
the following list of editing commands:
.DS I
n
a\e
XXXX
d
.DE
These commands, applied to our standard input, produce:
.DS I
In Xanadu did Kubla Khan
XXXX
Where Alph, the sacred river, ran
XXXX
Down to a sunless sea.
.DE
.P
In this particular case,
the same effect would be produced by either
of the two following command lists:
.DS I
n		n
i\e		c\e
XXXX	        XXXX
d
.DE
.H 3 "The Substitute Function"
The substitute function changes parts of lines selected by
a context search within the line.
Its syntax is below:
.DS I
.B
s/\|\fIpattern\fP/\|\fIreplacement\fP/\|\fIflags\fP
.R
.DE
The
.B s
function replaces
.I part
of a line (selected by \fIpattern\fP) with \fIreplacement\fP.
It can best be read as substitute for 
.I pattern , 
.I replacement .
The 
.I pattern 
argument contains a pattern,
exactly like the patterns in addresses. 
The only difference between 
.I pattern 
and a context address is
that the context address must be delimited by slash (/) characters;
.I pattern 
may be delimited by any character other than space or
newline.
.P
By default, only the first string matched by 
.I pattern 
is replaced,
but see the
.B g
flag below.
.P 
The
.I replacement 
argument begins immediately after the
second delimiting character of 
.I pattern, 
and must be followed
immediately by another instance of the delimiting character.
(Thus, there are exactly 
.I three
instances of the delimiting character.)
.P
The 
.I replacement 
is not a pattern,
and the characters which are special in patterns
do not have special meanings in 
.I replacement .
Instead, other characters are special:
.VL 10 5
.LI \fB&\fR
The ampersand is replaced by the string matched by \fIpattern\fP
.LI \fB\e\fId\fR
The single digit 
.I d 
is replaced by the 
.I d th
substring matched by parts of
.I pattern 
enclosed in 
.Q "\e("
and 
.Q "\e)" .
If nested substrings occur in 
.I pattern , 
the 
.I d th
is determined by counting opening delimiters 
.Q "\e(" .
.LE 1
.P
As in patterns, special characters may be made
literal by preceding them with backslash (\e).
.P
The \fIflags\fP argument may contain the following flags:
.VL 10 5
.LI "\fBg\fR"
Substitute \fIreplacement\fP for all (nonoverlapping)
instances of \fIpattern\fP in the line.
After a successful substitution, the scan for the next
instance of \fIpattern\fP begins just after the end of the
inserted characters; characters put into the line from
\fIreplacement\fP are not rescanned.
.LI "\fBp\fR"
Print the line if a successful replacement was done.
The
.B p
flag causes the line to be written to the output if and only
if a substitution was actually made by the
.B s
function.
Note that if several
.B s
functions, each followed by a
.B p
flag, successfully substitute in the same input line,
multiple copies of the line will be written to the
output; one for each successful substitution.
.LI "\fBw\fR \fIfilename\fP"
.br
Write the line to a file if a successful replacement was done.
The
.B w
flag causes lines which are actually substituted by the
.B s
function to be written to a file named by 
.I filename .
If 
.I filename 
exists before 
.I sed 
is run, it is overwritten;
if not, the
.I filename 
is created.
A single space must separate
.B w
and 
.I filename .
The possibilities of multiple, somewhat different copies of
one input line being written are the same as for 
.B p .
A maximum of ten different filenames may be mentioned after
.B w
flags and
.B w
functions (see below), combined.
.LE
.P
For example, study the following command 
.DS I
s/to/by/w changes
.DE
applied to our standard input:
.DS I
In Xanadu did Kubla Khan
A stately pleasure dome decree:
Where Alph, the sacred river, ran
Through caverns measureless to man
Down to a sunless sea.
.DE
.P
This produces the following output:
.DS I
In Xanadu did Kubla Khan
A stately pleasure dome decree:
Where Alph, the sacred river, ran
Through caverns measureless by man
Down by a sunless sea.
.DE
It also writes the following output to the file
.I changes :
.DS I
Through caverns measureless by man
Down by a sunless sea.
.DE
If the nocopy option is in effect, the command
.DS I
s/[.,;?:]/*P&*/gp
.DE
produces:
.DS I
A stately pleasure dome decree*P:*
Where Alph*P,* the sacred river*P,* ran
Down to a sunless sea*P.*
.DE
Finally, to illustrate the effect of the
.B g
flag,
the command
.DS I
/X/s/an/AN/p
.DE
produces (assuming nocopy mode):
.DS I
In XANadu did Kubla Khan
.DE
and the command
.DS I
/X/s/an/AN/gp
.DE
produces:
.DS I
In XANadu did Kubla KhAN
.DE
.H 3 "Input/Output Functions"
.VL 10 5
.LI "\fBp\fR~\*(EM~Print (2)"
.br
The print function writes the addressed lines 
to the standard output file.
They are written at the time the
.B p
function is encountered, regardless of what succeeding
editing commands may do to the lines.
.LI "\fBw\fR \fIfilename\fP~\*(EM~Write to \fIfilename\fP (2)"
.br
The write function writes the addressed lines to the file named
by 
.I filename .
If the file previously existed, it is overwritten; 
if not, it is created.
The lines are written exactly as they exist when the write function
is encountered for each line, regardless of what subsequent
editing commands may do to them.
Exactly one space must separate the
.B w
and 
.I filename .
A maximum of ten different files may be mentioned both for
write functions and for
.B w
flags after
.B s
functions. 
.LI "\fBr\fR \fIfilename\fP~\*(EM~Read the contents of a file (1)"
.br
The read function reads the contents of 
.I filename , 
and appends
them after the line matched by the address.
The file is read and appended regardless of what subsequent
editing commands do to the line which matched its address.
If
.B r
and
.B a
functions are executed on the same line,
the text from the 
.B a
functions and the
.B r
functions is written to the output in the order that
the functions are executed.
.P
Exactly one space must separate the
.B r
and 
.I filename .
If a file mentioned by an
.B r
function cannot be opened, it is considered a null file,
not an error, and no diagnostic is given.
.LE 1
.P
.B Note:
Since there is a limit to the number of files that can be opened
simultaneously, care should be taken that no more than ten
files are mentioned in
.B w
functions or flags. 
This number is reduced by one if any
.B r
functions are present,
since only one read file is open at one time.
.P
For example,
assume that the file 
.FN note1
has the following contents:
.DS I
    Note:  Kubla Khan (more properly Kublai Khan; 1216-1294)
    was the grandson and most eminent successor of Genghiz
    (Chingiz) Khan, and founder of the Mongol dynasty in China.
.DE
.P
Then the following command:
.DS I
/Kubla/r note1
.DE
produces:
.DS I
In Xanadu did Kubla Khan
    Note:  Kubla Khan (more properly Kublai Khan; 1216-1294)
    was the grandson and most eminent successor of Genghiz
    (Chingiz) Khan, and founder of the Mongol dynasty in China.
A stately pleasure dome decree:
Where Alph, the sacred river, ran
Through caverns measureless to man
Down to a sunless sea.
.DE
.H 3 "Multiple Input-Line Functions"
Three functions, all spelled with capital letters, deal
with multiple line pattern spaces containing embedded newlines.
They are intended to provide pattern matches across
lines in the input.
.VL 10 5
.LI "\fBN\fR~\*(EM~Next~line (2)"
.br
The 
.B N
function appends the next
input line to the current line in the
pattern space; the two input lines are separated by an embedded
newline.
Pattern matches may extend across the embedded newline(s).
.LI "\fBD\fR~\*(EM~Delete~first~part~of the pattern space (2)"
.br
The
.B D
functions
deletes up to and including the first newline character
in the current pattern space.
If the pattern space becomes empty (the only newline
was the terminal newline),
read another line from the input.
In any case, begin the list of editing commands again
from the beginning.
.LI "\fBP\fR~\*(EM~Print first part of the pattern space (2)"
.br
Print up to and including the first newline in the pattern space.
.LE 1
.P
The 
.B P
and
.B D
functions are equivalent to their lowercase counterparts
if there are no embedded newlines in the pattern space.
.H 3 "Hold and Get Functions"
Five functions save and retrieve part of the input 
for possible later use:
.VL 10 5
.LI "\fBh\fR~\*(EM~Hold pattern space (2)"
.br
The
.B h
function copies the contents of the pattern space
into a hold area, destroying the previous contents of the
hold area.
.LI "\fBH\fR~\*(EM~Append pattern space to hold area (2)"
.br
The
.B H
function appends the contents of the pattern space
to the contents of the hold area; the former and new contents
are separated by a newline.
.LI "\fBg\fR~\*(EM~Get contents of hold area (2)"
.br
The
.B g
function copies the contents of the hold area into
the pattern space, destroying the previous contents of the
pattern space.
.LI "\fBG\fR~\*(EM~Get contents of hold area (2)"
.br
The
.B G
function appends the contents of the hold area to the
contents of the pattern space; 
the former and new contents are separated by a newline.
.LI "\fBx\fR~\*(EM~Exchange (2)"
.br
The exchange command interchanges the contents
of the pattern space and the hold area.
.LE 2
For example, the commands
.DS I
1h
1s/ did.*//
1x
G
s/\en/  :/
.DE
applied to our standard example, produce:
.DS I
In Xanadu did Kubla Khan  :In Xanadu
A stately pleasure dome decree:  :In Xanadu
Where Alph, the sacred river, ran  :In Xanadu
Through caverns measureless to man  :In Xanadu
Down to a sunless sea.  :In Xanadu
.DE
.H 3 "Flow-of-Control Functions"
These functions do no editing on the input
lines, but rather control the application of functions
to the lines selected by the address part.
.VL 10 5
.LI "\fB!\fR~\*(EM~Don't (2)"
.br
The
Don't
command causes the next command
(written on the same line), 
to be applied to all and only those input lines
.I not
selected by the address part.
.LI "\fB{~\fRand~\fB}\fR~\*(EM~Grouping (2)"
.br
The grouping command,
.B { ,
causes the next set of commands to be applied
(or not applied) as a block to the
input lines selected by the addresses
of the grouping command.
The first of the commands under control of the grouping
may appear on the same line as the
.B { 
or on the next line.
The group of commands is terminated by a
matching 
.B }
standing on a line by itself.
Groups can be nested.
.LI "\fB:\fIlabel\fR~\*(EM~Place a label (0)"
.br
The label function marks a place in the list
of editing commands which may be referred to by
.B b
and
.B t
functions.
The 
.I label 
may be any sequence of eight or fewer characters.
If two different colon functions have identical labels,
a compile time diagnostic will be generated, and
no execution attempted.
.LI "\fBb\fIlabel\fR~\*(EM~Branch to label (2)"
.br
The branch function causes  the sequence of editing commands being
applied to the current input line to be restarted immediately
after the place where a colon function with the same 
.I label
was encountered.
If no colon function with the same label can be found after
all the editing commands have been compiled, a compile time diagnostic
is produced, and no execution is attempted.
.P
A
.B b
function with no 
.I label 
is taken to be a branch to the end of the
list of editing commands.
Whatever should be done with the current input line is done, and
another input line is read. 
The list of editing commands is restarted from the
beginning on the new line.
.LI "\fBt\fIlabel\fR~\*(EM~Test substitutions (2)"
.br
The
.B t
function tests whether 
.I any
successful substitutions have been made on the current input
line.
If so, it branches to 
.I label ;
if not, the
.B t
function does nothing.
The flag which indicates that a successful substitution has
been executed is reset by reading a new input line, or
executing a
.B t
function.
.LE
.H 3 "Miscellaneous Functions"
.VL 10 5
.LI "\fB=\fR~\*(EM~Equals (1)"
.br
The = function writes to the standard output the line number of the
line matched by its address.
.LI "\fBq\fR~\*(EM~Quit (1)"
.br
The
.B q
function causes the current line to be written to the
output (if it should be), any appended or read text to be written, and
execution to be terminated.
.LE 1
.bp
.H 2 "Command Summary"
.VL 20 5
.LI "\fBa\fR\e~\fItext\fR"
Append line to pattern space.
.LI "\fBb\fIlabel\fR"
Branch to label.
.LI "\fBc\fR\e~\fItext\fP"
Change pattern space, replacing with
.I text.
.LI "\fBd\fR"
Delete pattern space.
.LI "\fBD\fR"
Delete first part of pattern space.
.LI "\fBg\fR"
Get contents of hold area.
.LI "\fBG\fR"
Get first line of hold area.
.LI "\fBh\fR"
Put pattern space in hold area.
.LI "\fBH\fR"
Append pattern space to hold area.
.LI "\fBi\fR\e~\fItext\fP"
Insert~lines.
.LI "\fBn\fR"
Make next line pattern space.
.LI "\fBN\fR"
Append next line to pattern space.
.LI "\fBp\fR"
Print the pattern space.
.LI "\fBP\fR"
Print first part of the pattern space.
.LI "\fBq\fR"
Quit. 
.LI "\fBr\fR \fIfilename\fP"
Read in the contents of a 
.I filename.
.LI "\fBs/\|\fIpattern\fP/\|\fIreplacement\fP/\fR"
.br
Substitute
.I pattern
with 
.I replacement .
.LI "\fBt\fIlabel\fR"
Test substitutions.
.LI "\fBw\fR \fIfilename\fP"
Write to \fIfilename\fP. 
.LI "\fBx\fR"
Exchange hold area with pattern space.
.LI "\fB{\fR~and~\fB}\fR"
Group statements.
.LI "addresses\fB!\fR"
Don't match these 
.I addresses.
.LI "\fB:\fIlabel\fR"
Place label. 
.LI "\fB=\fR"
Print line number.
.LE
.TC 2 1 5 0
