@ECHO OFF

IF NOT '%leafinst%'=='' GOTO good_env
SET environ=1234567890
IF '%environ%'=='1234567890' GOTO good_env

ECHO 
ECHO %0: Insufficient environment space; approximately
ECHO 96 characters are needed to use Interleaf 5.  To increase the
ECHO environment space, edit \CONFIG.SYS on the boot drive.  Find
ECHO the line beginning with "SHELL=" and increase the number after
ECHO the "/e:" option by 96.  If there is no "SHELL=" line, add the
ECHO following line:
ECHO     SHELL=c:\dos\command.com /p /e:352
ECHO 
ECHO CONFIG.SYS must also contain lines that look like the following:
ECHO     FILES=60
ECHO     BUFFERS=40
ECHO The numbers of FILES and BUFFERS can be greater than these
ECHO examples, but not lower.
ECHO 
ECHO When you have finished editing CONFIG.SYS, reboot and
ECHO run %0 again.
ECHO 

SET environ=
GOTO done

:good_env
SET environ=

:good_env2
IF '%1'=='' GOTO init_u1
IF '%2'=='' GOTO init_u1

IF EXIST %1\nul GOTO init_1a
ECHO Can't find source drive %1.
ECHO 
GOTO init_use

:init_1a
IF EXIST %1\inst.s1l GOTO init_1b
ECHO Drive %1 does not contain diskette #1 of an Interleaf product.
ECHO 
GOTO init_use

:init_1b
IF EXIST %2\nul GOTO init_1c
ECHO Can't find destination drive %2.
ECHO 
GOTO init_use

:init_1c
IF EXIST %2\ileaf5\nul GOTO init_con
IF EXIST %1\ilunzip.exe GOTO init_con
ECHO Can't find Interleaf home directory %2\ileaf5,
ECHO and %1 doesn't contain Interleaf 5 diskette #1.
ECHO If you are modifying an existing installation, your
ECHO default drive must be set to the drive containing
ECHO the Interleaf home directory.
ECHO 
GOTO done

:init_u1
IF EXIST \ileaf5\install\private\parts.lsp GOTO not_new

:init_use
ECHO LEAFINST Usage
ECHO --------------
ECHO When installing Interleaf 5 or a layered product for the first
ECHO time from a set of diskettes, use:  leafinst SOURCE: DESTINATION:
ECHO (example: leafinst a: c:).
ECHO 
ECHO When installing additional options from a set of diskettes,
ECHO or when checking or deleting installed products, set your
ECHO default drive to the drive containing the \ileaf5 directory,
ECHO change to the \ileaf5 directory, and type install\leafinst.
GOTO done

:init_con
IF EXIST %2\ileaf5\install\private\parts.lsp GOTO init_c1a

ECHO 
ECHO Installation of Interleaf 5 for DOS
ECHO -----------------------------------
ECHO When you install Interleaf 5, you first view the default configuration
ECHO of installable options.  You can accept the defaults or edit them to
ECHO create a customized configuration.  Then the installation program loads
ECHO files from the diskettes.  The installation process takes 35 minutes
ECHO for the default small configuration.  Additional time is needed for
ECHO adding more options.
ECHO 
ECHO Interleaf 5 requires a 386 or 486 system and at least 20Mb of free
ECHO space after installation as swap space.  Check the System Administration
ECHO manual for supported video adapters.
ECHO 
ECHO Before installing, check for disk problems by running CHKDSK on the
ECHO drive where you will install.  If problems are reported, fix them by
ECHO running CHKDSK /F or another disk repair utility.
ECHO 
ECHO If an older version of the software is installed on the destination
ECHO drive, you should:  rename the home directory from ILEAF5 to ILEAF5.OLD
ECHO before installation, or remove the old ILEAF5 directory.  To remove it,
ECHO run the ILRD command provided on diskette #1 and follow the instructions.
ECHO 
ECHO Press Ctrl-C to cancel the installation.
PAUSE

MKDIR %2\ileaf5
ECHO writeable > %2\ileaf5\writetmp
IF EXIST %2\ileaf5\writetmp GOTO perm1
ECHO Can't create files in %2.  You might need write permissions.
GOTO done

:perm1
%2
CD \ileaf5
IF EXIST writetmp DEL writetmp
ECHO 
ECHO On menus, the default option will appear in brackets after
ECHO the prompt.  To select the default, press Enter or Return.
ECHO To select a different option, enter its number.  When multiple
ECHO options are allowed, enter all your choices, separating
ECHO them with spaces.
ECHO 
ECHO Created %2\ileaf5; installing partial application.
ECHO Please wait for the Configuration Options Menu.
%1\ilunzip -d -o -q %1\inst.s1l
SET leafinst=%1
install\leafinst

:init_c1a
ECHO writeable > %2\ileaf5\writetmp
IF EXIST %2\ileaf5\writetmp GOTO perm2
ECHO Can't create files in %2\ileaf5.  You might need write permissions.
GOTO done

:perm2
%2
CD \ileaf5
IF EXIST writetmp DEL writetmp
ECHO On menus, the default option will appear in brackets after
ECHO the prompt.  To select the default, press Enter or Return.
ECHO To select a different option, enter its number.  When multiple
ECHO options are allowed, enter all your choices, separating
ECHO them with spaces.
ECHO 
ECHO Extracting installation data files.
bin\ilunzip -d -o -q %1\inst.s1l
SET leafinst=%1

:not_new
:cont_1
CD \ileaf5
IF '%leafinst%'=='' SET leafinst=a:

ECHO writeable > writetmp
IF EXIST writetmp GOTO perm3
ECHO Can't create files in \ileaf5.  You might need write permissions.
GOTO done

:perm3
IF EXIST writetmp DEL writetmp
IF EXIST install\private\leafinst.bat DEL install\private\leafinst.bat
IF EXIST install\log_tmp.lsp DEL install\log_tmp.lsp

ECHO ; set leafinst=no_op> install\private\leafinst.bat
ECHO ; GOTO tempdone >> install\private\leafinst.bat
ECHO (progn >> install\private\leafinst.bat
ECHO (princ "\nLoading configuration database ...\n") >> install\private\leafinst.bat
ECHO (setq *self-name* "leafinst") >> install\private\leafinst.bat
ECHO (setq *hier-name* "\\ileaf5") >> install\private\leafinst.bat
ECHO (load "install\\private\\leaf.lsp") >> install\private\leafinst.bat
ECHO (load "install\\private\\parts.lsp") >> install\private\leafinst.bat
ECHO (setq prod-files nil) >> install\private\leafinst.bat
ECHO (init-parts 'dos "\\ileaf5" nil "\\ileaf5" :vars) >> install\private\leafinst.bat
ECHO (setq *source-host* "THIS_MACHINE") >> install\private\leafinst.bat
ECHO (setq *source-dir-is-writable* t) >> install\private\leafinst.bat
ECHO (init-page 23 80 :clear-string "\n\n") >> install\private\leafinst.bat
ECHO (setq *csh-temp* "install\\private\\leafinst.bat") >> install\private\leafinst.bat
ECHO (setq *media-device* "%leafinst%") >> install\private\leafinst.bat
ECHO (setq *date* "THE-DATE") >> install\private\leafinst.bat
ECHO (setq *user-login* "LEAF_USER") >> install\private\leafinst.bat
ECHO (setq *admin-login* "LEAF_USER") >> install\private\leafinst.bat
ECHO (config) >> install\private\leafinst.bat
ECHO (quit) >> install\private\leafinst.bat
ECHO ) >> install\private\leafinst.bat
ECHO :tempdone >> install\private\leafinst.bat

bin\inst_aux install\private\leafinst.bat -b

CALL install\private\leafinst
ECHO @ECHO OFF > install\private\leafinst.bat

IF '%leafinst%'=='delete' GOTO cont_6
IF NOT '%leafinst%'=='no_op' GOTO cont_6a
IF EXIST install\log.lsp GOTO done
ECHO To finish this installation later, set your default drive to
ECHO the drive containing the \ileaf5 directory, change to the \ileaf5
ECHO directory, and type install\leafinst.
ECHO 
ECHO To remove the partial \ileaf5 directory, run the ILRD command provided
ECHO on diskette #1 and follow the instructions.
GOTO done

:cont_6
rem  deleting
TYPE install\log_tmp.lsp >> install\log.lsp
DEL  install\log_tmp.lsp
ECHO *** added entry to install log
CALL install\private\script
GOTO cont_12a

:cont_6a
rem  installing
IF NOT EXIST install\log.lsp ECHO SET leafinst=initial>> install\private\leafinst.bat
CALL install\private\copypart %leafinst%
GOTO cont_12

:cont_12
IF EXIST install\private\supp GOTO cont_12a
ECHO 
ECHO Please switch to the supplemental diskette(s).
bin\iljoin %leafinst%SUPP_ install\private\supp.zip
bin\ilunzip -d -o -q install\private\supp.zip
DEL install\private\supp.zip
ECHO supplemental > install\private\supp

:cont_12a
CALL install\private\leafinst.bat
ECHO 
ECHO *** completing \ileaf5 directory
ECHO 
ECHO bin\i5load bin\tabler.i5 -v
bin\i5load bin\tabler.i5 -v
ECHO 

IF NOT '%leafinst%'=='initial' GOTO cont_14
IF EXIST \config.il5   DEL \config.il5
IF EXIST \autoexec.il5 DEL \autoexec.il5
COPY data\config.il5   \ > nul
COPY data\autoexec.il5 \ > nul
ECHO 
ECHO Before starting Interleaf 5, complete the following procedures.
ECHO Refer to the Installation Guide for more information.
ECHO 
ECHO 1.  If you have a key diskette for optional Interleaf 5 features,
ECHO     copy its contents to the \ileaf5\data\license directory.
ECHO 2.  Edit the CONFIG.SYS and AUTOEXEC.BAT files (in the root
ECHO     directory of the boot drive) according to the instructions
ECHO     in the files CONFIG.IL5 and AUTOEXEC.IL5, which have been
ECHO     copied to the root directory on the drive where the \ileaf5
ECHO     directory is located.
ECHO 3.  Reboot to make the edited files take effect.
ECHO 4.  To start Interleaf 5, type "ileaf".
ECHO 
ECHO To run under Windows, you must configure Windows for Interleaf 5
ECHO according to the instructions in the Installation Guide.  The
ECHO Guide also contains instructions for installing the diskettes
ECHO for layered products (such as the Developer's Toolkit.)
ECHO 

:cont_14
ECHO *** %0: done
GOTO done


:done
CD \
SET leafinst=
