.ad l
.nh
.TH XTOPS 1 "1 July 1991" "X Version 11"
.SH NAME
XtoPS - dump an image of an X window as encapsulated Postscript
.SH SYNOPSIS
.B "XtoPS"
[ \fIoptions\fP ... ] \fIfile\fP
.SH DESCRIPTION
.PP
.I XtoPS
is an X Window System window dumping utility.
.I XtoPS
reads an image from any visible window on an X server and outputs it to
an encapsulated Postscript file.  You can view this file with any
Postscript compatible viewer or printer.  The image is displayed in
color on Postscript viewers or printers that support color, otherwise
it is displayed as grayscale.
.pp
The target window can be specified by id or name or be selected by
clicking the mouse in the desired window.  The keyboard bell is rung
once at the beginning of the dump and twice when the dump is
completed.
.SH EXAMPLES
.PP
To select a X window and save it as encapsulated Postscript in a file on 
disk titled window.ps, use:
.PP
     XtoPS window.ps
.PP
To select a X window and save it as encapsulated Postscript in a file on
disk titled figure.ps to include in another document, use:
.PP
     XtoPS -geometry +0+0 figure.ps
.PP
To save the entire X server screen as encapsulated Postscript in a file on
disk titled root.ps, use:
.PP
     XtoPS -window root root.ps
.SH OPTIONS
\fIXtoPS\fP options can appear on the command line or in your X resources
file (see X(1)).  Options on the command line supercede values specified
in your X resources file.
.TP 5
.B "-border"
include image borders in the output image.
.TP 5
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP 5
.B "-frame"
include window manager frame.
.TP 5
.B "-geometry \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the image on the Postscript page.  
See \fBX(1)\fP for details about the geometry specification. By default, the `
image is scaled and centered to fit on an 612x792 point Postscript page.

If the specified image size is smaller than the actual image size, the
image is first reduced to an integral of the specified image size with
an antialias digital filter.  The image is then scaled to the exact
specified image size with pixel replication.  If the specified image
size is greater than the actual image size, the image is first enlarged
to an integral of the specified image size with bilinear
interpolation.  The image is then scaled to the exact specified image
size with pixel replication.
.B "-monochrome"
transform image to black and white.
.TP 5
.B "-rotate \fIdegrees\fP"
apply Paeth image rotation to the image.

By default the image is output in portrait mode.  Use \fB-rotate 90\fP to
display the image in landscape mode.
.TP 5
.B "-scale \fI<width factor>x<height factor>\fP"
preferred size factors of the image.

This option behaves like \fB-geometry\fP except the width and height values
are relative instead of absolute.  The image size is multiplied by the
width and height factors to obtain the final image dimensions.  If only
one factor is specified, both the width and height factors assume the
value.

Factors may be fractional.  For example, a factor of 1.5 will increase the
image size by one and one-half.
.TP 5
.B "-screen"
This option indicates that the GetImage request used to obtain the image
should be done on the root window, rather than directly on the specified
window.  In this way, you can obtain pieces of other windows that overlap
the specified window, and more importantly, you can capture menus or other
popups that are independent windows but appear over the specified window.
.TP 5
.B "-window \fIid\fP"
select window with this id or name.

With this option you can specify the target  window by id or name
rather than using the mouse.  Specify 'root' to select X's root window
as the target window.
.TP 5
.PP
Change \fI-\fP to \fI+\fP in any option above to reverse its effect.  For
example \fB+frame\fP means do not include window manager frame.
.PP
Specify \fIfile\fP as \fI-\fP for standard input or output.
.PP
.SH ENVIRONMENT
.PP
.TP 5
.B DISPLAY
To get the default host, display number, and screen.
.SH SEE ALSO
X(1), display(1), import(1)
.SH COPYRIGHT
Copyright 1991 E. I. du Pont de Nemours & Company                           
.PP                                                                           
Permission to use, copy, modify, distribute, and sell this software and    
its documentation for any purpose is hereby granted without fee,           
provided that the above copyright notice appear in all copies and that     
both that copyright notice and this permission notice appear in            
supporting documentation, and that the name of E. I. du Pont de Nemours     
& Company not be used in advertising or publicity pertaining to            
distribution of the software without specific, written prior               
permission.  E. I. du Pont de Nemours & Company makes no representations    
about the suitability of this software for any purpose.  It is provided    
"as is" without express or implied warranty.                               
.PP
E. I. du Pont de Nemours & Company disclaims all warranties with regard     
to this software, including all implied warranties of merchantability      
and fitness, in no event shall E. I. du Pont de Nemours & Company be        
liable for any special, indirect or consequential damages or any           
damages whatsoever resulting from loss of use, data or profits, whether    
in an action of contract, negligence or other tortious action, arising     
out of or in connection with the use or performance of this software.      
.SH AUTHORS
John Cristy, E.I. du Pont De Nemours & Company Incorporated

