.ad l
.nh
.TH DISPLAY 1 "1 July 1991" "X Version 11"
.SH NAME
display - display an image on any workstation running X
.SH SYNOPSIS
.B "display" [ \fIoptions\fP ...] \fIfile\fP
[ [ \fIoptions\fP ...] \fIfile\fP ...]
.SH DESCRIPTION
\fIDisplay\fP is a machine architecture independent image processing
and display program.  It can display any image in the MIFF format on
any workstation display running an X server.  \fIDisplay\fP first
determines the hardware capabilities of the workstation.  If the number
of unique colors in the image is less than or equal to the number the
workstation can support, the image is displayed in an X window.
Otherwise the number of colors in the image is first reduced to match
the color resolution of the workstation before it is displayed.
.PP
This means that a continuous-tone 24 bits/pixel image can display on a
8 bit pseudo-color device or monochrome device.  In most instances the
reduced color image closely resembles the original.  Alternatively, a
monochrome or pseudo-color image can display on a continuous-tone 24
bits/pixels device.
.SH EXAMPLES
To scale an image of a cockatoo to exactly 640 pixels in width and 480
pixels in height and position the window at location (200,200), use:
.PP
     display -geometry 640x480\+200\+200 cockatoo.miff
.PP
To display an image of a cockatoo without a border centered on a
backdrop, use:
.PP
     display -backdrop -borderwidth 0 cockatoo.miff
.PP
To tile an image of a cockatoo onto the root window, use:
.PP
     display -window root cockatoo.miff
.SH OPTIONS
.TP 5
.B "-backdrop"
display the image centered on a backdrop.

This backdrop covers the entire workstation screen and is useful for
hiding other X window activity while viewing the image.   The color of
the backdrop is specified as the background color.  Refer to \fBX
RESOURCES\fP for details.
.TP 5
.B "-clip \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the clipped image.  See \fBX(1)\fP for details 
about the geometry specification.

Use clipping to apply image processing options, or display, only a
particular area of an image.  

The equivalent X resource for this option is \fBclipGeometry\fP 
(class \fBClipGeometry\fP).  See \fBX RESOURCES\fP for details.
.TP 5
.B "-colors \fIvalue\fP"
preferred number of colors in the image.  

The actual number of colors in the image may be less than your request,
but never more.  Note, this is a color reduction option.  Images with
less unique colors than specified with this option will remain unchanged.
Refer to \fBCOLOR REDUCTION ALGORITHM\fP for more details.

Note, options \fB-dither\fP and \fB-treedepth\fP affect the color reduction
algorithm.
.TP 5
.B "-compress \fItype\fP"
the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.

Use this option with \fB-write\fP to specify the the type of image
compression.  See \fBMIFF FILE FORMAT\fP for details.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP 5
.B "-delay \fIseconds\fP"
display the next image after pausing.  

This option is useful when viewing several images in sequence.  Each
image will display and wait the number of seconds specified before the
next image is displayed.  The default is to display the image
continuously until you terminate it.  
.TP 5
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP 5
.B "-dither"
apply Floyd/Steinberg error diffusion to the image.  

The basic strategy of dithering is to trade intensity resolution for 
spatial resolution by averaging the intensities of several neighboring 
pixels.  Images which suffer from severe contouring when reducing colors 
can be improved with this option.

The \fB-colors\fP, \fB-gray\fP, or \fB-monochrome\fP option is required 
for this option to take effect.
.TP 5
.B "-enhance"
apply a digital filter to enhance a noisy image.
.TP 5
.B "-gamma \fIvalue\fP"
level of gamma correction.  

The same color image displayed on two different workstations may look
different due to differences in the display monitor.  Use gamma
correction to adjust for this color difference.  Reasonable values
extend from 0.8 to 2.3.  
.TP 5
.B "-geometry \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the image window.  See \fBX(1)\fP for details 
about the geometry specification.  By default, the window size is the image 
size and the location is choosen by you when it is mapped.

If the specified image size is smaller than the actual image size, the
image is first reduced to an integral of the specified image size with
an antialias digital filter.  The image is then scaled to the exact
specified image size with pixel replication.  If the specified image
size is greater than the actual image size, the image is first enlarged
to an integral of the specified image size with bilinear
interpolation.  The image is then scaled to the exact specified image
size with pixel replication.

When displaying an image on an X server, the x and y offset in the
geometry specification is relative to the root window.  When printing
an image, the x and y offset in the geometry specification is relative
to a Postscript page.  See \fB-print\fP for more details.

The equivalent X resource for this option is \fBimageGeometry\fP 
(class \fBImageGeometry\fP).  See \fBX RESOURCES\fP for details.
.TP 5
.B "-gray"
transform the image to gray scale colors.  
.TP 5
.B "-inverse"
apply color inversion to image.  

The red, green, and blue intensities of an image are negated.
.TP 5
.B "-magnify \fIvalue\fP"
specifies an integral factor by which the image should be enlarged.  The
default is 2.

This value only affects the magnification window which is invoked with
button number 1 after the image is displayed.  Refer to \fBBUTTONS\fP
for more details.
.TP 5
.B "-map \fItype\fP"
display image using this Standard Colormap type.

Choose from these Standard Colormap types:

    default
    best
    red
    green
    blue
    gray

The X server must support the Standard Colormap you choose, otherwise an 
error occurs.  See \fBxcmap(1)\fP for one way of creating Standard Colormaps.
.TP 5
.B "-monochrome"
transform the image to black and white.

Monochrome images can benefit from error diffusion.  Use \fB-dither\fP with
this option to diffuse the error.
.TP 5
.B "-noise"
reduce the noise in an image with a noise peak elimination filter.

The principal function of noise peak elimination filter is to smooth
the objects within an image without losing edge information and without
creating undesired structures.  The central idea of the algorithm is to
replace a pixel with its next neighbor in value within a 3 x 3 window,
if this pixel has been found to be noise.  A pixel is defined as noise
if and only if this pixel is a maximum or minimum within the 3 x 3 window.
.TP 5
.B "-normalize"
tranform image to span the full range of color values.
.TP 5
.B "-print \fIfile\fP"
write image as encapsulated Postscript to a file.  

You can view the file with any Postscript compatible viewer or
printer.  The image is displayed as color on viewers and printers that 
support color Postscript, otherwise it is displayed as grayscale.

If \fIfile\fP already exists, you will be prompted as to whether
it should be overwritten.  

By default, the image is scaled and centered to fit on an 612x792 point
Postscript page.  To specify a specific image size or a particular location on 
the Postscript page, use \fB-geometry\fP.

By default the image is output in portrait mode.  Use \fB-rotate 90\fP to
display the image in landscape mode.

The equivalent X resource for this option is \fBprintFilename\fP 
(class \fBPrintFilename\fP).  See \fBX RESOURCES\fP for details.
.TP 5
.TP 5
.B "-reflect"
create a "mirror image" by reflecting the image scanlines.
.TP 5
.B "-rotate \fIdegrees\fP"
apply Paeth image rotation to the image.
.TP 5
.B "-scale \fI<width factor>x<height factor>\fP"
preferred size factors of the image.

This option behaves like \fB-geometry\fP except the width and height values
are relative instead of absolute.  The image size is multiplied by the
width and height factors to obtain the final image dimensions.  If only
one factor is specified, both the width and height factors assume the
value.

Factors may be fractional.  For example, a factor of 1.5 will increase the
image size by one and one-half.

The equivalent X resource for this option is \fBscaleGeometry\fP 
(class \fBScaleGeometry\fP).  See \fBX RESOURCES\fP for details.
.TP 5
.B "-scene \fInumber\fP"
image scene number.
.TP 5
.B "-treedepth \fIvalue\fP"
Normally, this integer value is zero or one.  A zero or one tells
\fIDisplay\fP to choose a optimal tree depth for the color reduction
algorithm.  

An optimal depth generally allows the best representation of the source
image with the fastest computational speed and the least amount of
memory.  However, the default depth is inappropriate for some images.
To assure the best representation, try values between 2 and 8 for this
parameter.  Refer to \fBCOLOR REDUCTION ALGORITHM\fP for more details.

The \fB-colors\fP, \fB-gray\fP, or \fB-monochrome\fP option is required
for this option to take effect.
.TP 5
.B -verbose
print detailed information about the image.  

This information is printed: image scene number;  image name;  image
size; the image class (\fIDirectClass\fP or \fIPseudoClass\fP); the total 
number of unique colors (if known);  and the number of seconds to read and
transform the image.  Refer to \fBMIFF FILE FORMAT\fP for a description of
the image class.

If \fB-colors\fP is also specified, the total unique colors in the image
and color reduction error values are printed.  Refer to \fBMEASURING 
COLOR REDUCTION ERROR\fP for a description of these values.  
.TP 5
.B "-visual \fItype\fP"
display image using this visual type.

Choose from these visual classes:

    StaticGray
    GrayScale
    StaticColor
    PseudoColor
    TrueColor
    DirectColor
    default
    \fIvisual id\fP

The X server must support the visual you choose, otherwise an error occurs.
If a visual is not specified, the visual class that can display the most 
simultaneous colors on the default screen is choosen.
.TP 5
.B "-window \fIid\fP"
set the background pixmap of this window to the image.

\fid\fP can be a window id or name.  Specify 'root' to select X's root
window as the target window.

By default the image is tiled onto the background of the target
window.   If \fB-backdrop\fP or \fB-geometry\fP are specified, the
image is surrounded by the background color.  Refer to \fBX
RESOURCES\fP for details.

The image will not display on the root window if the image has more
unique colors than the target window colormap allows.  Use
\fB-colors\fP to reduce the number of colors.
.TP 5
.B "-write \fIfile\fP"
write image to a file.  

The image is stored in the MIFF image format.  If the number of unique
colors in the image exceed 65535, it is stored as \fIDirectClass\fP;
otherwise, it is stored as \fIPseudoClass\fP format.  Refer to \fBMIFF
FILE FORMAT\fP for more details.

Use \fB-compress\fP to specify the type of image compression.

If \fIfile\fP has the extension \fB.Z\fP, the file size is reduced using
Lempel-Ziv coding with \fBcompress\fP.  If \fIfile\fP already exists, 
you will be prompted as to whether it should be overwritten.

The equivalent X resource for this option is \fBwriteFilename\fP 
(class \fBWriteFilename\fP).  See \fBX RESOURCES\fP for details.
.PP
In addition to those listed above, you can specify these standard X
resources as command line options:  -background, -bordercolor,
-borderwidth,  -font, -foreground, -iconGeometry, -iconic, -name, or -title.  
See \fBX RESOURCES\fP for details.
.PP
Any option you specify on the command line remains in effect until it is
explicitly changed by specifying the option again with a different effect.
For example, to display two images, the first with 32 colors and the
second with only 16 colors, use:
.PP
     display -colors 32 cockatoo.miff -colors 16 macaw.miff
.PP
Change \fI-\fP to \fI\+\fP in any option above to reverse its effect.
For example, specify \fB\+display\fP to apply image transformations
without viewing them on the X server.  Or, specify \fB\+compress\fP to store
the binary image in an uncompressed format.
.PP
Specify \fIfile\fP as \fI-\fP for standard input or output.  If \fIfile\fP 
has the extension \fB.Z\fP, the file is decoded with \fBuncompress\fP.  
.SH BUTTONS
.TP 5
.B "Control-1"
Press and drag to pan the image.
.TP 5
.B "1"
Press and drag to select a command from a pop-up menu.  Choose from 
these commands:

    Image Info
    Write Image
    Print Image
    Annotate Image
    Reflect Image  
    Rotate Right  
    Rotate Left   
    Half Size     
    Double Size   
    Restore Image 
    Next Image    
    Quit          
.TP 5
.B "2"
Press and drag to define a region of the image to clip.  Release the button
to crop the image, or return the pointer to the location of the initial button 
press to cancel the cropping operation.
.TP 5
.B "3"
Press and drag to define a region of the image to magnify.
.SH KEYS
.TP 5
.B "i"
Press to display information about the image.  Press any key or button to 
erase the information.

This information is printed: image name;  image size; the visual class
(see \fB-visual\fP); and the total number of unique colors in the
image.
.TP 5
.B "w"
Press to write the image to a file.
.TP 5
.B "p"
Press to print the image to a file.
.TP 5
.B "a"
Press to annotate the image with text.

Refer to \fBIMAGE ANNOTATION\fP for more details.
.TP 5
.B "r"
Press to reflect the image scanlines.
.TP 5
.B "/"
Press to rotate the image 90 degrees clockwise.
.TP 5
.B "\e"
Press to rotate the image 90 degrees counter-clockwise.
.TP 5
.B "<"
Press to half the image size.
.TP 5
.B ">"
Press to double the image size.
.TP 5
.B "o"
Press to restore the image to its original size.
.TP 5
.B "n"
Press to display the next image.
.TP 5
.B "q"
Press to discard all images and exit program.
.TP 5
.B "1-9"
Press to change the level of magnification.
.SH "X RESOURCES"
\fIDisplay\fP options can appear on the command line or in your X
resource file.  Options on the command line supercede values specified
in your X resource file.  See \fBX(1)\fP for more information on X
resources.

All \fIdisplay\fP options have a corresponding X resource.  In addition,
the \fIdisplay\fP program uses the following X resources:
.TP 5
.B background (\fPclass\fB Background)
Specifies the preferred color to use for the image window background.  The
default is black.
.TP 5
.B borderColor (\fPclass\fB BorderColor)
Specifies the preferred color to use for the image window border.  The
default is white.
.TP 5
.B borderWidth (\fPclass\fB BorderWidth)
Specifies the width in pixels of the image window border.  The default is 2.
.TP 5
.B font (\fPclass\fB Font)
Specifies the name of the preferred font to use when displaying text 
within the image window.  The default is 9x15, fixed, or 5x8 determined by
the image window size.
.TP 5
.B font[1-9] (\fPclass\fB Font[1-9])
Specifies the name of the preferred font to use when annotating 
the image window with text.  The default fonts are fixed, variable,
5x8, 6x10, 7x13bold, 8x13bold, 9x15bold, 10x20, and 12x24. 
Refer to \fBIMAGE ANNOTATION\fP for more details.
.TP 5
.B foreground (\fPclass\fB Foreground)
Specifies the preferred color to use for text within the image window.  The
default is white.
.TP 5
.B iconGeometry (\fPclass\fB IconGeometry)
Specifies the preferred size and position of the application when
iconified.  It is not necessarily obeyed by all window managers.
.TP 5
.B iconic (\fPclass\fB Iconic)
This resource indicates that you would prefer that the application's
windows initially not be visible as if the windows had be immediately
iconified by you.  Window managers may choose not to honor the
application's request.
.TP 5
.B name (\fPclass\fB Name)
This resource specifies the name under which resources for the
application should be found.  This resource is useful in shell aliases to
distinguish between invocations of an application, without resorting to
creating links to alter the executable file name.  The default is the
application name.
.TP 5
.B pen[1-9] (\fPclass\fB Pen[1-9])
Specifies the color of the preferred font to use when annotating  
the image window with text.  The default colors are black, blue,
green, cyan, gray, red, magenta, yellow, and white.
Refer to \fBIMAGE ANNOTATION\fP for more details.
.TP 5
.B title (\fPclass\fB Title)
This resource specifies the title to be used for the image window.  This
information is sometimes used by a window manager to provide some sort
of header identifying the window.  The default is the image file name.
.SH IMAGE ANNOTATION
An image is annotated with text interactively.  There is no command
line argument to annotate an image.  To begin, press button 1 and
choose \fIAnnotate Image\fP from the command menu (see \fBBUTTONS\fP).
Alternatively, press \fIa\fP in the image window (see \fBKEYS\fP).
The cursor will change to a pencil to indicate you are in image 
annotation mode.  To exit immediately, press button 1 followed by \fIESC\fP.
.PP
In image annotation mode, a button press has a different effect than
described in \fBBUTTONS\fP.  Press a button to affect this behavior:
.TP 5
.B "1"
Press to select a location within the image window to begin entering text.
.TP 5
.B "2"
Press and drag to select a font from a pop-up menu.  Choose from 
these fonts:

    fixed 
    variable
    5x8
    6x10
    7x13bold
    8x13bold
    9x15bold
    10x20
    12x24

Other fonts can be specified by setting the X resources font1 through
font9.  Refer to \fBX RESOURCES\fP for more details.
.TP 5
.B "3"
Press and drag to select a font color from a pop-up menu.  Choose from 
these font colors:

    black
    blue
    cyan
    green
    gray
    red
    magenta
    yellow
    white

Other font colors can be specified by setting the X resources pen1
through pen9.  Refer to \fBX RESOURCES\fP for more details.
.PP
Choosing a font and its color is optional.  The default font is
\fIfixed\fP and the default color is \fIblack\fP.  However, you must
choose a location to begin entering text and press button 1.  An
underscore character will appear at the location of the cursor where
button 1 was pressed.  The underscore indicates you are in text
entering mode.  To exit immediately, press \fIESC\fP.
.PP
In text entering mode, any key presses will display the character at
the location of the underscore and advance the underscore cursor.
Enter your text and once completed press \fIESC\fP to finish your image
annotation.  To correct errors press \fIBACK SPACE\fP.  To delete an
entire line of text, press \fIDELETE\fP.  Any text that exceeds the
boundaries of the image window is automatically continued onto the next
line.
.PP
Before exiting image annotation mode, immediately after pressing the
\fIESC\fP key, the image is permanently updated with the text you
entered.  There is no way to `undo' your changes so be careful to
check your text before you press \fIESC\fP.
.PP
The actual color you request for the font is saved in the image.
However, the color that appears in your image window may be different.
For example, on a monochrome screen the text will appear black or white even 
if you choose the color red as the font color.  However, the image saved to
a file with \fB-write\fP will be written with red lettering.  To assure
the correct color text in the final image, any \fIPseudoClass\fP image
is promoted to \fIDirectClass\fP (see \fBMIFF FILE FORMAT\fP).  To
force a \fIPseudoClass\fP image to remain \fIPseudoClass\fP, use
\fB-colors\fP.
.SH "COLOR REDUCTION ALGORITHM"
.PP
This section describes how \fIDisplay\fP performs color reduction in an
image.  To fully understand this section, you should have a knowledge
of basic imaging techniques and the tree data structure and terminology.
.PP
For purposes of color allocation, an image is a set of \fIn\fP pixels,
where each pixel is a point in RGB space.  RGB space is a 3-dimensional
vector space, and each pixel, \fIp\d\s-3i\s0\u\fP,  is defined by an
ordered triple of red, green, and blue coordinates, (\fIr\d\s-3i\s0\u,
g\d\s-3i\s0\u, b\d\s-3i\s0\u\fP).
.PP
Each primary color component (red, green, or blue) represents an
intensity which varies linearly from 0 to a maximum value,
\fIc\d\s-3max\s0\u\fP, which corresponds to full saturation of that
color.  Color allocation is defined over a domain consisting of the
cube in RGB space with opposite vertices at (0,0,0) and
(\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  \fIDisplay\fP
requires \fIc\d\s-3max\s0\u = 255\fP.
.PP
The algorithm maps this domain onto a tree in which each node
represents a cube within that domain.  In the following discussion,
these cubes are defined by the coordinate of two opposite vertices: The
vertex nearest the origin in RGB space and the vertex farthest from the
origin.
.PP
The tree's root node represents the the entire domain, (0,0,0) through
(\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  Each lower level in
the tree is generated by subdividing one node's cube into eight smaller
cubes of equal size.  This corresponds to bisecting the parent cube
with planes passing through the midpoints of each edge.
.PP
The basic algorithm operates in three phases:  \fBClassification,
Reduction\fP, and \fBAssignment\fP.  \fBClassification\fP builds a
color description tree for the image.  \fBReduction\fP collapses the
tree until the number it represents, at most, is the number of colors
desired in the output image.  \fBAssignment\fP defines the output
image's color map and sets each pixel's color by reclassification in
the reduced tree.
.PP
\fBClassification\fP begins by initializing a color description tree of
sufficient depth to represent each possible input color in a leaf.
However, it is impractical to generate a fully-formed color description
tree in the classification phase for realistic values of
\fIc\d\s-3max\s0\u\fP.  If color components in the input image are
quantized to \fIk\fP-bit precision, so that \fIc\d\s-3max\s0\u =
2\u\s-3k\s0\d-1\fP, the tree would need \fIk\fP levels below the root
node to allow representing each possible input color in a leaf.  This
becomes prohibitive because the tree's total number of nodes is
.PP
        \fI\s+6\(*S\u\s-9 k\d\di=1\s0 8k\fP\s0\u
.PP
A complete tree would require 19,173,961 nodes for \fIk = 8,
c\d\s-3max\s0\u = 255\fP.  Therefore, to avoid building a fully
populated tree, \fIDisplay\fP: (1) Initializes data structures for
nodes only as they are needed; (2) Chooses a maximum depth for the tree
as a function of the desired number of colors in the output image
(currently \fIlog\d\s-34\s0\u(colormap size)\+2\fP).  A tree of this
depth generally allows the best representation of the source image with
the fastest computational speed and the least amount of memory.
However, the default depth is inappropriate for some images.
Therefore, the caller can request a specific tree depth.
.PP
For each pixel in the input image, classification scans downward from
the root of the color description tree.  At each level of the tree, it
identifies the single node which represents a cube in RGB space
containing the pixel's color.  It updates the following data for each
such node:
.TP 5
.B n\d\s-31\s0\u:  
Number of pixels whose color is contained in the RGB cube which this
node represents;
.TP 5
.B n\d\s-32\s0\u:  
Number of pixels whose color is not represented in a node at lower
depth in the tree;  initially,  \fIn\d\s-32\s0\u = 0\fP for all nodes
except leaves of the tree.
.TP 5
.B S\d\s-3r\s0\u, S\d\s-3g\s0\u, S\d\s-3b\s0\u:
Sums of the red, green, and blue component values for all pixels not
classified at a lower depth.  The combination of these sums and
\fIn\d\s-32\s0\u\fP will ultimately characterize the mean color of a
set of pixels represented by this node.
.PP
\fBReduction\fP repeatedly prunes the tree until the number of nodes with
\fIn\d\s-32\s0\u  > 0\fP is less than or equal to the maximum number of colors
allowed in the output image.  On any given iteration over the tree, it
selects those nodes whose \fIn\d\s-31\s0\u\fP count is minimal for pruning and
merges their color statistics upward.  It uses a pruning threshold,
\fIn\d\s-3p\s0\u\fP, to govern node selection as follows:
.PP
  n\d\s-3p\s0\u = 0
  while number of nodes with (n\d\s-32\s0\u > 0) > required maximum number of colors
      prune all nodes such that n\d\s-31\s0\u <= n\d\s-3p\s0\u
      Set n\d\s-3p\s0\u  to minimum n\d\s-31\s0\u  in remaining nodes
.PP
When a node to be pruned has offspring, the pruning procedure invokes
itself recursively in order to prune the tree from the leaves upward.
The values of \fIn\d\s-32\s0\u  S\d\s-3r\s0\u, S\d\s-3g\s0\u,\fP  and
\fIS\d\s-3b\s0\u\fP in a node being pruned are always added to the
corresponding data in that node's parent.  This retains the pruned
node's color characteristics for later averaging.
.PP
For each node,  \fIn\d\s-32\s0\u\fP pixels exist for which that node
represents the smallest volume in RGB space containing those pixel's
colors.  When \fIn\d\s-32\s0\u  > 0\fP the node will uniquely define a
color in the output image.  At the beginning of reduction,
\fIn\d\s-32\s0\u = 0\fP  for all nodes except the leaves of the tree
which represent colors present in the input image.
.PP
The other pixel count, \fIn\d\s-31\s0\u\fP,  indicates the total
number of colors within the cubic volume which the node represents.
This includes \fIn\d\s-31\s0\u - n\d\s-32\s0\u\fP pixels whose colors
should be defined by nodes at a lower level in the tree.
.PP
\fBAssignment\fP generates the output image from the pruned tree.  The
output image consists of two parts:  (1)  A color map, which is an
array of color descriptions (RGB triples) for each color present in the
output image; (2)  A pixel array, which represents each pixel as an
index into the color map array.
.PP
First, the assignment phase makes one pass over the pruned color
description tree to establish the image's color map.  For each node
with \fIn\d\s-32\s0\u > 0\fP, it divides \fIS\d\s-3r\s0\u,
S\d\s-3g\s0\u\fP, and \fPS\d\s-3b\s0\u\fP by \fIn\d\s-32\s0\u\fP.  This
produces the mean color of all pixels that classify no lower than this
node.  Each of these colors becomes an entry in the color map.
.PP
Finally, the assignment phase reclassifies each pixel in the pruned
tree to identify the deepest node containing the pixel's color.  The
pixel's value in the pixel array becomes the index of this node's mean
color in the color map.
.SH "MEASURING COLOR REDUCTION ERROR"
.PP
Depending on the image, the color reduction error may be obvious or
invisible.  Images with high spatial frequencies (such as hair or
grass) will show error much less than pictures with large smoothly
shaded areas (such as faces).  This is because the high-frequency
contour edges introduced by the color reduction process are masked by
the high frequencies in the image.
.PP
To measure the difference between the original and color reduced images
(the total color reduction error), \fIDisplay\fP sums over all pixels
in an image the distance squared in RGB space between each original
pixel value and its color reduced value. \fIDisplay\fP prints several error 
measurements including the mean error per pixel, the normalized mean error,
and the normalized maximum error.
.PP
The normalized error measurement can be used to compare images.  In
general, the closer the mean error is to zero the more the quantized
image resembles the source image.  Ideally, the error should be
perceptually-based, since the human eye is the final judge of
quantization quality.
.PP
These errors are measured and printed when \fB-verbose\fP and \fB-colors\fI 
are specified on the command line:
.TP 5
.B mean error per pixel:  
is the mean error for any single pixel in the image.
.TP 5
.B normalized mean square error:  
is the normalized mean square quantization error for any single pixel in the
image.  

This distance measure is normalized to a range between 0 and 1.  It is
independent of the range of red, green, and blue values in the image.
.TP 5
.B normalized maximum square error:  
is the largest normalized square quantization error for any single
pixel in the image.

This distance measure is normalized to a range between 0 and 1.  It is
independent of the range of red, green, and blue values in the image.
.SH "MIFF FILE FORMAT"
.PP
The Machine Independent File Format is described in this section.
.PP
A MIFF image file consist of two sections.  The first section is
composed of keywords describing the image in text form.  The next
section is the binary image data.  The two sections are separated by a
\fB:\fP character immediately followed by a \fInewline\fP.  Generally,
the first section has a \fIform-feed\fP and \fInewline\fP proceeding
the \fB:\fP character.   You can then list the image keywords with
\fImore\fP, without printing the binary image that follows the \fB:\fP
separator.
.PP
Each keyword must be separated by at least one space but can be
separated with control characters such a \fIform-feed\fP or
\fInewline\fP.
.PP
A list of valid keywords follows:
.TP 5
.B "class=\fIDirectClass | PseudoClass\fP"
identifies the type of binary image stored within the file.  

This keyword is optional.  If it is not specified, a \fIDirectClass\fP
image format is assumed.  An explanation of \fIDirectClass\fP and
\fIPseudoClass\fP image data follows this list.
.TP 5
.B "colors=\fIvalue\fP"
specifies the number of colors in the image, and for pseudo-color
images the size of the colormap.  

This keyword is optional.  However, if a colormap size is not
specified, a linear colormap is assumed for pseudo-color images.
.TP 5
.B "columns=\fIvalue\fP"
is a required keyword and specifies the number of columns, or width in
pixels, of the image.
.TP 5
.B "compression=\fIQEncoded | RunlengthEncoded\fP"
identifies how the image stored within the file is compressed.

This keyword is optional.  If it is not specified, the image is assumed
to be uncompressed.  A detailed explanation of runlength-encoded and
predictive arithmetic image compression follows this list.
.TP 5
.B "id=\fIImageMagick\fP"
is a required keyword and identifies this file as a MIFF image.  
.TP 5
.B "packets=\fIvalue\fP"
specifies the number of compressed color packets in the image data section.  

This keyword is optional, but recommended, for runlength-encoded image
compression.  It is required for arithimetic encoded image compression.  A
detailed explanation of image compression follows this list.
.TP 5
.B "rows=\fIvalue\fP"
is a required keyword and specifies the number of rows, or height in pixels, 
of the image.
.TP 5
.B "scene=\fIvalue\fP"
is an optional keyword and is a reference number for sequencing of
images.  

This keyword is typically useful for animating a sequence of images.
.PP
Comments can be included in the keyword section.  Comments must begin with
a \fB{\fP character and end with a \fI}\fP character.  
.PP
An example keyword section follows:
.PP
    {
      Rendered via Dore by Sandy Hause.
    }
    id=ImageMagick
    class=PseudoClass  colors=256
    compression=RunlengthEncoded  packets=27601
    columns=1280  rows=1024
    scene=1
    ^L
    :
.PP
The binary image data that follows the keyword text is stored in one of 
two binary classes as specified by the \fBclass\fP keyword: 
\fIDirectClass\fP or \fIPseudoClass\fP.
.PP
Use the \fIDirectClass\fP class to store continuous-tone images.
\fIDirectClass\fP requires that the image pixels immediately follow the
keyword text and be stored as binary red, green, and blue intensity
values.  The total number of pixels expected is equal to the number of pixel 
columns times the number of pixel rows as specified by the \fBcolumns\fP and 
\fBrows\fP keywords.
.PP
If the \fBcompression\fP keyword is not specified, a red, green, and blue byte 
in that order is expected for each pixel of the image.
.PP
If \fBcompression\fP is \fIQEncoded\fP, each red, green, and blue byte
intensity value is encoded using the predictive arithmetic compression
algorithm.  Use the \fBpackets\fP keyword to specify the total number
of arithimetic encoded packets that comprise the image.  Refer to
"JPEG-9-R6 Working Draft for Development of JPEG CD", January 1991, for
implementation specific details.
.PP
If \fBcompression\fP is \fIRunlengthEncoded\fP, each red, green, and
blue byte intensity value is followed by a count byte. This value
specifies the number of horizonally contiguous pixels in the image of
that color.  The count (0-255) is one less than the actual number of
contiguous pixels; thus a single packet can represent from 1 up to 256
identical pixels.  The total number of pixels specified by the
individual count bytes must add up to the number of pixel columns times
the number of pixel rows as specified by the \fBcolumns\fP and
\fBrows\fP keywords.  Use \fBpackets\fP to specify the total number of
runlength-encoded packets that comprise the image.
.PP
Use the \fIPseudoClass\fP class to store pseudo-color images.
\fIPseudoClass\fP requires that the image colormap and
pseudo-color pixels immediately follow the keyword text.  The colormap
is stored as contiguous red, green, and blue intensity values.  The
number of intensity values expected is determined by the \fBcolors\fP
keyword.  Note, an image colormap is restricted to at most 65535
entries.  The binary pseudo-color image is stored as indexes into the
colormap.  If the colormap size exceeds 256 entries, then each colormap
index is two bytes each with the most-significant-byte first.  The
total number of pixels expected is equal to the number of pixel columns
times the number of pixel rows as specified by the \fBcolumns\fP and
\fBrows\fP keywords.
.PP
If the \fBcompression\fP keyword is not specified, a colormap index is 
expected for each pixel of the image.
.PP
If \fBcompression\fP is \fIQEncoded\fP, each colormap index is encoded
using the predictive arithmetic compression algorithm.  Use the
\fBpackets\fP keyword to specify the total number of arithimetic
encoded packets comprise the image.  Refer to "JPEG-9-R6 Working Draft
for Development of JPEG CD", January 1991, for implementation specific
details.
.PP
If \fBcompression\fP is \fIRunlengthEncoded\fP, each colormap index
is followed by a count byte. This value  specifies the number of
horizonally contiguous pixels in the image of that color.  The count
(0-255) is one less than the actual number of contiguous pixels; thus a
single packet can represent from 1 up to 256 identical pixels.  The
total number of pixels specified by the individual count bytes must add
up to the number of pixels expected in the image as specified by the
\fBcolumns\fP and \fBrows\fP keywords.  Use \fBpackets\fP to specify the 
total number of runlength-encoded packets that comprise the image.
.SH FEATURES
Although \fIDisplay\fP will display an image on a server with an immutable
colormap, the image quality may suffer as compared to a server with a 
read/write colormap.
.PP
\fIDisplay\fP memory requirements is proportionate to the area of the image.
.PP
\fIDisplay\fP does not complain when it encounters a keyword in an image file
it does not understand.
.SH ENVIRONMENT
.TP 5
.B DISPLAY
To get the default host, display number, and screen.
.SH SEE ALSO
X(1), xcmap(1), import(1), XtoPS(1), more(1), compress(1)
.SH COPYRIGHT
Copyright 1991 E. I. du Pont de Nemours & Company                           
.PP                                                                           
Permission to use, copy, modify, distribute, and sell this software and    
its documentation for any purpose is hereby granted without fee,           
provided that the above copyright notice appear in all copies and that     
both that copyright notice and this permission notice appear in            
supporting documentation, and that the name of E. I. du Pont de Nemours     
& Company not be used in advertising or publicity pertaining to            
distribution of the software without specific, written prior               
permission.  E. I. du Pont de Nemours & Company makes no representations    
about the suitability of this software for any purpose.  It is provided    
"as is" without express or implied warranty.                               
.PP
E. I. du Pont de Nemours & Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours & Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising
out of or in connection with the use or performance of this software.      
.SH ACKNOWLEDGEMENTS
The MIT X Consortium for making network transparent graphics a reality.
.PP
Michael Halle, Spatial Imaging Group at MIT, for the initial
implementation of Alan Paeth's image rotation algorithm.
.PP
David Pensak, E. I. du Pont de Nemours & Company, for providing a
computing environment that made this program possible.
.PP
Paul Raveling, USC Information Sciences Institute, for the original
idea of using space subdivision for the color reduction algorithm.
With Paul's permission, the \fBCOLOR REDUCTION ALGORITHM\fP section is
a adaptation from a document he wrote.
.SH AUTHORS
John Cristy, E.I. du Pont de Nemours & Company Incorporated
