.TH XDU 1 X11
.SH NAME
xdu \- display the output of "du" in an X window
.SH SYNOPSIS
.B du \|| xdu
.SH DESCRIPTION
.I Xdu
is a program for displaying a graphical tree of disk space
utilization as reported by the UNIX utility "du".  The window
is divided up into several columns, each of which is one level
deeper in the directory hierarchy (from left to right).  Boxes
are drawn for each directory.  The amount of vertical space
occupied by each box is directly proportional to the amount of
disk space consumed by it and all of its children.  The name of
each directory will be displayed provided that there is enough
space within its box.
.PP
The user can move up or down the tree by clicking the left mouse on
a directory box.  If the left most box is selected, the display will
move up one level (assuming you are not already at the root).  If any
other box is selected, it will be placed on the left of the window
and the display will be rescaled appropriately.  At any time the middle
mouse, or typing "r" within the window, will bring you back to the root.
Clicking the right mouse, or typing "q", will exit the program.
.PP
The following resources are supported (with their default values
shown):
.PP
.nf
xdu.foreground:Black
xdu.background:White
xdu*window.width:600
xdu*window.height:480
xdu.ncol:5
xdu.font:Fixed
xdu.showsize:True
.fi
.SH EXAMPLE
.I
cd /usr/src
.br
.I
du > /tmp/du.out
.br
.I
xdu < /tmp/du.out
.SH "SEE ALSO"
du(1)
.SH AUTHORS
Phillip C. Dykstra
.br
<phil@BRL.MIL>
