.TH XBOARD 1 "June 11, 1991" "X Version 11"
.SH NAME
xboard \- Xt/Athena user interface for GNU Chess, version 1.2
.SH SYNOPSIS
.B xboard
[
.IR "\-wpc or -whitePieceColor color"
]
[
.IR "\-bpc or -blackPieceColor color"
]
[
.IR "\-lsc or -lightSquareColor color"
]
[
.IR "\-dsc or -darkSquareColor color"
]
[
.IR "\-mps or -movesPerSession moves"
]
[
.IR "\-fcp or -firstChessProgram program_name"
]
[
.IR "\-scp or -secondChessProgram program_name"
]
[
.IR "\-fh or -firstHost host_name"
]
[
.IR "\-sh or -secondHost host_name"
]
[
.IR "\-spb or -solidPawnBitmap file_name"
]
[
.IR "\-srb or -solidRookBitmap file_name"
]
[
.IR "\-sbb or -solidBishopBitmap file_name"
]
[
.IR "\-skb or -solidKnightBitmap file_name"
]
[
.IR "\-sqb or -solidQueenBitmap file_name"
]
[
.IR "\-skb or -solidKingBitmap file_name"
]
[
.IR "\-opb or -outlinePawnBitmap file_name"
]
[
.IR "\-orb or -outlineRookBitmap file_name"
]
[
.IR "\-obb or -outlineBishopBitmap file_name"
]
[
.IR "\-okb or -outlineKnightBitmap file_name"
]
[
.IR "\-oqb or -outlineQueenBitmap file_name"
]
[
.IR "\-okb or -outlineKingBitmap file_name"
]
[
.IR "\-rsh or -remoteShell shell_name"
]
[
.IR "\-td or -timeDelay seconds"
]
[
.IR "\-tc or -timeControl minutes"
]
[
.IR "\-rgf or -readGameFile file_name"
]
[
.IR "\-rpf or -readPositionFile file_name"
]
.IR "\-sgf or -saveGameFile file_name"
]
[
.IR "\-spf or -savePositionFile file_name"
]
[
.IR "\-mm or -matchMode (False | Init | Position | Opening)"
]
[
.IR "\-mono or -monoMode (True | False)"
]
[
.IR "\-debug or -debugMode (True | False)"
]
[
.IR "\-clock or -clockMode (True | False)"
]
[
.IR "\-big or -bigSizeMode (True | False)"
]
[
.IR "\-st or -searchTime seconds"
]
.SH DESCRIPTION
.IR xboard
provides an X11/Xt/Athena Widgets user interface for GNU Chess.
With
.IR xboard
you can play GNU Chess,
setup arbitrary positions,
force variations or watch
.IR xboard
manage a game between two chess programs.
.LP
.IR xboard
can also be used as a chessboard to play out games.
It will read through a game file or allow a player to play (force mode)
through a variation manually.
All of the keystroke commands (Backward, Forward, Reset, etc.) work.
A chess program doesn't even need to be present in the program search path
in this case.
This is useful for keeping track of email postal games or browsing games
off the net.
.LP
After starting
.IR xboard
you can make moves by pressing a mouse button
while the cursor is over a square with your piece on it
and dragging the mouse to another square.
If the move is illegal,
.IR gnuchess
will not allow it.
.IR xboard
will then retract the move.
.LP
Alternate bitmaps for piece icons can be specified
either by choosing one of two built-in sets or with
the file name resources described below.
There are two sets of piece bitmaps available:
a large set (the default) and a small set.
It is easiest to select the small set in the .Xdefaults file:
.sp 1
.br
XBoard*bigSizeMode:	false
.LP
The font used for button labels and comments can be changed in the
.Xdefaults file:
.sp 1
.br
XBoard*font:	helvetica_oblique14
.LP
If you are using a grayscale monitor, try setting the colors to:
.sp 1
.br
XBoard*whitePieceColor:     gray100
.br
XBoard*blackPieceColor:     gray0
.br
XBoard*lightSquareColor:    gray60
.br
XBoard*darkSquareColor:     gray40
.SH OPTIONS
The following command line options also correspond to X resources
that you can set in your
.IR \&.Xdefaults
file.
.TP 8
.B standard Xt options
.IR xboard
accepts standard Xt options like
.IR "\-display"
and
.IR "\-geometry" .
.TP 8
.B -wpc or -whitePieceColor color
Color specification for white pieces
suitable for
.IR XParseColor (3X11).
Default: #FFFFCC.
These colors look good on a DEC workstation.
If you need different colors, try using the
.IR xcolors
application.  Source for
.IR xcolors
can be found in the X11/R4 contrib directory.
.TP 8
.B -bpc or -blackPieceColor color
Same for black pieces.
Default: #202020.
.TP 8
.B -lsc or -lightSquareColor color
Same for light squares.
Default: #C8C365.
.TP 8
.B -dsc or -darkSquareColor color
Same for dark squares.
Default: #77A26D.
.TP 8
.B -td or -timeDelay seconds
Time delay between moves during "Play From File".
This doesn't have to be round numbers.
Try -td 0.4.  Default: 1 second.
.TP 8
.B -clock or -clockMode (True | False)
Determines whether or not to use the clock.
Some people aren't interested in having the chess clock be updated.
This allows it to be turned off.  The side that is on move is still
highlighted.
.TP 8
.B -big or -bigSizeMode (True | False)
Determines which set of bitmaps to use, a built-in 80x80 pixel set
or a built-in 64-64 set.
.TP 8
.B -st or -searchTime seconds
Call GNU Chess with only one argument.
Determines the program search time in seconds.
.TP 8
.B -tc or -timeControl minutes
Amount of time for a set of moves determined by
.IR movesPerSession .
If this number of moves is played within the time control period,
.IR xboard
resets the time clocks.
Default: 5 minutes.
.TP 8
.B -mps or -movesPerSession moves
Number of moves in a playing session.
Default: 40 moves.
.TP 8
.B -rgf or -readGameFile file
Name of file to read a game record from.
If the first line does not appear to start with a move,
that is if the first character of the file is not `1',
then the first line is assumed to be a title and is displayed.
Comments either start with [ and end with a matching ]
or they start with a ! and end with the next newline.
Game files are found in the directory named by the CHESSDIR environment
variable.  If this variable is not declared then the current directory is used
unless the file name starts with a /.
.TP 8
.B -rpf or -readPositionFile file
Name of file to read a game position from.
Position files are found in the directory named by the CHESSDIR environment
variable.  If this variable is not declared then the current directory is used
unless the file name starts with a /.
.TP 8
.B -sgf or -saveGameFile file
Name of file to save a game record to.
No default.
.TP 8
.B -spf or -savePositionFile file
Name of file to save a game position to.
No default.
.TP 8
.B -rsh or -remoteShell shell_name
Some systems do not use rsh as the remote shell.
This option allows a user to name the remote shell command.
This should be done in the resource file.
.TP 8
.B -fcp or -firstChessProgram program
Name of first chess program that,
by default,
plays black.
Default: "gnuchessr".
.TP 8
.B -scp or -secondChessProgram program
Name of second chess program that,
by default,
plays white.
Default: "gnuchessr".
.TP 8
.B -fh or -firstHost host
Name of host the white chess program plays on.
Default: "localhost".
.TP 8
.B -sh or -secondHost host
Name of host the black chess program plays on.
Default: "localhost".
.TP 8
.B -s*b or -solid*Bitmap file
Names of the bitmap files for the bitmap piece icons.
Default: solid_pawn.bitmap, solid_rook.bitmap ...
.TP 8
.B -o*b or -outline*Bitmap file
Names of the bitmap files for the outline piece icons.
Default: outline_pawn.bitmap, outline_rook.bitmap ...
.TP 8
.B -mm or -matchMode "(False | Init | Position | Opening)"
Automatically run a game between
.IR firstChessProgram
and
.IR secondChessProgram .
If
.IR matchMode
is set to
.IR Init ,
.IR xboard
will start the game with the initial chess position.
If
.IR matchMode
is set to
.IR Position ,
.IR xboard
will start the game with the position specified by the
.IR readPositionFile
resource.
If
.IR matchMode
is set to
.IR Opening ,
.IR xboard
will play out the opening moves specified by the
.IR -readGameFile
resource.
Default: "False".
.TP 8
.B -mono or -monoMode (False | True)
Determines whether
.IR xboard
displays its pieces and squares with two colors or four.
You shouldn't have to specify monochrome.
.IR xboard
will determine if this is necessary.
.SH RESOURCES
.TP 8
.B initString
The actual string that is sent to initialize the chess program can be
set from .Xdefaults.  It can't be set from the command line because of
syntax problems.
.TP 8
.B whiteString and blackString
These resources control what is sent when the Machine White and Machine Black
buttons are selected.  This is mostly for compatibility with previous versions
of gnuchess.
.TP 8
.B XBoard*font
This is the font that is used by
.IR xboard .
.SH COMMAND BUTTONS AND KEYS
.TP 8
.B Quit
Quits
.IR xboard .
Q or q is a keyboard equivalent.
.TP 8
.B Reset
Resets
.IR xboard
to the beginning of a chess game.
It also deselects any game or position files.
.TP 8
.B Flip View
inverts the view of the chess board.
.TP 8
.B Hint
displays a move hint from GNU Chess.
.TP 8
.B Play From File
plays a game from a record file.
If no file is specified a popup dialog asks for a filename.
Game files are found in the directory named by the CHESSDIR environment
variable.  If this variable is not declared then the current directory is used
unless the file name starts with a /.
G or g is a keyboard equivalent.
.TP 8
.B Setup From File
sets up a position from a position file.
If no file is specified a popup dialog asks for a filename.
Position files are found in the directory named by the CHESSDIR environment
variable.  If this variable is not declared then the current directory is used
unless the file name starts with a /.
.TP 8
.B Save Game
saves a game to a record file.
If no file is specified a popup dialog asks for a filename.
.TP 8
.B Save Position
saves a position to a position file.
If no file is specified a popup dialog asks for a filename.
.TP 8
.B Machine Black
forces GNU Chess to play black.
.TP 8
.B Machine White
forces GNU Chess to play white.
.TP 8
.B Switch Sides
forces GNU Chess to switch sides.
.TP 8
.B Two Machines
plays a game between two computer programs.
.TP 8
.B Forward
moves forward through a series of remembered moves.
F or f is a keyboard equivalent.
.TP 8
.B Backward
moves backward through a series of remembered moves.
B or b is a keyboard equivalent.
.TP 8
.B Force Moves
forces a series of moves.
.TP 8
.B Pause
pauses the game clocks or game replay.
P or p is a keyboard equivalent.
.TP 8
.B Iconify
I, i, C or c iconifies
.IR xboard .
.SH SEE ALSO
.IR xchess (1),
.IR gnuchess (1)
.SH LIMITATIONS
.LP
Doesn't handle black to play positions.
.LP
White must be on move for two program mode to work.
.LP
Only recognizes algebraic notation.
.LP
If you press the Pause button during GNU Chess's turn
.IR xboard .
will stop the clocks,
but GNU Chess will still make a move.
.LP
If you play out an opening set of moves with
.IR "Play From File" ,
you must make a move and then select
.IR "Machine Black" .
.LP
-iconic doesn't work properly.
.SH COPYRIGHT
.LP
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
.LP
All Rights Reserved
.LP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.LP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
