/*
 * Copyright 1991 Sony Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Sony not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Sony makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SONY
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Noriyuki Hosoe, Sony Corporation
 */

#include <stdio.h>
#include "sj3err.h"

sj3error(fp, code)
FILE	*fp;
int	code;
{
	unsigned char	tmp[BUFSIZ];

	switch (code) {
#define	CASE(X, str)		case (X): printout(fp, str); break;
	CASE(SJ3_InternalError,		"C^[iG[");
	CASE(SJ3_NormalEnd,		"I");
	CASE(SJ3_ServerDown,		"T[o[Ă܂");
	CASE(SJ3_OpenSocket,		"socket  open Ɏs܂");
	CASE(SJ3_ConnectSocket,		"socket  connect Ɏs܂");
	CASE(SJ3_GetHostByName,		"gethostbyname Ɏs܂");
	CASE(SJ3_NotOpened,		"I[vĂ܂");
	CASE(SJ3_NotEnoughMemory,	"܂");
	CASE(SJ3_IllegalCommand,	"R}h`Ă܂");
	CASE(SJ3_DifferentVersion,	"o[WႢ܂");
	CASE(SJ3_NoHostName,		"zXg܂");
	CASE(SJ3_NoUserName,		"[U܂");
	CASE(SJ3_NotAllowedUser,	"ڑĂ܂");
	CASE(SJ3_AlreadyConnected,	"ڑςł");
	CASE(SJ3_NotConnected,		"ڑĂ܂");
	CASE(SJ3_TooLongParameter,	"p[^܂");
	CASE(SJ3_IllegalParameter,	"p[^ُł");
	CASE(SJ3_BadDictID,		"̂悤Ȏ͂܂");
	CASE(SJ3_IllegalDictFile,	"t@Cُł");
	CASE(SJ3_IllegalStdyFile,	"wKt@Cُł");
	CASE(SJ3_IncorrectPasswd,	"pX[hقȂ܂");
	CASE(SJ3_FileNotExist,		"t@C݂܂");
	CASE(SJ3_CannotAccessFile,	"t@CɃANZXł܂");
	CASE(SJ3_CannotOpenFile,	"t@CI[vł܂");
	CASE(SJ3_CannotCreateFile,	"t@C쐬ł܂");
	CASE(SJ3_FileReadError,		"[hG[܂");
	CASE(SJ3_FileWriteError,	"CgG[܂");
	CASE(SJ3_FileSeekError,		"V[NG[܂");
	CASE(SJ3_StdyAlreadyOpened,	"wKt@C̓I[vĂ܂");
	CASE(SJ3_StdyFileNotOpened,	"wKt@CI[vĂ܂");
	CASE(SJ3_TooSmallStdyArea,	"ߒwK̈悪܂");
	CASE(SJ3_LockedByOther,		"̃NCAgɃbNĂ܂");
	CASE(SJ3_NotLocked,		"bNĂ܂");
	CASE(SJ3_NoSuchDict,		"̂悤Ȏ͂܂");
	CASE(SJ3_ReadOnlyDict,		"݂łȂł");
	CASE(SJ3_DictLocked,		"bNĂ܂");
	CASE(SJ3_BadYomiString,		"Ȃǂݕł");
	CASE(SJ3_BadKanjiString,	"Ȃł");
	CASE(SJ3_BadHinsiCode,		"iR[hُł");
	CASE(SJ3_AddDictFailed,		"o^s܂");
	CASE(SJ3_AlreadyExistWord,	"łɑ݂Ă܂");
	CASE(SJ3_NoMoreDouonWord,	"ȏ㓯o^ł܂");
	CASE(SJ3_NoMoreUserDict,	"ȏ㎫ɓo^ł܂");
	CASE(SJ3_NoMoreIndexBlock,	"ȏCfbNXɓo^ł܂");
	CASE(SJ3_DelDictFailed,		"폜s܂");
	CASE(SJ3_NoSuchWord,		"̂悤ȏn͂܂");
	CASE(SJ3_DirAlreadyExist,	"̃fBNg݂Ă܂");
	CASE(SJ3_CannotCreateDir,	"fBNg쐬ł܂");
	CASE(SJ3_NoMoreDictData,	"ȏ㎫f[^܂");
	CASE(SJ3_UserConnected,		"ڑĂ郆[U܂");
	CASE(SJ3_TooLongPasswd,		"pX[h܂");
	CASE(SJ3_TooLongComment,	"Rg܂");
#undef	CASE
	default:
		sprintf(tmp, "`̃G[(%d)", code);
		printout(fp, tmp);
		break;
	}
	printout(fp, "\r\n");
}

