/*
 * Copyright 1991 Sony Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Sony not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Sony makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SONY
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Masaki Takeuchi, Sony Corporation
 */
/*
 *	sj_rtbl.c
 *	romaji tuduri table.
 *	Copyright (c) 1987 1988 1989 Sony Corporation.
 *	Written by Masaki Takeuchi
 *	Tue Jun 23 13:31:11 JST 1987
 *
 *	This file is included Shift-JIS code.
 *
 *	Caution: This tabel must be sorted by tuduri.
 */
/*
 * $Header: sj_rtbl.c,v 1.1 91/04/29 17:56:50 masaki Exp $ SONY;
 */

struct romaji {
	char	*tuduri;
	char	*kana;
};

char	*str_tu = "\203\142";
char	*str_nn = "\203\223";

struct romaji Rtable[] = {
	{"a",	"\203\101"},
	{"ba",	"\203\157"},
	{"be",	"\203\170"},
	{"bi",	"\203\162"},
	{"bo",	"\203\173"},
	{"bu",	"\203\165"},
	{"bya",	"\203\162\203\203"},
	{"bye",	"\203\162\203\106"},
	{"byi",	"\203\162"},
	{"byo",	"\203\162\203\207"},
	{"byu",	"\203\162\203\205"},
	{"ca",	"\203\112"},
	{"ce",	"\203\120"},
	{"cha",	"\203\140\203\203"},
	{"che",	"\203\140\203\106"},
	{"chi",	"\203\140"},
	{"cho",	"\203\140\203\207"},
	{"chu",	"\203\140\203\205"},
	{"ci",	"\203\114"},
	{"co",	"\203\122"},
	{"cu",	"\203\116"},
	{"cya",	"\203\140\203\203"},
	{"cye",	"\203\140\203\106"},
	{"cyi",	"\203\140"},
	{"cyo",	"\203\140\203\207"},
	{"cyu",	"\203\140\203\205"},
	{"da",	"\203\137"},
	{"de",	"\203\146"},
	{"dha",	"\203\137\203\100"},
	{"dhi",	"\203\146\203\102"},
	{"dhu",	"\203\150\203\104"},
	{"dhyu",	"\203\146\203\205"},
	{"di",	"\203\141"},
	{"do",	"\203\150"},
	{"du",	"\203\144"},
	{"dya",	"\203\141\203\203"},
	{"dye",	"\203\141\203\106"},
	{"dyi",	"\203\141"},
	{"dyo",	"\203\141\203\207"},
	{"dyu",	"\203\141\203\205"},
	{"e",	"\203\107"},
	{"fa",	"\203\164\203\100"},
	{"fe",	"\203\164\203\106"},
	{"fi",	"\203\164\203\102"},
	{"fo",	"\203\164\203\110"},
	{"fu",	"\203\164"},
	{"fya",	"\203\164\203\203"},
	{"fye",	"\203\164\203\106"},
	{"fyi",	"\203\164\203\102"},
	{"fyo",	"\203\164\203\207"},
	{"fyu",	"\203\164\203\205"},
	{"ga",	"\203\113"},
	{"ge",	"\203\121"},
	{"gi",	"\203\115"},
	{"go",	"\203\123"},
	{"gu",	"\203\117"},
	{"gya",	"\203\115\203\203"},
	{"gye",	"\203\115\203\106"},
	{"gyi",	"\203\115"},
	{"gyo",	"\203\115\203\207"},
	{"gyu",	"\203\115\203\205"},
	{"ha",	"\203\156"},
	{"he",	"\203\167"},
	{"hi",	"\203\161"},
	{"ho",	"\203\172"},
	{"hu",	"\203\164"},
	{"hya",	"\203\161\203\203"},
	{"hye",	"\203\161\203\106"},
	{"hyi",	"\203\161"},
	{"hyo",	"\203\161\203\207"},
	{"hyu",	"\203\161\203\205"},
	{"i",	"\203\103"},
	{"ja",	"\203\127\203\203"},
	{"je",	"\203\127\203\106"},
	{"ji",	"\203\127"},
	{"jo",	"\203\127\203\207"},
	{"ju",	"\203\127\203\205"},
	{"jya",	"\203\127\203\203"},
	{"jye",	"\203\127\203\106"},
	{"jyi",	"\203\127"},
	{"jyo",	"\203\127\203\207"},
	{"jyu",	"\203\127\203\205"},
	{"ka",	"\203\112"},
	{"ke",	"\203\120"},
	{"ki",	"\203\114"},
	{"ko",	"\203\122"},
	{"ku",	"\203\116"},
	{"kya",	"\203\114\203\203"},
	{"kye",	"\203\114\203\106"},
	{"kyi",	"\203\114"},
	{"kyo",	"\203\114\203\207"},
	{"kyu",	"\203\114\203\205"},
	{"la",	"\203\211"},
	{"le",	"\203\214"},
	{"li",	"\203\212"},
	{"lo",	"\203\215"},
	{"lu",	"\203\213"},
	{"lya",	"\203\212\203\203"},
	{"lye",	"\203\212\203\106"},
	{"lyi",	"\203\212"},
	{"lyo",	"\203\212\203\207"},
	{"lyu",	"\203\212\203\205"},
	{"ma",	"\203\175"},
	{"me",	"\203\201"},
	{"mi",	"\203\176"},
	{"mo",	"\203\202"},
	{"mu",	"\203\200"},
	{"mya",	"\203\176\203\203"},
	{"mye",	"\203\176\203\106"},
	{"myi",	"\203\176"},
	{"myo",	"\203\176\203\207"},
	{"myu",	"\203\176\203\205"},
	{"na",	"\203\151"},
	{"ne",	"\203\154"},
	{"ni",	"\203\152"},
	{"nn",	"\203\223"},
	{"no",	"\203\155"},
	{"nu",	"\203\153"},
	{"nya",	"\203\152\203\203"},
	{"nye",	"\203\152\203\106"},
	{"nyi",	"\203\152"},
	{"nyo",	"\203\152\203\207"},
	{"nyu",	"\203\152\203\205"},
	{"o",	"\203\111"},
	{"pa",	"\203\160"},
	{"pe",	"\203\171"},
	{"pi",	"\203\163"},
	{"po",	"\203\174"},
	{"pu",	"\203\166"},
	{"pya",	"\203\163\203\203"},
	{"pye",	"\203\163\203\106"},
	{"pyi",	"\203\163"},
	{"pyo",	"\203\163\203\207"},
	{"pyu",	"\203\163\203\205"},
	{"qa",	"\203\116\203\100"},
	{"qe",	"\203\116\203\106"},
	{"qi",	"\203\116\203\102"},
	{"qo",	"\203\116\203\110"},
	{"qu",	"\203\116\203\104"},
	{"qya",	"\203\114\203\203"},
	{"qye",	"\203\114\203\106"},
	{"qyi",	"\203\114"},
	{"qyo",	"\203\114\203\207"},
	{"qyu",	"\203\114\203\205"},
	{"ra",	"\203\211"},
	{"re",	"\203\214"},
	{"ri",	"\203\212"},
	{"ro",	"\203\215"},
	{"ru",	"\203\213"},
	{"rya",	"\203\212\203\203"},
	{"rye",	"\203\212\203\106"},
	{"ryi",	"\203\212"},
	{"ryo",	"\203\212\203\207"},
	{"ryu",	"\203\212\203\205"},
	{"sa",	"\203\124"},
	{"se",	"\203\132"},
	{"sha",	"\203\126\203\203"},
	{"she",	"\203\126\203\106"},
	{"shi",	"\203\126"},
	{"sho",	"\203\126\203\207"},
	{"shu",	"\203\126\203\205"},
	{"si",	"\203\126"},
	{"so",	"\203\134"},
	{"su",	"\203\130"},
	{"sya",	"\203\126\203\203"},
	{"sye",	"\203\126\203\106"},
	{"syi",	"\203\126"},
	{"syo",	"\203\126\203\207"},
	{"syu",	"\203\126\203\205"},
	{"ta",	"\203\136"},
	{"te",	"\203\145"},
	{"tha",	"\203\136\203\100"},
	{"thi",	"\203\145\203\102"},
	{"thu",	"\203\147\203\104"},
	{"ti",	"\203\140"},
	{"to",	"\203\147"},
	{"tsa",	"\203\136"},
	{"tse",	"\203\145"},
	{"tsi",	"\203\140"},
	{"tso",	"\203\147"},
	{"tsu",	"\203\143"},
	{"tsya",	"\203\140\203\203"},
	{"tsye",	"\203\140\203\106"},
	{"tsyi",	"\203\140"},
	{"tsyo",	"\203\140\203\207"},
	{"tsyu",	"\203\140\203\205"},
	{"tu",	"\203\143"},
	{"tya",	"\203\140\203\203"},
	{"tye",	"\203\140\203\106"},
	{"tyi",	"\203\140"},
	{"tyo",	"\203\140\203\207"},
	{"tyu",	"\203\140\203\205"},
	{"u",	"\203\105"},
	{"va",	"\203\224\203\100"},
	{"ve",	"\203\224\203\106"},
	{"vi",	"\203\224\203\102"},
	{"vo",	"\203\224\203\110"},
	{"vu",	"\203\224"},
	{"vya",	"\203\162\203\203"},
	{"vye",	"\203\162\203\106"},
	{"vyi",	"\203\162"},
	{"vyo",	"\203\162\203\207"},
	{"vyu",	"\203\162\203\205"},
	{"wa",	"\203\217"},
	{"we",	"\203\105\203\106"},
	{"wi",	"\203\105\203\102"},
	{"wo",	"\203\222"},
	{"wu",	"\203\105"},
	{"x,",	"\201\112"},
	{"x.",	"\201\113"},
	{"xa",	"\203\100"},
	{"xe",	"\203\106"},
	{"xi",	"\203\102"},
	{"xka",	"\203\225"},
	{"xke",	"\203\226"},
	{"xo",	"\203\110"},
	{"xtsu",	"\203\142"},
	{"xtu",	"\203\142"},
	{"xu",	"\203\104"},
	{"xwa",	"\203\216"},
	{"xya",	"\203\203"},
	{"xye",	"\203\106"},
	{"xyi",	"\203\102"},
	{"xyo",	"\203\207"},
	{"xyu",	"\203\205"},
	{"ya",	"\203\204"},
	{"ye",	"\203\103\203\106"},
	{"yi",	"\203\103"},
	{"yo",	"\203\210"},
	{"yu",	"\203\206"},
	{"za",	"\203\125"},
	{"ze",	"\203\133"},
	{"zi",	"\203\127"},
	{"zo",	"\203\135"},
	{"zu",	"\203\131"},
	{"zya",	"\203\127\203\203"},
	{"zye",	"\203\127\203\106"},
	{"zyi",	"\203\127"},
	{"zyo",	"\203\127\203\207"},
	{"zyu",	"\203\127\203\205"},
	{"",	""}
};

