/*
 * pswdict.c
 *
 * Copyright (C) 1988 by Adobe Systems Incorporated.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notices appear in all copies and that
 * both those copyright notices and this permission notice appear in
 * supporting documentation and that the name of Adobe Systems
 * Incorporated not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  If any portion of this software is changed, it cannot be
 * marketed under Adobe's trademarks and/or copyrights unless Adobe, in
 * its sole discretion, approves by a prior writing the quality of the
 * resulting implementation.
 * 
 * ADOBE MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE SOFTWARE FOR
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 * ADOBE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT OF THIRD PARTY RIGHTS.  IN NO EVENT SHALL ADOBE BE LIABLE
 * TO YOU OR ANY OTHER PARTY FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE, STRICT LIABILITY OR ANY OTHER ACTION ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  ADOBE WILL NOT
 * PROVIDE ANY TRAINING OR OTHER SUPPORT FOR THE SOFTWARE.
 * 
 * PostScript, Display PostScript, and Adobe are trademarks of Adobe Systems
 * Incorporated registered in the U.S.A. and other countries.
 *
 * Author: Adobe Systems Incorporated
 */

/***********/
/* Imports */
/***********/

#include "pswtypes.h"
#include "pswdict.h"

#ifdef XENVIRONMENT
#include <X11/Xos.h>
#else
#include <string.h>
#endif

extern char *psw_calloc();
extern char *psw_malloc();

/********************/
/* Types */
/********************/

typedef struct _t_EntryRec {
  struct _t_EntryRec *next;
  char *name;
  PSWDictValue value;
  } EntryRec, *Entry;

 /* The concrete definition for a dictionary */
 typedef struct _t_PSWDictRec {
  int nEntries;
  Entry *entries;
  } PSWDictRec;

PSWDict atoms;

/**************************/
/* Procedure Declarations */
/**************************/

/* Creates and returns a new dictionary. nEntries is a hint. */
PSWDict CreatePSWDict(nEntries) int nEntries; {
  PSWDict d = (PSWDict)psw_calloc(sizeof(PSWDictRec), 1);
  d->nEntries = nEntries;
  d->entries = (Entry *)psw_calloc(sizeof(EntryRec), d->nEntries);
  return d;
  }

/* Destroys a dictionary */
void DestroyPSWDict(dict) PSWDict dict; {
  free(dict->entries);
  free(dict);
  }

static int Hash(name, nEntries) char *name; int nEntries; {
  register int val = 0;
  while (*name) val += *name++;
  if (val < 0) val = -val;
  return (val % nEntries);
  }

static Entry Probe(d, x, name) PSWDict d; int x; char *name; {
  register Entry e;
  for (e = (d->entries)[x]; e; e = e->next) {
    if (strcmp(name, e->name) == 0) break;
    }
  return e;
  }

static Entry PrevProbe(prev, d, x, name)
  Entry *prev; PSWDict d; int x; char *name;
  {
  register Entry e;
  *prev = NULL;
  for (e = (d->entries)[x]; e; e = e->next) {
    if (strcmp(name, e->name) == 0) break;
    *prev = e;
    }
  return e;
  }

/* -1 => not found */
PSWDictValue PSWDictLookup(dict, name) PSWDict dict; char *name; {
  Entry e;
  e = Probe(dict, Hash(name, dict->nEntries), name);
  if (e == NULL) return -1;
  return e->value;
  }

/*  0 => normal return (not found)
   -1 => found. If found, value is replaced. */
PSWDictValue PSWDictEnter(dict, name, value)
  PSWDict dict; char *name; PSWDictValue value;
  {
  Entry e;
  int x = Hash(name, dict->nEntries);
  e = Probe(dict, x, name);
  if (e) {
    e->value = value;
    return -1;
    }
  e = (Entry)psw_calloc(sizeof(EntryRec), 1);
  e->next = (dict->entries)[x]; (dict->entries)[x] = e;
  e->value = value;
  e->name = MakeAtom(name);
  return 0;
  }

/* -1 => not found. If found, value is returned. */
PSWDictValue PSWDictRemove(dict, name) PSWDict dict; char *name; {
  Entry e, prev;
  PSWDictValue value;
  int x = Hash(name, dict->nEntries);

  e = PrevProbe(&prev, dict, x, name);
  if (e == NULL) return -1;
  value = e->value;
  if (prev == NULL) (dict->entries)[x] = e->next; else prev->next = e->next;
  free(e);
  return value;
  }

PSWAtom MakeAtom(name) char *name; {
  Entry e;
  int x = Hash(name, 511);
  char *newname;

  if (atoms == NULL) atoms = CreatePSWDict(511);
  e = Probe(atoms, x, name);
  if (e == NULL) {
    e = (Entry)psw_calloc(sizeof(EntryRec), 1);
    e->next = (atoms->entries)[x]; (atoms->entries)[x] = e;
    e->value = 0;
    newname = psw_malloc(strlen(name)+1);
    strcpy(newname, name);
    e->name = newname;
    }
  return e->name;
  }

