.ds f. PEXtWorkst.tbl
.\" $Header: PEXtWorkst.tbl,v 1.0 91/10/04 17:02:11 rthomson Exp $
.\" **
.\" **
.\" **  (c) Copyright 1991 by Evans and Sutherland Computer Corporation
.\" **      All Rights Reserved.
.\" **
.TH PEXtWorkstation 3PEXt "" "" "" ""
.SH NAME
\fBPEXtWorkstation \(em the Workstation widget class\fP.
.iX "Workstation"
.iX "widget class" "Workstation"
.sp 1
.SH SYNOPSIS
\fB#include <PEXt/Workstati.h>\fP
.sp 1
Widget PEXtCreateWorkstation (\fIparent, name, arglist, argcount\fP)
.br
.ta .5i 1.5i
	Widget	\fIparent\fP;
.br
	String	\fIname\fP;
.br
	ArgList	\fIarglist\fP;
.br
	Cardinal	\fIargcount\fP;
.fi
.sp 1
.SH DESCRIPTION
Workstation is an empty widget that provides the functionality of a PHIGS
workstation (of workstation class output only) in a widget.  The widget
defines policies for exposure and resizing of the X window in which the
PHIGS workstation has been opened.  Other than this behaviour, the widget
defines no semantics.  \fBPEXtCreateWorkstation\fP is a convenience
function for creating an instance of this widget class.
.PP
Workstation is a subclass of \fBCore\fP.
.sp 1
.SS "Classes"
Workstation inherits behavior and resources from the \fBCore\fP
classe.
.PP
The class pointer is \fBpextWorkstationWidgetClass\fP.
.PP
The class name is \fBPEXtWorkstation\fP.
.sp 1
.SS "New Resources"
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the 
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in a .Xdefaults file, remove the \fBPEXtN\fP or
\fBPEXtC\fP prefix and use the remaining letters.  To specify one of the
defined values for a resource in a .Xdefaults file, remove the \fBPEXt\fP
prefix and use the remaining letters (white space and capitalization are
ignored).  The codes in the access column indicate if the given resource can be
set at creation time (\fBC\fP), set by using \fBXtSetValues\fP (\fBS\fP), 
retrieved by using \fBXtGetValues\fP (\fBG\fP), or is not applicable
(\fBN/A\fP).  A default value of <wsdep> indicates that the default value
for that resource is taken from the default PHIGS workstation description
table entry for the given workstation type.
.sp 1
.KS
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 80 81 82 83 84
.nr 80 0
.nr 38 \w\f3\s8Name\fP\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNworkstationId\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNworkstationType\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNhlhsrMode\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNdeferralMode\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNmodificationMode\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNresizePolicy\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNresizeGravity\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNresizeCallback\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNtraversalPolicy\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNtraversalCallback\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNcontrolFlag\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8PEXtNunrealizeCallback\s0
.if \n(80<\n(38 .nr 80 \n(38
.80
.rm 80
.nr 81 0
.nr 38 \w\f3\s8Class\fP\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCWorkstationId\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCWorkstationType\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCHLHSRMode\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCDeferralMode\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCModificationMode\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCResizePolicy\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCGravity\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCResizeCallback\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCTraversalPolicy\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCTraversalCallback\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCControlFlag\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8PEXtCUnrealizeCallback\s0
.if \n(81<\n(38 .nr 81 \n(38
.81
.rm 81
.nr 82 0
.nr 38 \w\f3\s8Type\fP\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8int\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pwstype\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8int\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pdefer_mode\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pmod_mode\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8PEXtResizePolicy\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8int\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtCallbackList\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8PEXtTraversalPolicy\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtCallbackList\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pctrl_flag\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtCallbackList\s0
.if \n(82<\n(38 .nr 82 \n(38
.82
.rm 82
.nr 83 0
.nr 38 \w\f3\s8Default\fP\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s81\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8drawable\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8none\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8<wsdep>\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8<wsdep>\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8none\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8center\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8none\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8conditionally\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL*\s0
.if \n(83<\n(38 .nr 83 \n(38
.83
.rm 83
.nr 84 0
.nr 38 \w\f3\s8Access\fP\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.84
.rm 84
.nr 38 \w\f3\s9PEXtWorkstation Resource Set\fP\s0-\n(80-3n-\n(81-3n-\n(82-3n-\n(83-3n-\n(84
.if \n(38>0 .nr 38 \n(38/4
.if \n(38<0 .nr 38 0
.nr 81 +\n(38
.nr 82 +\n(38
.nr 83 +\n(38
.nr 84 +\n(38
.nr 38 1n
.nr 79 0
.nr 40 \n(79+(0*\n(38)
.nr 80 +\n(40
.nr 41 \n(80+(3*\n(38)
.nr 81 +\n(41
.nr 42 \n(81+(3*\n(38)
.nr 82 +\n(42
.nr 43 \n(82+(3*\n(38)
.nr 83 +\n(43
.nr 44 \n(83+(3*\n(38)
.nr 84 +\n(44
.nr TW \n(84
.if t .if \n(TW>\n(.li .tm Table at line 82 file PEXtWorkst.tbl is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\f3\s9PEXtWorkstation Resource Set\f\n(31\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\f3\s8Name\f\n(31\s0\h'|\n(41u'\f3\s8Class\f\n(31\s0\h'|\n(42u'\f3\s8Type\f\n(31\s0\h'|\n(43u'\f3\s8Default\f\n(31\s0\h'|\n(44u'\f3\s8Access\f\n(31\s0
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNworkstationId\s0\h'|\n(41u'\s8PEXtCWorkstationId\s0\h'|\n(42u'\s8int\s0\h'|\n(43u'\s81\s0\h'|\n(44u'\s8CG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNworkstationType\s0\h'|\n(41u'\s8PEXtCWorkstationType\s0\h'|\n(42u'\s8Pwstype\s0\h'|\n(43u'\s8drawable\s0\h'|\n(44u'\s8CG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNhlhsrMode\s0\h'|\n(41u'\s8PEXtCHLHSRMode\s0\h'|\n(42u'\s8int\s0\h'|\n(43u'\s8none\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNdeferralMode\s0\h'|\n(41u'\s8PEXtCDeferralMode\s0\h'|\n(42u'\s8Pdefer_mode\s0\h'|\n(43u'\s8<wsdep>\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNmodificationMode\s0\h'|\n(41u'\s8PEXtCModificationMode\s0\h'|\n(42u'\s8Pmod_mode\s0\h'|\n(43u'\s8<wsdep>\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNresizePolicy\s0\h'|\n(41u'\s8PEXtCResizePolicy\s0\h'|\n(42u'\s8PEXtResizePolicy\s0\h'|\n(43u'\s8none\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNresizeGravity\s0\h'|\n(41u'\s8PEXtCGravity\s0\h'|\n(42u'\s8int\s0\h'|\n(43u'\s8center\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNresizeCallback\s0\h'|\n(41u'\s8PEXtCResizeCallback\s0\h'|\n(42u'\s8XtCallbackList\s0\h'|\n(43u'\s8NULL\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNtraversalPolicy\s0\h'|\n(41u'\s8PEXtCTraversalPolicy\s0\h'|\n(42u'\s8PEXtTraversalPolicy\s0\h'|\n(43u'\s8none\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNtraversalCallback\s0\h'|\n(41u'\s8PEXtCTraversalCallback\s0\h'|\n(42u'\s8XtCallbackList\s0\h'|\n(43u'\s8NULL\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNcontrolFlag\s0\h'|\n(41u'\s8PEXtCControlFlag\s0\h'|\n(42u'\s8Pctrl_flag\s0\h'|\n(43u'\s8conditionally\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8PEXtNunrealizeCallback\s0\h'|\n(41u'\s8PEXtCUnrealizeCallback\s0\h'|\n(42u'\s8XtCallbackList\s0\h'|\n(43u'\s8NULL*\s0\h'|\n(44u'\s8CSG\s0
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-20
.KE
.sp 1
.IP "\fBPEXtNworkstationId\fP"
Specifies the workstation identifier used in the call to \fBpopen_ws\fP when
the PHIGS workstation is openned in the widget's realize method.
.IP "\fBPEXtNworkstationType\fP"
Specifies the workstation type used for the workstation.  PEX supports
workstation types \fBtool\fP and \fBdrawable\fP.  The PEX-SI documentation
describes a workstation of type \fBtool\fP as creating a separate PHIGS
monitor process to handle PHIGS style input.  The PEX Toolkit makes no
attempt at handling PHIGS style input and hence a workstation of type
\fBdrawable\fP is recommended.
.IP "\fBPEXtNhlhsrMode\fP"
Specifies the hidden line, hidden surface removal mode for the workstation.
.IP "\fBPEXtNdeferralMode\fP"
Specifies the deferral mode for the workstation.  The default value is
workstation type dependant.
.IP "\fBPEXtNmodificationMode\fP"
Specifies the modification mode for the workstation.  The default value is
workstation type dependant.
.IP "\fBPEXtNresizePolicy\fP"
Specifies the resize policy for the workstation.  When a workstation's window
is resized, the widget may adjust the workstation transformation to redirect
the display of graphical data to the newly sized region of the X window in
which the workstation was openned.  Possible values include
\fBPEXtResizeNone\fP (perform no action upon resizing of the window),
\fBPEXtResizeCallback\fP (invoke the resize callback list upon resize),
\fBPEXtResizeContainer\fP (the workstation transformation will be adjusted
to be the largest portion of the window which completely contains NPC space),
\fBPEXtResizePorthole\fP (the workstation transformation will be adjusted
to be the largest portion of NPC space that completely contains the window).
.IP "\fBPEXtNresizeGravity\fP"
When the window is resized and the widget has a resize policy of
\fBPEXtResizePorthole\fP, or \fBPEXtResizeContainer\fP, there may be a portion
of NPC space or the window, respectively, in which 3D graphics is not
displayed.  The gravity attribute specifies which portion of NPC space, or
the window, respectively, is to be used.  The possible values include
\fBNorthWestGravity\fP, \fBNorthGravity\fP, \fBNorthEastGravity\fP,
\fBWestGravity\fP, \fBCenterGravity\fP, \fBEastGravity\fP,
\fBSouthWestGravity\fP, and \fBSouthEastGravity\fP.
.IP "\fBPEXtNresizeCallback\fP"
Specifies a list of callbacks that is called when the workstation is
resized and the resize policy is set to \fBPEXtResizeCallback\fP.  The callback
reason is \fBPEXtCR_RESIZE\fP.
.IP "\fBPEXtNtraversalPolicy\fP"
Specifies behaviour of the workstation when it receives expose events.
The possible values include \fBPEXtTraversalNone\fP (perform no action),
\fBPEXtTraversalCallback\fP (invoke the traversal callback) or
\fBPEXtTraversalRedraw\fP (call \fBREDRAW ALL STRUCTURES\fP on the
workstation).  Multiple exposures are compressed by the Intrinsics into
a single event.
.IP "\fBPEXtNtraversalCallback\fP"
Specifies a list of callbacks that is called when the workstation
receives an exposure event and the traversal policy is set to
\fBPEXtTraversalCallback\fP.  The callback reason is \fBPEXtCR_TRAVERSE\fP.
.IP "\fBPEXtNcontrolFlag\fP"
Specifies the update control flag used in the \fBREDRAW ALL STRUCTURES\fP
call in the traversal.
.IP "\fBPEXtNunrealizeCallback\fP"
This callback list is initialized to contain a callback that closes the
associated PHIGS workstation when the widget becomes unrealized.
.sp 1
.SS "Inherited Resources"
DrawingArea inherits behavior and resources from the following   
superclasses.  For a complete description of these resources, refer to the
man page for that superclass.
.sp 1
.DS
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 80 81 82 83 84
.nr 80 0
.nr 38 \w\f3\s8Name\fP\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNaccelerators\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNancestorSensitive\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNbackground\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNbackgroundPixmap\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNborderColor\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNborderPixmap\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNborderWidth\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNcolormap\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNdepth\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNdestroyCallback\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNheight\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNmappedWhenManaged\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNscreen\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNsensitive\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNtranslations\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNwidth\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNx\s0
.if \n(80<\n(38 .nr 80 \n(38
.nr 38 \w\s8XtNy\s0
.if \n(80<\n(38 .nr 80 \n(38
.80
.rm 80
.nr 81 0
.nr 38 \w\f3\s8Class\fP\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCAccelerators\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCSensitive\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCBackground\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XmCPixmap\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCBorderColor\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCPixmap\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCBorderWidth\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCColormap\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCDepth\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCCallback\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCHeight\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCMappedWhenManaged\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCScreen\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCSensitive\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCTranslations\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCWidth\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCPosition\s0
.if \n(81<\n(38 .nr 81 \n(38
.nr 38 \w\s8XtCPosition\s0
.if \n(81<\n(38 .nr 81 \n(38
.81
.rm 81
.nr 82 0
.nr 38 \w\f3\s8Type\fP\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtTranslations\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Boolean\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pixel\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pixmap\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pixel\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pixmap\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Dimension\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Colormap\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8int\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtCallbackList\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Dimension\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Boolean\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Pointer\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Boolean\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8XtTranslations\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Dimension\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Position\s0
.if \n(82<\n(38 .nr 82 \n(38
.nr 38 \w\s8Position\s0
.if \n(82<\n(38 .nr 82 \n(38
.82
.rm 82
.nr 83 0
.nr 38 \w\f3\s8Default\fP\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8True\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8dynamic\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8XmUNSPECIFIED_PIXMAP\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8Black\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8XmUNSPECIFIED_PIXMAP\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s80\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8XtCopyFromParent\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8XtCopyFromParent\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s80\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8True\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8XtCopyScreen\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8True\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s8NULL\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s80\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s80\s0
.if \n(83<\n(38 .nr 83 \n(38
.nr 38 \w\s80\s0
.if \n(83<\n(38 .nr 83 \n(38
.83
.rm 83
.nr 84 0
.nr 38 \w\f3\s8Access\fP\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8G\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8C\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.nr 38 \w\s8CSG\s0
.if \n(84<\n(38 .nr 84 \n(38
.84
.rm 84
.nr 38 \w\f3\s9Core Resource Set \fP\s0-\n(80-3n-\n(81-3n-\n(82-3n-\n(83-3n-\n(84
.if \n(38>0 .nr 38 \n(38/4
.if \n(38<0 .nr 38 0
.nr 81 +\n(38
.nr 82 +\n(38
.nr 83 +\n(38
.nr 84 +\n(38
.nr 38 1n
.nr 79 0
.nr 40 \n(79+(0*\n(38)
.nr 80 +\n(40
.nr 41 \n(80+(3*\n(38)
.nr 81 +\n(41
.nr 42 \n(81+(3*\n(38)
.nr 82 +\n(42
.nr 43 \n(82+(3*\n(38)
.nr 83 +\n(43
.nr 44 \n(83+(3*\n(38)
.nr 84 +\n(44
.nr TW \n(84
.if t .if \n(TW>\n(.li .tm Table at line 177 file PEXtWorkst.tbl is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\f3\s9Core Resource Set \f\n(31\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\f3\s8Name\f\n(31\s0\h'|\n(41u'\f3\s8Class\f\n(31\s0\h'|\n(42u'\f3\s8Type\f\n(31\s0\h'|\n(43u'\f3\s8Default\f\n(31\s0\h'|\n(44u'\f3\s8Access\f\n(31\s0
.nr 36 \n(.v
.vs \n(.vu-\n(.sp
\h'|0'\s\n(33\l'|\n(TWu\(ul'\s0
.vs \n(36u
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNaccelerators\s0\h'|\n(41u'\s8XtCAccelerators\s0\h'|\n(42u'\s8XtTranslations\s0\h'|\n(43u'\s8NULL\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNancestorSensitive\s0\h'|\n(41u'\s8XtCSensitive\s0\h'|\n(42u'\s8Boolean\s0\h'|\n(43u'\s8True\s0\h'|\n(44u'\s8G\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNbackground\s0\h'|\n(41u'\s8XtCBackground\s0\h'|\n(42u'\s8Pixel\s0\h'|\n(43u'\s8dynamic\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNbackgroundPixmap\s0\h'|\n(41u'\s8XmCPixmap\s0\h'|\n(42u'\s8Pixmap\s0\h'|\n(43u'\s8XmUNSPECIFIED_PIXMAP\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNborderColor\s0\h'|\n(41u'\s8XtCBorderColor\s0\h'|\n(42u'\s8Pixel\s0\h'|\n(43u'\s8Black\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNborderPixmap\s0\h'|\n(41u'\s8XtCPixmap\s0\h'|\n(42u'\s8Pixmap\s0\h'|\n(43u'\s8XmUNSPECIFIED_PIXMAP\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNborderWidth\s0\h'|\n(41u'\s8XtCBorderWidth\s0\h'|\n(42u'\s8Dimension\s0\h'|\n(43u'\s80\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNcolormap\s0\h'|\n(41u'\s8XtCColormap\s0\h'|\n(42u'\s8Colormap\s0\h'|\n(43u'\s8XtCopyFromParent\s0\h'|\n(44u'\s8CG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNdepth\s0\h'|\n(41u'\s8XtCDepth\s0\h'|\n(42u'\s8int\s0\h'|\n(43u'\s8XtCopyFromParent\s0\h'|\n(44u'\s8CG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNdestroyCallback\s0\h'|\n(41u'\s8XtCCallback\s0\h'|\n(42u'\s8XtCallbackList\s0\h'|\n(43u'\s8NULL\s0\h'|\n(44u'\s8C\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNheight\s0\h'|\n(41u'\s8XtCHeight\s0\h'|\n(42u'\s8Dimension\s0\h'|\n(43u'\s80\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNmappedWhenManaged\s0\h'|\n(41u'\s8XtCMappedWhenManaged\s0\h'|\n(42u'\s8Boolean\s0\h'|\n(43u'\s8True\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNscreen\s0\h'|\n(41u'\s8XtCScreen\s0\h'|\n(42u'\s8Pointer\s0\h'|\n(43u'\s8XtCopyScreen\s0\h'|\n(44u'\s8CG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNsensitive\s0\h'|\n(41u'\s8XtCSensitive\s0\h'|\n(42u'\s8Boolean\s0\h'|\n(43u'\s8True\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNtranslations\s0\h'|\n(41u'\s8XtCTranslations\s0\h'|\n(42u'\s8XtTranslations\s0\h'|\n(43u'\s8NULL\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNwidth\s0\h'|\n(41u'\s8XtCWidth\s0\h'|\n(42u'\s8Dimension\s0\h'|\n(43u'\s80\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNx\s0\h'|\n(41u'\s8XtCPosition\s0\h'|\n(42u'\s8Position\s0\h'|\n(43u'\s80\s0\h'|\n(44u'\s8CSG\s0
.ta \n(80u \n(81u \n(82u \n(83u \n(84u 
.nr 31 \n(.f
.nr 35 1m
\&\h'|\n(40u'\s8XtNy\s0\h'|\n(41u'\s8XtCPosition\s0\h'|\n(42u'\s8Position\s0\h'|\n(43u'\s80\s0\h'|\n(44u'\s8CSG\s0
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-26
.DE
.sp 1
.SS "Callback Information"
The following structure is returned with each callback.
.sp 1
.nf
.ta .25i 1.1i
\fBtypedef struct\fP
{
	\fBint\fP	\fIreason\fP;
	\fBint\fP	\fIwidth\fP, \fIheight\fP;
	\fBXEvent *\fP	\fIevent\fP;
} \fBPEXtWorkstationCallbackStruct\fP;
.fi
.fi
.sp 1
.IP "\fIreason\fP" .75i
Indicates why the callback was invoked.
.IP "\fIwidth\fP, \fIheight\fP"
Indicate the new width and height of the window when the reason is
\fBPEXtCR_RESIZE\fP.
.IP "\fIevent\fP" .75i
Points to the \fBXEvent\fP that triggered the callback.
.sp 1
.SS "Actions"
The workstation widget registers a Traverse() action that invokes the
workstations traversal method.  It is used by the expose method so that
the application can obtain a custom traversal during expose events through
the traversal callback.
.sp 1
.SS "Default Translations"
The workstation defines no translations.
.sp 1
.na
.SH SEE ALSO
.nf
\fBPEXtRegisterConverters(3)\fP
\fBCore(3X)\fP 
\fBpopen_ws(3)\fP	
\fBpredraw_all_structs(3)\fP
.SH AUTHOR
Rich Thomson <rthomson@dsd.es.com>
.br
Design Systems Division
.br
Evans & Sutherland Computer Corporation
