.\" $Header: XpexSearchNetwork.man,v 2.6 91/09/11 16:03:58 sinyaw Exp $
.\"
.\"
.\" Copyright 1991 by Sony Microsystems Company, San Jose, California
.\" 
.\"                   All Rights Reserved
.\"
.\" Permission to use, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear
.\" in supporting documentation, and that the name of Sony not be used
.\" in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" SONY DISCLAIMS ANY AND ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL EXPRESS WARRANTIES AND ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS, FOR A PARTICULAR PURPOSE. IN NO EVENT
.\" SHALL SONY BE LIABLE FOR ANY DAMAGES OF ANY KIND, INCLUDING BUT NOT
.\" LIMITED TO SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING FROM
.\" LOSS OF USE, DATA OR LOSS OF ANY PAST, PRESENT, OR PROSPECTIVE PROFITS,
.\" WHETHER IN AN ACTION OF CONTRACT, NEGLIENCE OR OTHER TORTIOUS ACTION, 
.\" ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
.\" SOFTWARE.
.\"
.\" 
.TH XpexSearchNetwork 3PEX "$Revision: 2.6 $" "Sony Microsystems" 
.AT
.SH "Name"
XpexSearchNetwork \- Search Network
.SH "Synopsis"
.nf
Status
XpexSearchNetwork(dpy, sc_id, elem_refs, num_elem_refs)
.br
	Display *\fIdpy\fP;
.br
	XpexSC \fIsc_id\fP;
.br
	XpexElementRef *elem_refs; /* RETURN */
.br
	int *\fInum_elem_refs\fP; /* RETURN */
.fi
.SH "Arguments"
.IP \fIdpy\fP 1i		
Specifies a pointer to the Display structure;
returned from XOpenDisplay.
.IP \fIsc_id\fP 1i    	
Specifies the search context.
.IP \fIelem_refs\fP 1i    	
To be added 
.IP \fInum_elem_refs\fP 1i    	
To be added 
.SH "Description"
This function causes a spatial search world coordinates to be 
performed on a structure network. The parameters of the searching
operations are found in the search context \fIsc_id\fP. The search
begins at the element following the one indicated by the 
\fIstart_path\fP attribute of \fIsc_id\fP.  The search is terminated
once the end of the structure indicated by \fIsearch_ceiling\fP
has been reached. The first element that meets the search criteria
is returned in \fI*elem_refs\fP.  If no element is found, 
\fI*elem_refs\fP will be null. After the search has completed, 
the \fIstart_path\fP attribute of \fIsc_id\fP will be set to the 
value that is returned in \fI*elem_refs\fP. The number of elements
found will be returned in \fIcount\fP.
.sp
This function can generate 
\fIBadSearchContext\fP and \fIBadPath\fP errors.
.SH "Structures"
typedef struct {
.br
	XpexStructure  s_id;
.br
	int  offset;
.br
}  XpexElementRef;
.SH "Errors"
.IP \fIBadSearchContext\fP 1i
specified search context resource ID is invalid
.IP \fIBadPath\fP 1i
illegal or poorly-formed search path 
(includes valid structure ID's, invalid element offset values)
.SH "Related Commands" 
XpexCreateSC, XpexCopySC, XpexFreeSC, XpexGetSC,
XpexChangeSC.
