
# line 42 "gram.y"
#include <stdio.h>
#include <ctype.h>
#include "twm.h"
#include "menus.h"
#include "list.h"
#include "util.h"
#include "screen.h"
#include "parse.h"
#include <X11/Xos.h>
#include <X11/Xmu/CharSet.h>

static char *Action = "";
static char *Name = "";
static MenuRoot	*root, *pull = NULL;

static MenuRoot *GetRoot();

static Bool CheckWarpScreenArg(), CheckWarpRingArg();
static Bool CheckColormapArg();
static void GotButton(), GotKey(), GotTitleButton();
static char *ptr;
static name_list **list;
static int cont = 0;
static int color;
int mods = 0;
unsigned int mods_used = (ShiftMask | ControlMask | Mod1Mask);

extern int do_single_keyword(), do_string_keyword(), do_number_keyword();
extern name_list **do_colorlist_keyword();
extern int do_color_keyword(), do_string_savecolor();
extern int yylineno;

# line 75 "gram.y"
typedef union 
{
    int num;
    char *ptr;
} YYSTYPE;
# define LB 257
# define RB 258
# define LP 259
# define RP 260
# define MENUS 261
# define MENU 262
# define BUTTON 263
# define DEFAULT_FUNCTION 264
# define PLUS 265
# define MINUS 266
# define ALL 267
# define OR 268
# define CURSORS 269
# define PIXMAPS 270
# define ICONS 271
# define COLOR 272
# define SAVECOLOR 273
# define MONOCHROME 274
# define FUNCTION 275
# define ICONMGR_SHOW 276
# define ICONMGR 277
# define WINDOW_FUNCTION 278
# define ZOOM 279
# define ICONMGRS 280
# define ICONMGR_GEOMETRY 281
# define ICONMGR_NOSHOW 282
# define MAKE_TITLE 283
# define ICONIFY_BY_UNMAPPING 284
# define DONT_ICONIFY_BY_UNMAPPING 285
# define NO_TITLE 286
# define AUTO_RAISE 287
# define NO_HILITE 288
# define ICON_REGION 289
# define META 290
# define SHIFT 291
# define LOCK 292
# define CONTROL 293
# define WINDOW 294
# define TITLE 295
# define ICON 296
# define ROOT 297
# define FRAME 298
# define COLON 299
# define EQUALS 300
# define SQUEEZE_TITLE 301
# define DONT_SQUEEZE_TITLE 302
# define START_ICONIFIED 303
# define NO_TITLE_HILITE 304
# define TITLE_HILITE 305
# define MOVE 306
# define RESIZE 307
# define WAIT 308
# define SELECT 309
# define KILL 310
# define LEFT_TITLEBUTTON 311
# define RIGHT_TITLEBUTTON 312
# define NUMBER 313
# define KEYWORD 314
# define NKEYWORD 315
# define CKEYWORD 316
# define CLKEYWORD 317
# define FKEYWORD 318
# define FSKEYWORD 319
# define SKEYWORD 320
# define DKEYWORD 321
# define JKEYWORD 322
# define WINDOW_RING 323
# define WARP_CURSOR 324
# define ERRORTOKEN 325
# define NO_STACKMODE 326
# define STRING 327
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 627 "gram.y"

yyerror(s) char *s;
{
    twmrc_error_prefix();
    fprintf (stderr, "error in input file:  %s\n", s ? s : "");
    ParseError = 1;
}
RemoveDQuote(str)
char *str;
{
    register char *i, *o;
    register n;
    register count;

    for (i=str+1, o=str; *i && *i != '\"'; o++)
    {
	if (*i == '\\')
	{
	    switch (*++i)
	    {
	    case 'n':
		*o = '\n';
		i++;
		break;
	    case 'b':
		*o = '\b';
		i++;
		break;
	    case 'r':
		*o = '\r';
		i++;
		break;
	    case 't':
		*o = '\t';
		i++;
		break;
	    case 'f':
		*o = '\f';
		i++;
		break;
	    case '0':
		if (*++i == 'x')
		    goto hex;
		else
		    --i;
	    case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		n = 0;
		count = 0;
		while (*i >= '0' && *i <= '7' && count < 3)
		{
		    n = (n<<3) + (*i++ - '0');
		    count++;
		}
		*o = n;
		break;
	    hex:
	    case 'x':
		n = 0;
		count = 0;
		while (i++, count++ < 2)
		{
		    if (*i >= '0' && *i <= '9')
			n = (n<<4) + (*i - '0');
		    else if (*i >= 'a' && *i <= 'f')
			n = (n<<4) + (*i - 'a') + 10;
		    else if (*i >= 'A' && *i <= 'F')
			n = (n<<4) + (*i - 'A') + 10;
		    else
			break;
		}
		*o = n;
		break;
	    case '\n':
		i++;	/* punt */
		o--;	/* to account for o++ at end of loop */
		break;
	    case '\"':
	    case '\'':
	    case '\\':
	    default:
		*o = *i++;
		break;
	    }
	}
	else
	    *o = *i++;
    }
    *o = '\0';
}

static MenuRoot *GetRoot(name, fore, back)
char *name;
char *fore, *back;
{
    MenuRoot *tmp;

    tmp = FindMenuRoot(name);
    if (tmp == NULL)
	tmp = NewMenuRoot(name);

    if (fore)
    {
	int save;

	save = Scr->FirstTime;
	Scr->FirstTime = TRUE;
	GetColor(COLOR, &tmp->hi_fore, fore);
	GetColor(COLOR, &tmp->hi_back, back);
	Scr->FirstTime = save;
    }

    return tmp;
}

static void GotButton(butt, func)
int butt, func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0)
	    continue;

	Scr->Mouse[butt][i][mods].func = func;
	if (func == F_MENU)
	{
	    pull->prev = NULL;
	    Scr->Mouse[butt][i][mods].menu = pull;
	}
	else
	{
	    root = GetRoot(TWM_ROOT, NULLSTR, NULLSTR);
	    Scr->Mouse[butt][i][mods].item = AddToMenu(root,"x",Action,
		    NULLSTR, func, NULLSTR, NULLSTR);
	}
    }
    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}

static void GotKey(key, func)
char *key;
int func;
{
    int i;

    for (i = 0; i < NUM_CONTEXTS; i++)
    {
	if ((cont & (1 << i)) == 0) 
	  continue;
	if (!AddFuncKey(key, i, mods, func, Name, Action)) 
	  break;
    }

    Action = "";
    pull = NULL;
    cont = 0;
    mods_used |= mods;
    mods = 0;
}


static void GotTitleButton (bitmapname, func, rightside)
    char *bitmapname;
    int func;
    Bool rightside;
{
    if (!CreateTitleButton (bitmapname, func, Action, pull, rightside, True)) {
	twmrc_error_prefix();
	fprintf (stderr, 
		 "unable to create %s titlebutton \"%s\"\n",
		 rightside ? "right" : "left", bitmapname);
    }
    Action = "";
    pull = NULL;
}

static Bool CheckWarpScreenArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0 ||
	strcmp (s,  WARPSCREEN_BACK) == 0)
      return True;

    for (; *s && isascii(*s) && isdigit(*s); s++) ; /* SUPPRESS 530 */
    return (*s ? False : True);
}


static Bool CheckWarpRingArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s,  WARPSCREEN_NEXT) == 0 ||
	strcmp (s,  WARPSCREEN_PREV) == 0)
      return True;

    return False;
}


static Bool CheckColormapArg (s)
    register char *s;
{
    XmuCopyISOLatin1Lowered (s, s);

    if (strcmp (s, COLORMAP_NEXT) == 0 ||
	strcmp (s, COLORMAP_PREV) == 0 ||
	strcmp (s, COLORMAP_DEFAULT) == 0)
      return True;

    return False;
}


twmrc_error_prefix ()
{
    fprintf (stderr, "%s:  line %d:  ", ProgramName, yylineno);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 14,
	257, 16,
	-2, 18,
-1, 20,
	257, 27,
	-2, 29,
-1, 23,
	257, 34,
	-2, 36,
-1, 24,
	257, 37,
	-2, 39,
-1, 25,
	257, 40,
	-2, 42,
-1, 26,
	257, 43,
	-2, 45,
-1, 38,
	257, 67,
	-2, 69,
-1, 43,
	257, 154,
	-2, 153,
-1, 44,
	257, 157,
	-2, 156,
-1, 248,
	257, 141,
	-2, 140,
	};
# define YYNPROD 191
# define YYLAST 412
short yyact[]={

   4,  46, 250, 165, 129, 275,  30,  45,  36,  93,
  61,  62,  50,  13,  12,  32,  33,  34,  35,  31,
  22,  50,  37,  11,  21,  10,  20,  27,  14,  19,
  26,  29,  24,   9,  63,  46, 241, 202, 195, 189,
 183, 261, 262, 257, 130,  43,  44,  28,  23, 100,
 236, 237,  61,  62, 198,  15,  16, 244,  40,  42,
 234,  46, 168,  99,  41,  65, 272,  39,  38, 192,
  25,  46,  46, 235,  46, 159, 278, 229, 230, 231,
 232, 233, 227,  18,  59, 255, 116, 160, 267,  50,
 162, 132, 133,  47,  48,  98, 143, 139, 127,  56,
  57,  58,  61,  62, 122,  46,  46,  46,  46,  46,
  46, 138, 201, 200,  77,  78, 102,  61,  62, 120,
 107,  84,  85,  82,  54,  88, 225, 226,  52, 136,
 137, 121, 135, 242, 193, 245, 223, 155, 194, 196,
 140, 141, 142, 144, 145, 163, 101, 155,  49, 224,
 184, 146, 190, 218, 219, 220, 221, 222, 216, 151,
 152, 153, 154, 157,  91, 169,  90, 276, 156, 151,
 152, 153, 154, 273, 166, 123, 266, 258, 149, 199,
 164, 134, 103,  96, 147, 148, 131,  95, 228, 217,
 150,  89, 188, 186,  92,  87,  86,  94,  83,  81,
 158,  80, 119,  79, 161, 118, 117, 167, 264,  76,
  75,  74,  73,  72,  71, 124, 171,  70,  69, 172,
 173, 174, 175, 176, 177, 178, 179, 180, 181, 182,
 185, 106,  68,  67,  66,  55,  53,  51,   8,   7,
   6, 191,   5,   3,   2,   1,  64, 197,  60, 259,
  17,   0,   0, 203,   0,   0, 205, 206, 207, 208,
 209, 210, 211, 212, 213, 214, 215,   0,   0,   0,
   0,   0, 238,   0,   0, 239, 240, 243, 170, 246,
   0, 247,   0,   0, 248, 249,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  97,   0,   0,
 187, 251,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 252,   0,   0,   0,   0,   0,   0, 204,
   0,   0,   0, 254,   0,   0,   0,   0, 256,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 271, 265,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 274, 277,   0,   0,
   0, 279,   0, 280, 104, 105,   0, 108, 109, 110,
 111, 112, 113, 114, 115,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 125, 126,   0,   0, 253, 128,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 260,
   0,   0,   0, 263,   0,   0,   0,   0, 268,   0,
 269, 270 };
short yypact[]={

-1000,-1000,-256,-1000,-1000,-1000,-1000,-1000,-1000,-326,
-326,-301,-129,-133,-1000,-326,-326,-266,-235,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-326,-326,-1000,-1000,-134,-1000,-308,-308,-1000,-1000,
-1000,-326,-301,-1000,-1000,-301,-1000,-312,-301,-1000,
-1000,-1000,-1000,-1000,-1000,-162,-237,-251,-1000,-1000,
-1000,-1000,-326,-1000,-1000,-1000,-162,-162,-137,-162,
-162,-162,-162,-162,-162,-162,-162,-173,-1000,-138,
-153,-1000,-1000,-153,-1000,-1000,-162,-162,-1000,-1000,
-159,-162,-1000,-317,-1000,-214,-166,-1000,-1000,-308,
-308,-1000,-121,-131,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-326,-170,-167,-1000,
-1000,-1000,-1000,-255,-1000,-1000,-1000,-1000,-1000,-301,
-1000,-1000,-326,-1000,-1000,-326,-326,-326,-326,-326,
-326,-326,-326,-326,-326,-326,-218,-1000,-1000,-1000,
-1000,-301,-1000,-1000,-1000,-1000,-1000,-219,-230,-1000,
-1000,-1000,-1000,-220,-204,-1000,-1000,-1000,-1000,-221,
-301,-1000,-326,-326,-326,-326,-326,-326,-326,-326,
-326,-326,-326,-1000,-1000,-1000,-141,-1000,-217,-1000,
-1000,-326,-326,-222,-201,-1000,-1000,-326,-1000,-1000,
-326,-326,-1000,-320,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-308,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-308,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-292,
-175,-1000,-1000,-216,-1000,-1000,-1000,-1000,-1000,-1000,
-224,-1000,-1000,-1000,-301,-1000,-1000,-326,-169,-301,
-1000,-301,-301,-1000,-170,-233,-1000,-1000,-1000,-1000,
-1000,-1000,-326,-253,-184,-1000,-1000,-326,-308,-1000,
-1000 };
short yypgo[]={

   0,  83,  84, 250, 148, 249, 248, 246, 245, 244,
 243, 242, 240, 239, 238, 237, 236, 235, 297, 234,
 233, 232, 231, 218, 217, 214, 213, 212, 211, 210,
 209, 208,  75, 206, 205, 204, 203, 202, 201, 131,
 199, 198, 196, 195, 116, 193, 192, 190, 189, 188,
 187, 186, 183, 181, 180, 179, 177, 176, 175, 174,
 173, 167, 166, 165, 164, 163, 152, 151, 150, 145,
 139, 138, 135, 134, 133 };
short yyr1[]={

   0,   8,   9,   9,  10,  10,  10,  10,  10,  10,
  10,  10,  10,  10,  10,  10,  17,  10,  10,  10,
  10,  10,  10,  10,  10,  19,  10,  20,  10,  10,
  21,  10,  23,  10,  24,  10,  10,  25,  10,  10,
  26,  10,  10,  27,  10,  10,  28,  10,  29,  10,
  30,  10,  31,  10,  33,  10,  34,  10,  36,  10,
  38,  10,  10,  41,  10,  10,  10,  42,  10,  10,
  43,  10,  11,  12,  13,   6,   7,  44,  44,  47,
  47,  47,  47,  47,  47,  45,  45,  48,  48,  48,
  48,  48,  48,  48,  48,  48,  46,  46,  49,  49,
  49,  49,  49,  49,  49,  49,  49,  49,  15,  50,
  50,  51,  16,  52,  52,  53,  53,  53,  53,  53,
  53,  53,  53,  53,  53,  53,  53,  53,  53,  53,
  53,  53,  53,  53,  53,  53,  53,  39,  54,  54,
  55,  56,  55,  55,  40,  58,  58,  59,  59,  57,
  60,  60,  61,  14,  62,  14,  14,  64,  14,  63,
  63,  22,  65,  65,  66,  66,  18,  67,  67,  68,
  37,  69,  69,  70,  35,  71,  71,  72,  32,  73,
  73,  74,  74,   2,   2,   5,   5,   5,   3,   1,
   4 };
short yyr2[]={

   0,   1,   0,   2,   1,   1,   1,   1,   1,   6,
   3,   2,   2,   1,   2,   2,   0,   3,   1,   4,
   4,   2,   2,   2,   2,   0,   3,   0,   3,   1,
   0,   3,   0,   3,   0,   3,   1,   0,   3,   1,
   0,   3,   1,   0,   3,   1,   0,   3,   0,   3,
   0,   3,   0,   9,   0,   4,   0,   4,   0,   3,
   0,   3,   2,   0,   3,   2,   2,   0,   3,   1,
   0,   3,   1,   2,   2,   6,   6,   0,   2,   1,
   1,   1,   1,   2,   1,   0,   2,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   0,   2,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   3,   0,
   2,   2,   3,   0,   2,   3,   2,   3,   2,   3,
   2,   3,   2,   3,   2,   3,   2,   3,   2,   3,
   2,   3,   2,   3,   2,   3,   2,   3,   0,   2,
   2,   0,   4,   2,   3,   0,   2,   1,   1,   3,
   0,   2,   2,   1,   0,   5,   1,   0,   3,   0,
   5,   3,   0,   2,   3,   4,   3,   0,   2,   1,
   3,   0,   2,   2,   3,   0,   2,   1,   3,   0,
   2,   2,   7,   1,   2,   1,   2,   2,   2,   1,
   1 };
short yychk[]={

-1000,  -8,  -9, -10, 256, -11, -12, -13, -14, 289,
 281, 279, 270, 269, 284, 311, 312,  -3,  -1, 285,
 282, 280, 276, 304, 288, 326, 286, 283, 303, 287,
 262, 275, 271, 272, 273, 274, 264, 278, 324, 323,
 314, 320, 315, 301, 302, 263, 327,  -1,  -1,  -4,
 313, -15, 257, -16, 257, -17,  -1,  -1,  -1,  -2,
  -6, 318, 319, 300,  -7, 300, -19, -20, -21, -23,
 -24, -25, -26, -27, -28, -29, -30,  -1,  -1, -36,
 -38, -40, 257, -41,  -2,  -2, -42, -43,  -1,  -4,
 -62, -64,  -4, 321,  -4, -50, -52, -18, 257, 300,
 300,  -1, -44, -44, -18, -18, -22, 257, -18, -18,
 -18, -18, -18, -18, -18, -18, 259, -33, -34, -37,
 257, -39, 257, -58, -39, -18, -18, 257, -18, 321,
 258, -51, 305, 258, -53, 298, 295, 296, 277, 263,
 306, 307, 308, 262, 309, 310, -67,  -2,  -2, 299,
 -47, 290, 291, 292, 293, 268, 299, -65,  -1, -32,
 257, -35, 257, -69, -54, 258, -59,  -1, 317, -63,
  -4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1, 258, -68,  -1, -45,  -4, -46, 258,
 -66,  -1, 299, -73, -71, 258, -70,  -1, 258, -55,
 317, 316, 258,  -1,  -4,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1, 299, -48, 294, 295,
 296, 297, 298, 277, 290, 267, 268, 299, -49, 294,
 295, 296, 297, 298, 277, 290, 267, 268,  -1,  -1,
  -1, 258, -74,  -1, 258, -72,  -2,  -1,  -1,  -1,
 322,  -2,  -2,  -4,  -1, 260,  -2, 259, -56,  -5,
  -4, 265, 266,  -4, -31,  -1, -57, 257,  -4,  -4,
  -4, -32, 299, -60,  -1, 258, -61,  -1, 260,  -1,
  -2 };
short yydef[]={

   2,  -2,   1,   3,   4,   5,   6,   7,   8,   0,
   0,  13,   0,   0,  -2,   0,   0,   0,   0,  25,
  -2,  30,  32,  -2,  -2,  -2,  -2,  46,  48,  50,
   0,   0,  58,  60,   0,  63,   0,   0,  -2,  70,
  72,   0,   0,  -2,  -2,   0, 189,   0,  11,  12,
 190,  14, 109,  15, 113,   0,   0,   0,  21,  22,
  24, 183,   0,  77,  23,  77,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  54,  56,   0,
   0,  62, 145,   0,  65,  66,   0,   0,  73,  74,
   0,   0, 188,   0,  10,   0,   0,  17, 167,   0,
   0, 184,   0,   0,  26,  28,  31, 162,  33,  35,
  38,  41,  44,  47,  49,  51,   0,   0,   0,  59,
 171,  61, 138,   0,  64,  68,  71, 159, 158,   0,
 108, 110,   0, 112, 114,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  19,  20,  85,
  78,  79,  80,  81,  82,  84,  96,   0,   0,  55,
 179,  57, 175,   0,   0, 144, 146, 147, 148,   0,
   0, 111, 116, 118, 120, 122, 124, 126, 128, 130,
 132, 134, 136, 166, 168, 169,   0,  83,   0, 161,
 163,   0,   0,   0,   0, 170, 172,   0, 137, 139,
   0,   0, 155,   0,   9, 115, 117, 119, 121, 123,
 125, 127, 129, 131, 133, 135,   0,  86,  87,  88,
  89,  90,  91,  92,  93,  94,  95,   0,  97,  98,
  99, 100, 101, 102, 103, 104, 105, 106, 107,   0,
   0, 178, 180,   0, 174, 176, 177, 173,  -2, 143,
   0,  75,  76, 164,   0,  52, 181,   0,   0,   0,
 185,   0,   0, 165,   0,   0, 142, 150, 160, 186,
 187,  53,   0,   0,   0, 149, 151,   0,   0, 152,
 182 };
/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: yaccpar,v 1.1.1.1 89/11/26 13:31:38 wje Exp $ */

#ifndef lint
/* static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83"; */
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 9:
# line 115 "gram.y"
{ AddIconRegion(yypvt[-4].ptr, yypvt[-3].num, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num); } break;
case 10:
# line 116 "gram.y"
{ if (Scr->FirstTime)
						  {
						    Scr->iconmgr.geometry=yypvt[-1].ptr;
						    Scr->iconmgr.columns=yypvt[-0].num;
						  }
						} break;
case 11:
# line 122 "gram.y"
{ if (Scr->FirstTime)
						    Scr->iconmgr.geometry = yypvt[-0].ptr;
						} break;
case 12:
# line 125 "gram.y"
{ if (Scr->FirstTime)
					  {
						Scr->DoZoom = TRUE;
						Scr->ZoomCount = yypvt[-0].num;
					  }
					} break;
case 13:
# line 131 "gram.y"
{ if (Scr->FirstTime) 
						Scr->DoZoom = TRUE; } break;
case 14:
# line 133 "gram.y"
{} break;
case 15:
# line 134 "gram.y"
{} break;
case 16:
# line 135 "gram.y"
{ list = &Scr->IconifyByUn; } break;
case 18:
# line 137 "gram.y"
{ if (Scr->FirstTime) 
		    Scr->IconifyByUnmapping = TRUE; } break;
case 19:
# line 139 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, False);
					} break;
case 20:
# line 142 "gram.y"
{ 
					  GotTitleButton (yypvt[-2].ptr, yypvt[-0].num, True);
					} break;
case 21:
# line 145 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR);
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = F_MENU;
					  Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = root;
					} break;
case 22:
# line 149 "gram.y"
{ Scr->Mouse[yypvt[-1].num][C_ROOT][0].func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->Mouse[yypvt[-1].num][C_ROOT][0].item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num,NULLSTR,NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 23:
# line 165 "gram.y"
{ GotKey(yypvt[-1].ptr, yypvt[-0].num); } break;
case 24:
# line 166 "gram.y"
{ GotButton(yypvt[-1].num, yypvt[-0].num); } break;
case 25:
# line 167 "gram.y"
{ list = &Scr->DontIconify; } break;
case 27:
# line 169 "gram.y"
{ list = &Scr->IconMgrNoShow; } break;
case 29:
# line 171 "gram.y"
{ Scr->IconManagerDontShow = TRUE; } break;
case 30:
# line 172 "gram.y"
{ list = &Scr->IconMgrs; } break;
case 32:
# line 174 "gram.y"
{ list = &Scr->IconMgrShow; } break;
case 34:
# line 176 "gram.y"
{ list = &Scr->NoTitleHighlight; } break;
case 36:
# line 178 "gram.y"
{ if (Scr->FirstTime)
						Scr->TitleHighlight = FALSE; } break;
case 37:
# line 180 "gram.y"
{ list = &Scr->NoHighlight; } break;
case 39:
# line 182 "gram.y"
{ if (Scr->FirstTime)
						Scr->Highlight = FALSE; } break;
case 40:
# line 184 "gram.y"
{ list = &Scr->NoStackModeL; } break;
case 42:
# line 186 "gram.y"
{ if (Scr->FirstTime)
						Scr->StackMode = FALSE; } break;
case 43:
# line 188 "gram.y"
{ list = &Scr->NoTitle; } break;
case 45:
# line 190 "gram.y"
{ if (Scr->FirstTime)
						Scr->NoTitlebar = TRUE; } break;
case 46:
# line 192 "gram.y"
{ list = &Scr->MakeTitle; } break;
case 48:
# line 194 "gram.y"
{ list = &Scr->StartIconified; } break;
case 50:
# line 196 "gram.y"
{ list = &Scr->AutoRaise; } break;
case 52:
# line 198 "gram.y"
{
					root = GetRoot(yypvt[-5].ptr, yypvt[-3].ptr, yypvt[-1].ptr); } break;
case 53:
# line 200 "gram.y"
{ root->real_menu = TRUE;} break;
case 54:
# line 201 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 55:
# line 202 "gram.y"
{ root->real_menu = TRUE; } break;
case 56:
# line 203 "gram.y"
{ root = GetRoot(yypvt[-0].ptr, NULLSTR, NULLSTR); } break;
case 58:
# line 205 "gram.y"
{ list = &Scr->IconNames; } break;
case 60:
# line 207 "gram.y"
{ color = COLOR; } break;
case 63:
# line 211 "gram.y"
{ color = MONOCHROME; } break;
case 65:
# line 213 "gram.y"
{ Scr->DefaultFunction.func = yypvt[-0].num;
					  if (yypvt[-0].num == F_MENU)
					  {
					    pull->prev = NULL;
					    Scr->DefaultFunction.menu = pull;
					  }
					  else
					  {
					    root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					    Scr->DefaultFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					  }
					  Action = "";
					  pull = NULL;
					} break;
case 66:
# line 229 "gram.y"
{ Scr->WindowFunction.func = yypvt[-0].num;
					   root = GetRoot(TWM_ROOT,NULLSTR,NULLSTR);
					   Scr->WindowFunction.item = 
						AddToMenu(root,"x",Action,
							  NULLSTR,yypvt[-0].num, NULLSTR, NULLSTR);
					   Action = "";
					   pull = NULL;
					} break;
case 67:
# line 237 "gram.y"
{ list = &Scr->WarpCursorL; } break;
case 69:
# line 239 "gram.y"
{ if (Scr->FirstTime) 
					    Scr->WarpCursor = TRUE; } break;
case 70:
# line 241 "gram.y"
{ list = &Scr->WindowRingL; } break;
case 72:
# line 246 "gram.y"
{ if (!do_single_keyword (yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
					"unknown singleton keyword %d\n",
						     yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 73:
# line 256 "gram.y"
{ if (!do_string_keyword (yypvt[-1].num, yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown string keyword %d (value \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 74:
# line 266 "gram.y"
{ if (!do_number_keyword (yypvt[-1].num, yypvt[-0].num)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
				"unknown numeric keyword %d (value %d)\n",
						     yypvt[-1].num, yypvt[-0].num);
					    ParseError = 1;
					  }
					} break;
case 75:
# line 278 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 76:
# line 281 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 79:
# line 288 "gram.y"
{ mods |= Mod1Mask; } break;
case 80:
# line 289 "gram.y"
{ mods |= ShiftMask; } break;
case 81:
# line 290 "gram.y"
{ mods |= LockMask; } break;
case 82:
# line 291 "gram.y"
{ mods |= ControlMask; } break;
case 83:
# line 292 "gram.y"
{ if (yypvt[-0].num < 1 || yypvt[-0].num > 5) {
					     twmrc_error_prefix();
					     fprintf (stderr, 
				"bad modifier number (%d), must be 1-5\n",
						      yypvt[-0].num);
					     ParseError = 1;
					  } else {
					     mods |= (Mod1Mask << (yypvt[-0].num - 1));
					  }
					} break;
case 84:
# line 302 "gram.y"
{ } break;
case 87:
# line 309 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 88:
# line 310 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 89:
# line 311 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 90:
# line 312 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 91:
# line 313 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 92:
# line 314 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 93:
# line 315 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 94:
# line 316 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 95:
# line 317 "gram.y"
{  } break;
case 98:
# line 324 "gram.y"
{ cont |= C_WINDOW_BIT; } break;
case 99:
# line 325 "gram.y"
{ cont |= C_TITLE_BIT; } break;
case 100:
# line 326 "gram.y"
{ cont |= C_ICON_BIT; } break;
case 101:
# line 327 "gram.y"
{ cont |= C_ROOT_BIT; } break;
case 102:
# line 328 "gram.y"
{ cont |= C_FRAME_BIT; } break;
case 103:
# line 329 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 104:
# line 330 "gram.y"
{ cont |= C_ICONMGR_BIT; } break;
case 105:
# line 331 "gram.y"
{ cont |= C_ALL_BITS; } break;
case 106:
# line 332 "gram.y"
{ } break;
case 107:
# line 333 "gram.y"
{ Name = yypvt[-0].ptr; cont |= C_NAME_BIT; } break;
case 111:
# line 344 "gram.y"
{ SetHighlightPixmap (yypvt[-0].ptr); } break;
case 115:
# line 355 "gram.y"
{
			NewBitmapCursor(&Scr->FrameCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 116:
# line 357 "gram.y"
{
			NewFontCursor(&Scr->FrameCursor, yypvt[-0].ptr); } break;
case 117:
# line 359 "gram.y"
{
			NewBitmapCursor(&Scr->TitleCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 118:
# line 361 "gram.y"
{
			NewFontCursor(&Scr->TitleCursor, yypvt[-0].ptr); } break;
case 119:
# line 363 "gram.y"
{
			NewBitmapCursor(&Scr->IconCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 120:
# line 365 "gram.y"
{
			NewFontCursor(&Scr->IconCursor, yypvt[-0].ptr); } break;
case 121:
# line 367 "gram.y"
{
			NewBitmapCursor(&Scr->IconMgrCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 122:
# line 369 "gram.y"
{
			NewFontCursor(&Scr->IconMgrCursor, yypvt[-0].ptr); } break;
case 123:
# line 371 "gram.y"
{
			NewBitmapCursor(&Scr->ButtonCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 124:
# line 373 "gram.y"
{
			NewFontCursor(&Scr->ButtonCursor, yypvt[-0].ptr); } break;
case 125:
# line 375 "gram.y"
{
			NewBitmapCursor(&Scr->MoveCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 126:
# line 377 "gram.y"
{
			NewFontCursor(&Scr->MoveCursor, yypvt[-0].ptr); } break;
case 127:
# line 379 "gram.y"
{
			NewBitmapCursor(&Scr->ResizeCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 128:
# line 381 "gram.y"
{
			NewFontCursor(&Scr->ResizeCursor, yypvt[-0].ptr); } break;
case 129:
# line 383 "gram.y"
{
			NewBitmapCursor(&Scr->WaitCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 130:
# line 385 "gram.y"
{
			NewFontCursor(&Scr->WaitCursor, yypvt[-0].ptr); } break;
case 131:
# line 387 "gram.y"
{
			NewBitmapCursor(&Scr->MenuCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 132:
# line 389 "gram.y"
{
			NewFontCursor(&Scr->MenuCursor, yypvt[-0].ptr); } break;
case 133:
# line 391 "gram.y"
{
			NewBitmapCursor(&Scr->SelectCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 134:
# line 393 "gram.y"
{
			NewFontCursor(&Scr->SelectCursor, yypvt[-0].ptr); } break;
case 135:
# line 395 "gram.y"
{
			NewBitmapCursor(&Scr->DestroyCursor, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 136:
# line 397 "gram.y"
{
			NewFontCursor(&Scr->DestroyCursor, yypvt[-0].ptr); } break;
case 140:
# line 409 "gram.y"
{ if (!do_colorlist_keyword (yypvt[-1].num, color,
								     yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled list color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 141:
# line 418 "gram.y"
{ list = do_colorlist_keyword(yypvt[-1].num,color,
								      yypvt[-0].ptr);
					  if (!list) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color list keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 143:
# line 429 "gram.y"
{ if (!do_color_keyword (yypvt[-1].num, color,
								 yypvt[-0].ptr)) {
					    twmrc_error_prefix();
					    fprintf (stderr,
			"unhandled color keyword %d (string \"%s\")\n",
						     yypvt[-1].num, yypvt[-0].ptr);
					    ParseError = 1;
					  }
					} break;
case 147:
# line 447 "gram.y"
{ do_string_savecolor(color, yypvt[-0].ptr); } break;
case 148:
# line 448 "gram.y"
{ do_var_savecolor(yypvt[-0].num); } break;
case 152:
# line 458 "gram.y"
{ if (Scr->FirstTime &&
					      color == Scr->Monochrome)
					    AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 153:
# line 463 "gram.y"
{ 
				    if (HasShape) Scr->SqueezeTitle = TRUE;
				} break;
case 154:
# line 466 "gram.y"
{ list = &Scr->SqueezeTitleL; 
				  if (HasShape && Scr->SqueezeTitle == -1)
				    Scr->SqueezeTitle = TRUE;
				} break;
case 156:
# line 471 "gram.y"
{ Scr->SqueezeTitle = FALSE; } break;
case 157:
# line 472 "gram.y"
{ list = &Scr->DontSqueezeTitleL; } break;
case 160:
# line 477 "gram.y"
{
				if (Scr->FirstTime) {
				   do_squeeze_entry (list, yypvt[-3].ptr, yypvt[-2].num, yypvt[-1].num, yypvt[-0].num);
				}
			} break;
case 164:
# line 492 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-2].ptr, (char *)
						AllocateIconManager(yypvt[-2].ptr, NULLSTR,
							yypvt[-1].ptr,yypvt[-0].num));
					} break;
case 165:
# line 498 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-3].ptr, (char *)
						AllocateIconManager(yypvt[-3].ptr,yypvt[-2].ptr,
						yypvt[-1].ptr, yypvt[-0].num));
					} break;
case 169:
# line 512 "gram.y"
{ if (Scr->FirstTime)
					    AddToList(list, yypvt[-0].ptr, 0);
					} break;
case 173:
# line 524 "gram.y"
{ if (Scr->FirstTime) AddToList(list, yypvt[-1].ptr, yypvt[-0].ptr); } break;
case 177:
# line 534 "gram.y"
{ AddToMenu(root, "", Action, NULLSTR, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					} break;
case 181:
# line 547 "gram.y"
{ AddToMenu(root, yypvt[-1].ptr, Action, pull, yypvt[-0].num,
						NULLSTR, NULLSTR);
					  Action = "";
					  pull = NULL;
					} break;
case 182:
# line 552 "gram.y"
{
					  AddToMenu(root, yypvt[-6].ptr, Action, pull, yypvt[-0].num,
						yypvt[-4].ptr, yypvt[-2].ptr);
					  Action = "";
					  pull = NULL;
					} break;
case 183:
# line 560 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 184:
# line 561 "gram.y"
{
				yyval.num = yypvt[-1].num;
				Action = yypvt[-0].ptr;
				switch (yypvt[-1].num) {
				  case F_MENU:
				    pull = GetRoot (yypvt[-0].ptr, NULLSTR,NULLSTR);
				    pull->prev = root;
				    break;
				  case F_WARPRING:
				    if (!CheckWarpRingArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.warptoring argument \"%s\"\n",
						 Action);
					yyval.num = F_NOP;
				    }
				  case F_WARPTOSCREEN:
				    if (!CheckWarpScreenArg (Action)) {
					twmrc_error_prefix();
					fprintf (stderr, 
			"ignoring invalid f.warptoscreen argument \"%s\"\n", 
					         Action);
					yyval.num = F_NOP;
				    }
				    break;
				  case F_COLORMAP:
				    if (CheckColormapArg (Action)) {
					yyval.num = F_COLORMAP;
				    } else {
					twmrc_error_prefix();
					fprintf (stderr,
			"ignoring invalid f.colormap argument \"%s\"\n", 
						 Action);
					yyval.num = F_NOP;
				    }
				    break;
				} /* end switch */
				   } break;
case 185:
# line 602 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 186:
# line 603 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
case 187:
# line 604 "gram.y"
{ yyval.num = -(yypvt[-0].num); } break;
case 188:
# line 607 "gram.y"
{ yyval.num = yypvt[-0].num;
					  if (yypvt[-0].num == 0)
						yyerror("bad button 0");

					  if (yypvt[-0].num > MAX_BUTTONS)
					  {
						yyval.num = 0;
						yyerror("button number too large");
					  }
					} break;
case 189:
# line 619 "gram.y"
{ ptr = (char *)malloc(strlen(yypvt[-0].ptr)+1);
					  strcpy(ptr, yypvt[-0].ptr);
					  RemoveDQuote(ptr);
					  yyval.ptr = ptr;
					} break;
case 190:
# line 624 "gram.y"
{ yyval.num = yypvt[-0].num; } break;
		}
		goto yystack;  /* stack new state and value */

	}
