.\" $XConsortium: MBToWC.man,v 1.2 91/10/08 15:24:21 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH _XConvertMBToWC 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
_XConvertMBToWC \- conversion from  CT string to mb string.
.SH SYNOPSIS
.B int _XConvertMBToWC\f2(xlocale, mb_str, mb_bytes, wc_str, wc_len,
.br
.B                                    \f2scanned_bytes, state)
.br
.B XLocale \f2xlocale\f3;
.br
.B unsigned char \f2*mb_str\f3;
.br
.B int \f2mb_bytes\f3;
.br
.B wchar \f2*wc_str\f3;
.br
.B int \f2*wc_len\f3;
.br
.B int \f2*scanned_bytes\f3;
.br
.B _State \f2*state\f3;
.br
.SH ARGUMENTS
.IP \fIxlocale\fP 1i
In: specifies locale, the default NULL is the current locale.
.IP \fImb_str\fP 1i 
In: multibyte string.
.br
.IP \fImb_bytes\fP 1i 
In: length of mb strings, counted in bytes.
.br
.IP \fIwc_str\fP 1i
Out: conversion buffer of result wchar string.
.br
.IP \fIwc_len\fP 1i 
In/Out: as "In" it is length of buffer wc_str passed by caller; 
as "Out" it is the returned number of converted wchars. 
.br
.IP \fIscanned_bytes\fP 1i 
Number of mb bytes converted when the function returns.
.br
.IP \fIstate\fP 1i
In/Out: as "In" it is the state at the beginning of mb string;
as "Out" it is the current state stopped at the last converted mb string.
.br
.SH DESCRIPTION
The
.B _XConvertMBToWC
converts the multibyte string encoded in the specfied \fIxlocale\fP
to wchar string.
After a successful conversion, the null character WNULL will be
appended to wc_str if there is room for it in the buffer.
The terminator WNULL
of wchar string is not counted in length of output buffer wc_len.
.PP
When function returns at any time, scanned_bytes always remembers
where stopped, and \fIstate\fP always remembers the curren state
of \fIxlocale\fP if it is state-dependent codeset.
.PP
The caller of this funcion has to provide the output buffer wc_str,
and store the buffer length(in wchars) into wc_len as input. 
By using \fIscanned_bytes\fP and \fIstate\fP, the caller can break a large
mb string into pieces, and convert one piece at a time.
.PP
In other hand caller can pass any broken mb 
string to this function for doing conversion.
For example, caller can still be trying of conversion when 
the error BadBuffer is occurred(output buffer was exhausted).
If the codeset of the \fIxlocale\fP is state-dependent and
the mb_str is passed as NULL pointer, the function will set
initial state in the \fIxlocale\fP.
Usually, the application should calls it with NULL mb_str for first 
conversion as the following:
.IP "" "   "
\f3_XConvertMBToWC(NULL, mb_bytes, wc_str,
            &mb_len, &scanned)\f2
.PP
The function returns the BadBuffer meaning that
the output buffer wc_str was exhausted.
The function returns the BadTerminate meaning that
the mb string is terminated uncompletely, 
e.g., uncompleted ESC sequence or
uncompleted code point ended at tail of mb_str.
.PP
Only in both the case of BadBuffer and BadTerminate the
caller can
move pointer mb_str to (mb_str + *scanned_bytes), then continue
to do conversion.
And function ensure that the wc_str stores the already converted
wchar string; wc_len counts
the number of them in wchars(not bytes); 
.PP
The function returns a number greate than zero meaning a number of
wrong codepoints recovered by the funcition.
The wrong codepoint
will be recovered with the first codepoint of the charset at which
the wrong codepoint occurs.
After replaced, the function will continue to do conversion untill
one of the results Success, BadTerminate, BadBuffer or BadEncoding
is met.
.PP
Both the null character and mb_bytes will terminate the conversion.
.PP
All error status are defined to be less than zero, i.e.:
.IP "" 2
#define Success          0
.IP
#define BadBuffer       -1
.IP
#define BadTerminate    -2
.IP
#define BadEncoding     -3
.SH RETURNED VALUE
The
.B _XConvertMBToWC will return the following values:
.TP
.B Success
successful conversion.
.TP
.B BadBuffer
output buffer(wc_str) was exhausted.
.TP
.B BadTerminate
mb_str terminated at uncomplete codepoint.
.TP
.B BadEncoding 
wrong codepoints can not be recovered.
.TP
.B "> 0"
number of wrong codepoints, but recovered.
.SH SEE ALSO
Refer to "CT and WC" for their definitions.
