.\" $XConsortium: WCToCT.man,v 1.2 91/10/08 15:24:23 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH _XConvertWCToCT 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
_XConvertWCToCT \- conversion from  WC string to CT
.SH SYNOPSIS
.B int _XConvertWCToCT\f2(xlocale, wc_str, wc_len, ct_str, ct_bytes, scanned_len)
.br
.B XLocale \f2xlocale\f3;
.br
.B wchar \f2*wc_str\f3;
.br
.B int \f2wc_len\f3;
.br
.B char \f2*ct_str\f3;
.br
.B int \f2*ct_bytes\f3;
.br
.B int \f2*scanned_len\f3;
.SH ARGUMENTS
.IP \fIxlocale\fP 1i
In: specifies locale, the default NULL is the current locale.
.IP \fIwc_str\fP 1i
In: wchar string.
.br
.IP \fIwc_len\fP 1i 
In: length of wchar string, counted in wchars.
.br
.IP \fIct_str\fP 1i 
Out: conversion buffer of result CT string.
.br
.IP \fIct_bytes\fP 1i 
In/Out: as "In" it is length of buffer ct_str
passed by caller; as "Out" it is the returned
length of converted CT string, both counted in bytes
.br
.IP \fIscanned_len\fP 1i 
Out: scanned number of wchars,
counted in wchars
.br
.SH DESCRIPTION
The
.B _XConvertWCToCT
converts the string encoded in wchar to string encoded in CT.
After a successful conversion the default state designation of CT will
be appended at ct_str if the last state is not same as default state.
And function will automatically
append a null character to ct_str if more room in output buffer ct_str.
This null character is not counted in length of CT string.
.PP
When fucntion returns at any time, scanned_len always remembers
where stopped.
.PP
The caller of this funcion has to provide the output buffer ct_str.
By using scanned_len, the caller can break a large
wchar string into pieces, and convert one piece at a time.
The result of CT string is concatenatable. However concatenation
may produce reduntant designation sequence.
.PP
The function returns BadBuffer meaning that
the output buffer ct_str was exhausted. In this case function
ensure that the ct_str
stores already converted CT string; ct_bytes stores 
number of bytes of ct_str; the scanned_len stores
the number of already proccessed wchars. 
Caller can move wc_str to (wc_str + *scanned_len) for next conversion.
.PP
The function returns a number greate than zero meaning a BadEncoding,
the unconvertable codes in wchar string were met.
In this case the function will automatically recover the wrong code
with the following algorithm:
.IP "" 2
If a byte of wchar code is wrong, replace it with the mininum character 
of the current encoding.
.PP
Then function continues to do conversion.
.PP
Both the WNULL character and wc_len will terminate the conversion.
.PP
All errors are defined less than zero, i.e.:
.IP "" 2
#define Success         0
.IP 
#define BadBuffer      -1
.IP
#define BadTerminate   -2
.IP
#define BadEncoding    -3
.SH RETURNED VALUE
The
.B _XConvertWCToCT returns the following value:
.TP
.B Success
successful conversion.
.TP
.B BadBuffer
buffer was exhausted.
.TP
.B BadEncoding
wrong codepoints can not be recovered.
.TP
.B "> 0"
number of wrong codepoints, but recovered.
.SH "SEE ALSO"
Refer to "CT and WC" for their definitions.
