.ds xL Programming with Xlib
.TH XListInputDevices 3X11 "Release 5" "X Version 11" "X FUNCTIONS"
.SH NAME
XListInputDevices, XFreeDeviceList \- list available input devices
.SH SYNTAX
XDeviceInfo *XListInputDevices\^(\^\fIdisplay\fP, \fIndevices_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int *\fIndevices_return\fP\^;
.sp
XFreeDeviceList\^(\^\fIlist\fP\^)
.br
      XDeviceInfo *\fIlist\fP\^;
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I ndevices_return
Specifies a pointer to a variable where the number of available devices can
be returned.
.TP 12
.I list
Specifies the list of devices to free.  The \fIXFreeDeviceList\fP function
frees the list of available extension input devices.
.SH DESCRIPTION
The \fIXListInputDevices\fP
request lists the available extension input devices.  This list includes the
X pointer and X keyboard, any other input devices that are currently accessible
through the X server, and any input devices that are not currently accessible
through the X server but could be accessed if requested.
.P
Some server implementations may make all input devices available at the time
the server is initialized.  Others may wait until requested by a client to
access an input device.  In the latter case, it is possible that an input 
device will be listed as available at one time but not at another.
.P
For each input device available to the server, the XListInputDevices
request returns an XDeviceInfo structure.  That structure contains a
pointer to a list of structures, each of which contains information about 
one class of input supported by the device.

The XDeviceInfo structure is defined as follows:

.DS
.nf
typedef struct _XDeviceInfo
{
	XID		id;        
	Atom		type;
	char		*name;
	int		num_classes;
	int		use;
	XAnyClassPtr	inputclassinfo;
} XDeviceInfo;
.fi
.DE
.P
The id is a number in the range 0-128 that uniquely identifies 
the device.  It is assigned to the device when it is initialized by the server.
.P
The type field is of type Atom and indicates the nature
of the device.
.P
The name field contains a pointer to a null-terminated
string that corresponds to one of the defined device
types.  The name will correspond to one of the following
strings (defined in the header file \fIXI.h\fP:
.P
.DS
XI_MOUSE
XI_TABLET
XI_KEYBOARD
XI_TOUCHSCREEN
XI_TOUCHPAD
XI_BUTTONBOX
XI_BARCODE
XI_TRACKBALL
XI_QUADRATURE
XI_ID_MODULE
XI_ONE_KNOB
XI_NINE_KNOB
XI_KNOB_BOX
XI_SPACEBALL
XI_DATAGLOVE
XI_EYETRACKER
XI_CURSORKEYS
XI_FOOTMOUSE
.DE
.P
These names may be directly compared with the name field of the
XDeviceInfo structure, or used in an XInternAtom request to return
an atom that can be compared with the type field of the XDeviceInfo
structure.
.P
The num_classes field is a number in the
range 0-255 that specifies the number of input classes
supported by the device for which information is
returned by ListInputDevices.  Some input classes, such
as class Focus and class Proximity do not have any
information to be returned by ListInputDevices.
.P
The use field specifies how the device is currently
being used.  If the value is \fIIsXKeyboard\fP, the device is
currently being used as the X keyboard.  If the value
is \fIIsXPointer\rP, the device is currently being used as
the X pointer.  If the value is \fIIsXExtensionDevice\fP, the
device is available for use as an extension device.
.P
The inputclassinfo field contains a pointer to the first input-class
specific data.  The first two fields are common to all
classes.
.P
The class field is a number in the range 0-255.
It uniquely identifies the class of input for which
information is returned.  Currently defined classes
are KeyClass, ButtonClass, and ValuatorClass.
.P
The length field is a number in the range 0- 255.  
It specifies the number of bytes of data that are
contained in this input class.  The length includes the
class and length fields.
.P
The XKeyInfo structure describes the characteristics of the keys on the
device.  It is defined as follows:
.P
.DS
.nf
typedef struct _XKeyInfo {
	XID			class;
	int			length;
	unsigned short		min_keycode;
	unsigned short		max_keycode;
	unsigned short		num_keys;
} XKeyInfo;
.fi
.DE
.P
min_keycode is of type KEYCODE.  It specifies the
minimum keycode that the device will report.  The
minimum keycode will not be smaller than 8.
.P
max_keycode is of type KEYCODE.  It specifies the
maximum keycode that the device will report.  The
maximum keycode will not be larger than 255.
.P
num_keys specifies the number of keys that the device has.
.P
The XButtonInfo structure defines the characteristics of the buttons
on the device.  It is defined as follows:
.P
.DS
.nf
typedef struct _XButtonInfo {
	XID		class;
	int		length;
	short		num_buttons;
} XButtonInfo;
.fi
.DE
.P
num_buttons specifies the number of buttons that the device has.
.P
The XValuatorInfo structure defines the characteristics of the valuators
on the device.  It is defined as follows:
.P
.DE
.nf
typedef struct	_XValuatorInfo {
	XID			class;
	int			length;
	unsigned char		num_axes;
	unsigned char		mode;
	unsigned long		motion_buffer;
	XAxisInfoPtr		axes;
} XValuatorInfo;
.fi
.DS
num_axes contains the number of axes the device supports.
.P
mode is a constant that has one of the following
values: Absolute or Relative.  Some devices allow the
mode to be changed dynamically via the SetDeviceMode
request.
.P
motion_buffer_size is a cardinal number that specifies
the number of elements that can be contained in the
motion history buffer for the device.
.P
The axes field contains a pointer to an XAxisInfo structure.
.P
The XAxisInfo structure is defined as follows:
.P
.DS
.nf
typedef struct _XAxisInfo {
	int 	resolution;
	int 	min_value;
	int 	max_value;
} XAxisInfo;
.fi
.DE
.P
The resolution contains a number in counts/meter.
.P
The min_val field contains a number that specifies
the minimum value the device reports for this axis.
For devices whose mode is Relative, the min_val field
will contain 0.
.P
The max_val field contains a number that specifies
the maximum value the device reports for this axis.
For devices whose mode is Relative, the max_val field
will contain 0.
.P
To free the \fIXDeviceInfo\fP array created by \fIXListInputDevices\fP,
use \fIXFreeDeviceList\fP.
.SH DIAGNOSTICS
none.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
