.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XmbDrawText 3X11 "Release 5" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XmbDrawText, XwcDrawText \- draw text using multiple font sets 
.SH SYNTAX
void XmbDrawText\^(\^\fIdisplay\fP\^, \fId\fP\^, \fIgc\fP\^, \fIx\fP\^, \fIy\fP\^, \fIitems\fP\^, \fInitems\fP\^)
.br
      Display *\fIdisplay\fP\;
.br
      Drawable \fId\fP\^;
.br
      GC \fIgc\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.br
      XmbTextItem *\fIitems\fP\^;
.br
      int \fInitems\fP\^;
.LP
void XwcDrawText\^(\^\fIdisplay\fP\^, \fId\fP\^, \fIgc\fP\^, \fIx\fP\^, \fIy\fP\^, \fIitems\fP\^, \fInitems\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Drawable \fId\fP\^;
.br
      GC \fIgc\fP\^;
.br
      int \fIx\fP\^, \fIy\fP\^;
.br
      XwcTextItem *\fIitems\fP\^;
.br
      int \fInitems\fP\^;
.SH ARGUMENTS
.\" $Header: d.a,v 1.1 88/02/26 10:04:25 mento Exp $
.IP \fId\fP 1i
Specifies the drawable. 
.\" $Header: display.a,v 1.1 88/02/26 10:26:29 mento Exp $
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.\" $Header: gc.a,v 1.2 88/05/09 11:20:34 mento Exp $
.IP \fIgc\fP 1i
Specifies the GC.
.\" $Header: items.a,v 1.1 88/02/26 10:28:21 mento Exp $
.IP \fIitems\fP 1i
Specifies an array of text items.
.\" $Header: nitems.a,v 1.1 88/02/26 10:29:33 mento Exp $
.IP \fInitems\fP 1i
Specifies the number of text items in the array.
.ds Xy
.\" $Header: xy_gen.a,v 1.2 88/08/04 11:22:37 mento Exp $
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
.ZN XmbDrawText
and 
.ZN XwcDrawText 
allow complex spacing and font set shifts between text strings.
Each text item is processed in turn, with the origin of a text
element advanced in the primary draw direction by the escapement of the
previous text item.
A text item delta specifies an additional escapement of the text item
drawing origin in the primary draw direction.
A font_set member other than 
.ZN None
in an item causes the font set to be used for this and subsequent text items
in the text_items list.
Leading text items with font_set member set to
.ZN None
will not be drawn.
.LP
.ZN XmbDrawText
and
.ZN XwcDrawText
do not perform any context-dependent rendering between text segments.
Clients may compute the drawing metrics by passing each text segment to
.ZN XmbTextExtents
and XwcTextExtents
or 
.ZN XmbTextPerCharExtents
and
.ZN XwcTextPerCharExtents .
When the 
.ZN XFontSet
has missing charsets, each unavailable character is drawn 
with the default string returned by 
.ZN XCreateFontSet .
The behavior for an invalid codepoint is undefined.
.SH STRUCTURES
The
.ZN XmbTextItem
structure contains:
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	char *chars;	/* pointer to string */
	int nchars;	/* number of characters */
	int delta;	/* pixel delta between strings */
	XFontSet font_set; 	/* fonts, None means don't change */
} XmbTextItem;
.De
The
.ZN XwcTextItem
structure contains:
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	wchar_t *chars;	/* pointer to wide char string */
	int nchars;	/* number of wide characters */
	int delta;	/* pixel delta between strings */
	XFontSet font_set;	/* fonts, None means don't change */
} XwcTextItem;
.De
.SH "SEE ALSO"
XDrawImageString(3X11),
XDrawString(3X11),
XDrawText(3X11),
XmbDrawImageString(3X11),
XmbDrawString(3X11)
.br
\fI\*(xL\fP
