.\" $XConsortium: XmacII.man,v 1.8 91/07/27 16:17:30 rws Exp $
.TH XMACII 1 "Release 5" "X Version 11"
.SH NAME
XmacII \- Macintosh II server for X Version 11
.SH SYNOPSIS
.B XmacII
[ option ] ...
.SH DESCRIPTION
.I XmacII
is the server for Version 11 of the X window system on Macintosh II hardware running A/UX.
It will normally be started by the shell script
.IR X11.
.fi
.SH CONFIGURATIONS
.I XmacII
operates under A/UX Release 1.0 and later.
Under A/UX Release 1.0, the server supports a single monochrome display.
Color and multiple screens are supported under A/UX Release 1.1 and later.
.SH OPTIONS
The following options can be given on the command line to the X server.
.TP 8
.B \-screen \fInumber\fP \-depth \fInumber\fP
arranges that the given screen will operate at the given depth.
Screens are numbered from 0 and correspond to the relative position
of video cards in the Macintosh II slots.
Supported depths are 1 (monochrome at 1 bit per pixel, the default value),
and 8 (color at 8 bits per pixel, indexing a colormap with 256 entries).
Multiple screens and color support require A/UX Release 1.1 or later.
.TP 8
.B \-a \fInumber\fP
sets pointer acceleration (i.e. the ratio of how much is reported to how much
the user actually moved the pointer).
.TP 8
.B \-logo
turns on the X Window System logo display in the screen-saver.
There is currently no way to change this from a client.
.TP 8
.B nologo
turns off the X Window System logo display in the screen-saver.
There is currently no way to change this from a client.
.TP 8
.B \-p \fIminutes\fP
sets screen-saver pattern cycle time in minutes.
.TP 8
.B \-r
turns off auto-repeat.
.TP 8
.B r
turns on auto-repeat.
.TP 8
.B \-s \fIminutes\fP
sets screen-saver timeout time in minutes.
.TP 8
.B \-t \fInumbers\fP
sets pointer acceleration threshold in pixels (i.e. after how many pixels
pointer acceleration should take effect).
.TP 8
.B \-to \fIseconds\fP
sets default screensaver timeout in seconds.
.TP 8
.B \-co \fIfilename\fP
sets name of RGB color database
.TP 8
.B \-help
prints a usage message
.TP 8
.B \-fp \fIfontPath
sets the search path for fonts
.TP 8
.B \-fc \fIcursorFont\fP
sets default cursor font
.TP 8
.B \-fn \fIfont\fP
sets the default font
.SH "BUTTON MAPPINGS"
Many X clients assume the mouse has three buttons. The A/UX X server simulates
the middle and right mouse buttons with keystrokes -- the left-arrow key
generates middle button events, and the right-arrow key generates right button
events -- the real mouse button generates left button events. The 
open-apple or cloverleaf key is the "Meta" modifier, Meta can also be obtained
by pressing the up-arrow key. The down-arrow key duplicates the Control key.
Meta, Control, and Shift are often used in combination with other keystrokes
or mouse clicks. For example, the terminal emulator xterm pops up menus in
response to control-left and control-middle. The original function of the
arrow keys may be obtained by holding down the Option key while pressing
one of the arrow keys.
.SH "SECURITY"
.I X
uses an access control list for deciding whether or not to accept a
connection from a given client.  This list
initially consists of the machine on which the server is running, and any
hosts listed in the file
\fI/etc/X0.hosts\fP
This file should contain one line
per host name, with no white space.  
.PP
The user can manipulate a dynamic form of this list in the server
using the \fIxhost(1)\fP program from
the same machine as the server.
.PP
Unlike some window systems, \fIX\fP does not have any notion of 
window operation permissions or
place any restrictions on what a client can do; if
a program can connect to a display, it has full run of the screen.  There
is support for using 
authentication services on connection startup beyond the simple host name
check, but it is not used in the standard distribution.
.SH "FONTS"
Fonts are stored in individual files in the directory(ies) named by
the font search path.  These files may be created by the \fIfc\fP utility.
The name of the file must correspond to the name of the font in lowercase
with the suffix ".snf" appended.
Font files may be stored in \fIcompress\fP(1) format, in which case an
additional suffix (usually ".Z", defined when the server is built) must
be appended to the usual filename.
.SH "FILES"
.TP 30
/usr/bin/X11/X11 
Bourne shell script which starts the server and initial 
.I xterm 
client
.TP 30
$HOME/.x11start 
Bourne shell script executed by initial 
.I xterm 
client which starts a slew of other clients. 
Reference copy in /usr/lib/X11/.x11start
.TP 30
/usr/bin/X11/XmacII 
the server binary
.TP 30
/usr/bin/X11/Xrepair 
ensures console viability after server exits
.TP 30
/usr/bin/X11/* 
client binaries
.TP 30
/usr/lib/X11/fonts/*
.TP 30
/usr/lib/X11/rgb.{dir,pag,txt} 
color names to RGB mapping
.TP 30
/etc/X0.hosts
Initial access control list
.TP 30
/tmp/.X11-unix/X0
Unix domain socket
.TP 30
/usr/adm/X0msgs
Error log file
.TP 30
$HOME/.twmrc 
customization for the
.I twm
window manager. Reference copy in /usr/lib/X11/Sample.twmrc
.TP 30
$HOME/.uwmrc 
customization for the
.I uwm
window manager. Reference copy in /usr/lib/X11/default.uwmrc
.TP 30
/usr/lib/X11/XErrorDB 
client error message database
.TP 30
/usr/lib/X11/app-defaults 
client specific resource specifications
.TP 30
/usr/lib/X11/examples/Xaw/* 
source code examples of applications built on the
.I X
Toolkit
.TP 30
/usr/lib/terminfo/x/xterm* 
.I terminfo
database entries descibing the terminal emulation capabilities of the
.I xterm
client. Reference copies in /usr/lib/X11/xterm*.tic
.TP 30
/usr/include/X11/bitmaps/*icon 
bitmap representations of icons used by the
.I twm
window manager
.SH "SEE ALSO"
xinit(1), X(1)
.SH BUGS
In the unlikely event the server crashes,  
it may leave the keyboard in a non-useful state.
The X11 script executes the
.I Xrepair
command in an attempt to repair the damage.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
