/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: fb_ioctl.h,v 1.5 92/08/06 17:10:02 dd Exp $ */
#ifndef _SYS_FB_IOCTL_H
#define	_SYS_FB_IOCTL_H

#include <svr4/sys/ioccom.h>

/*
 * Interface for simple frame buffers
 */

#define	_IOC_FB	('F' | 128)

/*
 * basic information
 */
struct fb_type {
	short type;		/* type code (see below) */
	short flags;		/* defined per-type */
	short width;		/* visible pixels per scan line */
	short height;		/* visible scan lines */
};

#define	FB_GET_TYPE		_IOR(_IOC_FB, 0, struct fb_type)

#define	FB_TYPE_VDR2	0	/* G300, 2M VRAM */
#define	FB_TYPE_VDR1	1	/* G364, 2M VRAM */
#define	FB_TYPE_MIPS1	0x10	/* G364, 2M VRAM */
#define	FB_TYPE_MIPS2	0x11	/* G365, 2M VRAM */
#define	FB_TYPE_MIPS3	0x12	/* G332, 1M VRAM */

/*
 * memory mapping information
 * - depth = -1 returns mmap information for registers, if any
 * - if low byte of mmap_offset is non-zero, it's a shm key (!)
 */
struct fb_mapinfo {
	short depth;		/* bits populated per pixel (in/out) */
	short bits_per_pixel;	/* space occupied per pixel */
	short width;		/* pixels populated per scan line */
	short pixels_per_line;	/* space occupied per scan line */
	short height;		/* scan lines populated */
	short class;		/* visual class (should be elsewhere) */
	off_t mmap_offset;
	size_t mmap_size;	/* for convenience */
};

#define	FB_GET_MAPINFO		_IOWR(_IOC_FB, 1, struct fb_mapinfo)

/*
 * video control: parameter value 0 = video off, 1 = video on
 */
#define	FB_SET_VIDEO		_IOW(_IOC_FB, 2, int)
#define	FB_GET_VIDEO		_IOR(_IOC_FB, 3, int)


/*
 * color map access
 */
struct fb_colormap {
	short map;		/* which colormap */
	short index;		/* first element */
	short count;		/* number of elements */
	unsigned char *rgb;	/* RGB values (8 bits each) */
};

#define	FB_SET_COLORMAP		_IOW(_IOC_FB, 4, struct fb_colormap)
#define	FB_GET_COLORMAP		_IOW(_IOC_FB, 5, struct fb_colormap)


/*
 * hardware cursor control
 */

struct fb_cursor_xy {
	short x, y;
};

struct fb_cursor {
	char set;		/* what to set */
#define	FB_CUR_SETCUR	0x01
#define	FB_CUR_SETPOS	0x02
#define	FB_CUR_SETHOT	0x04
#define	FB_CUR_SETCOLORMAP 0x08
#define	FB_CUR_SETSHAPE	0x10
#define	FB_CUR_SETALL	0x1f
	char enable;		/* cursor on/off */
	unsigned char rgb[6];	/* bg/fg RGB values */
	struct fb_cursor_xy pos; /* cursor position */
	struct fb_cursor_xy hot; /* cursor hot spot */
	int shape_bytes;	/* bytes of data */
	char *shape_data;	/* formatted data */
};

/* set/get cursor data */
#define FB_SET_CURSOR		_IOW(_IOC_FB, 6, struct fb_cursor)
#define FB_GET_CURSOR		_IOWR(_IOC_FB, 7, struct fb_cursor)

/* get maximum cursor size */
#define	FB_GET_CURSOR_SIZE	_IOR(_IOC_FB, 8, struct fb_cursor_xy)

/* set cursor position only */
#define	FB_SET_CURSOR_POSITION	_IOW(_IOC_FB, 9, struct fb_cursor_xy)

/* reformat cursor data */
struct fb_cursor_shape {
	struct fb_cursor_xy size; /* cursor bit map size */
	unsigned int *image;	/* cursor image bits (32 bit padded) */
	unsigned int *mask;	/* cursor mask bits (32 bit padded) */
	int shape_bytes;	/* bytes of data */
	char *shape_data;	/* formatted data */
};
#define	FB_FORMAT_CURSOR	_IOWR(_IOC_FB, 10, struct fb_cursor_shape)
#define	FB_UNFORMAT_CURSOR	_IOWR(_IOC_FB, 11, struct fb_cursor_shape)


/* FB_REMAP is a temporary hack to allow use of large pages on R4000 */
struct fb_map {
	caddr_t addr;
	size_t size;
};

#define	FB_REMAP		_IOW(_IOC_FB, 90, struct fb_map)
#define	FB_UNMAP		_IOW(_IOC_FB, 91, struct fb_map)

#ifdef MIPS_LOCAL
/* debugging aid */
#define	FB_DUMPTLB		_IO(_IOC_FB, 99)
#endif /* MIPS_LOCAL */

#endif /* _SYS_FB_IOCTL_H */
