/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1992 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved				       |
 * |-----------------------------------------------------------|
 * |	      Restricted Rights Legend			       |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in		       |
 * | subparagraph (c)(1)(ii) of the Rights in Technical	       |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |	     MIPS Computer Systems, Inc.		       |
 * |	     950 DeGuigne Avenue			       |
 * |	     Sunnyvale, California 94088-3650, USA	       |
 * |-----------------------------------------------------------|
 */
/* $Header: fb_vdr2.h,v 1.2 92/04/06 21:01:49 dd Exp $ */
#ifndef _SYS_FB_VDR2_H
#define	_SYS_FB_VDR2_H

/*
 * "VDR2" frame buffer description
 */

/* Inmos G300 video controller */

typedef struct {
#ifdef _MIPSEL
	volatile unsigned int r;
	int pad;
#else /* _MIPSEL */
	int pad;
	volatile unsigned int r;
#endif /* _MIPSEL */
} g300_reg;

struct g300 {
	g300_reg cmap[256];	/* 0x000 .. 0x0ff */
	g300_reg pad121[0x21];
	g300_reg halfsync;	/* 0x121 */
	g300_reg backporch;	/* 0x122 */
	g300_reg display;	/* 0x123 */
	g300_reg shortdisplay;	/* 0x124 */
	g300_reg broadpulse;	/* 0x125 */
	g300_reg vsync;		/* 0x126 */
	g300_reg vblank;	/* 0x127 */
	g300_reg vdisplay;	/* 0x128 */
	g300_reg linetime;	/* 0x129 */
	g300_reg linestart;	/* 0x12a */
	g300_reg meminit;	/* 0x12b */
	g300_reg xferdelay;	/* 0x12c */
	g300_reg pad140[0x13];
	g300_reg mask;		/* 0x140 */
	g300_reg pad160[0x1f];
	g300_reg control;	/* 0x160 */
	g300_reg pad180[0x1f];
	g300_reg top;		/* 0x180 */
	g300_reg pad1a0[0x1f];
	g300_reg boot;		/* 0x1a0 */
	g300_reg pad1b0[0x0f];
	g300_reg null;		/* 0x1b0 */
	g300_reg pad200[0x4f];
};


/*
 * boot register
 */
#define	G300_BOOTVAL(mult)	(0x20 + (mult))		/* PLL mode */

/*
 * control register values:
 *	address step = 512
 *	bits per pixel = 8
 *	CBlank pin is output
 *	sync delay = 1
 *	separate sync
 *	plain synchronizing waveform
 */
#define	G300_CONTROL_OFF	0x170418
#define	G300_CONTROL_ON		0x170419

/* transfer delay */
#define	G300_XFER_DELAY 36


/* Brooktree Bt431 cursor generator */

typedef struct {
#ifdef _MIPSEL
	volatile unsigned short r;
	short pad[3];
#else /* _MIPSEL */
	short pad[3];
	volatile unsigned short r;
#endif /* _MIPSEL */
} bt431_reg;

struct bt431 {
	bt431_reg adlo;
	bt431_reg adhi;
	bt431_reg ram;
	bt431_reg ctrl;
	char pad[4096 - 4 * sizeof (bt431_reg)];
};

#define	BT431_SETADDR(p, a)	((p)->adhi.r = (a) >> 8, (p)->adlo.r = (a))

/* Bt431 addresses */
#define	BT431_VAL(a)	((a) * 0x101)
#define	BT431_CMAPRAM	BT431_VAL(0x000)
#define	BT431_COMMAND	BT431_VAL(0x000)
#define		BT431_COMMAND_CURSOFF	BT431_VAL(0x04)	/* cursor enable */
#define		BT431_COMMAND_CURSON	BT431_VAL(0x44)	/* cursor enable */

#define	BT431_CURSMAX	64	/* cursor size */
#define	BT431_CURSBYTES	(64 * 64 * 2 / 8)


/*
 * "VDR2" color frame buffer registers
 */
struct vdr2_reg {
	struct g300 ramdac;	/* 0x60000000 .. 0x60001000 */
	char pad[0x7000];
	struct bt431 cursor;	/* 0x60008000 .. 0x60009000 */
};

#endif /* _SYS_FB_VDR2_H */
