/*
 * $XConsortium$
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ident	"$Header: mips2030.c,v 1.7 91/11/12 12:11:30 dd Exp $"

#include <sys/types.h>
#include <sysv/sys/grafreg.h>
#include <sysv/sys/termio.h>
#include <sysv/sys/kbd_ioctl.h>

#include <X.h>
#include <Xproto.h>
#include <misc.h>
#include <colormapst.h>
#include <input.h>
#include <scrnintstr.h>

#include "mips.h"
#include "mipsFb.h"
#include "mipsKbd.h"
#include "mipsIo.h"
#include "mips2030.h"

#ifndef MIPSEL

extern char *mipsMapit();

static void Blank2030();
static int WriteCMapIoctl();
static void WriteCMap2030();

Bool
mipsMap2030(pm)
	MipsScreenPtr pm;
{
	if (!pm->fbreg && (
		!(pm->fbnocache = (unsigned char *) mipsMapit((char *) 0,
			GBUFKEY, GRAPHICS_FRAME_SIZE)) ||
		!(pm->fbreg = (unsigned char *) mipsMapit((char *) 0,
			GREGKEY, GRAPHICS_REG_SIZE))))
		return FALSE;

	pm->fbnorm = pm->fbnocache;

	mipsInitColor(pm);

	pm->fb_width = RS2030_BPSL;
	pm->Blank = Blank2030;

	/* open keyboard for colormap access */
	openKeybd();

	/* KTCWRTCOLOR is broken in RISC/os 5.0 beta kernels */
	if (WriteCMapIoctl(pm, 0, 0, (unsigned char *) pm))
		pm->WriteCMap = (void (*)()) WriteCMapIoctl;
	else {
		pm->WriteCMap = WriteCMap2030;
		keybdPriv.cap &= ~DEV_COLORMAP;
	}

#if MIPS_4BIT
	{
		struct bt458 *ramdac =
			&((struct rs2030_reg *) pm->fbreg)->ramdac;

		/*
		 * Set read mask for number of planes populated.
		 * XXX The PROM and/or kernel should take care of this.
		 */
		ramdac->addr = BT458_READMASK;
		ramdac->ctrl = (1 << pm->depth) - 1;
	}
#endif /* MIPS_4BIT */

	return TRUE;
}

static void
Blank2030(pm, on)
	MipsScreenPtr pm;
	Bool on;
{
	struct rs2030_reg *reg = (struct rs2030_reg *) pm->fbreg;

	if (on != SCREEN_SAVER_ON)
		reg->unblank = 0;
	else
		reg->blank = 0;
}

/*ARGSUSED*/
static int
WriteCMapIoctl(pm, index, count, rgb)
	MipsScreenPtr pm;
	int index;
	int count;
	unsigned char *rgb;
{
	struct colorm cm;

	cm.cmstart = index;
	cm.cmcount = count;
	bcopy((char *) rgb, (char *) cm.cmap, count * 3);

	return sysvIoctl(keybdPriv.fd, KTCWRTCOLOR, &cm) >= 0;
}

static void
WriteCMap2030(pm, index, count, rgb)
	MipsScreenPtr pm;
	int index;
	int count;
	unsigned char *rgb;
{
	struct bt458 *ramdac =
		&((struct rs2030_reg *) pm->fbreg)->ramdac;
	volatile unsigned char *out = &ramdac->cmap;

	ramdac->addr = index;

	while (--count >= 0) {
		*out = rgb[0];
		*out = rgb[1];
		*out = rgb[2];
		rgb +=3;
	}
}

#endif /* not MIPSEL */
