/*
 * $XConsortium$
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ident	"$Header: mipsColor.c,v 1.8 91/10/12 16:22:35 dd Exp $"

#include <sys/types.h>

#include "X.h"
#include "Xproto.h"
#include "scrnintstr.h"
#include "colormapst.h"
#include "windowstr.h"
#include "input.h"

#include "mips.h"
#include "mipsFb.h"

int
mipsListInstalledColormaps(pScreen, pmaps)
	ScreenPtr pScreen;
	Colormap *pmaps;
{
	MipsScreenPtr pm = MipsScreenToPriv(pScreen);

	/* By the time we are processing requests, we can guarantee that
	 * there is always a colormap installed */

	*pmaps = pm->InstalledMap->mid;
	return 1;
}

void
mipsStoreColors(pmap, ndef, pdefs)
	ColormapPtr pmap;
	int ndef;
	xColorItem *pdefs;
{
	MipsScreenPtr pm = MipsScreenToPriv(pmap->pScreen);
	void (*WriteCMap)();
	unsigned char rgb[256 * 3];
#ifndef X11R4
	xColorItem expanddefs[256];
#endif

	if (pmap != pm->InstalledMap)
		return;

#ifndef X11R4
	if ((pmap->pVisual->class | DynamicClass) == DirectColor) {
		ndef = cfbExpandDirectColors(pmap, ndef, pdefs, expanddefs);
		pdefs = expanddefs;
	}
#endif /* !X11R4 */

	if (!(WriteCMap = pm->WriteCMap))
		return;

	while (ndef > 0) {
		int index = pdefs->pixel;
		int prev = index;
		int count = 0;
		unsigned char *out = rgb;

		do {
			out[0] = pdefs->red >> 8;
			out[1] = pdefs->green >> 8;
			out[2] = pdefs->blue >> 8;
			out += 3;
			count++;
		} while (--ndef > 0 && (++pdefs)->pixel == ++prev);

		(*WriteCMap)(pm, index, count, rgb);
	}
}

void
mipsInstallColormap(pmap)
	ColormapPtr pmap;
{
	ScreenPtr pScreen = pmap->pScreen;
	int index = pScreen->myNum;
	MipsScreenPtr pm = MipsScreenNumToPriv(index);
	ColormapPtr oldpmap = pm->InstalledMap;
	VisualPtr pVisual;
	Entry *in;
	int i, count;
	unsigned char *out, rgb[256 * 3];

	if (pmap == oldpmap)
		return;

	/*
	 * Uninstall existing map. No hardware changes required, just
	 * notify all interested parties.
	 */
	if (oldpmap != (ColormapPtr) None)
		WalkTree(oldpmap->pScreen, TellLostMap,
			(pointer) &oldpmap->mid);

	/* Install new map */
	pm->InstalledMap = pmap;

	pVisual = pmap->pVisual;
	out = rgb;

#ifndef X11R4
	if ((pVisual->class | DynamicClass) == DirectColor) {
		count = 256;
		for (i = 0; i < count; i++) {
			out[0] = pmap->red[(i & pVisual->redMask) >>
				pVisual->offsetRed].co.local.red >> 8;
			out[1] = pmap->green[(i & pVisual->greenMask) >>
				pVisual->offsetGreen].co.local.green >> 8;
			out[2] = pmap->blue[(i & pVisual->blueMask) >>
				pVisual->offsetBlue].co.local.blue >> 8;
			out += 3;
		}
	}
	else
#endif /* !X11R4 */
	{
		count = pVisual->ColormapEntries;
		in = pmap->red;
		for (i = 0; i < count; i++) {
			if (in->fShared) {
				out[0] = in->co.shco.red->color >> 8;
				out[1] = in->co.shco.green->color >> 8;
				out[2] = in->co.shco.blue->color >> 8;
			}
			else {
				out[0] = in->co.local.red >> 8;
				out[1] = in->co.local.green >> 8;
				out[2] = in->co.local.blue >> 8;
			}
			in++;
			out += 3;
		}
	}

	if (pm->WriteCMap)
		(*pm->WriteCMap)(pm, 0, count, rgb);

	WalkTree(pScreen, TellGainedMap, (pointer) &pmap->mid);
}

void
mipsUninstallColormap(pmap)
	ColormapPtr pmap;
{
	ScreenPtr pScreen = pmap->pScreen;
	MipsScreenPtr pm = MipsScreenToPriv(pScreen);

	if (pmap != pm->InstalledMap)
		return;

	/* Install default map */
	pmap = (ColormapPtr) LookupIDByType(pScreen->defColormap,
		RT_COLORMAP);
	(*pScreen->InstallColormap)(pmap);
}


/*
 * taken from X11R5 ddx/dec/ws/cfbinit.c -- thank you DEC!
 */
static void
colorNameToColor(index, name, red, green, blue)
	int index;
	char *name;
	unsigned short *red, *green, *blue;
{
	/* hex color */
	if (name[0] == '#') {
		int value;
		if (sscanf(&name[1], "%6x", &value) == 1) {
			*blue = value << 8;
			*green = (value >>= 8) << 8;
			*red = (value >>= 8) << 8;
		}
	}
	/* named color */
	else
		(void) OsLookupColor(index, name, strlen(name),
			red, green, blue);
}

/* based on cfb/cfbcmap.c:cfbCreateDefColormap() */
Bool
mipsCreateDefColormap(index, pScreen, white, black)
	int index;
	ScreenPtr pScreen;
	char *white, *black;
{
	VisualPtr pVisual;
	ColormapPtr cmap;
	unsigned short red, green, blue;

	for (pVisual = pScreen->visuals;
		pVisual->vid != pScreen->rootVisual;
		pVisual++)
		 /* nothing */ ;

	if (CreateColormap(pScreen->defColormap, pScreen, pVisual, &cmap,
		(pVisual->nplanes == 1 || (pVisual->class & DynamicClass)) ?
			AllocNone : AllocAll, 0))
		return FALSE;

	red = green = blue = 0xffff;
	colorNameToColor(index, white, &red, &green, &blue);
	if (AllocColor(cmap, &red, &green, &blue, &pScreen->whitePixel, 0))
		return FALSE;

	red = green = blue = 0;
	colorNameToColor(index, black, &red, &green, &blue);
	if (AllocColor(cmap, &red, &green, &blue, &pScreen->blackPixel, 0))
		return FALSE;

	(*pScreen->InstallColormap) (cmap);
	return TRUE;
}
