@chapter[The Development Environment]

The development environment for the PC/IP code consists of a VAX running
Berkeley Unix with Chris Terman's 8088 C compiler, derived from the Bell
Portable C compiler. Terman's package includes a C compiler, assembler,
linker, @i[a.out] file to @i[.com] file converter, C compiler interface
program (like @i[cc] on Unix), and the Standard I/O Library. We use the C
compiler, assembler and linker, and have made slight modifications to the
@i[a.out] file to @i[.com] file converter. The source release has the
modified converter and our own Standard I/O Library.

To get a copy of the development system, you need a Unix source license. A
copy of the license and a modest fee should be mailed to:
@begin[verbatim]
	Prof. Christopher Terman
	545 Technology Square
	Cambridge, MA 02319
@end[verbatim]

If you already have the compiler, it's necessary to make sure that it's a
recent version, supporting long symbol names. The February 1 1984 release
was the last which supported short symbols names; that tape had two versions
of the release on it. Any release which is more recent than February 1 1984
will be compilable only with the version of the compiler which supports long
symbol names.

In addition, the December 1 1984 release has converted to using the version
of the standard I/O library shipped with the compiler. This has affected
many of the programs, and the I/O library did have to be modified slightly.
Diffs of the modifications are included and the Makefile in the root
directory on the release will integrate the two releases for you. You should
make sure that the version of the compiler you have supports DOS 2.0 system
calls; older versions will not work correctly with this release.

@section[Installation]

To install this distribution, edit the Makefile in the root directory.  You
need to define two symbols. The first is @c[compiler]. Set this equal to the
pathname of the directory where the compiler release is. Set @c[bin]
equal to the directory where you want executables for the VAX (like
@i[setver86]) put. Then just run "make install" and it should integrate the
two releases. If you are converting to this version of the release, you
should skim through the programmer's manual and the change log
(@i[doc/change.log]) to find any important changes which might affect any
programs you had written.

@section[Changes]

Since Feb. 1 1984.

There have been a lot of changes in the development environment. The most
significant ones are converting to the @i[cc86] (the C compiler shell script) and the standard I/O library
as supplied on the compiler release. The @i[cc86] shell script has been
modified in a couple of ways to provide support for libraries. The I/O
library has been modified to use the @i[printf()] that the old library used
and to fold/unfold @c[CR LF] and newline sequences on input and output with
ASCII files. A small change had to be made to @i[sbrk()] to allow allocation
while running on a stack which was itself allocated from the heap. A new
function, @i[exit@us2()hook()] was written to allow other functions to be
called when @i[exit()] is run.

Most of the C library and standard I/O library are combined in @i[-lc]. The
old C library had some nonstandard functions to access I/O ports and the
BIOS timer; these are now in the @i[-lpc] library. Both libraries are
automatically linked in by the @i[cc86] shell script.

@section[Makefiles]

There are makefiles @cite[make] describing dependencies of all the programs.
In general, the dependencies are slightly incomplete: @i[.h] files are
rarely listed when they should be. This causes the makefiles to be slightly
less than fully useful. Doing @i[make all] in the root directory should
rebuild every PC program, but none of the VAX development programs. In
directories under @i[srccmd] doing @i[make eprogram] will make the ethernet
version of @i[program]; @i[make sprogram] will make the serial line version
of @i[program]; and @i[make pprogram] will make the proNET version of the
rogram.

@section[Include files]

There are quite a few include files that are necessary to make things work.
There are two directories where they are kept: @i[cc86@us2()include] and
@i[include]. Files in @i[cc86@us2()include] are from the compiler
distribution. Files in @i[include] are from our distribution and also
include modified files from the compiler distribution. The @i[cc86] shell
script forces the C Preprocessor to search in @i[include] before
@i[cc86@us2()include]. 

Most commonly used is @i[<stdio.h>], defining things for the standard I/O
library. It is independent of other include files, but some others include
it automatically. It is a modified version of @i[stdio.h] from the compiler
release.

The file @i[<net.h>] contains the @i(net) structure, some debugging
constants, and some constants that are important for communication between
Internet level protocols and net interface drivers.

The file @i[<netbuf.h>] defines the packet buffer structure and a few
fundamental constants having to do with it. It automatically includes
@i[<net.h>]. Then there's @i[<netq.h>] which defines the @i[putfree(),
getfree()] and @i[a@us2()getfree()] routines for enqueuing and dequeuing
packet buffers from the system free queue. It includes the @i[<q.h>] file
which has some queue definitions, structures and macros in it.

@i[<task.h>] and @i[<timer.h>] have to do with the tasking system and timers;
they should be included by any program which wants to use tasks or timers.

@i[<types.h>] tries to define various types (@i(byte), @i(word), @i(lword),
...) in a machine dependent way. Unfortunately, most of the code doesn't use
these types yet, instead working with the normal @i(int), @i(unsigned), etc.
The following assumptions are made about object size:
@begin[verbatim]
char		8 bits
int		16 bits
unsigned	16 bits
pointer		16 bits
long		32 bits
@end[verbatim]

The Terman C compiler satisfies these assumptions.

At a higher level, @i[<ip.h>] which is the internet include file. It defines
the internet header structure, a couple of variations on internet addresses,
and a bunch of constants and macros and functions. It includes:
@i[<stdio.h>], @i[<types.h>], @i[<netbuf.h>] and @i[<icmp.h>], so it gets
a lot of files automatically.

The @i[<udp.h>] and @i[<tcp.h>] files which include @i[<ip.h>] and are for
the obvious layers.

The file @i[<sockets.h>] defines a number of constants for use as socket
numbers for UDP or TCP. The socket number for TCP/Telnet is the constant
@i[TCP@us()TELNET]. The socket for UDP/TFTP is the constant @i[UDP@us()TFTP].
It would be better to have used a naming service, but the static approach is
sufficient.

@section(Libraries)

A library corresponds with a layer, or module of code, like the ethernet
driver, or the internet layer, or UDP, or TCP. Then an applications level
program like telnet links in all the appropriate libraries and off it goes.
The linker ought to know where to look for the libraries when you specify
@i[-lfoo] as an argument to it. The libraries are really normal 4.2 random
access libraries. Be sure to order the files that go in them correctly.

@section[Lint]

Lint support isn't quite there yet. All makefiles for libraries should be
able to produce lint libraries and all makefiles for commands should be able
to check out the command with lint but not all problems reported by lint
have been fixed. Most of them are trivial.

@section[Profiler]

The profiler is a tool for finding out roughly how much time programs are
spending in particular places. At every clock tick (18.2 times per second on
the PC) the profiler records where the program was executing when the clock
ticked, with a 16 byte granularity. When the program finishes executing, the
profiler writes out the results into a file. The file is then transferred to
the VAX where the program was compiled and where the @i[.ld] file with the
symbols is. Then @i[merge86] should be run to merge the data produced by the
profiler with the data in the symbol table to tell you approximately how
much time is being spent in each routine.

Some @i[caveats]: the profiler is known to be slightly flaky and hasn't been
used for a long time. Don't be surprised if it doesn't seem to work. Don't
expect accurate results in programs with a lot of idle time. The profiler
works best with compute bound programs. In programs using the tasking
package, often we find that all the idle time is accumulated by the core
task switching routines looping through the task list waiting for a task to
become runnable.

@section[Differences with the compiler release]
There are a number of differences between our development environment and
the portable C compiler release.

@begin[itemize]
cc86: We now use a version of @i[cc86] very similar to the release version.
Diffs between the two are in @i[vax/cc86.diffs]. It has been changed to be
able to handle libraries specified with @i[-l].

ld86: A very simple difference. Our ld86 is modified to know where to look
for libraries specified with @i[-l]. No source is included in the release;
simply find the place in the source for ld86 and recompile it.

cvt86: Our cvt86 defines a symbol, @us2()data@us2()seg, which Terman's
doesn't (and doesn't need to). This symbol is used to calculate our data
segment. The source for our version is in @i[vax/cvt86].

standard I/O library: our release now uses a slightly modified version of
the compiler release's libraries. We use our @i[printf()], with a special
version in @i[-lnet] modified to support fields %a and %A. The %a field
prints an internet address in decimal (18.26.0.10) format; %A prints it in
octal (22,32,0,12) format. Several other changes are mentioned above.

crt: This is the C runtime system. There are several versions of it.
The version normally used by both network and non-network programs is
@i[crt0.a86]. This is in contrast with previous releases which used a
different crt for network programs. @i[crt0.a86] has been modified to
include a space for a version number in the first few bytes. The program
@i[setver86] modifies this version number. The version is available in a
global variable called @i[version]. Another version of crt, which supports
the profiler, is called @i[pcrt0.a86].

setver86: this program is available only in our release. It allows you to
set version numbers on programs. The version number is written into two
bytes early in the @i[.com] file, and copied into the variable @i[version]
at runtime. A program of version number 4.2 would have the variable
@i[version] set to 42.
@end[itemize]

By and large, these differences are historical artifacts. Many differences
have vanished since the last release, especially now that we're using the
compiler release's standard I/O library.
