@appendix[Glossary]

This is a limited glossary to explain some terms used in the manual and
cite references for them.

@begin[description]
a86@\The cross-assembler used in the development environment. See @cite[a86].

ARP@\Address Resolution Protocol. ARP is a non-IP protocol used on local
area networks to convert from internet addresses to hardware addresses. See
@cite[plummer].

c86@\The actual C compiler used in the development environment. Called by
@i[cc86].

cc86@\A shell script or small C program that interfaces the development
environment C cross-compiler to the real world.

client@\An application. Common clients of TCP are FTP and telnet.

customizer@\The customizer is the program @i[custom.com]. It edits the
information which the network programs use to determine things about the
machine they are using. See end of the chapter on structure.

cvt86@\A program in the development environment which converts @i[a.out] files
(produced by @i[ld86]) to @i[.com] files. The release supplies its own
version of this program.

ethernet@\Originally developed by Xerox, the ethernet is a local area bus
network which uses collision avoidance and collision detection to handle the
problem of contention for the cable. At this time, 3COM Corp. and
Ungermann-Bass make ethernet interfaces for the IBM PC. This release
supports only the 3COM interface. See @cite[ethernet] for ethernet
specifications.

FTP@\File Transfer Protocol. A TCP based protocol which allows authenticated
access to files over the network. FTP requires two TCP connections, one for
control and one for data. See @cite[ftp].

gateway@\A machine which ties together two networks. A gateway forwards
packets from one network to another. Gateways are also sometimes called
@i[bridges]. Variations are @i[translating gateways] which change the
protocol of the data they forward, @i[encapsulating gateways] which wrap or
unwrap a packet of one protocol (such as IP) in a packet of another protocol
(such as Chaos), and @i[store-and-forward] gateways, also called relays,
which do not forward packets but complete messages. Store-and-forward
gateways are often useful for security purposes.

hostname@\A program in the release which polls name servers to resolve the
textual name of a host into an Internet address. See @cite[usermanual] for
the command, @cite[nameuser] for protocol details.

ICMP@\Internet Control Message Protocol. This protocol is used by IP to
report errors, give limited routing advice and provide simple lowlevel
services. Ping uses the "echo request" feature of this protocol. Gateways
use "redirects" when there is a better path to a destination. See
@cite[icmp].

ioctl@\An MS-DOS system call which allows special commands to be sent to a
device. RVD uses ioctls to spin disks up and down. See @cite[msdos] for
details.

IP@\Internet Protocol. A datagram protocol used to transport datagrams
over and across local area networks. See @cite[internet].

ld86@\The linker in the development environment. Pretty much the standard
Unix linker.

lorder86@\A program in the release for the development environment which
figures out the correct ordering of files in a library or for linking.

mkfs@\MaKe FileSystem. Mkfs is named after its Unix equivalent. It is
provided with RVD because there is no way in MS-DOS to create an empty
filesystem. Because of the way RVD works, mkfs can occasionally fail and
should be replaced with a better mechanism.

netwatch@\A program in the release which displays packets on the network. 
This program puts the net interface into "promiscuous mode" where it will
receive all packets on the net. See @cite[usermanual].

nicname@\A program in the release which accesses the NIC (Network
Information Center) name server, where you can find out information (phone
numbers, US mail addresses, electronic mail addresses) about people. See
@cite[usermanual] about the program and @cite[nicname] for information about
the protocol.

ping@\A program in the release which uses ICMP echo requests to determine if
a host can be reached. All IP implementations should respond to ICMP echo
requests, so if the machine doesn't respond it should either be off the net
or unreachable for some reason. See @cite[usermanual].

pronet@\proNET is a local area token ring network developed by Proteon, Inc.
It handles contention for the cable by use of a constantly circulating token.
See @cite[pronet] for details.

reliable@\A protocol is reliable if it delivers the same bytes which were
sent exactly once in the same order. In the Internet a packet which is sent
to another machine may be received zero or more times and may be received
out of order with respect to other packets sent.

rwho@\A protocol used in Berkeley 4.2 Unix. Machines supporting rwho on a
local area net supporting broadcast periodically broadcast a UDP packet
containing information about the load average, number of users and who they
are. Then servers collect the information and replace the old information
with it. See @cite[rwho].

server@\Something which provides a service. In some cases, when two
processes are communicating, the process which accepts the connection.

setclock@\A program in the release which polls time servers over the network
and sets the PC's clock accordingly. See @cite[usermanual] for the
command. See @cite[timeuser] for protocol details.

setver86@\A program in the development environment which sets the version
number of a program.

task@\In the context of this release, a @i[task] is a section of code and a
stack. Tasks give up control of the processor to other tasks voluntarily.
There is a circular list of tasks used by the task scheduler. See the
chapter on tasking.

TCP@\Transmission Control Protocol. A reliable stream protocol based on IP.
See @cite[tcp].

telnet@\A TCP based protocol which provides remote login. See @cite[telnet].

terminal emulator@\In this release the terminal emulator is an h19 emulator.
It is used in several programs, namely term and telnet.

UDP@\User Datagram Protocol. An unreliable datagram protocol based on IP.
See @cite[udp].

upcall@\An upcall is a call made from a service providing layer to its
client. Usual models of interfaces between services and clients have a
strictly downcall interface (vis. the Unix @i[read, write]) interface. In an
upcall model, the service can call the client when data is available, or
even when it is ready to accept more data from the client. See @cite[ddc2]
and @cite[upcall].

user@\Something which requests a service or, sometimes, something which
initiates a connection.

whois@\A program which polls a remote machine and lists the users currently
logged on, or information about a specific user of the machine. This program
is also known as "finger" on some machines. See @cite[usermanual] for
information about the program and @cite[finger] for information about the
protocol.
@end[description]
