@chapter(Overview)

@section[Introduction]

The IBM PC network code implements the DoD standard Internet protocol family
@Cite[Internet]. This system includes drivers for the 3COM 10Mbps ethernet
interface @cite[3com1]@cite[3com2], the Proteon proNET ring interface
@cite[pronet], and for serial lines running a special link level protocol
which requires a special gateway. A high level of modularity is forced on
the code by the requirement that it be able to use different net interface
drivers easily. Packages that are available are user telnet, user and server
tftp, user finger (the "whois" program in this release), user cookie, user
smtp, user and server ping, and user setclock, user hostname resolution,
user nicname, and netwatch.

The code is structured in a somewhat unusual manner. It includes a small,
nonpreemptive multitasking system. Its history is long, starting with Dr.
David Clark's TCP for the Xerox Alto, running to Larry's Allen's translation
of this from BCPL to C for Unix, to Lou Konopelski's port to the PC, and my
cleanups and additions. The Internet began as a port from Larry Allen's Unix
Internet, but later was almost totally rewritten to work with tasking by me.

The system was originally developed on a PDP 11/45 running Version 6 Unix,
and later on a VAX running 4.2. For a variety of reasons, it would be
extremely painful to port the development environment to the IBM PC.

The code has also been ported to the Apple Macintosh by Mark Sherman at
Dartmouth @cite[mac]. His address is:
@begin[verbatim]
	Mark Sherman
	Computer Network Laboratory
	Department of Mathematics and Computer Science
	Dartmouth College
	Hanover, NH  03755

	(603) 646-2415
	mss@@Dartmouth.CSNet
@end[verbatim]

Any filenames in the source release which are mentioned in this manual will
be given as a pathname relative to the root of the release. Thus the
directory with the telnet source code is @i[srccmd/tn].

For a more user oriented tour of the programs, you should see the user
manual for the programs@cite[usermanual].

Comments made in this manual are not intended to represent the opinion of
MIT or any person there, including possibly the author (depending on his
mood).

Comments @i[about] this manual and suggestions/criticisms are quite welcome
and encouraged.

This manual is available online in the release in the directory
@i[doc/progman]. The user's manual is in @i[man].

@section[Changes to the manual]

Since April 1 1984.

A chapter on the
development environment has been split out of the chapter on structure.
Documentation has been added on using the UDP time service functions. The
use of lint and the profiler is documented. The serial line framing protocol
section has been fixed so that the tables are readable. Several references
have been changed or added.

The tasking section has been updated to describe the new stack handling
code. The timer section has been updated to describe some new ways of
setting timers, and describes the obscure low level routines that interface
to the BIOS clock. The description of the customizer in the structure section
has finally been updated.

A glossary has been added.

The file @i[doc/change.log] should be consulted for a list of changes to the
various pieces of code.

@section[Credits]

This is a roughly alphabetical list of [known] people who have contributed
to this release in some way:

Larry Allen, David Bridgham, Dave Clark, Geof Cooper, Eric Crane, Don
Gillies, Wayne Gramlich, Lou Konopelski, John Romkey, Jerome Saltzer,
Karen Sollins, Chris Terman, Muriel Webber, William Westfield, Karl Wright

@comment[Soon Marie Macaisa and Henry Woo, also]

@section[Things To Come]

It's almost certainly a bad idea to tell people what you'll be doing in the
future when you haven't really done it yet, but here goes anyway.  The next
release (if there is one) will probably have a "new" TCP which will support
multiple connections. Supported by this TCP will be a user and server SMTP
and an implementation of USP, the Unified Stream Protocol @cite[usp]. Based
on USP will be a distributed mail package. There may be several other
programs using USP available too. Sources for USP on 4.2 Unix should also be
included. For those who are wondering, USP is a locally developed protocol
which provides a block structured reliable stream.

Another new set of programs will be RVD, for accessing Remote Virtual Disks.
These programs will include a device driver for ten remote disk drives, a
collection of utilities for using these disks and the server which runs on a
VAX running Berkeley 4.2 Unix.

We currently have no plans to implement FTP. If we're really lucky, though,
there might even be an arguably feeble multiplayer game!
