@part[arp, root "progman"]

@chapter[Address Resolution Protocol]

@section(ARP: The Address Resolution Protocol)

Any implementation of the Internet protocol on a local area network must
face the problem of translating from 32 bit internet addresses to @i(n) bit
local area network addresses (hardware addresses). On some networks, such as
the Proteon ring at LCS, such translation is simple because hardware
addresses are short (8 bits). Ethernets pose a problem, though, because
somehow you need to cram 48 bits worth of hardware address into 32 bits of
internet address (of which you can't really use 32 bits, of course) and have
the process be reversible.

There are a number of ways that people have accomplished this, ranging from
caching the translation pairs to assuming that there are only two
manufacturers of ethernet interfaces in the world (a false assumption) and
discarding half of the ethernet address. A potential standard for doing such
translation appears in @cite[plummer], and it is this method which we
have implemented on the PC.

Here's the basic algorithm:

Suppose machine @i(A) wants to send a packet to machine @i(B) and it has
determined via its routing algorithm that @i(B) is on the same physical
network as it, so @i(A) can send the packet directly to @i(B). It then needs
to convert @i(B)'s internet address to a hardware address. @i(A) maintains a
cache of all internet-ethernet address pairs that it knows, so it searches
this cache first. If it finds a useful entry in the cache, then the matter
is done and @i(A) can send the packet.

Otherwise, @i(A) should cobble up a (non-internet) packet which contains its
ethernet address, its internet address, the internet address of the foreign
machine and a variety of constants which indicate the the protocol addresses
are internet addresses and the hardware is ethernet. @i(A) the broadcasts
this packet over the ethernet and (according to spec) discards the packet
which it was sending@footnote[The PC implementation does not discard the
packet it was sending; it waits until a certain timeout has elapsed and then
discards it if no response has arrived.].

When @i[B] receives one of these request packets, it looks at the protocol
address of the machine that the packet is for. If it is @i[B]'s address, it
then replies to the packet by changing the type field from @i[REQUEST] to
@i[REPLY], filling in its hardware address and sending the packet back to
@i[A].

Finally, @i[A] receives a reply and caches the internet-ethernet address
pair in its cache for future use (perhaps for use with the packet which was
dropped earlier and will hopefully be retransmitted).

For more details, and a more complete description of the protocol, see
@cite[plummer].

@section(The PC Implementation)

As mentioned above, the PC implementation of the protocol does not drop the
outgoing packet when it cannot resolve the internet address into an ethernet
address. It hangs onto it, sends out a request, sets a timer, and the blocks
the task which the call came from. Then, when a reply is received, it wakes
up the blocked task and finishes sending the packet. Otherwise, when the
timeout occurs, it wakes up the blocked task and doesn't send the packet.

Since it is the responsibility of the driver to translate the internet
address into an ethernet address, this all happens within the ethernet
driver. The ethernet driver initializes the address resolution code by
calling @i[etainit()] when it is initialized. Currently, this code sets up
the initial cache contents by copying them from the custom structure where
they might have been set by the user.

@begin(group)
Address conversion is accomplished by the following routine.
@begin(verbatim)

int ip2et(ether, ip)
	char *ether;
	in@us()name ip;

@end(verbatim)
@end(group)

Since an ethernet address is 6 bytes long, it is a bit hard to manipulate,
so the driver passes around pointers to 6 byte arrays, like the @i(ether)
parameter. This array is filled in with the ethernet address corresponding
to the internet address @i(ip). If the translation was done, this routine
returns a 1; otherwise it returns 0. It does all of the communication with
the code which actually implements the protocol.

@section(Other Implementations)

This section was last updated on 2/12/84.

The PC implementation of ARP has been tested by MIT against several
implementations: the MIT C Gateway ARP, the Symbolics 3600 ARP, the Berkeley
4.2 Unix ARP, and the Imagen ARP.  There are rumored to be some
implementations of an old version of the protocol in some BBN VAX and
TOPS-20 code which will not work with the PC version. The Sun implementation
of ARP is said to be compatible with the PC implementation.
