@part[h19, root "progman"]

@chapter[The H19 Terminal Emulator]

Several programs in the release (telnet, term, netwatch) use the H19
terminal emulator. The emulator is built on top of a package of routines
written in assembly code that manipulate the display. The supdup emulator
uses the same package. An advantage of this package over the DOS or BIOS
routines is that it provides fast scrolling. This allows the emulator to
handle characters fast enough so that term can handle almost 9600 baud.

The H19 emulator handles most commands which are reasonable to handle on an
IBM PC. The User's Manual @cite[usermanual] explains in more detail which
commands are not provided. The emulator provides some ANSI mode features,
but only the ones that TOPS-20 emacs has been found to utilize. For more
information on the H19 terminal, see @cite[h19].

This chapter describes some routines that the terminal emulator provides; it
does not describe the low level screen handler. The emulator uses various
constants defined in @i<h19.h>. To link it in, specify @i[-lh19] on the link
command line.

The way to link the emulator in depends on how you want to use it. If it is
linked @i[before] the standard I/O library, all output to @i[stdout] will go
through the emulator. This means that I/O redirection @i[will not] work with
this program. Telnet uses the emulator this way. Alternatively, the emulator
can be linked after the standard I/O library, provided the functions
described below but not forcing them on you.

@section[Display handling]

The H19 emulator has an initialization function, a shutdown function and a
function which takes a character and emulates the action of an H19 on that
character.

@subsection[@i{em()}]

@begin[verbatim]

em(c)
	char c;

@end[verbatim]

This routine handles the single character @i[c]. It retains internal state
for handling escape sequences.

@section[Keyboard handling]

There are several routines which read characters from the keyboard using
BIOS calls. These routines will not work correctly with standard input
redirection; they will still read from the keyboard. All of them map some of
the keys (the arrow keys, the function keys) to escape sequences which the
H19 sends. These functions also interact with the emulator in that there are
escape sequences which an H19 can receive which cause it to send characters.
While routines reading from standard input would not return these
characters, the functions specified below will.

@subsection[@i{h19key()}]

@begin[verbatim]

int h19key()

@end[verbatim]

The @i[h19key()] function returns a character if one is available, or the
constant @c[NONE] if no characters are waiting on the keyboard. The special
constants @c[c@us{}break], @c[f9] and @c[f10] are returned for the @c[control
break], @c[f9] and @c[f10] keys. Since entire lines are not read in, no line
editing is done.

@subsection[@i{h19line()}]

@begin[verbatim]

int h19line(buf, size, echo)
	char *buf;
	unsigned size;
	int echo;

@end[verbatim]

This function reads a line, performing line editing and optional echoing.
Line editing characters are:
@begin[itemize]
backspace, delete@\delete the previous character

escape, control U@\erase the entire line

control break@\cancel this line completely
@end[itemize]

In addition, carriage return and line feed terminate the line. When
@i[h19line()] finishes, it returns the character which terminated the line:
@c[lf], @c[cr] or @c[c@us{}break].

If @i[echo] is true, character echoing will be enabled; otherwise nothing
typed will be echoed, although @c[esc] or @c[^U] will print @c[xxx]. This is
useful for passwords.

The length of the buffer is given by @i[size]. The number of characters the
user will be allowed to enter will then be @i[size-1]. When @i[h19line()]
returns, the input string will be zero terminated and the last character
entered (@c[cr], @c[lf] or @c[control break]) character will not be in the
buffer.
