@part[low-level, root "progman"]

@chapter[Low Level System Interface]

This chapter describes the programming interface to several functions
used by PC/IP to access the PC hardware.

@section[Linking in the low level functions]

The low level functions library can be linked in by specifying
@i[-lpc] on the command line to @i[ld86]. The cross-compiler shell
script @i[cc86] automatically links in @i[-lpc].

Some functions documented in this section come with the C
cross-compiler and are not supplied with PC/IP. These functions are
in the @i[c] library, which is also linked in automatically by
@i[cc86].

@section[DOS Calls]

This section tells how to do PC-DOS system calls from inside a C
program.

@subsection[@i<dos()>]

@Begin[verbatim]
unsigned dos(call, arg)
	int call;
	unsigned arg;
@End[verbatim]

Calls system call number @i[call], passing it argument @i[arg]. This
function loads register @c[ah] with @i[call] and register @c[dx] with
@i[arg] and performs an interrupt 0x21. It returns value the system
call returned in register @c[ah], zero-extended instead of
sign-extended.

@i[dos()] is in the C library.


@section[I/O port access]

This section describes the functions that give C programs access to the
processor's I/O ports.

@subsection[@i<inb()>]

@Begin[verbatim]
unsigned inb(port)
	unsigned port;

@End[verbatim]

Performs an eight-bit byte input from I/O port @i[port] and returns
the zero-extended result.

@subsection[@i<outb()>]

@Begin[verbatim]
unsigned outb(port, value)
	unsigned port;
	char value;

@End[verbatim]

Outputs byte @i[value] to I/O port @i[port].

@subsection[@i<inw()>]

@Begin[verbatim]
unsigned inw(port)
	unsigned port;

@End[verbatim]

Performs a sixteen-bit word input by doing two inputs from consecutive
I/O ports. The most significant byte of the word is input from port
@i[port]; the least significant byte from port @i[port+1].

This routine is useful for inputting words from many hardware devices
for the PC (especially network interfaces).

@subsection[@i<outw()>]

@Begin[verbatim]
unsigned outw(port, value)
	unsigned port;
	unsigned value;

@End[verbatim]

Performs a sixteen-bit word output by doing two outputs to consecutive
I/O ports. The least significant byte of the word is output to port
@i[port]; the most significant byte to port @i[port+1].

This routine is useful for outputting words from many hardware devices
for the PC (especially network interfaces).

@subsection[@i<inw2()>]

@Begin[verbatim]
unsigned inw2(port)
	unsigned port;

@End[verbatim]

Performs a sixteen-bit word input by doing two successive inputs from
the same port. The most significant byte of the word is input from
port @i[port] and then the least significant byte is input from port
@i[port].

This routine is useful for outputting words to the 8237 DMA controller.

@subsection[@i<outw2()>]

@Begin[verbatim]
unsigned outw2(port, value)
	unsigned port;
	char value;

@End[verbatim]

Performs a sixteen-bit word output by doing two successive outputs to
the same port. The least significant byte of the word is output to
port @i[port] and then the most significant byte is output to port
@i[port].

This routine is useful for outputting words to the 8237 DMA controller.

@subsection[@i<fastin()>]

@Begin[verbatim]
fastin(port, buffer, len)
	unsigned port;
	char *buffer;
	unsigned len;

@End[verbatim]

Inputs @i[len] bytes from I/O port @i[port] into memory starting at
address @i[buffer] by inputting bytes from the port in a tight loop.

This function is useful to copy packets quickly from a network interface
in lieu of DMA.

@subsection[@i<fastout()>]

@Begin[verbatim]
fastout(port, buffer, len)
	unsigned port;
	char *buffer;
	unsigned len;

@End[verbatim]

Outputs @i[len] bytes to I/O port @i[port] from memory starting at
address @i[buffer] by outputting bytes to the port in a tight loop.

This function is useful to copy packets quickly to a network interface
in lieu of DMA.

@section[Enabling and disabling interrupts]

@subsection[@i<int@us()off()>]

@Begin[verbatim]
int@us()off()

@End[verbatim]

Performs a @i[cli] instruction to disable interrupts at the processor.

@subsection[@i<int@us()on()>]

@Begin[verbatim]
int@us()on()

@End[verbatim]

Performs a @i[sti] instruction to enable interrupts at the processor.

@section[Segment register access]

Although the C compiler does not support multiple data segments, it's
often useful for debugging to be able to read the contents of segment
registers.

@subsection[@i<get@us()ds()>]

@Begin[verbatim]
unsigned get@us()ds()
@End[verbatim]

Returns the contents of the @i[ds] processor register.

@subsection[@i<get@us()cs()>]

@Begin[verbatim]
unsigned get@us()cs()
@End[verbatim]

Returns the contents of the @i[cs] processor register.

@section[Fast memory copies]

@subsection[@i<gencpy()>]

@Begin[verbatim]
gencpy(srcoff, srcseg, dstoff, dstseg, len)
	unsigned srcoff;
	unsigned srcseg;
	unsigned dstoff;
	unsigned dstseg;
	unsigned len;

@End[verbatim]

Copies @i[len] bytes of data from @i[srcseg:srcoff] to
@i[dstseg:dstoff]. There must be no overlap between the memory areas.

@section[Bell access]

@subsection[@i<ring()>]

@Begin[verbatim]
ring()

@End[verbatim]

Chirps the bell. This is the bell used by telnet, handcrafted by Jerry
Saltzer.

@section[DMA functions]

This section describes several functions that allow easy programming
of the DMA controller from C programs.

@subsection[@i<dma@us{}setup()>]

@Begin[verbatim]
dma@us{}setup(channel, buffer, length, dir)
	int channel;
	char *buffer;
	unsigned len;
	int dir;
@End[verbatim]

Sets up a DMA transfer on channel @i[channel]. Channels 0 through 3
are supported; the AT's extra 16 bit channels are not. @i[length]
bytes of data will be transferred from address @i[buffer]. If @i[dir]
is 0, data will be copied into memory; if @i[dir] is 1, data will be
copied out of memory. Two constants, @c[DMA@us{}INPUT] and
@c[DMA@us{}OUTPUT], are defined in @i[<dma.h>] and should be used
instead of 0 and 1.

When @i[dma@us{}setup()] returns, the DMA channel is primed to do the
transfer, and the transfer can be initiated by having the device that
the transfer is working with request it or by calling @i[dma@us{}start()].
This is very dependent on the specific hardware you are performing DMA
with.

@i[dma@us{}setup()] does no consistency checking; it will accept all
manner of invalid arguments.

When @i[dma@us{}setup()] returns, @i[channel] will be masked active
and ready to transfer data.

@subsection[@i<dma@us{}done()>]

@Begin[verbatim]
dma@us{}done(channel)
	int channel;
@End[verbatim]

Returns -1 if the DMA transfer on channel @i[channel] has completed.

@subsection[@i<dma@us{}reset()>]

@Begin[verbatim]
dma@us{}reset(channel)
	int channel;
@End[verbatim]

Disables DMA channel @i[channel]. This function does no checking on
its argument; on a PC or PC/XT, calling it with @i[channel] set to 0
produces disastrous results (it turns off memory refresh).
