@part[changes, root "manual"]

@string[sectiontitle = "Changes"]
@newpage

@section[Changes From The Last Release]

This section describes user-visible changes since the January, 1985,
release of the PC/IP packages.

A.  Changes to user commands.

PC/@b[custom]

@Begin[enumerate]
Now allows the user to select transmit and receive DMA channels.

Accepts interface base I/O address in hexadecimal instead of decimal.

A new flag was added to specify the preferred output radix for IP
addresses (decimal or octal).

Now recomputes the subnet mask when either the number of subnet bits
changes or the internet address changes (address could have changed
class).

Permits the user to separately control debug tracing of different
protocol levels.

The office and phone number fields were removed and the space reused.

Added a domain name field and the addresses of up to three domain name
servers. The number of old-style name servers was reduced to two.
@End[enumerate]

PC/@b[netwatch]

@Begin[enumerate]
Can now match on several layers of types, and can match on protocol
source and destination addresses.

Now has an explicit @i[pause] command and also pauses when printing
help message.

Packets are displayed in color when possible.

Records the number of packets accepted of each type.

Records the number of packets accepted by length (in quanta of 64
bytes).

Records the number of broadcast packets.

Ethernet versions can display the manufacturer of an ethernet interface
when printing the address.

Can print local net addresses when printing packets symbolically.

Works with proNET driver.

Can match on source, destination or source/or/destination address
(hardware or protocol).
@End[enumerate]

PC/@b[setclock]

@Begin[enumerate]
PC/@b[setclock] now automatically adjusts for daylight savings time
according to 1985 U.S. law.
@End[enumerate]

PC/@b[telnet]

@Begin[enumerate]
Changed user interface to the debugging and statistics printing
commands, allowing a larger repertoire.  All debugging commands now
are obtained by F10/control-something; a list of them is displayed
in response to F10/control-h.
@End[enumerate]

PC/@b[tftp]

@Begin[enumerate]
Greeting message now mentions the mode of the transfer, so
that default of netascii does not trap unwitting user.

Packet buffer allocation now is preceded by flushing out broadcast
packets to allow TCP packet processing. Formerly, if a lot of
broadcasts or character-at-a-time messages from a hyperactive UNIX
filled up the packet buffers during initialization of @b[tftp], it
couldn't get any free buffers and would have to give up.

Disk writes are now collected into a 10 KByte buffer rather
than performed once per arriving packet.  Improves performance
on Ethernet transfers to floppy disks by a factor of three.  A
new option ("spool") to the server turns off this buffering, so
that the @b[tftp] server can be used as an interface to a print
spooler.
@End[enumerate]

PC/@b[whois]

@Begin[enumerate]
Order of opening connection, receiving data, and closing
connection modified to avoid bug in BSD 4.2 finger server, which
would forget about sending more than one packet if the connection is
closed from the originator's end.

All bare ASCII LF characters are changed to LF/CR, because
BSD 4.2 finger server doesn't send network standard ASCII.  Since
a bare LF is never legal in network standard ASCII, this change
doesn't cause trouble with servers that do netascii right.
@End[enumerate]

@comment[this is device specific to get rid of widows...]
@newpage

B.  Changes to protocol implementations

TCP (affects @b[telnet], @b[nicname], and @b[whois])

@Begin[enumerate]
Fixed error in which TCP failed to reack when rereceiving old
data.  This error had two effects: First, if an ACK was lost, the
connection would hang, the other end would give up, and the next
thing to be typed would cause a foreign reset.  Second, it caused
TCP to ignore UNIX "keepalives", which lead to a foreign reset if
the connection isn't used for ten minutes.  TCP now responds
to "keepalives".

Fixed error in TCP close/reset sequence, eliminating occasional
message "Bad TCP State" on exit.

Performance improvement of about 50%, accomplished by calling
client with larger blocks.

Implemented TCP maxsegsize option, set to 511 bytes.  This
feature prevents the foreign system from sending packets larger
than the PC can handle.  It also has the side effect of preventing
Berkeley 4.2 systems from sending packets with trailers to the PC.

Changed checksum calculation to accept either FFFF or 0000, to
compensate for the ambiguous TCP specification as to which form of
one's complement zero is expected.  Some implementations use one,
some the other.  TCP now works with either kind of implementation.

Connection close sequence now acknowledges properly when the
close is initiated by the PC.

A deadlock in the algorithm for window opening was eliminated.

Closing a connection when it is only partially opened no longer
triggers an "unexpected state" error message.
@End[enumerate]

ICMP

@Begin[enumerate]
No longer sends "destination unreachable" in response to IP
broadcast packets.  Helps avoid avalanching the network.

Bad echo sequence number messages are now displayed only when
debugging switches are on.
@End[enumerate]

IP
@Begin[enumerate]
Properly returns an error if the user tries to send a packet to
an address not on the local network, but the gateway address hasn't
been customized.  (Previously, PC/IP erroneously sent the packet to
address 0.0.0.0.)
@End[enumerate]

UDP
@Begin[enumerate]
The name resolver has been updated to use new ARPANET standard
domain name resolution protocol.

Debug tracing of incoming packets now includes packet size.
@End[enumerate]

C.  Other changes

Debugging features

@Begin[enumerate]
Separated debugging trace flags for the application, transport,
internet, and driver levels.  This change permits user to control
the volume of debugging messages much more effectively.  Any individual
debugging flag can be turned on or off, either with PC/@b[custom] or
dynamically when running PC/@b[telnet].
@End[enumerate]

Terminal emulator (affects PC/@b[term] and PC/@b[telnet])

@Begin[enumerate]
Special version created for use with IBM Professional Graphics
Display, which mis-emulates the cursor motion of the Color Graphics
Display.  (used in PC/@b[pgatn] and PC/@b[pgaterm])

Several bugs that produced incorrect line fill and background
colors have been fixed.  These were noted mostly when using the
"vi" editor via PC/@b[telnet].

Hercules color card (as well as some others that have more than
2K of display memory) now works.
@End[enumerate]

Timer package

@Begin[enumerate]
A misdeclared variable in the timer package led to an error every
65535 times the timer was used.  The most noticeable symptom of
this bug was that the line-25 clock in PC/@b[telnet] stopped ticking
after 18 hours.  
@End[enumerate]

3COM Etherlink Ethernet driver

@Begin[enumerate]
Properly initializes ARP cache to all zeros.  Previous initialize
loop terminated early, left garbage, and occasionally caused improper
hit.

Driver now saves and restores state of interrupt handlers and
masks, so that it can be reused, for example, while calling a shell
from @b[telnet].
@End[enumerate]

D. New Packages

@Begin[enumerate]
PC/@b[lpr] allows users to send files to be printed by a 4.2 Unix
printer spooler.

PC/@b[monitor] is a new command that repeatedly tests a list of
network services and keeps a display of the result.

New device driver for the Interlan NI5010 Ethernet card.

A domain name resolver was integrated with the old-style name resolver.
@End[enumerate]

17 January 1986. This document is in file changes.mss
