@part[hard-inst, root "manual"]

@string[sectiontitle = "Hardware Installation"]
@newpage

@section[Hardware Installation]


This section describes the installation procedures for network
interface hardware supported by PC/IP, and also notes a problem found
with some old memory cards.

Before you install your network interface, you need to select a DMA
channel (note that the proNET card can use two separate DMA channels,
one for transmitting packets and one for receiving them) for it and an
interrupt vector. The board may need to be reconfigured to use your
selections, and you also have to inform the software via the
PC/@b[custom] command. It is important that the DMA channel and
interrupt vector you select are not being used by any other hardware
in the machine. Below is a chart showing what channels and vectors the
network interfaces supported by PC/IP can use, and what channels and
vectors are already in use in a PC, PC/XT and PC/AT.

@Begin[group]
@Begin[verbatim]

Network Interfaces		Interrupts		Dma Channels
proNET				2, 3, or 4		1, 2, or 3
3COM Etherlink (old revs)	3 or 5			1 or 3
3COM Etherlink (newer)		2, 3, 4, 5, 6, or 7	1, 2, or 3
Interlan NI5010			3 or 5			1 or 3

PC Devices
COM1 (same for AT)		4			none
COM2 (same for AT)		3			none
Printer 1 (same for AT)		7			none
Printer 2 (same for AT)		5			none
Floppy disk			6			3

PC/XT hard disk			5			2

AT Devices
Floppy and hard disk		6			2
@End[verbatim]
@End[group]

If you cannot, or choose not to, use a DMA channel, you should set the
DMA channel (via PC/@b[custom]) to 0. The driver will then use a tight loop
to transfer data from the card. We recommend using DMA, however.

If you install more than one network interface in your machine, or
have some other unusual hardware, it is also important to make sure
that the base I/O address of the interface does not conflict with any
other hardware. Refer to the documentation for the appropriate
interface for details on setting the base I/O address.

@subsection[Pronet jumper selection]

There are both switch-settable and jumper-selectable options on
the proNet p1300 ring interface.  See the p1300 "User's Guide" that
came with the interface for more details.

@subheading[Switches]

The node address switch (S39) must be set to an address different
from every other station on your ring network, and that address
is the same as the value in the last field of the internet
address that your machine has been assigned (see step one under
software installation.)  Note that the node address switch uses
the "on" position to denote the binary value "0" and the "off"
position to denote the binary value "1".  The board/rom address
switch (S22) should be set to all zeros (all "on".)


@subheading[Jumpers]

The interrupt vector jumper and the two DMA jumpers (one for
input, one for output) must agree with the configuration that the
software will assume, and must not conflict with other installed
I/O devices.  The card can be set to use any of interrupt vector
positions 2, 3, or 4, and any of DMA channels 1, 2, and 3.  The
PC/IP software requires that the two DMA jumpers be configured to
use the same DMA channel.  The card is usually shipped with the
jumpers set for a configuration that will work with a standard PC
or PC/XT, using interrupt vector 2 and DMA channel 1 for both
input and output.

@subsection[Interlan NI5010 jumper selection]

All options on the Interlan NI5010 interface are jumper selectable.
For more information, refer to the "NI5010 Installation and
Programming Guide", supplied with the card by Micom-Interlan.

@subheading[Interrupts]

The NI5010 card can be configured to use interrupt 3 or interrupt 5,
controlled by jumper W7. The B position of the jumper selects
interrupt 3; the A position selects interrupt 5.

@subheading[DMA]

The NI5010 card can be configured to use DMA channel 1 or 3, or no DMA
at all, depending on the positions of jumpers W8 and W14.
@Begin[format]
@Begin[group]
@tabdivide[5]
channel@\W8@\W14
none@\remove@\remove
1@\A@\B
3@\B@\A
@End[group]
@End[format]

@subsection[3COM Etherlink interface]

@subheading[Jumper selection]

There are several jumper-selectable hardware options on the 3COM
Etherlink Ethernet card.  The cards come in two forms.  The
first, older form, is identifiable by the label "Rev. A" or
"Rev.  x.y" where x and y are integers; the card is usually
green in color.  The second, newer form, is identifiable by its
blue color and by the presence of a humongous, 64-pin chip in
the upper left corner of the card (when held with the chips
visible and the bus connector pointing down.)  The two kinds of
cards have completely different labels for their option setting
jumpers, and the newer cards have a few additional settings.
The option set shown below is known to work with
the PC/IP Ethernet packages.

The choice of which DMA channel and which interrupt vector to use
depends on what other I/O equipment is attached to the PC.  For
example, on an IBM PC/XT the hard disk, floppy disk, and printer
are configured to use interrupt vector positions five, six, and
seven, leaving two, three, and four for other attached devices.
The Ethernet commonly uses interrupt vector position three.

@Begin[group]
@Begin[verbatim]
3COM Etherlink card option settings:

    Rev. B             Rev. A
    label              label       suggested jumper position
DMA REQ                 jp1    channel 1 (must match software)
DMA ACK                 jp2    Must match DMA REQ or jp1
Interrupt               jp3    vector 3 (must match software)
I/O address bit 9       n/a    right (1)
I/O address bit 8       jp4    right (1)	
I/O address bit 7       jp5    left  (0)	
I/O address bit 6       jp6    left  (0)	
I/O address bit 5       jp7    left  (0)	
I/O address bit 4       jp8    left  (0)	
Memory address bit 19   n/a    right (1)
Memory address bit 18   jp9    right (1)	
Memory address bit 17   jp10   right (1)	
Memory address bit 16   n/a    left  (0)
Memory address bit 15   n/a    right (1)
Memory address bit 14   jp11   right (1)	
Memory address bit 13   jp12   left  (0)	
Memory address bit 12   jp13   left  (0)	
Memory enable           jp14   right (disable)
n/a                     sw1    Left for onboard transceiver,
                               right for external transceiver
U11/U10                 n/a    Plug goes in socket U10 for onboard,
                               socket U11 for external transceiver

@End[verbatim]
@End[group]

Older Etherlink cards can be set only to interrupt vector positions
three and five, and therefore must use position three in an XT.
Similarly, the PC/XT uses DMA channel three for the hard disk and DMA
channel two for its floppy disk, so the Ethernet must use DMA channel
one. In recent shipments the 3COM Ethernet card has been configured at
the factory with exactly these two settings.

@subheading[3COM Ethernet external transceiver incompatibility]

Certain combinations of 3COM Etherlink cards that are labeled
"Revision B" with external transceivers generate improper
Ethernet waveforms.  These improper waveforms can be decoded
without trouble by any 3COM interface, but some Ethernet
interfaces from other manufacturers cannot decode these improper
signals.  This problem may be the cause when a PC can
communicate with some, but not other, hosts on the same
Ethernet. If switching the 3COM Etherlink card to use the
internal transceiver clears up the difficulty, then the
transceiver incompatibility problem is almost certainly the
cause.  Contact a 3COM sales representative for information on
an engineering change that corrects the problem.

@subsection[Memory expansion card flaw]

Some IBM 64K/256K memory expansion cards have a design flaw that
causes trouble when an I/O device uses DMA channel 1.  (The PC/IP
software usually uses DMA channel 1 for the Ethernet or the
Pronet.)  The symptom of this design flaw when running PC/IP
software is a catastrophic crash with the screen displaying the
message @c"PARITY CHECK 2".  The crash usually occurs within the
first hundred or so packets transmitted to or from the network.

If this problem appears, one should check the memory expansion
card to see whether or not it has this design flaw, and whether
or not it has been field-upgraded.  Flawed cards have a
connection between pins nine and ten of chip U49.  (The
connection is a very small printed circuit stripe on the
underside of the card.)  Repaired cards have had that connection
severed, and two new wires added, from chip U33 pin eight to chip
U33 pin eleven, and from chip U33 pin ten to chip U49 pin nine.
Note that making changes such as these must be done with care to
avoid damaging the card, and may void any warranties.  If you
have a flawed card it may be appropriate to inquire of your
dealer what action should be taken.  Alternatively, the network
can be operated using DMA channel 3 if that channel is not
already in use for some other device such as a hard disk, or can
operate without DMA by selecting channel 0.

23 January 1986.  This document is in file hard-inst.mss
