@part[oldchanges, root "manual"]

@string[sectiontitle = "Old Changes"]
@newpage

@section[Changes In Prior Releases]

This section describes changes between the January, 1985 and  the
February 1, 1984, releases of the PC/IP packages.


@heading[WARNING]

A major structural change in the installed device driver appeared in
the January 1985 release.  As a result, a single PC must run either all 1984
release programs or else all 1985 release programs.  Users of the
1984 release who want to switch to the 1985 release must perform
the installation and customization procedures just as if they had
never before used these programs.  Note, however, that if one PC
runs the 1984 release and another PC runs the 1985 release on the
same network they can communicate.


I.  Changes that affect all packages

1) Name user upgraded to check responses to make sure they are for
the current request rather than for an earlier one.

2) Improved error messages throughout system.

3) The sources of PCIP were modified to compile and assemble with
the latest release of the microcomputer development C compiler, 
which now handles identifiers of longer than 8 characters
correctly.  In addition, a new C library is now is use.  (Neither 
of these changes should cause any user-visible effects.)

4) An error in initialization that caused some programs to crash
when run on machines with more than 512K of memory was fixed.

5) Class B and Class C internet addresses now print properly.

6) All commands now return an error code to DOS as they terminate,
so that the DOS ERRORLEVEL feature can be used.

7) An error in the NETDEV device driver that prevented operation
under TopView was fixed.

8)  The Ethernet device driver is now substantially more reliable,
and it works with the PC/AT.

II.  Changes to protocol implementations


A)  ICMP

1) Time-exceeded debugging messages now include information about
the packet that got in trouble.


B)  IP

1) A bug in interpretation of bit fields in the IP header that
caused the "do-not-fragment" bit to act as the "this is a fragment"
bit was fixed.


C)  UDP

1) An error in length interpretation was fixed, which eliminates
some bogus checksum errors.


D)  TCP

1) TCP now provides an entry that allows an aborting command to
reset a connection before exiting.

2)  Characters received over a TCP connection that have the high-order
(meta- or parity- bit) set to one are now properly discarded as the
TCP specification requires.  Formerly, they were accepted, and the
high-order bit set to zero. (Discarding illegal characters has the
effect, when talking to a TCP host that mistakenly sets parity bits,
of making about half the characters sent by that host disappear.)

III.  Changes in specific packages


A)  PC/@b[telnet]

1) The escape sequences F10-u and F10-U enable and disable the 
25th line clock.

2) A new feature allows the user to specify that the @b[tftp] server 
of @b[telnet] should not ask the user for permission to do file 
transfers.

3) The escape sequence F10-A (which turned on tracing of TCP
activity) is now invoked by F10-P.

4) An experimental feature allows the user to call a command
interpreter while running @b[telnet].


B)  Terminal emulator (used in PC/@b[term] and PC/@b[telnet])

1) Certain escape sequences are not emulated; the emulator simply
discards them.  Formerly, the emulator discarded only the escape
sequence but not its following arguments.  Now, the arguments are
discarded also.

2) In certain scrolling situations, the wrong attribute byte was
used at the end of newly scrolled lines.  The bug affected only
color displays, where text near the bottom of the screen was 
filled to the right with light blue background.  Screen filling 
is now done correctly.


C)  PC/@b[whois]

1) Replaced messages using the old command name @b"finger" with the 
name @b"whois".

2) The user can now abort the command by typing "q".


D)  PC/@b[tftp]

1) An error in PC/@b[tftp] sometimes caused outgoing packets to contain
a header with a zero-length field.  Although the resulting packet 
was, according to protocol, strictly legal, a bug in BSD4.2 UNIX 
caused UNIX to go into a loop in the kernel whenever it received 
such a packet.  The error in PC/@b[tftp] was fixed.

2) An error in server @b[tftp] caused one packet buffer to be lost 
each time it was used to send a file from the PC.  In addition, 
the error caused the wrong data packet to be resent when a timeout 
occurred, thereby assuring failure of that transfer.  The error 
was fixed.  (This error affects both PC/@b[tftp] and PC/@b[telnet].)

3) A bug in calculating the length of error packets was fixed. 
Other hosts should no longer receive error packets with extraneous
junk at the end.


E)  Ethernet driver

1) The 3COM Etherlink card for the PC locks up when it receives
successive runt packets.  It remains locked up until either the 
card is reset or the PC tries to send a packet.  The effect is 
to disable any program (such as ping, tftp, or netwatch) that 
acts as a server.  The Ethernet driver program was modified to 
watch for this condition and reset the Etherlink card if 
necessary.

2) An (apparently) hardware bug causes the 3COM Etherlink card
to occasionally fail to respond to DMA requests on the PC/AT.  
The Ethernet driver program now loops in a busy wait to insure 
that DMA is completed, rather than depending on an interrupt.
It now initiates DMA with a sequence that works on PC's with an
expansion chassis.

3) Zero-length packets (a common occurrence) are no longer 
reported as protocol errors.

4) The software can now be configured to use any DMA channel and
I/O base address that the 3COM Etherlink card can be configured
to use.  (But PC/@b[custom] does not yet allow setting DMA channel.)

5) Lost interrupts are now picked up by a timer.  This addition
improves reliability on Ethernets that have a large traffic
load.


F)  PC/@b[custom]

1) Upgraded to allow flexible choice of I/O base address for
Ethernet interface.  Also allows setting of user  name, office
location, telephone number, and printer service  address.  
Ability to set inverse video mode in display removed.  


G)  PC/@b[netwatch]

1) A new "symbolic" format option displays IP, CHAOS, and 
Ethernet ARP interpretation of received packets, as an 
alternative to simple hexadecimal contents.

2) Packet buffer area reduced from 1000 to 512 undisplayed 
packets.


H)  PC/@b[hostname]

1) Built-in table of name servers brought up to date.


I)  PC/@b[ping]

1) Ethernet version now gives intelligible error messages when
pinging a non-responding host on the same local net.


H)  New packages

1) PC/@b[nicname]:  A command to send requests to the ARPANET 
Network Information Center name server.

2) PC/@b[iprint]:  A command to send files to an Imagen printer
service.


18 January 1985.  This document is in file oldchanges.mss
