@part[soft-inst, root "manual"]

@string[sectiontitle = "Software Installation"]
@newpage

@section[Software Installation]

This section describes how to install the PC/IP commands and
how to do initial customization.

The first step is to determine whether a serial line, an
Ethernet, or a Pronet interface will be used for network
attachment.  One should obtain a diskette containing the proper
versions of the set of PC/IP commands.

The distribution diskette is designed to be a read-only master 
copy, and it does not contain any parts of DOS.  Thus you should 
start by copying the files you intend to use from the 
distribution diskette onto a formatted, DOS-containing working 
diskette or hard disk.  You can then put the distribution 
diskette away in a safe place.

The next step is customization of the PCIP system for your
environment.  To do customization a few key facts about the
environment must be collected for input to the customizer.  If
you are using an Ethernet or Pronet attachment:
@Begin[enumerate]
Someone must assign an internet address for this PC.

If you plan to communicate with hosts not directly attached to the
same physical net, you must know the  internet address of a gateway
that is attached to the Ethernet or Pronet.

If you are using an Ethernet and other hosts on your Ethernet do not
use the proposed standard Ethernet-to-Internet address translation
protocol, you must obtain a list of Ethernet-to-Internet address
translations for the other hosts on your Ethernet.

Figure out which DMA channel and which interrupt vector  will be used
by your network interface.  (See the hardware  installation section
for details.)
@End[enumerate]

If you are using a serial line attachment, you do not need any of
the above pieces of information.  Instead, you must know the data
rate of the serial line you plan to use.

That is the minimum repertoire of information needed for
customization.  In addition, you will probably want to make use
of time, name, and printer services, so you should also obtain a 
list of names of up to five name servers and time servers, and 
one print server.  The names are all you need if your local net 
is linked to the ARPANET; you will be able to use the PC/@b[hostname]
command to discover the internet addresses of those services.

The next step is to customize the network device, a file named
@i"netdev.sys" on the working diskette or hard disk, using the 
minimum set of facts collected above.  See the writeup of 
command PC/@b[custom] for details on how to customize @i"netdev.sys".

The customization of @i"netdev.sys" does not take effect until you
install it as a DOS device driver.  The reason is that 
@i"netdev.sys" is a file that describes a device driver rather than 
the device driver itself.  Installation is automatic when DOS is 
bootloaded, that is either when the PC power is turned on or when
control-alt-delete is typed.  However, there is one detail: In 
order for the device driver to be installed automatically, the 
bootload diskette or disk must also contain a file named 
@i"config.sys" and that file must contain a line such as:

          DEVICE=NETDEV.SYS

that names the file containing the device driver.  If you already
use a @i"config.sys" file you should make a copy of it and add this
line, using a text editor.  If you do not already have a
@i"config.sys" file, you can use the one found on the distribution
diskette.  The DOS reference manual provides more information
about the DEVICE command and about the file @i"config.sys".

You should now have a @i"config.sys" file containing a "device"
command that names @i"netdev.sys", you should have customized
@i"netdev.sys" with the minimum information, and after you bootload
DOS (type control-alt-delete) you will be ready to try a PC/IP
command. 

Try, for example, PC/@b[ping], specifying the IP address of some host
that you should be able to address, to see what happens.  If
customization is not correct, some error message should appear
that may give a clue as to what is wrong.  

The next step is to use PC/@b[hostname] to obtain the internet
addresses of some time and name servers, add them to the
customization, and reboot to check them out.  PC/@b[setclock] can be
used to verify that both time service and name service customization
are working: if PC/@b[setclock] succeeds when invoked with no
argument, at least one time service address is correct; if it can
obtain the time from a named time service, at least one name service
address is correct.


8 April 1985.  This document is in file soft-inst.mss
