@part[supdup, root "manual"]

@string[sectiontitle = "@b<supdup>"]
@newpage

@section[Supdup]

PC/@b[supdup], version 4.0

An alternative remote login package for the IBM PC, using the TCP/IP
protocol and emulating a supdup display terminal.

@Begin[format]
Usage:

     @b[supdup] hostname
or
     @b[supdup] -p portno hostname
@End[format]

Where @i"hostname" is either a character-string name of the target
host, or an internet address in standard form.  (See the section
on hostnames in the network overview for more details.)  When
used with the "-p" option, the argument @i"portno" is used as a
port number at the target machine.  This feature is used to
connect with certain supdup-like services available on some
hosts.

From the point of view of the target host, PC/@b[supdup] emulates a
standard @b"supdup" display terminal. The implementation is not complete,
but the protocol allows the user to tell the server what features it
implements. The server should set up your terminal characteristics for
you; if you change them it's not likely that things will work.

If the environment variable @c"LOCATION" is set, its value will be passed
to the supdup server as the location of your PC.

Typing the command with the name or internet address of a target
host causes PC/@b[supdup] to try to establish a connection.  When that
connection is successful, the target host should display its
greeting banner.

The PC "Print-Screen" feature, triggered by key "PrtSc", can be used
from within PC/@b[supdup], but immediately preceding its use one must
restore the display buffer to the format expected by PrtSc.  Function
key F10 typed twice does this format adjustment.

@subsection[Closing connections]

At the end of a login session, some hosts will close the connection,
in which case PC/@b[supdup] exits, returning to the PC operating system.
Other hosts issue an invitation for another login.  In the latter
case, type F10 followed by "c" to close the connection and exit from
PC/@b[supdup].  Other methods of exiting, such as F10 followed by "q",
or powering down the PC, will leave a dangling TCP/Supdup connection
that some hosts may not clean up properly.  A later attempt to login
to that host from the same PC may encounter interference from the
unclosed previous connection.

If you close a connection without logging out, most hosts will
deal with the situation in the same way they handle telephone
line hangups.  If you exit supdup without either logging out or
closing the connection, the host may not realize you are gone,
and there is no way to pick up the connection again.  (The host,
noticing lack of activity for a long time, may eventually log you
out and close the connection.)

If you try to open a connection to a host that does not respond, 
PC/@b[supdup] will try eight times, then display an error message and exit.
Note that this message may mean either that the target host is not
listening to the network or that some network or gateway in the 
communication path to that host has failed.  (The command PC/@b[ping]
may be useful in isolating the trouble.)

@subsection(File transfer with PC/supdup)

Refer to the section on file transfer in the PC/@b[telnet] writeup.

@subsection[Customization]

The following parameters of supdup can be customized with the
PC/@b[custom] command:

     1)  The parameters for TCP window size and TCP low window
	 are of particular interest to PC/supdup users.  See
	 the description of @b[custom] for explanation of these
         parameters.

@subsection[DOS 2.0 note]

The DOS 2.0 feature of redirecting output to a file cannot be used
for PC/@b[supdup] display output.


@subsection[Supdup Caveat]

Unfortunately, very few machines have TCP/Supdup servers. The only servers
known to us are on Mit-MC and Su-AI, and 4.2 Unix machines running a
server we distribute.

18 September 1985.  This document is in file supdup.mss
