@part[tech, root "manual"]

@string[sectiontitle = "Technical Notes"]
@newpage

@section[Technical Notes on PC/IP]

This section discusses technical details about the implementation of
PC/IP and interactions between PC/IP and other TCP/IP implementations
(especially Berkeley 4.2 Unix). Casual users of PC/IP can skip this
section unless interested; people installing PC/IP at a site should
definitely read this section.

@subsection[Device Drivers]

Both the Interlan and 3COM ethernet drivers use the Address Resolution
Protocol (ARP), as described in NIC RFC 826. The proNET driver does
not support ARP.

Some TCP/IP implementations encapsulate IP packets in a non-standard
fashion called a @i"trailer", as specified in NIC RFC 893. PC/IP does
not support trailers with any of its drivers; instead, it supports
only the standard form of encapsulation as specified in NIC RFC 894.
The only implementations that are known to send trailers are 4.2
@c[Unix]@footnote{@c[UNIX] is a trademark of American Telephone and
Telegraph Co."} derivatives (Wollongong's VMS TCP/IP, for instance, is
derived from 4.2's). The 4.2 Unix command @i[ifconfig(8)] can control
trailer usage on a per-interface basis.

The maximum length packet PC/IP is prepared to send or receive is
620 bytes long, including the local net header.

@subsection[IP]

The IP layer does not implement packet fragmentation or reassembly. If
a packet fragment is received, it is discarded. Options are never
sent, and incoming options are ignored. Type of service is ignored.

Incoming destination unreachables and other errors will be printed on
the display if the NETERR or PROTERR debugging flags are turned on
(see the section on debugging). IP protocol or TCP or UDP socket, unless those
packets were broadcast. Packets are determined to be broadcast by the
old convention of having the host field be all 0's.

Routing is done according to RFC 950. The user specifies the PC's
network address and the number of bits in its subnet field with the
PC/@b[custom] command. This program computes a mask that can be used
to separate the net/subnet portion of the address from the host
portion. Two machines are determined to be on the same physical
network if the net/subnet parts of both their addresses are identical.
If PC/IP tries to send to a machine that is not on the same physical
network, it routes the packet through the default gateway, also
specified with @b[custom]. If PC/IP receives an ICMP redirect from the
gateway, it records the redirect in internal routing tables, which it
scans before using the default gateway.

@subsection[UDP]

PC/IP has a complete UDP implementation, including checksums.

The 4.2 Unix UDP had a number of problems that have been fixed in 4.3.
Among other things, checksums were computed incorrectly, so PC's would
not accept packets from 4.2 machines.

@subsection[TCP]

The TCP is a single connection implementation tailored to Telnet. It
sends MAXBUFSIZE options setting the maximum buffer size to 511 bytes
to defeat trailers (discussed above; trailer packets have a multiple
of 512 bytes of data). It ignores incoming MAXBUFSIZE options.

A number of TCP problems have been fixed since the January 1985
release. One of the most noticeable was an incompatibility between 4.2
Unix's TCP and PC/IP's. The 4.2 TCP sent probing messages called
"keepalives" when a connection was otherwise inactive. PC/IP did not
respond to these messages the way 4.2 expected, and 4.2 would decide
that the PC was down and close the connection. PC/IP's TCP now
responds as 4.2 expects.

@subsection[Hostname resolution]

This release has a simple domain name resolver, and all executable
programs use it in addition to the old-style hostname resolver. This
domain name resolver depends on the name server doing recursion.
Recent versions of the @i[Bind] Unix domain name system have supported
this. There are not currently any other servers to report on.

PC/IP uses the following algorithm when trying to resolve hostname
@i[foo]:
@Begin[verbatim]
If @i[foo] is a numeric address
	then parse @i[foo] and return the result.
If @i[foo] is a fully qualified domain name,
	then attempt a domain name resolution of @i[foo]
		if the domain name resolution fails
			try an old style name resolution of @i[foo]
		if this resolution fails return an error
If @i[foo] is not a fully qualified domain name,
	then attempt a domain name resolution of @i[foo.my_domain]
		(where @i[my_domain] is the default domain specified
		 in configuration with the PC/@b[custom] command)
		if that name resolution fails, try @i[foo.arpa]
		if that fails, try @i[foo] with old name resolver
		if that fails, return an error
@End[verbatim]

@subsection[TFTP]

The PC TFTP implementation includes both a TFTP user and server, and
implements both NETASCII and OCTET modes of file transfer.

The 4.2 Unix TFTP server and user were unreliable and did not
implement NETASCII mode.  A completely different implementation of
TFTP for Berkeley UNIX, one that meets all the specifications of TFTP
and that does not require either Berkeley or AT&T source licenses, is
available on on the PC/IP source tape.
@subsection[LPR]

The 4.2 @i[lpr] daemon accepts requests only from hosts authorized to
use it. A host is authorized if it is listed in the file
@i[/etc/hosts.lpd] on the server host. Unfortunately, only hosts with
names are handled, so you must assign names to any PC's you wish to
let use the line printer spooler. See @i[4.2BSD Line Printer Spooler
Manual], by Ralph Campbell, included in the 4.2 and 4.3 Unix releases.

17 January 1986. This document is in file tech.mss
