#
/* showlog.c */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	"notice.h"


/* EMACS_MODES: c !fill */

/* Watch the tail of a log file and print changes. */

#include	<stdio.h>

#define	SLEEPTIME	1
#define	LINSIZ		128

main (argc, argv)
int	argc;
char	**argv;
{
	FILE	*logfd;
	char	line[LINSIZ];
	
	if (argc != 2) {
		printf ("usage: %s <logfile>\n", argv[0]);
		exit (1);
	}
	if ((logfd = fopen (argv[1], "r")) == NULL) {
		printf ("can't open log file\n");
		exit (1);
	}
	
	fseek (logfd, 0L, 2);		/* to end */
	
	for (;;) {			/* do til killed */
		while (fgets (line, LINSIZ, logfd) != NULL)
			printf ("%s", line);
		sleep (SLEEPTIME);
	}
}
