// DLL Functions for component

#include "stdafx.h"

#include "component.h"

// TODO: Change these strings to your own requirements
const TCHAR g_szFriendlyName[] = _T("Component Friendly Name");
const TCHAR g_szVerIndProgID[] = _T("Component.Object");
const TCHAR g_szProgID[] = _T("Component.Object.1");

//////////////////////////////////////////////////////////////////////////////
// DLL FUNCTIONS:

HINSTANCE g_hModule = NULL ;   // DLL module instance

// Standard DLL entry point. Save module handle for future use
BOOL APIENTRY DllMain(HINSTANCE hModule, DWORD dwReason,
                      void* lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
		g_hModule = hModule ;
	return TRUE ;
}

// register COM component
STDAPI DllRegisterServer()
{
	// TODO: Change CLSID_Component to the name used in Component.h GUID declaration
	return RegisterServer(g_hModule, 
	    CLSID_Component, g_szFriendlyName,
	    g_szVerIndProgID, g_szProgID);
}

// unregister COM component
STDAPI DllUnregisterServer()
{
	// TODO: Change CLSID_Component to the name used in Component.h GUID declaration
	return UnregisterServer(CLSID_Component,
	     g_szVerIndProgID, g_szProgID);
}

// Called by COM to determine if this DLL is in use (i.e. has components, or is currently
// locked by IClassFactory)
STDAPI DllCanUnloadNow()
{
	if(g_nComponents == 0 && g_nServerLocks == 0)
		return S_OK;
	else
		return S_FALSE;
}

// Called by COM to get a IClassFactory pointer for the component
STDAPI DllGetClassObject(REFCLSID clsid,
							REFIID iid, LPVOID* ppv)
{
	// TODO: Change CLSID_Component to the name used in Component.h GUID declaration
	if(clsid != CLSID_Component)
		return CLASS_E_CLASSNOTAVAILABLE;
	CFactory *pFactory = new CFactory;
	if(pFactory == NULL)
		return E_OUTOFMEMORY;
	// get requested interface
	HRESULT hr = pFactory->QueryInterface(iid, ppv);
	return hr;
}

