// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// Chapter 5: Processes and Threads. Sample Code

#include "stdafx.h"
#include "examples.h"


// *** Listing 5.1
//
// Create a process.

void Listing5_1()
{
	TCHAR szApplication[MAX_PATH];
	PROCESS_INFORMATION pi;

	if(!GetTextResponse(_T("Enter Application to Run:"), szApplication, MAX_PATH))
		return;
	if(CreateProcess(szApplication, NULL, NULL, NULL, FALSE, 0,
				NULL, NULL, NULL, &pi) == 0)
		cout << _T("Cannot create process") << endl;
	else
	{
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}
}


// *** Listing 5.2
//
// Executing an application with ShellExecuteEx

void Listing5_2(HWND hWnd)
{
	SHELLEXECUTEINFO sei;
	TCHAR szApplication[MAX_PATH];

	if(!GetTextResponse(_T("Enter Application to Run:"), szApplication, MAX_PATH))
		return;

	memset(&sei, 0, sizeof(sei));
	sei.cbSize = sizeof(sei);
	sei.hwnd = hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = szApplication;
	sei.lpParameters = NULL;
	sei.nShow = SW_SHOWNORMAL;
	if(ShellExecuteEx(&sei) == 0)
		cout << _T("Error calling ShellExecuteEx:") << GetLastError() << endl;
}	

// *** Listing 5.3
//
// Waiting for a process to terminate

void Listing5_3()
{
	TCHAR szApplication[MAX_PATH];
	PROCESS_INFORMATION pi;

	if(!GetTextResponse(_T("Enter Application to Run:"), szApplication, MAX_PATH))
		return;
	if(CreateProcess(szApplication, NULL, NULL, NULL, FALSE, 0,
				NULL, NULL, NULL, &pi) == 0)
		cout << _T("Cannot create process") << endl;
	else
	{
		if(WaitForSingleObject(pi.hProcess, INFINITE) == WAIT_FAILED)
			cout << _T("Could not wait on object");
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}
}

// *** Listing 5.4
//
// List running processes

#include <Tlhelp32.h>
// Add toolhelp.lib to the project

void Listing5_4()
{
  HANDLE         hProcessSnap;
  PROCESSENTRY32 pe32;
  
  // Take a snapshot of all processes currently in the system.
  hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  if (hProcessSnap == (HANDLE)-1)
  {
		cout << _T("Could not take Toolhelp snapshot") << endl;
		return ;
  }
  
  pe32.dwSize = sizeof(PROCESSENTRY32);
  
  if (Process32First(hProcessSnap, &pe32))
  {
      do
      {
		  cout << pe32.szExeFile
				<< _T(" Threads: ") << pe32.cntThreads
				<< _T(" ProcID: ") << pe32.th32ProcessID
				<< endl;
      }
      while (Process32Next(hProcessSnap, &pe32));
    }
    
    CloseToolhelp32Snapshot (hProcessSnap);
    return ;
}


// *** Listing 5.5
//
// Modules in use by a process

void Listing5_5()
{
	HANDLE        hModuleSnap;
	MODULEENTRY32 me32;
	DWORD dwProcessID;

	dwProcessID = GetCurrentProcessId();
	  
	hModuleSnap = CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwProcessID);
  
	if (hModuleSnap == (HANDLE)-1)
	{
		cout << _T("Could not take Toolhelp snapshot") << endl;
		return ;
	}
  
	me32.dwSize = sizeof(MODULEENTRY32);
  
	if (Module32First(hModuleSnap, &me32))
	{
		do 
		{   
		  cout << me32.szModule
				<< _T(" Base addr: ") << (DWORD)me32.modBaseAddr
				<< _T(" Size (KB): ") << me32.modBaseSize / 1024 << endl;
		  TCHAR szPathname[MAX_PATH];
		  GetModuleFileName(me32.hModule, szPathname, MAX_PATH);
		  cout << szPathname << endl;
		}
      while (Module32Next(hModuleSnap, &me32));
	}
    CloseToolhelp32Snapshot (hModuleSnap);
    return;
}

// *** Listing 5.6
//
// Determining if this is the first instance. This function is 
// called when the application first starts up.

BOOL Listing5_6()
{
	HWND hWnd;

	hWnd = FindWindow(_T("EXAMPLES"), NULL);
	if(hWnd == NULL)
		return FALSE;		// this is the first instance
	ShowWindow(hWnd, SW_SHOWNORMAL);
	SetForegroundWindow(hWnd);
	PostQuitMessage(0);		// terminate this instance
	return TRUE;
}

// *** Listing 5.7
//
// Creating a Thread

DWORD WINAPI MyThreadProc1(LPVOID lpParameter)
{
	cout << _T("Message from the thread") << endl;
	return 0;
}

void Listing5_7()
{
	HANDLE hThread;
	DWORD dwThreadId;

	hThread = CreateThread(NULL, 0, MyThreadProc1, NULL, 0, &dwThreadId);
	if(hThread == NULL)
		cout << _T("Could not create thread") << endl;
	else
	{
		CloseHandle(hThread);
		cout << _T("Thread Created") << endl;
	}
}

// *** Listing 5.8
//
// Thread Exit Code

DWORD WINAPI MyThreadProc2(LPVOID lpParameter)
{
	ExitThread(10);
	cout << _T("This message is not displayed") << endl;
	return 0;
}

void Listing5_8()
{
	HANDLE hThread;
	DWORD dwExitCode;

	hThread = CreateThread(NULL, 0, MyThreadProc2, NULL, 0, NULL);
	if(hThread == NULL)
		cout << _T("Could not create thread") << endl;
	else
	{
		if(WaitForSingleObject(hThread, 5000) == WAIT_FAILED)
			cout << _T("Could not wait on thread") << endl;
		GetExitCodeThread(hThread, &dwExitCode);
		CloseHandle(hThread);
		cout << _T("Thread Exit code: ") << dwExitCode << endl;
	}

}

// *** Listing 5.9
//
// Sleeping a thread

void Listing5_9()
{
	DWORD dwTickCount = GetTickCount();
	Sleep(1);
	dwTickCount = GetTickCount() - dwTickCount;
	cout << _T("Sleep for: ") << dwTickCount << endl;
}

// *** Listing 5.10
//
// Getting and setting the thread quantum

void Listing5_10()
{
	cout << CeGetThreadQuantum(GetCurrentThread()) << endl;
	CeSetThreadQuantum(GetCurrentThread(), 20);
}

// *** Listing 5.11
//
// Setting Realtime thread priorities

void Listing5_11()
{
	int nPri = CeGetThreadPriority(GetCurrentThread());

	cout << _T("Pri: ") << nPri << endl;
	CeSetThreadPriority(GetCurrentThread(), 1);
	cout << _T("New Pri: ") << CeGetThreadPriority(GetCurrentThread()) << endl;
	CeSetThreadPriority(GetCurrentThread(), nPri);
}

// *** Listing 5.12
//
// 

void Listing5_12()
{
	HANDLE        hThreadSnap;
	THREADENTRY32 th32;

	hThreadSnap = CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, 0);
  
	if (hThreadSnap == (HANDLE)-1)
	{
		cout << _T("Could not take Toolhelp snapshot") << endl;
		return ;
	}
  
	th32.dwSize = sizeof(THREADENTRY32);
  
	if (Thread32First(hThreadSnap, &th32))
	{
		do 
		{
			cout << _T("ThreadID: ") << th32.th32ThreadID
				<< _T(" ProcessID: ") << th32.th32OwnerProcessID
				<< _T(" Priority: ") << th32.tpBasePri << endl;
		}
      while (Thread32Next(hThreadSnap, &th32));
	}
    CloseToolhelp32Snapshot(hThreadSnap);
    return;
}

