// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CEBlock.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

// Function prototype to export function.
extern "C"
{
__declspec(dllexport) int WaitCreateProcess(DWORD cbInput, BYTE* pInput, DWORD *pcbOutput, BYTE **ppOutput, PVOID reserved);
}

int WaitCreateProcess(DWORD cbInput, BYTE* pInput, DWORD *pcbOutput, BYTE **ppOutput, PVOID reserved)
{
	LPTSTR lpAppName = (LPTSTR)pInput;
	PROCESS_INFORMATION pi;
	int nError = 0;

	if(!CreateProcess(lpAppName, NULL, NULL, NULL, FALSE,0, NULL, NULL, NULL, &pi))
		nError = GetLastError();
	else
	{
		if(WaitForSingleObject(pi.hProcess, INFINITE) == WAIT_FAILED)
			nError = GetLastError();
	}
	CloseHandle(pi.hProcess);
	CloseHandle(pi.hThread);
	*ppOutput = (BYTE*)LocalAlloc(LPTR, sizeof(nError));
	memcpy(*ppOutput, &nError, sizeof(nError));
	*pcbOutput = sizeof(nError);
	return 0;
}
