// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// CustomStream.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <rapi.h>
#include <iostream.h>

const DWORD dwCODE_ERROR = 1;
const DWORD dwCODE_USERTIME = 2;
const DWORD dwCODE_END = 3;

void ShowThreadTime(FILETIME ft[4])
{
	__int64 ht;

	ht = ft[3].dwHighDateTime;
	ht <<= 32;
	ht |= ft[3].dwLowDateTime;
	ht /= 10000;
	cout << "User Time: " << (DWORD)ht << endl;
}

int main(int argc, char* argv[])
{
	HRESULT hr;
	DWORD dwOut, dwCode, dwBytesRead, dwError;
	BYTE* pOut;
	int nErr;
	BOOL bContinue = TRUE;
	IRAPIStream *pStream;
	FILETIME ft[4];

	hr = CeRapiInit();
	if(FAILED(hr))
	{
		cout << "Could not initialize RAPI:" << GetLastError() << endl;
		return 1;
	}
	LPWSTR lpAppname = L"\\windows\\cmd.exe";
	
	hr = CeRapiInvoke(L"CEStream", L"ThreadTimes", 
			(wcslen(lpAppname) + 1) * sizeof(WCHAR), 
			(BYTE*)lpAppname, &dwOut, &pOut, &pStream, 0);
	if(FAILED(hr))
	{
		nErr = CeGetLastError();
		switch(nErr)
		{
		case ERROR_FILE_NOT_FOUND :
			cout << "Library not found" << endl;
			break;
		case ERROR_CALL_NOT_IMPLEMENTED:
			cout << "Could not locate function in library" << endl;
			break;
		case ERROR_EXCEPTION_IN_SERVICE:
			cout << "Exception caught in function" << endl;
			break;
		default:
			cout << "Error in invoke: " << nErr << endl;
		}
	}
	else
	{
		while(bContinue)
		{
			// Read the DWORD code
			hr = pStream->Read(&dwCode, sizeof(DWORD), &dwBytesRead);
			if(FAILED(hr) || dwBytesRead != sizeof(DWORD))
			{
				cout << "Could not read result: " << CeGetLastError();
				bContinue = FALSE;
			}
			else
			{
				switch (dwCode)
				{
				case dwCODE_ERROR:
					hr = pStream->Read(&dwError, sizeof(DWORD), &dwBytesRead);
					if(FAILED(hr) || dwBytesRead != sizeof(DWORD))
						cout << "Could not read error code" << endl;
					else
						cout << "Error from Windows CE: " << dwError << endl;
					bContinue = FALSE;
					break;
				case dwCODE_USERTIME:
					hr = pStream->Read(ft, sizeof(ft), &dwBytesRead);
					if(FAILED(hr) || dwBytesRead != sizeof(ft))
						cout << "Could not read filetime" << endl;
					else
						ShowThreadTime(ft);
					break;
				case dwCODE_END:
					bContinue = FALSE;
					break;
				}
			}
		}
	}
	hr = CeRapiUninit();
	if(FAILED(hr))
		cout << "Could not un-initialize RAPI" << endl;
	return 0;
}

