// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// FindAllFiles.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <rapi.h>
#include <iostream.h>

void ShowRAPIError()
{
	int nErr = CeRapiGetError();
	if(nErr == 0)
		cout << "Win32 Error:" 
				<< GetLastError() << endl;
	else
		cout << "RAPI Error:"
				<< nErr << endl;
}

int main(int argc, char* argv[])
{
	HRESULT hr;
	DWORD dwFileCount;
	LPCE_FIND_DATA pFindDataArray;
	char szFilename[MAX_PATH];

	// List files in root directory of connected CE Device
	hr = CeRapiInit();
	if(FAILED(hr))
	{
		cout << "Could not initialize RAPI:" << GetLastError() << endl;
		return 1;
	}
	if(!CeFindAllFiles(L"\\*.*", 
				FAF_NAME | FAF_SIZE_LOW | FAF_ATTRIBUTES, 
				&dwFileCount, 
				&pFindDataArray))
		ShowRAPIError();
	else
	{
		cout << "Files in root of Windows Device:" << endl;
		for(DWORD i = 0; i < dwFileCount; i++)
		{
			wcstombs(szFilename, pFindDataArray[i].cFileName, MAX_PATH);
			cout << szFilename << " ";
			if(pFindDataArray[i].dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				cout << "<DIR>" << endl;
			else
				cout << pFindDataArray[i].nFileSizeLow << endl;
		}
		CeRapiFreeBuffer(pFindDataArray);
	}
	hr = CeRapiUninit();
	if(FAILED(hr))
		cout << "Could not un-initialize RAPI" << endl;

	return 0;
}

