// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// SockClient.cpp : Simple Socket Client to run on a Win32 application and communiate with a
//				    socket server running on Windows CE device.
//
// Include wsock32.lib rapi.lib into the project.

#include "stdafx.h"

#include <winsock.h>
#include <rapi.h>
#include <tchar.h>

#define SERVER_PORT    50000


SOCKET ConnectSocket(char* szIPAddress)
{
	DWORD dwDestAddr;
	SOCKADDR_IN sockAddrDest;
	SOCKET sockDest;

	// create socket
	sockDest = socket(AF_INET, SOCK_STREAM, 0);
	if(sockDest == SOCKET_ERROR)
	{
		cout << "Could not create socket:" << WSAGetLastError() << endl;
		return INVALID_SOCKET;
	}

	// convert address to in_addr (binary) form
	dwDestAddr = inet_addr(szIPAddress);
	// Initialize SOCKADDR_IN with IP address, port number and address family
	memcpy(&sockAddrDest.sin_addr, &dwDestAddr, sizeof(DWORD));
	sockAddrDest.sin_port = htons(SERVER_PORT);
	sockAddrDest.sin_family = AF_INET;  // Internet address family
	// attempt to connect to server
	if(connect(sockDest, (LPSOCKADDR)&sockAddrDest, sizeof(sockAddrDest)) == SOCKET_ERROR)
	{
		cout << "Could not connect to server socket:" << WSAGetLastError() << endl;
		closesocket(sockDest);
		return INVALID_SOCKET;
	}
	return sockDest;
}

int main(int argc, char* argv[])
{
	WSADATA wsaData;
	char szIPAddress[100];
	char szBuffer[100];
	int nSent, nToSend, nRecv, nReceived;
	SOCKET sock;

	// Get Server IP address
	cout << "Enter IP address of CE Device: ";
	cin.getline(szIPAddress, 1024);
	cout << "Connecting to:" << szIPAddress << endl;
	// Initialize WinSock
	if(WSAStartup(MAKEWORD(1,1), &wsaData) != 0)
	{
		cout << "Could not initialize sockets" << endl; 
		return 1;
	}
	// Create socket and connect to server
	sock = ConnectSocket(szIPAddress);
	if(sock == INVALID_SOCKET)
		return 1;
	// Now send information to server
	while(TRUE)
	{
		// read line of input from user
		cout << "Line to send or <END> to finish:";
		cin.getline(szBuffer, 1024);
		if(strcmp(szBuffer, "<END>") == 0) // marks end of text from user
			break;
		strcat(szBuffer, "\r\n");
		nToSend = strlen(szBuffer) + 1;
		// send this line to the server
		nSent = send(sock, szBuffer, nToSend, 0);
		if(nSent == SOCKET_ERROR)
		{
			cout << "Connection Broken:" << WSAGetLastError() << endl;
			break;
		}
		// now read back the number of characters received.
		nRecv = recv(sock, (char*)&nReceived, sizeof(nReceived), 0);
		if(nRecv != sizeof(nReceived))
		{
			cout << "Error reading acknowledgement:" << WSAGetLastError() << endl;
			break;
		}
		if(nReceived != nToSend)
		{
			cout << "Error in number of bytes sent:" << WSAGetLastError() << endl;
			break;
		}
	}
	// close socket
	closesocket(sock);
	// Clean up Winsock
	if(WSACleanup() == SOCKET_ERROR)
	{
		cout << "Could not cleanup sockets:" << WSAGetLastError() << endl; 
		return 1;
	}
	return 0;
}
