// 'Windows CE 3.0 Programming' Source Code Samples (Prentice Hall, 2000)
// Source Code Author: Nick Grattan (nick@softwarepaths.com)
// Version 1.00

// SockServer.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "SockServer.h"
#include <commctrl.h>

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE			hInst;			// The current instance
HWND				hwndCB;			// The command bar handle
HWND				hEdit;			// The edit box for displaying information

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE hInstance, LPTSTR szWindowClass);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
DWORD WINAPI SockThread(LPVOID);

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_SOCKSERVER);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_SOCKSERVER));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_SOCKSERVER, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance, szWindowClass);

	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		0, 0, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{	
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	if (hwndCB)
		CommandBar_Show(hwndCB, TRUE);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	HANDLE hThread;
	DWORD dwThreadID;

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_HELP_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_FILE_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CommandBar_Create(hInst, hWnd, 1);			
			CommandBar_InsertMenubar(hwndCB, hInst, IDM_MENU, 0);
			CommandBar_AddAdornments(hwndCB, 0, 0);
			hEdit = CreateWindow(_T("Edit"), NULL,
					WS_CHILD | WS_VISIBLE | ES_MULTILINE | ES_READONLY, 
					0,0,0,0,
					hWnd, NULL, hInst,NULL);
			if(hEdit == NULL)
				MessageBox(hWnd, _T("Could not create edit window"), NULL, MB_OK);
			hThread = CreateThread(NULL, 0, SockThread, 0, 0, &dwThreadID);
			if(hThread == NULL)
				MessageBox(hWnd, _T("Could not create thread"), NULL, MB_OK);
			else
				CloseHandle(hThread);
			break;
		case WM_SIZE:
			MoveWindow(hEdit, 0, CommandBar_Height(hwndCB), LOWORD(lParam), 
					HIWORD(lParam) - CommandBar_Height(hwndCB), TRUE);
			break;
		case WM_DESTROY:
			CommandBar_Destroy(hwndCB);
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT rt, rt1;
	int DlgWidth, DlgHeight;	// dialog width and height in pixel units
	int NewPosX, NewPosY;

	switch (message)
	{
		case WM_INITDIALOG:
			// trying to center the About dialog
			if (GetWindowRect(hDlg, &rt1)) {
				GetClientRect(GetParent(hDlg), &rt);
				DlgWidth	= rt1.right - rt1.left;
				DlgHeight	= rt1.bottom - rt1.top ;
				NewPosX		= (rt.right - rt.left - DlgWidth)/2;
				NewPosY		= (rt.bottom - rt.top - DlgHeight)/2;
				
				// if the About box is larger than the physical screen 
				if (NewPosX < 0) NewPosX = 0;
				if (NewPosY < 0) NewPosY = 0;
				SetWindowPos(hDlg, 0, NewPosX, NewPosY,
					0, 0, SWP_NOZORDER | SWP_NOSIZE);
			}
			return TRUE;

		case WM_COMMAND:
			if ((LOWORD(wParam) == IDOK) || (LOWORD(wParam) == IDCANCEL))
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}


/////////////////////////////////////////////////////////////////////////////////

#include <winsock.h>

#define SERVER_PORT    50000

// displays last error associated with socket function
void DisplaySocketError(LPCTSTR lpszError)
{
	TCHAR szBuffer[1024];

	int nErr = WSAGetLastError();
	wsprintf(szBuffer, lpszError, nErr);
	MessageBox(GetFocus(), szBuffer, _T("WinSock Error"), MB_OK);
}

// Appends text to end of contents of edit box
void AppendToEditBox(LPCTSTR lpBuffer)
{
	int nIndex = -1;

	SendMessage(hEdit, EM_SETSEL, nIndex, nIndex); 
	SendMessage(hEdit, EM_REPLACESEL, 0, (LPARAM)lpBuffer); 
}

// creates a listening socket and waits for a connection. Returns a connected
// socket

SOCKET CreateListener()
{
	SOCKADDR_IN sockAddrListen;
	SOCKET sockListen;
	DWORD address;
	char szHostName[1024];
	HOSTENT* lphostent;

	// create a socket
	sockListen = socket(AF_INET, SOCK_STREAM, 0);
	if(sockListen == INVALID_SOCKET)
	{
		DisplaySocketError(_T("Could not create socket: %d"));
		return INVALID_SOCKET;
	}

	if(gethostname (szHostName, 1024) == SOCKET_ERROR)
	{
		DisplaySocketError(_T("Could not get host name: %d"));
		return INVALID_SOCKET;
	}
	lphostent = gethostbyname(szHostName);
	if(lphostent == NULL)
	{
		DisplaySocketError(_T("Could not get host information: %d"));
		return INVALID_SOCKET;
	}
	memcpy(&address, lphostent->h_addr_list[0], sizeof(address));

	memset(&sockAddrListen, 0, sizeof(SOCKADDR_IN));
	// specify the port number
	sockAddrListen.sin_port = htons(SERVER_PORT);
	// specify address family as Internet
	sockAddrListen.sin_family = AF_INET;
	// specify address to bind to
	sockAddrListen.sin_addr.s_addr = address;
	
	// bind socket with the SOCKADDR_IN structure
	if(bind(sockListen, (LPSOCKADDR)&sockAddrListen, sizeof(SOCKADDR)) == SOCKET_ERROR)
	{
		DisplaySocketError(_T("Could not bind socket: %d"));
		return INVALID_SOCKET;
	}
	// listen for a connection
	if(listen(sockListen, 1) == SOCKET_ERROR)
	{
		DisplaySocketError(_T("Could not listen on socket: %d"));
		return INVALID_SOCKET;
	}
	return sockListen;
}

DWORD WINAPI SockThread(LPVOID)
{
	WSADATA wsaData;
	SOCKET sockConnected, sockListen;
	int nReceive, nSent;
	char  szmbsBuffer[1024];
	TCHAR szBuffer[1024];
	SOCKADDR_IN sockAddrClient;
	int nAddrLen = sizeof(SOCKADDR_IN);

	AppendToEditBox(_T("Thread started...\r\n"));
	// Initialize WinSock
	if(WSAStartup(MAKEWORD(1,1), &wsaData) != 0)
	{
		MessageBox(GetFocus(), _T("Could not initialize sockets"), NULL, MB_OK);
		return 1;
	}
	sockListen = CreateListener();
	while(TRUE)
	{
		AppendToEditBox(_T("Waiting for connection\r\n"));
		// block until a socket attempts to connect
		sockConnected = accept(sockListen, (LPSOCKADDR)&sockAddrClient, &nAddrLen);
		if(sockConnected == INVALID_SOCKET)
		{
			DisplaySocketError(_T("Could not accept a connection: %d"));
			break;
		}
		if(sockConnected != INVALID_SOCKET)
		{
			// accept strings from client while connection is open
			while(TRUE)
			{
				nReceive = recv(sockConnected, szmbsBuffer, 1024, 0);
				if(nReceive == 0)
				{
					AppendToEditBox(_T("Connection broken\r\n"));
					break;
				}
				else if(nReceive == SOCKET_ERROR)
				{
					DisplaySocketError(_T("Error receiving: %d"));
					break;
				}
				// convert to Unicode
				szmbsBuffer[nReceive] = '\0';
				mbstowcs(szBuffer, szmbsBuffer, nReceive + 1);
				// appened to edit box
				AppendToEditBox(szBuffer);
				// send acknowledgement
				nSent = send(sockConnected, (char*)&nReceive, sizeof(nReceive), 0);
				if(nSent == SOCKET_ERROR)
				{
					DisplaySocketError(_T("Cannot send acknowledgement: %d"));
					break;
				}
			}
			// connection broken, clean up.
			shutdown(sockConnected, SD_BOTH);
			closesocket(sockConnected);
		}
	}
	// Clean up Winsock
	if(WSACleanup() == SOCKET_ERROR)
	{
		MessageBox(GetFocus(), _T("Could not cleanup sockets"), NULL, MB_OK);
		return 1;
	}
	return 0;
}

